/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.ews.mapper;

import java.io.IOException;
import javax.wsdl.Binding;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.gen.Generator;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.PortTypeEntry;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaStubWriter;
import org.apache.axis.wsdl.toJava.Utils;
import org.apache.ws.ews.mapper.J2eeEmitter;
import org.apache.ws.ews.mapper.J2eeImplWriter;
import org.apache.ws.ews.mapper.J2eeInterfaceWriter;
import org.apache.ws.ews.mapper.J2eeSkelWriter;

public class J2eeBindingWriter
implements Generator {
    protected Generator stubWriter = null;
    protected Generator skelWriter = null;
    protected Generator implWriter = null;
    protected Generator interfaceWriter = null;
    protected J2eeEmitter emitter;
    protected Binding binding;
    protected SymbolTable symbolTable;
    public static String INTERFACE_NAME = "interface name";

    public J2eeBindingWriter(J2eeEmitter emitter, Binding binding, SymbolTable symbolTable) {
        this.emitter = emitter;
        this.binding = binding;
        this.symbolTable = symbolTable;
    }

    protected Generator getJavaInterfaceWriter(J2eeEmitter emitter, PortTypeEntry ptEntry, BindingEntry bEntry, SymbolTable st) {
        return new J2eeInterfaceWriter(emitter, ptEntry, bEntry, st);
    }

    protected Generator getJavaStubWriter(J2eeEmitter emitter, BindingEntry bEntry, SymbolTable st) {
        return new JavaStubWriter((Emitter)emitter, bEntry, st);
    }

    protected Generator getJavaSkelWriter(J2eeEmitter emitter, BindingEntry bEntry, SymbolTable st) {
        return new J2eeSkelWriter(emitter, bEntry, st);
    }

    protected Generator getJavaImplWriter(J2eeEmitter emitter, BindingEntry bEntry, SymbolTable st) {
        return new J2eeImplWriter(emitter, bEntry, st);
    }

    public void generate() throws IOException {
        this.setGenerators();
        if (this.interfaceWriter != null) {
            this.interfaceWriter.generate();
        }
        if (this.stubWriter != null) {
            this.stubWriter.generate();
        }
        if (this.skelWriter != null) {
            this.skelWriter.generate();
        }
        if (this.implWriter != null) {
            this.implWriter.generate();
        }
    }

    protected void setGenerators() {
        BindingEntry bEntry = this.symbolTable.getBindingEntry(this.binding.getQName());
        PortTypeEntry ptEntry = this.symbolTable.getPortTypeEntry(this.binding.getPortType().getQName());
        if (ptEntry.isReferenced()) {
            this.interfaceWriter = this.getJavaInterfaceWriter(this.emitter, ptEntry, bEntry, this.symbolTable);
        }
        if (bEntry.isReferenced()) {
            this.stubWriter = this.getJavaStubWriter(this.emitter, bEntry, this.symbolTable);
            if (this.emitter.isServerSide()) {
                if (this.emitter.isSkeletonWanted()) {
                    this.skelWriter = this.getJavaSkelWriter(this.emitter, bEntry, this.symbolTable);
                }
                String fileName = Utils.getJavaLocalName(bEntry.getName()) + "Impl.java";
                try {
                    if (Utils.fileExists(fileName, this.binding.getQName().getNamespaceURI(), this.emitter.getNamespaces())) {
                        System.out.println(Messages.getMessage("wontOverwrite", fileName));
                    } else {
                        this.implWriter = this.getJavaImplWriter(this.emitter, bEntry, this.symbolTable);
                    }
                }
                catch (IOException ioe) {
                    System.err.println(Messages.getMessage("fileExistError00", fileName));
                }
            }
        }
    }
}

