/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.unmarshalling;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.jboss.xb.binding.Util;
import org.jboss.xb.binding.metadata.AddMethodMetaData;
import org.jboss.xb.binding.metadata.CharactersMetaData;
import org.jboss.xb.binding.metadata.ClassMetaData;
import org.jboss.xb.binding.metadata.MapEntryMetaData;
import org.jboss.xb.binding.metadata.PropertyMetaData;
import org.jboss.xb.binding.metadata.ValueMetaData;
import org.jboss.xb.binding.sunday.unmarshalling.AttributeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.AttributeHandler;
import org.jboss.xb.binding.sunday.unmarshalling.CharactersHandler;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ElementHandler;
import org.jboss.xb.binding.sunday.unmarshalling.ElementInterceptor;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.jboss.xb.binding.sunday.unmarshalling.impl.runtime.RtCharactersHandler;
import org.jboss.xb.binding.sunday.unmarshalling.impl.runtime.RtElementHandler;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class TypeBinding {
    private final QName qName;
    private Map elements = Collections.EMPTY_MAP;
    private QName arrayItemQName;
    private ElementBinding arrayItem;
    private Map attrs = Collections.EMPTY_MAP;
    private ElementHandler handler = RtElementHandler.INSTANCE;
    private CharactersHandler simpleType;
    private ClassMetaData classMetaData;
    private ValueMetaData valueMetaData;
    private PropertyMetaData propertyMetaData;
    private MapEntryMetaData mapEntryMetaData;
    private SchemaBinding schemaBinding;
    private SchemaBindingResolver schemaResolver;
    private TypeBinding baseType;
    private boolean skip;
    private CharactersMetaData charMetaData;
    private PropertyMetaData wildcardPropertyMetaData;
    private AddMethodMetaData addMethodMetaData;

    public TypeBinding() {
        this(null);
    }

    public TypeBinding(QName qName) {
        this(qName, RtCharactersHandler.INSTANCE);
    }

    public TypeBinding(QName qName, CharactersHandler simple) {
        this.qName = qName;
        this.simpleType = simple;
    }

    public TypeBinding(QName qName, TypeBinding baseType) {
        this(qName, baseType.simpleType);
        this.elements = new HashMap(baseType.elements);
        this.arrayItemQName = baseType.arrayItemQName;
        this.arrayItem = baseType.arrayItem;
        this.attrs = new HashMap(baseType.attrs);
        this.classMetaData = baseType.classMetaData;
        this.valueMetaData = baseType.valueMetaData;
        this.propertyMetaData = baseType.propertyMetaData;
        this.mapEntryMetaData = baseType.mapEntryMetaData;
        this.schemaBinding = baseType.schemaBinding;
        this.schemaResolver = baseType.schemaResolver;
        this.baseType = baseType;
        if (!baseType.isSimple()) {
            this.handler = baseType.handler;
        }
    }

    public QName getQName() {
        return this.qName;
    }

    public ElementBinding getLocalElement(QName name) {
        return (ElementBinding)this.elements.get(name);
    }

    public ElementBinding getElement(QName name) {
        return this.getElement(name, null);
    }

    public ElementBinding getElement(QName name, Attributes atts) {
        ElementBinding element = (ElementBinding)this.elements.get(name);
        if (element == null) {
            SchemaBindingResolver resolver2 = this.schemaResolver;
            if (resolver2 == null && this.schemaBinding != null) {
                resolver2 = this.schemaBinding.getSchemaResolver();
            }
            if (resolver2 != null) {
                String schemaLocation = atts == null ? null : Util.getSchemaLocation(atts, name.getNamespaceURI());
                SchemaBinding schema = resolver2.resolve(name.getNamespaceURI(), name.getLocalPart(), null, schemaLocation);
                if (schema != null) {
                    element = schema.getElement(name);
                }
            }
        }
        return element;
    }

    public void addElement(QName qName, ElementBinding binding) {
        switch (this.elements.size()) {
            case 0: {
                this.elements = Collections.singletonMap(qName, binding);
                if (!binding.isMultiOccurs()) break;
                this.arrayItem = binding;
                this.arrayItemQName = qName;
                break;
            }
            case 1: {
                this.elements = new HashMap(this.elements);
                this.arrayItem = null;
                this.arrayItemQName = null;
            }
            default: {
                this.elements.put(qName, binding);
            }
        }
    }

    public ElementBinding addElement(QName name, TypeBinding type) {
        ElementBinding el = new ElementBinding(this.schemaBinding, type);
        this.addElement(name, el);
        return el;
    }

    public void addGroup(Map group) {
        Iterator i = group.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            QName name = (QName)entry.getKey();
            TypeBinding type = (TypeBinding)entry.getValue();
            this.addElement(name, type);
        }
    }

    public AttributeBinding getAttribute(QName qName) {
        return (AttributeBinding)this.attrs.get(qName);
    }

    public Attributes expandWithDefaultAttributes(Attributes attrs) {
        if (this.attrs.size() == 0) {
            return attrs;
        }
        HashMap attrsNotSeen = new HashMap(this.attrs);
        for (int n = 0; n < attrs.getLength(); ++n) {
            QName name = new QName(attrs.getURI(n), attrs.getLocalName(n));
            attrsNotSeen.remove(name);
        }
        Attributes expandedAttrs = attrs;
        if (attrsNotSeen.size() > 0) {
            AttributesImpl tmp = new AttributesImpl(attrs);
            Iterator iter = attrsNotSeen.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                QName name = (QName)entry.getKey();
                AttributeBinding binding = (AttributeBinding)entry.getValue();
                String constraint = binding.getDefaultConstraint();
                if (constraint == null) continue;
                QName typeName = binding.getType().getQName();
                tmp.addAttribute(name.getNamespaceURI(), name.getLocalPart(), name.toString(), typeName.toString(), constraint);
            }
            expandedAttrs = tmp;
        }
        return expandedAttrs;
    }

    public AttributeBinding addAttribute(QName name, TypeBinding type, AttributeHandler handler) {
        AttributeBinding attr = new AttributeBinding(this.schemaBinding, type, handler);
        switch (this.attrs.size()) {
            case 0: {
                this.attrs = Collections.singletonMap(name, attr);
                break;
            }
            case 1: {
                this.attrs = new HashMap(this.attrs);
            }
            default: {
                this.attrs.put(name, attr);
            }
        }
        return attr;
    }

    public CharactersHandler getSimpleType() {
        return this.simpleType;
    }

    public void setSimpleType(CharactersHandler simpleType) {
        this.simpleType = simpleType;
    }

    public Object startElement(Object parent, QName qName, ElementBinding element) {
        return this.handler.startElement(parent, qName, element);
    }

    public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx) {
        this.handler.attributes(o, elementName, element, attrs, nsCtx);
    }

    public Object endElement(Object parent, Object o, ElementBinding element, QName qName) {
        return this.handler.endElement(o, qName, element);
    }

    public void setHandler(ElementHandler handler) {
        this.handler = handler;
    }

    public ElementHandler getHandler() {
        return this.handler;
    }

    public void pushInterceptor(QName qName, ElementInterceptor interceptor) {
        ElementBinding el = this.getElement(qName);
        if (el == null) {
            el = this.addElement(qName, new TypeBinding());
        }
        el.pushInterceptor(interceptor);
    }

    public TypeBinding getBaseType() {
        return this.baseType;
    }

    public boolean isSimple() {
        return this.elements.isEmpty() && this.attrs.isEmpty();
    }

    public boolean hasSimpleContent() {
        return this.elements.isEmpty();
    }

    public boolean isArrayWrapper() {
        return this.arrayItem != null;
    }

    public ElementBinding getArrayItem() {
        return this.arrayItem;
    }

    public QName getArrayItemQName() {
        return this.arrayItemQName;
    }

    public ClassMetaData getClassMetaData() {
        return this.classMetaData;
    }

    public void setClassMetaData(ClassMetaData classMetaData) {
        this.classMetaData = classMetaData;
    }

    public SchemaBinding getSchemaBinding() {
        return this.schemaBinding;
    }

    public void setSchemaBinding(SchemaBinding schemaBinding) {
        this.schemaBinding = schemaBinding;
    }

    public void setValueMetaData(ValueMetaData valueMetaData) {
        this.valueMetaData = valueMetaData;
    }

    public ValueMetaData getValueMetaData() {
        return this.valueMetaData;
    }

    public PropertyMetaData getPropertyMetaData() {
        return this.propertyMetaData;
    }

    public void setPropertyMetaData(PropertyMetaData propertyMetaData) {
        this.propertyMetaData = propertyMetaData;
    }

    public SchemaBindingResolver getSchemaResolver() {
        return this.schemaResolver;
    }

    public void setSchemaResolver(SchemaBindingResolver schemaResolver) {
        this.schemaResolver = schemaResolver;
    }

    public MapEntryMetaData getMapEntryMetaData() {
        return this.mapEntryMetaData;
    }

    public void setMapEntryMetaData(MapEntryMetaData mapEntryMetaData) {
        this.mapEntryMetaData = mapEntryMetaData;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public CharactersMetaData getCharactersMetaData() {
        return this.charMetaData;
    }

    public void setCharactersMetaData(CharactersMetaData charMetaData) {
        this.charMetaData = charMetaData;
    }

    public boolean isWildcardElement(QName qName) {
        return !this.elements.containsKey(qName);
    }

    public PropertyMetaData getWildcardPropertyMetaData() {
        return this.wildcardPropertyMetaData;
    }

    public void setWildcardPropertyMetaData(PropertyMetaData wildcardPropertyMetaData) {
        this.wildcardPropertyMetaData = wildcardPropertyMetaData;
    }

    public void setAddMethodMetaData(AddMethodMetaData addMethodMetaData) {
        this.addMethodMetaData = addMethodMetaData;
    }

    public AddMethodMetaData getAddMethodMetaData() {
        return this.addMethodMetaData;
    }
}

