/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.local;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import java.util.Timer;
import javax.jms.JMSException;
import org.objectweb.joram.client.jms.connection.RequestChannel;
import org.objectweb.joram.mom.dest.AdminTopic;
import org.objectweb.joram.mom.notifications.GetProxyIdNot;
import org.objectweb.joram.mom.proxies.ConnectionManager;
import org.objectweb.joram.mom.proxies.OpenConnectionNot;
import org.objectweb.joram.mom.proxies.StandardConnectionContext;
import org.objectweb.joram.shared.JoramTracing;
import org.objectweb.joram.shared.client.AbstractJmsReply;
import org.objectweb.joram.shared.client.AbstractJmsRequest;
import org.objectweb.util.monolog.api.BasicLevel;

public class LocalConnection
implements RequestChannel {
    private String userName;
    private String password;
    private AgentId proxyId;
    private StandardConnectionContext ctx;

    public LocalConnection(String userName, String password) throws JMSException {
        if (JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)("LocalConnection.<init>(" + userName + ',' + password + ')'));
        }
        this.userName = userName;
        this.password = password;
    }

    public void setTimer(Timer timer) {
    }

    public void connect() throws Exception {
        if (JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)"LocalConnection.connect()");
        }
        if (AgentServer.getStatus() != 4) {
            if (AgentServer.getStatus() != 2 && AgentServer.getStatus() != 6) {
                if (JoramTracing.dbgProxy.isLoggable(BasicLevel.ERROR)) {
                    JoramTracing.dbgProxy.log(BasicLevel.ERROR, (Object)("LocalConnection.connect(), server is not initialized: " + AgentServer.getStatusInfo() + '.'));
                }
                throw new Exception();
            }
            if (JoramTracing.dbgProxy.isLoggable(BasicLevel.WARN)) {
                JoramTracing.dbgProxy.log(BasicLevel.WARN, (Object)("LocalConnection.connect(), server is not started: " + AgentServer.getStatusInfo() + '.'));
            }
        }
        GetProxyIdNot gpin = new GetProxyIdNot(this.userName, this.password, null);
        try {
            gpin.invoke(AdminTopic.getDefault());
            this.proxyId = gpin.getProxyId();
        }
        catch (Exception exc) {
            if (JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) {
                JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
            }
            throw new JMSException(exc.getMessage());
        }
        OpenConnectionNot ocn = new OpenConnectionNot(false, 0);
        try {
            ocn.invoke(this.proxyId);
            this.ctx = (StandardConnectionContext)ocn.getConnectionContext();
        }
        catch (Exception exc) {
            if (JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) {
                JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
            }
            JMSException jmse = new JMSException(exc.getMessage());
            jmse.setLinkedException(exc);
            throw jmse;
        }
    }

    public void send(AbstractJmsRequest request) throws Exception {
        if (JoramTracing.dbgClient.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgClient.log(BasicLevel.DEBUG, (Object)("LocalConnection.send(" + request + ')'));
        }
        ConnectionManager.sendToProxy(this.proxyId, this.ctx.getKey(), request, request);
    }

    public AbstractJmsReply receive() throws Exception {
        AbstractJmsReply reply = (AbstractJmsReply)this.ctx.getQueue().get();
        this.ctx.getQueue().pop();
        return reply;
    }

    public void close() {
    }
}

