/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jotm;

import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionSynchronizationRegistry;
import org.objectweb.jotm.Current;
import org.objectweb.jotm.TraceTm;
import org.objectweb.jotm.TransactionImpl;

public class TransactionSynchronizationRegistryImpl
implements Referenceable,
TransactionSynchronizationRegistry {
    private static TransactionSynchronizationRegistryImpl instanceTSR = new TransactionSynchronizationRegistryImpl();

    public static TransactionSynchronizationRegistryImpl getInstance() {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("getInstance");
        }
        return instanceTSR;
    }

    public Object getTransactionKey() {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("getTransactionKey");
        }
        try {
            Current.getCurrent();
            return Current.getTransactionManager().getTransaction();
        }
        catch (SystemException ex) {
            return null;
        }
    }

    public void putResource(Object key, Object value) {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("putResource");
        }
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        try {
            Current.getCurrent();
            TransactionImpl tran = (TransactionImpl)Current.getTransactionManager().getTransaction();
            if (tran == null) {
                throw new IllegalStateException("Cannot find Transaction for putResource");
            }
            tran.putUserResource(key, value);
        }
        catch (SystemException ex) {
            throw new IllegalStateException("Cannot getTransaction");
        }
    }

    public Object getResource(Object key) {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("getResource");
        }
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        try {
            Current.getCurrent();
            TransactionImpl tran = (TransactionImpl)Current.getTransactionManager().getTransaction();
            if (tran == null) {
                throw new IllegalStateException("Cannot find Transaction for getResource");
            }
            return tran.getUserResource(key);
        }
        catch (SystemException ex) {
            throw new IllegalStateException("Cannot getTransaction");
        }
    }

    public void registerInterposedSynchronization(Synchronization sync) throws IllegalStateException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("registerInterposedSynchronization");
        }
        try {
            Current.getCurrent();
            TransactionImpl tx = (TransactionImpl)Current.getTransactionManager().getTransaction();
            if (tx == null) {
                throw new IllegalStateException("Cannot find Transaction for registerInterposedSynchronization");
            }
            tx.registerInterposedSynchronization(sync);
        }
        catch (SystemException ex) {
            throw new IllegalStateException("Cannot getTransaction");
        }
    }

    public int getTransactionStatus() {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("getTransactionStatus");
        }
        try {
            Current.getCurrent();
            int mystatus = Current.getTransactionManager().getStatus();
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug("mystatus=" + mystatus);
            }
            return mystatus;
        }
        catch (SystemException ex) {
            return 6;
        }
    }

    public void setRollbackOnly() {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("setRollbackOnly");
        }
        try {
            Current.getCurrent();
            Current.getTransactionManager().setRollbackOnly();
        }
        catch (SystemException ex) {
            throw new IllegalStateException("Cannot setRollbackOnly");
        }
    }

    public boolean getRollbackOnly() {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("getRollbackOnly");
        }
        int status = this.getTransactionStatus();
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("status=" + status);
        }
        if (status == 6) {
            throw new IllegalStateException("Cannot getTransactionStatus");
        }
        return status == 1 || status == 9;
    }

    public Reference getReference() throws NamingException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("TSRImpl.getReference()");
        }
        Reference ref = new Reference(this.getClass().getName(), "org.objectweb.jotm.TransactionSynchronizationRegistryFactory", null);
        return ref;
    }
}

