/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.util.configuration;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TraceCarol {
    public static final String PREFIX = "org.ow2.carol";
    private static Log carolLogger = null;
    private static Log jndiCarolLogger = null;
    private static Log jndiEncCarolLogger = null;
    private static Log rmiCarolLogger = null;
    private static Log exportCarolLogger = null;
    private static boolean configured = false;

    private TraceCarol() {
    }

    public static void configure() {
        if (configured) {
            return;
        }
        carolLogger = LogFactory.getLog(PREFIX);
        jndiCarolLogger = LogFactory.getLog("org.ow2.carol.jndi");
        jndiEncCarolLogger = LogFactory.getLog("org.ow2.carol.jndi.enc");
        rmiCarolLogger = LogFactory.getLog("org.ow2.carol.rmi");
        exportCarolLogger = LogFactory.getLog("org.ow2.carol.rmi.export");
        configured = true;
    }

    public static void verbose(String msg) {
        if (carolLogger != null) {
            carolLogger.info(msg);
        } else {
            System.out.println("CAROL Verbose message:" + msg);
        }
    }

    public static void error(String msg) {
        if (carolLogger != null) {
            carolLogger.error(msg);
        } else {
            System.err.println("CAROL Error:" + msg);
        }
    }

    public static void error(String msg, Throwable th) {
        if (carolLogger != null) {
            carolLogger.error(msg, th);
        } else {
            System.err.println("CAROL Error:" + msg);
            th.printStackTrace();
        }
    }

    public static boolean isDebugCarol() {
        return carolLogger != null && carolLogger.isDebugEnabled();
    }

    public static void debugCarol(String msg) {
        if (carolLogger != null) {
            carolLogger.debug(msg);
        }
    }

    public static boolean isInfoCarol() {
        return carolLogger != null && carolLogger.isInfoEnabled();
    }

    public static void infoCarol(String msg) {
        if (carolLogger != null) {
            carolLogger.info(msg);
        }
    }

    public static boolean isDebugJndiCarol() {
        return jndiCarolLogger != null && jndiCarolLogger.isDebugEnabled();
    }

    public static void debugJndiCarol(String msg) {
        if (jndiCarolLogger != null) {
            jndiCarolLogger.debug(msg);
        }
    }

    public static boolean isDebugjndiEncCarol() {
        return jndiEncCarolLogger != null && jndiEncCarolLogger.isDebugEnabled();
    }

    public static void debugjndiEncCarol(String msg) {
        if (jndiEncCarolLogger != null) {
            jndiEncCarolLogger.debug(msg);
        }
    }

    public static boolean isDebugRmiCarol() {
        return rmiCarolLogger != null && rmiCarolLogger.isDebugEnabled();
    }

    public static void debugRmiCarol(String msg) {
        if (rmiCarolLogger != null) {
            rmiCarolLogger.debug(msg);
        }
    }

    public static boolean isDebugExportCarol() {
        return exportCarolLogger != null && exportCarolLogger.isDebugEnabled();
    }

    public static void debugExportCarol(String msg) {
        if (exportCarolLogger != null) {
            exportCarolLogger.debug(msg);
        }
    }
}

