/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.pool;

import javax.naming.NamingException;
import net.jcip.annotations.ThreadSafe;
import org.ow2.cmi.controller.common.ClusterViewManager;
import org.ow2.cmi.controller.server.ProtocolNotFoundException;
import org.ow2.cmi.pool.NamingPoolException;
import org.ow2.cmi.reference.CMIReference;
import org.ow2.cmi.reference.CMIReferenceable;
import org.ow2.cmi.reference.CMIReferenceableWrapper;
import org.ow2.cmi.reference.ObjectNotFoundException;
import org.ow2.cmi.rpc.StubOrProxyHelper;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.api.PoolException;
import org.ow2.util.pool.impl.PoolEntryStatistics;
import org.ow2.util.pool.impl.PoolFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class StubOrProxyFactory
implements PoolFactory<CMIReferenceable<?>, CMIReference> {
    private static final Log LOGGER = LogFactory.getLog(StubOrProxyFactory.class);
    private final ClusterViewManager clusterViewManager;

    public StubOrProxyFactory(ClusterViewManager clusterViewManager) {
        this.clusterViewManager = clusterViewManager;
    }

    @Override
    public CMIReferenceable<?> create(CMIReference cmiReference) throws PoolException {
        try {
            return StubOrProxyHelper.download(this.clusterViewManager, cmiReference);
        }
        catch (ProtocolNotFoundException e) {
            LOGGER.error("Cannot get a CMIReferenceable for " + cmiReference, e);
            throw new PoolException("Cannot get a CMIReferenceable for " + cmiReference, e);
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error("Cannot get a CMIReferenceable for " + cmiReference, e);
            throw new PoolException("Cannot get a CMIReferenceable for " + cmiReference, e);
        }
        catch (NamingException e) {
            LOGGER.debug("No CMIReferenceable is bound for " + cmiReference, e);
            throw new NamingPoolException("No CMIReferenceable is bound for " + cmiReference, e);
        }
    }

    @Override
    public boolean isMatching(CMIReferenceable<?> cmiReferenceable, CMIReference cmiReference) {
        LOGGER.debug("{0} == {1} ?", cmiReferenceable.getReference(), cmiReference);
        return cmiReferenceable.getReference().equals(cmiReference);
    }

    @Override
    public void remove(CMIReferenceable<?> cmiReferenceable) {
    }

    @Override
    public boolean validate(CMIReferenceable<?> cmiReferenceable, PoolEntryStatistics stats) {
        return true;
    }

    public void setClue(CMIReferenceable<?> cmiReferenceable, CMIReference cmiRef) throws PoolException {
        if (!(cmiReferenceable instanceof CMIReferenceableWrapper)) {
            throw new PoolException("Cannot set the given clue on the instance");
        }
        ((CMIReferenceableWrapper)cmiReferenceable).setReference(cmiRef);
    }
}

