/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.smartclient.server;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.easybeans.component.api.EZBComponentException;
import org.ow2.easybeans.component.itf.EZBSmartComponent;
import org.ow2.easybeans.component.itf.RegistryComponent;
import org.ow2.easybeans.component.smartclient.message.ChannelAttachment;
import org.ow2.easybeans.component.smartclient.message.ClassAnswer;
import org.ow2.easybeans.component.smartclient.message.ClassNotFound;
import org.ow2.easybeans.component.smartclient.message.ClassRequest;
import org.ow2.easybeans.component.smartclient.message.ProviderURLAnswer;
import org.ow2.easybeans.component.smartclient.message.ResourceAnswer;
import org.ow2.easybeans.component.smartclient.message.ResourceNotFound;
import org.ow2.easybeans.component.smartclient.message.ResourceRequest;

public class SmartClientEndPointComponent
implements EZBSmartComponent,
Runnable {
    private static Logger logger = Logger.getLogger(SmartClientEndPointComponent.class.getName());
    private static final int MAX_LENGTH_INCOMING_MSG = 500;
    private static final int DEFAULT_PORT_NUMBER = 2503;
    private static final int BUF_APPEND = 1000;
    private int portNumber = 2503;
    private Selector selector = null;
    private SelectionKey serverkey = null;
    private ServerSocketChannel server = null;
    private boolean waitingSelector = true;
    private RegistryComponent registryComponent = null;
    private ClassLoader classLoader = null;

    public void init() throws EZBComponentException {
        try {
            this.selector = Selector.open();
        }
        catch (IOException e) {
            throw new EZBComponentException("Cannot open a new selector.", e);
        }
        try {
            this.server = ServerSocketChannel.open();
        }
        catch (IOException e) {
            throw new EZBComponentException("Cannot open a new server socket channel.", e);
        }
        try {
            this.server.configureBlocking(false);
        }
        catch (IOException e) {
            throw new EZBComponentException("Cannot configure the server socket with non-blocking mode.", e);
        }
    }

    public void start() throws EZBComponentException {
        try {
            this.server.socket().bind(new InetSocketAddress(this.portNumber));
        }
        catch (IOException e) {
            throw new EZBComponentException("Cannot listen on the port number '" + this.portNumber + "', maybe the port is already used.", e);
        }
        try {
            this.serverkey = this.server.register(this.selector, 16);
        }
        catch (ClosedChannelException e) {
            throw new EZBComponentException("Cannot register the current selector as an accepting selector waiting clients.", e);
        }
        this.waitingSelector = true;
        new Thread(this).start();
        logger.info("SmartClient Endpoint listening on port '" + this.portNumber + "'.");
    }

    public void stop() throws EZBComponentException {
        this.waitingSelector = false;
        this.selector.wakeup();
        try {
            this.server.socket().close();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Unable to close the socket.", e);
        }
    }

    public void handleSelectors() {
        while (this.waitingSelector) {
            int updatedKeys = 0;
            try {
                updatedKeys = this.selector.select();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Selector has been closed, stopping listener", e);
                this.waitingSelector = false;
            }
            if (updatedKeys == 0) continue;
            Set<SelectionKey> selectedKeys = this.selector.selectedKeys();
            Iterator<SelectionKey> itSelectedKeys = selectedKeys.iterator();
            while (itSelectedKeys.hasNext()) {
                SelectionKey selectionKey = itSelectedKeys.next();
                itSelectedKeys.remove();
                if (selectionKey == this.serverkey) {
                    if (!selectionKey.isAcceptable()) continue;
                    try {
                        this.handleAccept();
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Unable to accept a new connection.", e);
                    }
                    continue;
                }
                if (selectionKey.isReadable()) {
                    try {
                        this.handleRead(selectionKey);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Unable to read data from the client.", e);
                    }
                    continue;
                }
                if (!selectionKey.isWritable()) continue;
                try {
                    this.handleWrite(selectionKey);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Unable to write data to the client.", e);
                }
            }
        }
    }

    private void handleAccept() throws IOException {
        SocketChannel client = this.server.accept();
        client.configureBlocking(false);
        client.register(this.selector, 1, new ChannelAttachment());
    }

    private void handleRead(SelectionKey selectionKey) throws IOException {
        ChannelAttachment channAttachment;
        ByteBuffer channBuffer;
        SocketChannel client = (SocketChannel)selectionKey.channel();
        int bytesread = client.read(channBuffer = (channAttachment = (ChannelAttachment)selectionKey.attachment()).getByteBuffer());
        if (bytesread == -1) {
            selectionKey.cancel();
            client.close();
        }
        if (channBuffer.position() >= 6) {
            byte version2 = channBuffer.get(0);
            if (version2 != 1) {
                selectionKey.cancel();
                client.close();
                throw new IllegalStateException("Invalid protocol version : waiting '1', got '" + version2 + "'.");
            }
            byte opCode = channBuffer.get(1);
            int length = channBuffer.getInt(2);
            if (length < 0) {
                selectionKey.cancel();
                client.close();
                throw new IllegalStateException("Invalid length for client '" + length + "'.");
            }
            if (length > 500) {
                selectionKey.cancel();
                client.close();
                throw new IllegalStateException("Length too big, max length = '500', current = '" + length + "'.");
            }
            if (channBuffer.position() >= 6 + length) {
                channBuffer.limit(6 + length);
                ByteBuffer dataBuffer = channBuffer.duplicate();
                dataBuffer.position(6);
                try {
                    switch (opCode) {
                        case 1: {
                            this.handleReadClassRequest(selectionKey, dataBuffer);
                            break;
                        }
                        case 4: {
                            this.handleReadResourceRequest(selectionKey, dataBuffer);
                            break;
                        }
                        case 7: {
                            this.handleReadProviderURLRequest(selectionKey, dataBuffer);
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    selectionKey.cancel();
                    client.close();
                    throw new IllegalStateException("Cannot handle request with opCode '" + opCode + "'.", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleReadClassRequest(SelectionKey selectionKey, ByteBuffer dataBuffer) throws IOException {
        ClassRequest classRequest = new ClassRequest(dataBuffer);
        String className = classRequest.getClassName();
        selectionKey.interestOps(4);
        String encodedClassName = className.replaceAll("\\.", "/").concat(".class");
        InputStream inputStream = this.findClassLoader().getResourceAsStream(encodedClassName);
        if (inputStream == null) {
            ClassNotFound classNotFound = new ClassNotFound(className);
            selectionKey.attach(classNotFound.getMessage());
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Class '" + className + "' not found");
            }
            return;
        }
        byte[] bytecode = null;
        try {
            bytecode = SmartClientEndPointComponent.readClass(inputStream);
        }
        finally {
            inputStream.close();
        }
        ClassAnswer classAnswer = new ClassAnswer(className, bytecode);
        selectionKey.attach(classAnswer.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleReadResourceRequest(SelectionKey selectionKey, ByteBuffer dataBuffer) throws IOException {
        ResourceRequest resourceRequest = new ResourceRequest(dataBuffer);
        String resourceName = resourceRequest.getResourceName();
        selectionKey.interestOps(4);
        URL url = this.findClassLoader().getResource(resourceName);
        if (url == null) {
            ResourceNotFound resourceNotFound = new ResourceNotFound(resourceName);
            selectionKey.attach(resourceNotFound.getMessage());
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Resource '" + resourceName + "' not found");
            }
            return;
        }
        InputStream inputStream = url.openStream();
        byte[] bytes = null;
        try {
            bytes = SmartClientEndPointComponent.readClass(inputStream);
        }
        finally {
            inputStream.close();
        }
        ResourceAnswer resourceAnswer = new ResourceAnswer(resourceName, bytes);
        selectionKey.attach(resourceAnswer.getMessage());
    }

    private void handleReadProviderURLRequest(SelectionKey selectionKey, ByteBuffer dataBuffer) throws IOException {
        selectionKey.interestOps(4);
        String providerURL = this.registryComponent.getProviderURL();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Provider URL asked by client : '" + providerURL + "'.");
        }
        ProviderURLAnswer providerURLAnswer = new ProviderURLAnswer(providerURL);
        selectionKey.attach(providerURLAnswer.getMessage());
    }

    private void handleWrite(SelectionKey selectionKey) throws IOException {
        SocketChannel channel = (SocketChannel)selectionKey.channel();
        ByteBuffer buffer = (ByteBuffer)selectionKey.attachment();
        if (buffer.hasRemaining()) {
            channel.write(buffer);
        } else {
            channel.close();
        }
    }

    private static byte[] readClass(InputStream is) throws IOException {
        if (is == null) {
            throw new IOException("Given input stream is null");
        }
        byte[] b = new byte[is.available()];
        int len = 0;
        while (true) {
            byte[] c;
            int n;
            if ((n = is.read(b, len, b.length - len)) == -1) {
                if (len < b.length) {
                    c = new byte[len];
                    System.arraycopy(b, 0, c, 0, len);
                    b = c;
                }
                return b;
            }
            if ((len += n) != b.length) continue;
            c = new byte[b.length + 1000];
            System.arraycopy(b, 0, c, 0, len);
            b = c;
        }
    }

    public void run() {
        this.handleSelectors();
    }

    public void setPortNumber(int portNumber) {
        this.portNumber = portNumber;
    }

    public void setRegistryComponent(RegistryComponent registryComponent) {
        this.registryComponent = registryComponent;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    private ClassLoader findClassLoader() {
        if (this.classLoader != null) {
            return this.classLoader;
        }
        return Thread.currentThread().getContextClassLoader();
    }
}

