/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.container.info.security;

import java.util.Collection;
import java.util.List;
import javax.security.jacc.EJBMethodPermission;
import org.ow2.easybeans.api.bean.info.ISecurityInfo;
import org.ow2.easybeans.container.info.security.MethodSecurityInfo;
import org.ow2.easybeans.container.info.security.SecurityInfo;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarClassMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarMethodMetadata;

public final class SecurityInfoHelper {
    private SecurityInfoHelper() {
    }

    public static ISecurityInfo getSecurityInfo(EasyBeansEjbJarClassMetadata bean) {
        Collection methods;
        SecurityInfo securityInfo = new SecurityInfo(bean);
        securityInfo.setDeclaredRole(bean.getDeclareRoles());
        String runAsRole = bean.getRunAs();
        if (runAsRole != null) {
            securityInfo.setRunAsRole(runAsRole);
        }
        if ((methods = bean.getMethodMetadataCollection()) == null) {
            return securityInfo;
        }
        for (EasyBeansEjbJarMethodMetadata method : methods) {
            if (!method.isBusinessMethod()) continue;
            MethodSecurityInfo methodSecurityInfo = new MethodSecurityInfo();
            securityInfo.addMethodSecurityInfo(methodSecurityInfo);
            methodSecurityInfo.setExcluded(method.hasDenyAll());
            methodSecurityInfo.setUnchecked(method.hasPermitAll());
            List<String> roles = method.getRolesAllowed();
            if (roles != null) {
                for (String role : roles) {
                    methodSecurityInfo.addRole(role);
                }
            }
            String ejbName = bean.getJCommonBean().getName();
            String methodName = method.getMethodName();
            String methodInterface = null;
            String[] methodParams = null;
            EJBMethodPermission permission = new EJBMethodPermission(ejbName, methodName, methodInterface, methodParams);
            methodSecurityInfo.setPermission(permission);
        }
        return securityInfo;
    }
}

