/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.container.mdb;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.EJBException;
import javax.ejb.Timer;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.InvalidPropertyException;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.FactoryException;
import org.ow2.easybeans.api.bean.EasyBeansMDB;
import org.ow2.easybeans.container.mdb.MDBFactory;
import org.ow2.easybeans.container.mdb.MDBMessageEndPoint;
import org.ow2.easybeans.container.mdb.MDBMessageListenerEndPoint;
import org.ow2.easybeans.resolver.api.EZBJNDIResolverException;
import org.ow2.util.ee.metadata.ejbjar.impl.struct.JActivationConfigProperty;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.api.PoolException;

public class MDBMessageEndPointFactory
extends MDBFactory
implements MessageEndpointFactory {
    public static final String DEFAULT_ACTIVATION_SPEC_NAME = "joramActivationSpec";
    public static final String DEFAULT_DESTINATION_TYPE = "javax.jms.Queue";
    public static final String DESTINATION_TYPE_PROPERTY = "destinationType";
    private static Log logger = LogFactory.getLog(MDBMessageEndPointFactory.class);
    private ActivationSpec activationSpec = null;
    private ResourceAdapter resourceAdapter = null;

    public MDBMessageEndPointFactory(String className, EZBContainer container, ActivationSpec activationSpec, ResourceAdapter resourceAdapter) throws FactoryException {
        super(className, container);
        this.activationSpec = activationSpec;
        this.resourceAdapter = resourceAdapter;
    }

    public void init() throws FactoryException {
        this.initActivationSpec();
        this.validateActivationSpec();
        this.activate();
    }

    private void initActivationSpec() throws FactoryException {
        String messageDestinationLink;
        List<ActivationConfigProperty> properties = this.getMessageDrivenInfo().getActivationConfigProperties();
        if (properties == null) {
            properties = new ArrayList<ActivationConfigProperty>();
        }
        if ((messageDestinationLink = this.getMessageDrivenInfo().getMessageDestinationLink()) != null) {
            String jndiName = null;
            try {
                jndiName = this.getContainer().getConfiguration().getContainerJNDIResolver().getMessageDestinationJNDIUniqueName(messageDestinationLink);
            }
            catch (EZBJNDIResolverException e) {
                throw new FactoryException("Unable to resolve message destination link '" + messageDestinationLink + "' for bean '" + this.getBeanInfo().getName() + "'.", e);
            }
            properties.add(new JActivationConfigProperty("destination", jndiName));
            logger.info("Message destination link ''{0}'' resolved to ''{1}'' for bean ''{2}''", messageDestinationLink, jndiName, this.getBeanInfo().getName());
        }
        boolean destinationTypeFound = false;
        for (ActivationConfigProperty property : properties) {
            if (!DESTINATION_TYPE_PROPERTY.equals(property.propertyName())) continue;
            destinationTypeFound = true;
            break;
        }
        if (!destinationTypeFound) {
            JActivationConfigProperty jActivationConfigProperty = new JActivationConfigProperty(DESTINATION_TYPE_PROPERTY, DEFAULT_DESTINATION_TYPE);
            properties.add(jActivationConfigProperty);
            logger.warn("No ''{0}'' property found in the activation config, adding default value ''{1}'' for bean ''{2}''", DESTINATION_TYPE_PROPERTY, DEFAULT_DESTINATION_TYPE, this.getBeanInfo().getName());
        }
        for (ActivationConfigProperty property : properties) {
            String key = property.propertyName();
            String value = property.propertyValue();
            String methodName = "set" + key.substring(0, 1).toUpperCase() + key.substring(1);
            Method m = null;
            try {
                m = this.activationSpec.getClass().getMethod(methodName, String.class);
            }
            catch (SecurityException e) {
                throw new FactoryException("Cannot get a method named '" + methodName + "' on activation spec object '" + this.activationSpec + "'.", e);
            }
            catch (NoSuchMethodException e) {
                throw new FactoryException("Cannot get a method named '" + methodName + "' on activation spec object '" + this.activationSpec + "'.", e);
            }
            try {
                m.invoke((Object)this.activationSpec, value);
            }
            catch (IllegalArgumentException e) {
                throw new FactoryException("Cannot invoke method named '" + methodName + "' with value '" + value + "' on activation spec object '" + this.activationSpec + "'.", e);
            }
            catch (IllegalAccessException e) {
                throw new FactoryException("Cannot invoke method named '" + methodName + "' with value '" + value + "' on activation spec object '" + this.activationSpec + "'.", e);
            }
            catch (InvocationTargetException e) {
                throw new FactoryException("Cannot invoke method named '" + methodName + "' with value '" + value + "' on activation spec object '" + this.activationSpec + "'.", e);
            }
        }
    }

    private void validateActivationSpec() throws FactoryException {
        try {
            this.activationSpec.validate();
        }
        catch (InvalidPropertyException e) {
            throw new FactoryException("Cannot validate the validation spec object for bean '" + this.getBeanInfo().getName() + "'.", e);
        }
    }

    private void activate() throws FactoryException {
        try {
            this.resourceAdapter.endpointActivation(this, this.activationSpec);
        }
        catch (ResourceException e) {
            throw new FactoryException("Cannot activate the activationspec object and us (MessageEndPointFactory) on the resource adapter", e);
        }
    }

    public MessageEndpoint createEndpoint(XAResource xaResource) throws UnavailableException {
        return this.createInternalEndpoint(xaResource);
    }

    public MDBMessageEndPoint createInternalEndpoint(XAResource xaResource) throws UnavailableException {
        MDBMessageListenerEndPoint messageEndpoint = null;
        EasyBeansMDB easyBeansMDB = null;
        try {
            easyBeansMDB = (EasyBeansMDB)this.getPool().get();
        }
        catch (PoolException e) {
            throw new UnavailableException("Cannot get instance in the pool", e);
        }
        messageEndpoint = new MDBMessageListenerEndPoint(this, easyBeansMDB);
        messageEndpoint.setXaResource(xaResource);
        return messageEndpoint;
    }

    protected void releaseEndPoint(MDBMessageEndPoint mdbMessageEndPoint) {
        try {
            this.getPool().release(mdbMessageEndPoint.getEasyBeansMDB());
        }
        catch (PoolException e) {
            throw new IllegalStateException("Cannot release the given message end point", e);
        }
    }

    public boolean isDeliveryTransacted(Method method) throws NoSuchMethodException {
        return false;
    }

    public void stop() {
        super.stop();
        this.resourceAdapter.endpointDeactivation(this, this.activationSpec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyTimeout(Timer timer) {
        MDBMessageEndPoint mdbMessageEndPoint = null;
        try {
            mdbMessageEndPoint = this.createInternalEndpoint(null);
        }
        catch (UnavailableException e) {
            throw new EJBException("Cannot get an endpoint for notifying the timeout", e);
        }
        try {
            mdbMessageEndPoint.notifyTimeout(timer);
        }
        finally {
            this.releaseEndPoint(mdbMessageEndPoint);
        }
    }
}

