/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.injection.impl;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.rmi.PortableRemoteObject;
import org.ow2.easybeans.asm.Type;
import org.ow2.easybeans.injection.api.ArchiveInjectionException;
import org.ow2.easybeans.resolver.api.EZBJNDIBeanData;
import org.ow2.easybeans.resolver.api.EZBJNDIData;
import org.ow2.easybeans.resolver.api.EZBRemoteJNDIResolver;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.ee.builder.webserviceref.WebServiceRefBuilder;
import org.ow2.util.ee.builder.webserviceref.factory.WebServiceRefObjectFactory;
import org.ow2.util.ee.deploy.api.deployable.CARDeployable;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployable.metadata.DeployableMetadataException;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelper;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelperException;
import org.ow2.util.ee.metadata.car.api.ICarDeployableMetadata;
import org.ow2.util.ee.metadata.car.impl.CarDeployableMetadataFactory;
import org.ow2.util.ee.metadata.common.api.ICommonClassMetadata;
import org.ow2.util.ee.metadata.common.api.ICommonFieldMetadata;
import org.ow2.util.ee.metadata.common.api.ICommonMethodMetadata;
import org.ow2.util.ee.metadata.common.api.interfaces.ISharedMetadata;
import org.ow2.util.ee.metadata.common.api.struct.IJAnnotationResource;
import org.ow2.util.ee.metadata.common.api.struct.IJEjbEJB;
import org.ow2.util.ee.metadata.common.api.struct.IJavaxPersistenceUnit;
import org.ow2.util.ee.metadata.common.api.struct.IJaxwsWebServiceRef;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.scan.api.metadata.structures.JClass;
import org.ow2.util.scan.api.metadata.structures.JField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchiveInjection {
    private static Log logger = LogFactory.getLog(ArchiveInjection.class);
    public static final String JAVA_LANG_OBJECT = "java/lang/Object";
    private IArchive archive = null;
    private boolean analyzed = false;
    private EZBRemoteJNDIResolver jndiResolver = null;
    private Collection<? extends ICommonClassMetadata<? extends ICommonClassMetadata, ? extends ICommonMethodMetadata, ? extends ICommonFieldMetadata>> metadataCollection = null;

    public ArchiveInjection(IArchive archive) {
        this.archive = archive;
    }

    public ArchiveInjection(ICarDeployableMetadata carMetadata) {
        this.metadataCollection = carMetadata.getCarClassMetadataCollection();
        this.analyzed = true;
    }

    public void analyze(ClassLoader classLoader) throws ArchiveInjectionException {
        ICarDeployableMetadata carDeployableMetadata;
        IDeployable<?> deployable = null;
        try {
            deployable = DeployableHelper.getDeployable(this.archive);
        }
        catch (DeployableHelperException e) {
            throw new ArchiveInjectionException("Unable to get a deployable on archive '" + this.archive + "'.", e);
        }
        if (CARDeployable.class.isInstance(deployable)) {
            carDeployableMetadata = null;
            try {
                carDeployableMetadata = new CarDeployableMetadataFactory().createDeployableMetadata((CARDeployable)CARDeployable.class.cast(deployable), classLoader);
            }
            catch (DeployableMetadataException e) {
                throw new ArchiveInjectionException("Unable to get metadata on archive '" + this.archive + "'.", e);
            }
        } else {
            throw new UnsupportedOperationException("Can only manage injection for Client Deployable. Deployable found is '" + deployable + "'.");
        }
        this.metadataCollection = carDeployableMetadata.getCarClassMetadataCollection();
        this.analyzed = true;
    }

    public void init(Class<?> clazz) throws ArchiveInjectionException {
        if (!this.analyzed) {
            this.analyze(clazz.getClassLoader());
        }
        LinkedList listClasses = new LinkedList();
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            listClasses.addFirst(currentClass);
        }
        for (Class clazz2 : listClasses) {
            ICommonClassMetadata<? extends ICommonClassMetadata, ? extends ICommonMethodMetadata, ? extends ICommonFieldMetadata> classMetadata = this.getClassMetadata(clazz2);
            if (classMetadata == null) continue;
            this.init(classMetadata, clazz2, null);
        }
    }

    public void init(ICommonClassMetadata commonMetadata, Class<?> clazz, Object instance) throws ArchiveInjectionException {
        Collection fieldCollection = commonMetadata.getStandardFieldMetadataCollection();
        for (ICommonFieldMetadata fieldMetadata : fieldCollection) {
            IJaxwsWebServiceRef jaxwsWSR;
            IJavaxPersistenceUnit jJavaxPersistenceUnit;
            IJAnnotationResource jAnnotationResource;
            Type typeInterface = Type.getType(fieldMetadata.getJField().getDescriptor());
            String interfaceName = typeInterface.getClassName();
            IJEjbEJB jejb = fieldMetadata.getJEjbEJB();
            if (jejb != null) {
                jejb.setBeanInterface(interfaceName);
                this.injectFieldEJB(jejb, fieldMetadata, clazz, instance);
            }
            if ((jAnnotationResource = fieldMetadata.getJAnnotationResource()) != null) {
                jAnnotationResource.setType(interfaceName);
                if ("javax.transaction.UserTransaction".equals(jAnnotationResource.getType())) {
                    jAnnotationResource.setMappedName("java:comp/UserTransaction");
                } else if ("org.omg.CORBA.ORB".equals(jAnnotationResource.getType())) {
                    jAnnotationResource.setMappedName("java:comp/ORB");
                }
                this.injectFieldResource(jAnnotationResource, fieldMetadata, clazz, instance);
            }
            if ((jJavaxPersistenceUnit = fieldMetadata.getJavaxPersistenceUnit()) != null) {
                this.injectFieldPersistenceUnit(jJavaxPersistenceUnit, fieldMetadata, clazz, instance);
            }
            if ((jaxwsWSR = fieldMetadata.getJaxwsWebServiceRef()) == null) continue;
            jaxwsWSR.setType(interfaceName);
            this.injectWebServiceRef(jaxwsWSR, fieldMetadata, clazz, instance);
        }
        List<IJaxwsWebServiceRef> webServiceRefs = commonMetadata.getJaxwsWebServiceRefs();
        if (webServiceRefs != null) {
            for (IJaxwsWebServiceRef ref : webServiceRefs) {
                this.injectWebServiceRef(ref, commonMetadata, clazz, instance);
            }
        }
        ArrayList<ICommonMethodMetadata> postConstructMethods = new ArrayList<ICommonMethodMetadata>();
        Collection methodCollection = commonMetadata.getStandardMethodMetadataCollection();
        for (ICommonMethodMetadata methodMetadata : methodCollection) {
            if (!methodMetadata.isPostConstruct()) continue;
            postConstructMethods.add(methodMetadata);
        }
        this.invokePostConstructMethods(postConstructMethods, clazz, instance);
    }

    private void injectWebServiceRef(IJaxwsWebServiceRef jaxwsWSR, ISharedMetadata fieldMetadata, Class clazz, Object instance) throws ArchiveInjectionException {
        WebServiceRefBuilder builder = new WebServiceRefBuilder();
        Reference ref = null;
        try {
            ref = builder.build(jaxwsWSR);
        }
        catch (NamingException e) {
            throw new ArchiveInjectionException("Cannot build the Reference for @WebServiceRef(" + jaxwsWSR.getName() + ")", e);
        }
        String encName = jaxwsWSR.getName();
        if (fieldMetadata instanceof ICommonFieldMetadata) {
            ClassLoader loader = clazz.getClassLoader();
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(loader);
                WebServiceRefObjectFactory factory = new WebServiceRefObjectFactory();
                Object injectedValue = factory.getObjectInstance(ref, null, null, null);
                this.setFieldValue((ICommonFieldMetadata)fieldMetadata, clazz, instance, injectedValue);
                encName = this.buildENCName(jaxwsWSR.getName(), (ICommonFieldMetadata)fieldMetadata);
            }
            catch (Exception e) {
                throw new ArchiveInjectionException("Cannot inject @WebServiceRef(" + jaxwsWSR.getName() + ")", e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
        this.bindValue(encName, ref);
    }

    protected void invokePostConstructMethods(List<ICommonMethodMetadata> postConstructMethods, Class clazz, Object instance) throws ArchiveInjectionException {
        if (postConstructMethods == null) {
            return;
        }
        for (ICommonMethodMetadata postConstructMethodMetadata : postConstructMethods) {
            Method postConstructMethod = null;
            try {
                postConstructMethod = clazz.getDeclaredMethod(postConstructMethodMetadata.getJMethod().getName(), new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new ArchiveInjectionException("Cannot invoke postconstruct method", e);
            }
            boolean accessible = postConstructMethod.isAccessible();
            try {
                postConstructMethod.setAccessible(true);
                postConstructMethod.invoke(instance, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new ArchiveInjectionException("Cannot invoke postconstruct method", e);
            }
            catch (InvocationTargetException e) {
                throw new ArchiveInjectionException("Cannot invoke postconstruct method", e);
            }
            finally {
                postConstructMethod.setAccessible(accessible);
            }
        }
    }

    public void injectFieldEJB(IJEjbEJB ejb, ICommonFieldMetadata fieldMetadata, Class clazz, Object instance) throws ArchiveInjectionException {
        String interfaceName = ejb.getBeanInterface();
        String beanName = ejb.getBeanName();
        String mappedName = ejb.getMappedName();
        String encName = this.buildENCName(ejb.getName(), fieldMetadata);
        boolean needToBind = true;
        Object value = null;
        try {
            value = new InitialContext().lookup("java:comp/env/" + encName);
            needToBind = false;
        }
        catch (NamingException e) {
            logger.debug("Value for ENC '{0}' not bound in the registry", encName);
        }
        if (value == null) {
            String jndiName = null;
            jndiName = mappedName != null ? mappedName : this.getRemoteEJBJNDIName(interfaceName, beanName);
            try {
                value = new InitialContext().lookup(jndiName);
            }
            catch (NamingException e) {
                throw new ArchiveInjectionException("Cannot get object with JNDI Name '" + jndiName + "' for ejb '" + ejb + "'.", e);
            }
        }
        this.setFieldValue(fieldMetadata, clazz, instance, value);
        if (needToBind) {
            this.bindValue(encName, value);
        }
    }

    public void injectFieldPersistenceUnit(IJavaxPersistenceUnit jJavaxPersistenceUnit, ICommonFieldMetadata fieldMetadata, Class clazz, Object instance) throws ArchiveInjectionException {
        String name = jJavaxPersistenceUnit.getName();
        Object value = null;
        String encName = this.buildENCName(jJavaxPersistenceUnit.getName(), fieldMetadata);
        boolean needToBind = true;
        try {
            value = new InitialContext().lookup("java:comp/env/" + encName);
            needToBind = false;
        }
        catch (NamingException e) {
            logger.debug("Value for ENC '{0}' not bound in the registry", encName);
        }
        if (value == null) {
            try {
                value = new InitialContext().lookup(name);
            }
            catch (NamingException e) {
                throw new ArchiveInjectionException("Cannot get object with JNDI Name '" + name + "' for Resource '" + jJavaxPersistenceUnit + "'.", e);
            }
        }
        this.setFieldValue(fieldMetadata, clazz, instance, value);
        if (needToBind) {
            this.bindValue(encName, value);
        }
    }

    public void injectFieldResource(IJAnnotationResource jAnnotationResource, ICommonFieldMetadata fieldMetadata, Class clazz, Object instance) throws ArchiveInjectionException {
        String mappedName = jAnnotationResource.getMappedName();
        Object value = null;
        String encName = this.buildENCName(jAnnotationResource.getName(), fieldMetadata);
        boolean needToBind = true;
        try {
            value = new InitialContext().lookup("java:comp/env/" + encName);
            needToBind = false;
        }
        catch (NamingException e) {
            logger.debug("Value for ENC '{0}' not bound in the registry", encName);
        }
        if (value == null) {
            if (mappedName == null) {
                String messageDestinationLink = jAnnotationResource.getMessageDestinationLink();
                if (messageDestinationLink == null) {
                    logger.warn("Injection of @Resource for {0} is not supported", jAnnotationResource);
                    return;
                }
                mappedName = this.getRemoteMessageDestinationJNDIName(messageDestinationLink);
            }
            try {
                value = new InitialContext().lookup(mappedName);
            }
            catch (NamingException e) {
                throw new ArchiveInjectionException("Cannot get object with JNDI Name '" + mappedName + "' for Resource '" + jAnnotationResource + "'.", e);
            }
        }
        this.setFieldValue(fieldMetadata, clazz, instance, value);
        if (needToBind) {
            this.bindValue(encName, value);
        }
    }

    protected void bindValue(String encName, Object value) {
        try {
            new InitialContext().bind("java:comp/env/" + encName, value);
        }
        catch (NamingException e) {
            logger.warn("Unable to bind the value for ENC '{0}'.", encName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setFieldValue(ICommonFieldMetadata fieldMetadata, Class clazz, Object instance, Object value) throws ArchiveInjectionException {
        JField jField = fieldMetadata.getJField();
        Field field = null;
        try {
            field = clazz.getDeclaredField(jField.getName());
        }
        catch (NoSuchFieldException e) {
            throw new ArchiveInjectionException("Cannot get field '" + jField + "' on the class '" + clazz.getName() + "'", e);
        }
        boolean accessible = field.isAccessible();
        try {
            field.setAccessible(true);
            try {
                field.set(instance, value);
            }
            catch (IllegalAccessException e) {
                throw new ArchiveInjectionException("Cannot set given value on the field '" + jField + "'.", e);
            }
        }
        finally {
            field.setAccessible(accessible);
        }
    }

    protected String buildENCName(String name, ICommonFieldMetadata fieldMetadata) {
        String encName = name;
        if (encName == null || "".equals(encName)) {
            encName = fieldMetadata.getClassMetadata().getJClass().getName().replace("/", ".") + "/" + fieldMetadata.getJField().getName();
        }
        return encName;
    }

    protected EZBRemoteJNDIResolver getJNDIResolver() throws ArchiveInjectionException {
        if (this.jndiResolver == null) {
            Object o = null;
            try {
                o = new InitialContext().lookup("EZB_Remote_JNDIResolver");
            }
            catch (NamingException e) {
                throw new ArchiveInjectionException("No Remote EJB3 JNDI Resolver found", e);
            }
            this.jndiResolver = (EZBRemoteJNDIResolver)PortableRemoteObject.narrow((Object)o, EZBRemoteJNDIResolver.class);
        }
        return this.jndiResolver;
    }

    protected String getRemoteMessageDestinationJNDIName(String messageDestinationName) throws ArchiveInjectionException {
        String jndiName = null;
        List<EZBJNDIData> jndiDataList = null;
        try {
            jndiDataList = this.getJNDIResolver().getMessageDestinationJNDINames(messageDestinationName);
        }
        catch (RemoteException re) {
            throw new ArchiveInjectionException("Unable to get JNDI Name for '" + messageDestinationName + "'", re);
        }
        if (jndiDataList.size() == 0) {
            throw new ArchiveInjectionException("Unable to get JNDI Name for message destination '" + messageDestinationName + "', no data was found on the remote side.");
        }
        if (jndiDataList.size() > 1) {
            logger.warn("There may be a problem for message destination '" + messageDestinationName + "', too many answers : '" + jndiDataList + "'. Using the first entry", new Object[0]);
        }
        EZBJNDIData jndiData = jndiDataList.get(0);
        jndiName = jndiData.getName();
        if (logger.isDebugEnabled()) {
            logger.debug("Found JNDI Name '" + jndiName + "' for message destination '" + messageDestinationName + "', answers : '" + jndiDataList + "'.", new Object[0]);
        }
        return jndiName;
    }

    protected String getRemoteEJBJNDIName(String interfaceName, String beanName) throws ArchiveInjectionException {
        String jndiName = null;
        List<EZBJNDIBeanData> jndiDataList = null;
        try {
            jndiDataList = this.getJNDIResolver().getEJBJNDINames(interfaceName, beanName);
        }
        catch (RemoteException re) {
            throw new ArchiveInjectionException("Unable to get JNDI Name for '" + interfaceName + "'/'" + beanName + "'", re);
        }
        if (jndiDataList.size() == 0) {
            throw new ArchiveInjectionException("Unable to get JNDI Name for '" + interfaceName + "'/'" + beanName + "', no data was found on the remote side.");
        }
        if (jndiDataList.size() > 1) {
            logger.warn("There may be a problem for bean '" + interfaceName + "'/'" + beanName + "', too many answers : '" + jndiDataList + "'. Using the first entry", new Object[0]);
        }
        EZBJNDIBeanData jndiData = jndiDataList.get(0);
        jndiName = jndiData.getName();
        if (logger.isDebugEnabled()) {
            logger.debug("Found JNDI Name '" + jndiName + "' for '" + interfaceName + "'/'" + beanName + "', answers : '" + jndiDataList + "'.", new Object[0]);
        }
        return jndiName;
    }

    protected ICommonClassMetadata<? extends ICommonClassMetadata, ? extends ICommonMethodMetadata, ? extends ICommonFieldMetadata> getClassMetadata(Class clazz) {
        return this.getClassMetadata(clazz.getName());
    }

    protected ICommonClassMetadata<? extends ICommonClassMetadata, ? extends ICommonMethodMetadata, ? extends ICommonFieldMetadata> getClassMetadata(String requestedClassName) {
        for (ICommonClassMetadata<? extends ICommonClassMetadata, ? extends ICommonMethodMetadata, ? extends ICommonFieldMetadata> iCommonClassMetadata : this.metadataCollection) {
            String className;
            JClass jClass = iCommonClassMetadata.getJClass();
            if (jClass == null || !requestedClassName.equals((className = jClass.getName()).replace('/', '.'))) continue;
            return iCommonClassMetadata;
        }
        return null;
    }
}

