/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.naming.interceptors;

import javax.naming.Context;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.api.naming.NamingInterceptor;
import org.ow2.easybeans.naming.interceptors.EZBENCInterceptor;
import org.ow2.easybeans.naming.interceptors.JOnASENCInterceptor;
import org.ow2.easybeans.naming.interceptors.JettyENCInterceptor;
import org.ow2.easybeans.naming.interceptors.TomcatENCInterceptor;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ENCManager {
    private static Log logger = LogFactory.getLog(ENCManager.class);
    private static Class<? extends NamingInterceptor> encInterceptor = null;

    private ENCManager() {
    }

    public static void setInterceptorClass(Class<? extends NamingInterceptor> userEncInterceptor) {
        if (encInterceptor != null) {
            throw new IllegalStateException("The interceptor class has already been set with '" + encInterceptor + "', cannot update it with '" + userEncInterceptor + "'.");
        }
        encInterceptor = userEncInterceptor;
    }

    public static Class<? extends NamingInterceptor> getInterceptorClass() {
        block9: {
            if (encInterceptor == null) {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                try {
                    loader.loadClass("org.objectweb.jonas.naming.NamingManager");
                    encInterceptor = JOnASENCInterceptor.class;
                    logger.info("Detecting JOnAS: using JOnAS ENC for the naming.", new Object[0]);
                }
                catch (ClassNotFoundException e) {
                    if (System.getProperty("catalina.home") != null) {
                        try {
                            loader.loadClass("org.apache.naming.ContextBindings");
                            encInterceptor = TomcatENCInterceptor.class;
                            logger.info("Detecting Tomcat: using Tomcat ENC for the naming.", new Object[0]);
                        }
                        catch (ClassNotFoundException e1) {
                            logger.debug("Unable to use Tomcat ENC for the naming", e1);
                        }
                    }
                    if (encInterceptor != null) break block9;
                    if (System.getProperty("jetty.home") != null) {
                        try {
                            loader.loadClass("org.mortbay.naming.ContextFactory");
                            encInterceptor = JettyENCInterceptor.class;
                            logger.info("Detecting Jetty: using Jetty ENC for the naming.", new Object[0]);
                        }
                        catch (ClassNotFoundException e2) {
                            logger.debug("Unable to use JETTY ENC for the naming", e2);
                        }
                    }
                    if (encInterceptor != null) break block9;
                    encInterceptor = EZBENCInterceptor.class;
                    logger.debug("Using EasyBeans ENC for the naming.", new Object[0]);
                }
            }
        }
        return encInterceptor;
    }

    public static void initContext(Factory factory, Context context) {
        try {
            encInterceptor.newInstance().initContext(factory.getId(), context);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Cannot init the context for the factory '" + factory.getClassName() + "' of container '" + factory.getContainer().getName() + "'.", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot init the context for the factory '" + factory.getClassName() + "' of container '" + factory.getContainer().getName() + "'.", e);
        }
    }

    public static void removeContext(Factory factory) {
        try {
            encInterceptor.newInstance().removeContext(factory.getId());
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Cannot remove the context for the factory '" + factory.getClassName() + "' of container '" + factory.getContainer().getName() + "'.", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot remove the context for the factory '" + factory.getClassName() + "' of container '" + factory.getContainer().getName() + "'.", e);
        }
    }
}

