/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.security.auth.spi;

import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.ow2.easybeans.security.api.EZBSecurityCurrent;
import org.ow2.easybeans.security.propagation.context.SecurityContext;
import org.ow2.easybeans.security.propagation.context.SecurityCurrent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientLoginModule
implements LoginModule {
    private Subject subject = null;
    private Map<String, ?> options = null;
    private boolean globalContext = false;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.options = options;
    }

    @Override
    public boolean login() throws LoginException {
        String useGlobalCtx = (String)this.options.get("globalCtx");
        if (useGlobalCtx != null && Boolean.valueOf(useGlobalCtx).booleanValue()) {
            this.globalContext = true;
        }
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        EZBSecurityCurrent current = SecurityCurrent.getCurrent();
        SecurityContext context = new SecurityContext(this.subject);
        if (this.globalContext) {
            SecurityCurrent.setGlobalSecurityContext(context);
        } else {
            current.setSecurityContext(context);
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        SecurityContext context = new SecurityContext(SecurityContext.ANONYMOUS_SUBJECT);
        EZBSecurityCurrent current = SecurityCurrent.getCurrent();
        if (this.globalContext) {
            SecurityCurrent.setGlobalSecurityContext(context);
        } else {
            current.setSecurityContext(context);
        }
        return true;
    }
}

