/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.server;

import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.EZBContainerException;
import org.ow2.easybeans.server.Embedded;
import org.ow2.easybeans.util.url.URLUtils;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.impl.ArchiveManager;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class ContainersMonitor
extends Thread {
    private static final int SLEEP_TIME = 5000;
    private Log logger = LogFactory.getLog(ContainersMonitor.class);
    private Map<EZBContainer, Long> modifiedFiles = null;
    private Embedded embedded = null;
    private boolean bootInProgress = false;
    private boolean stopped = false;

    public ContainersMonitor(Embedded embedded) {
        this.embedded = embedded;
        this.modifiedFiles = new WeakHashMap<EZBContainer, Long>();
    }

    public void init() {
        this.bootInProgress = true;
        this.scanNewContainers();
        this.bootInProgress = false;
    }

    public void run() {
        while (!this.stopped) {
            for (EZBContainer container : this.embedded.getContainers().values()) {
                if (!container.isAvailable()) continue;
                this.checkContainer(container);
            }
            this.scanNewContainers();
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Thread fail to sleep");
            }
        }
        return;
    }

    private void scanNewContainers() {
        List<File> deployDirectories = this.embedded.getServerConfig().getDeployDirectories();
        for (File deployDirectory : deployDirectories) {
            File[] files = deployDirectory.listFiles();
            if (files == null) continue;
            for (File f : files) {
                if (!f.getName().toLowerCase().endsWith(".jar")) continue;
                IArchive archive = ArchiveManager.getInstance().getArchive(f);
                boolean alreadyExist = false;
                for (EZBContainer container : this.embedded.getContainers().values()) {
                    if (!container.getArchive().equals(archive)) continue;
                    alreadyExist = true;
                }
                if (alreadyExist) continue;
                if (!this.bootInProgress) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException("Thread fail to sleep");
                    }
                }
                this.logger.info("Creating container for archive {0}.", f);
                EZBContainer container = this.embedded.createContainer(archive);
                try {
                    container.start();
                }
                catch (EZBContainerException e) {
                    this.logger.error("Cannot start container {0}", container.getName(), e);
                }
            }
        }
    }

    protected void checkContainer(EZBContainer container) {
        long previousLastModified = 0L;
        Long l = this.modifiedFiles.get(container);
        if (l != null) {
            previousLastModified = l;
        }
        IArchive archive = container.getArchive();
        URL url = null;
        try {
            url = archive.getURL();
        }
        catch (ArchiveException e1) {
            this.logger.warn("Cannot get URL on the container {0}", archive.getName());
            return;
        }
        File file = URLUtils.urlToFile(url);
        if (!file.exists()) {
            return;
        }
        long updatedModified = this.getLastModified(file);
        this.modifiedFiles.put(container, updatedModified);
        if (previousLastModified == 0L) {
            return;
        }
        if (updatedModified > previousLastModified) {
            this.logger.info("Container with archive {0} was modified. Reloading...", archive.getName());
            container.stop();
            try {
                container.start();
            }
            catch (EZBContainerException e) {
                e.printStackTrace();
            }
        }
    }

    protected long getLastModified(File archive) {
        if (archive.isFile()) {
            return archive.lastModified();
        }
        File[] files = archive.listFiles();
        long last = 0L;
        if (files != null) {
            for (File f : files) {
                last = Math.max(last, this.getLastModified(f));
            }
        }
        return last;
    }

    public void stopOrder() {
        this.stopped = true;
    }

    public Embedded getEmbedded() {
        return this.embedded;
    }
}

