/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.fastrmic;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.MarshalException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.UnexpectedException;
import java.rmi.UnmarshalException;
import java.rmi.server.Operation;
import java.rmi.server.RemoteCall;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteRef;
import java.rmi.server.RemoteStub;
import java.rmi.server.Skeleton;
import java.rmi.server.SkeletonMismatchException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.ow2.fastrmic.ClassInfo;
import org.ow2.fastrmic.RMICException;
import org.ow2.fastrmic.Variables;
import org.ow2.fastrmic.asm.ClassVisitor;
import org.ow2.fastrmic.asm.ClassWriter;
import org.ow2.fastrmic.asm.Label;
import org.ow2.fastrmic.asm.MethodVisitor;
import org.ow2.fastrmic.asm.Opcodes;
import org.ow2.fastrmic.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RMIC
implements Opcodes {
    private String[] args;
    private int next;
    private Exception exception;
    private boolean keep = false;
    private boolean need11Stubs = true;
    private boolean need12Stubs = true;
    private boolean compile = true;
    private boolean verbose;
    private String destination;
    private String classpath;
    private ClassLoader loader;
    private int errorCount = 0;
    private Class clazz;
    private String classname;
    private String classInternalName;
    private String fullclassname;
    private MethodRef[] remotemethods;
    private String stubname;
    private String skelname;
    private List mRemoteInterfaces;
    private static final String forName = "class$";

    public RMIC(String[] a) {
        this.args = a;
    }

    public static void main(String[] args) {
        RMIC r = new RMIC(args);
        if (!r.run()) {
            Exception e = r.getException();
            if (e != null) {
                e.printStackTrace();
            } else {
                System.exit(1);
            }
        }
    }

    public boolean run() {
        this.parseOptions();
        if (this.next >= this.args.length) {
            RMIC.error("no class names found");
        }
        for (int i = this.next; i < this.args.length; ++i) {
            try {
                if (this.verbose) {
                    System.out.println("[Processing class " + this.args[i] + ".class]");
                }
                this.processClass(this.args[i].replace(File.separatorChar, '.'));
                continue;
            }
            catch (Exception e) {
                this.exception = e;
                return false;
            }
        }
        return true;
    }

    private boolean processClass(String cls) throws Exception {
        this.clazz = null;
        this.classname = null;
        this.classInternalName = null;
        this.fullclassname = null;
        this.remotemethods = null;
        this.stubname = null;
        this.skelname = null;
        this.mRemoteInterfaces = new ArrayList();
        this.errorCount = 0;
        this.analyzeClass(cls);
        if (this.errorCount > 0) {
            System.exit(1);
        }
        this.generateStub();
        if (this.need11Stubs) {
            this.generateSkel();
        }
        return true;
    }

    private void analyzeClass(String cname) throws Exception {
        int p;
        if (this.verbose) {
            System.out.println("[analyze class " + cname + "]");
        }
        this.classname = (p = cname.lastIndexOf(46)) != -1 ? cname.substring(p + 1) : cname;
        this.fullclassname = cname;
        this.findClass();
        this.findRemoteMethods();
    }

    public Exception getException() {
        return this.exception;
    }

    private void findClass() {
        try {
            ClassLoader cl = this.loader == null ? ClassLoader.getSystemClassLoader() : this.loader;
            this.clazz = Class.forName(this.fullclassname, false, cl);
        }
        catch (ClassNotFoundException cnfe) {
            System.err.println(this.fullclassname + " not found in " + this.classpath);
            throw new RuntimeException(cnfe);
        }
        if (!Remote.class.isAssignableFrom(this.clazz)) {
            this.logError("Class " + this.clazz.getName() + " is not a remote object. " + "It does not implement an interface that is a " + "java.rmi.Remote-interface.");
            throw new RuntimeException("Class " + this.clazz.getName() + " is not a remote object. " + "It does not implement an interface that is a " + "java.rmi.Remote-interface.");
        }
    }

    private static Type[] typeArray(Class[] cls) {
        Type[] t = new Type[cls.length];
        for (int i = 0; i < cls.length; ++i) {
            t[i] = Type.getType(cls[i]);
        }
        return t;
    }

    private static String[] internalNameArray(Type[] t) {
        String[] s = new String[t.length];
        for (int i = 0; i < t.length; ++i) {
            s[i] = t[i].getInternalName();
        }
        return s;
    }

    private static String[] internalNameArray(Class[] c) {
        return RMIC.internalNameArray(RMIC.typeArray(c));
    }

    private static Object param(Method m, int argIndex) {
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(m);
        l.add(new Integer(argIndex));
        return l;
    }

    private static void generateClassForNamer(ClassVisitor cls) {
        MethodVisitor cv = cls.visitMethod(4106, forName, Type.getMethodDescriptor(Type.getType(Class.class), new Type[]{Type.getType(String.class)}), null, null);
        Label start = new Label();
        cv.visitLabel(start);
        cv.visitVarInsn(25, 0);
        cv.visitMethodInsn(184, Type.getInternalName(Class.class), "forName", Type.getMethodDescriptor(Type.getType(Class.class), new Type[]{Type.getType(String.class)}));
        cv.visitInsn(176);
        Label handler = new Label();
        cv.visitLabel(handler);
        cv.visitVarInsn(58, 1);
        cv.visitTypeInsn(187, RMIC.typeArg(NoClassDefFoundError.class));
        cv.visitInsn(89);
        cv.visitVarInsn(25, 1);
        cv.visitMethodInsn(182, Type.getInternalName(ClassNotFoundException.class), "getMessage", Type.getMethodDescriptor(Type.getType(String.class), new Type[0]));
        cv.visitMethodInsn(183, Type.getInternalName(NoClassDefFoundError.class), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[]{Type.getType(String.class)}));
        cv.visitInsn(191);
        cv.visitTryCatchBlock(start, handler, handler, Type.getInternalName(ClassNotFoundException.class));
        cv.visitMaxs(-1, -1);
    }

    private void generateClassConstant(MethodVisitor cv, Class cls) {
        if (cls.isPrimitive()) {
            Class boxCls;
            if (cls.equals(Boolean.TYPE)) {
                boxCls = Boolean.class;
            } else if (cls.equals(Character.TYPE)) {
                boxCls = Character.class;
            } else if (cls.equals(Byte.TYPE)) {
                boxCls = Byte.class;
            } else if (cls.equals(Short.TYPE)) {
                boxCls = Short.class;
            } else if (cls.equals(Integer.TYPE)) {
                boxCls = Integer.class;
            } else if (cls.equals(Long.TYPE)) {
                boxCls = Long.class;
            } else if (cls.equals(Float.TYPE)) {
                boxCls = Float.class;
            } else if (cls.equals(Double.TYPE)) {
                boxCls = Double.class;
            } else if (cls.equals(Void.TYPE)) {
                boxCls = Void.class;
            } else {
                throw new IllegalArgumentException("unknown primitive type " + cls);
            }
            cv.visitFieldInsn(178, Type.getInternalName(boxCls), "TYPE", Type.getDescriptor(Class.class));
            return;
        }
        cv.visitLdcInsn(cls.getName());
        cv.visitMethodInsn(184, this.classInternalName, forName, Type.getMethodDescriptor(Type.getType(Class.class), new Type[]{Type.getType(String.class)}));
    }

    private void generateClassArray(MethodVisitor code, Class[] classes) {
        code.visitLdcInsn(new Integer(classes.length));
        code.visitTypeInsn(189, RMIC.typeArg(Class.class));
        for (int i = 0; i < classes.length; ++i) {
            code.visitInsn(89);
            code.visitLdcInsn(new Integer(i));
            this.generateClassConstant(code, classes[i]);
            code.visitInsn(83);
        }
    }

    private void fillOperationArray(MethodVisitor clinit) {
        clinit.visitLdcInsn(new Integer(this.remotemethods.length));
        clinit.visitTypeInsn(189, RMIC.typeArg(Operation.class));
        clinit.visitFieldInsn(179, this.classInternalName, "operations", Type.getDescriptor(Operation[].class));
        for (int i = 0; i < this.remotemethods.length; ++i) {
            Method m = this.remotemethods[i].meth;
            StringBuffer desc = new StringBuffer();
            desc.append(RMIC.getPrettyName(m.getReturnType()) + " ");
            desc.append(m.getName() + "(");
            Class<?>[] sig = m.getParameterTypes();
            for (int j = 0; j < sig.length; ++j) {
                desc.append(RMIC.getPrettyName(sig[j]));
                if (j + 1 >= sig.length) continue;
                desc.append(", ");
            }
            clinit.visitFieldInsn(178, this.classInternalName, "operations", Type.getDescriptor(Operation[].class));
            clinit.visitLdcInsn(new Integer(i));
            clinit.visitTypeInsn(187, RMIC.typeArg(Operation.class));
            clinit.visitInsn(89);
            clinit.visitLdcInsn(desc.toString());
            clinit.visitMethodInsn(183, Type.getInternalName(Operation.class), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[]{Type.getType(String.class)}));
            clinit.visitInsn(83);
        }
    }

    private void generateStaticMethodObjs(MethodVisitor clinit) {
        for (int i = 0; i < this.remotemethods.length; ++i) {
            Method m = this.remotemethods[i].meth;
            String methodVar = "$method_" + m.getName() + "_" + i;
            this.generateClassConstant(clinit, m.getDeclaringClass());
            clinit.visitLdcInsn(m.getName());
            this.generateClassArray(clinit, m.getParameterTypes());
            clinit.visitMethodInsn(182, Type.getInternalName(Class.class), "getMethod", Type.getMethodDescriptor(Type.getType(Method.class), new Type[]{Type.getType(String.class), Type.getType(Class[].class)}));
            clinit.visitFieldInsn(179, this.classInternalName, methodVar, Type.getDescriptor(Method.class));
        }
    }

    private void generateStub() throws IOException {
        ClassInfo classInfo = this.generateStubData();
        File file = new File((this.destination == null ? "." : this.destination) + File.separator + classInfo.getName().replace('.', File.separatorChar) + ".class");
        if (file.exists()) {
            file.delete();
        }
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        FileOutputStream fos = new FileOutputStream(file);
        fos.write(classInfo.getBytecode());
        fos.flush();
        fos.close();
    }

    private ClassInfo generateStubData() throws IOException {
        ClassInfo classInfo = new ClassInfo();
        this.stubname = this.fullclassname + "_Stub";
        classInfo.setName(this.stubname);
        if (this.verbose) {
            System.out.println("[Generating class " + this.stubname + "]");
        }
        ClassWriter stub = new ClassWriter(1);
        this.classInternalName = this.stubname.replace('.', '/');
        String superInternalName = Type.getType(RemoteStub.class).getInternalName();
        String[] remoteInternalNames = RMIC.internalNameArray(this.mRemoteInterfaces.toArray(new Class[0]));
        stub.visit(46, 17, this.classInternalName, null, superInternalName, remoteInternalNames);
        if (this.need12Stubs) {
            stub.visitField(26, "serialVersionUID", Type.LONG_TYPE.getDescriptor(), null, new Long(2L));
        }
        if (this.need11Stubs) {
            stub.visitField(26, "interfaceHash", Type.LONG_TYPE.getDescriptor(), null, new Long(RMIC.getInterfaceHash(this.clazz)));
            if (this.need12Stubs) {
                stub.visitField(10, "useNewInvoke", Type.BOOLEAN_TYPE.getDescriptor(), null, null);
            }
            stub.visitField(26, "operations", Type.getDescriptor(Operation[].class), null, null);
        }
        if (this.need12Stubs) {
            for (int i = 0; i < this.remotemethods.length; ++i) {
                Method m = this.remotemethods[i].meth;
                String slotName = "$method_" + m.getName() + "_" + i;
                stub.visitField(10, slotName, Type.getDescriptor(Method.class), null, null);
            }
        }
        MethodVisitor clinit = stub.visitMethod(8, "<clinit>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]), null, null);
        if (this.need11Stubs) {
            this.fillOperationArray(clinit);
            if (!this.need12Stubs) {
                clinit.visitInsn(177);
            }
        }
        if (this.need12Stubs) {
            Label begin = new Label();
            Label handler = new Label();
            clinit.visitLabel(begin);
            if (this.need11Stubs) {
                this.generateClassConstant(clinit, RemoteRef.class);
                clinit.visitLdcInsn("invoke");
                this.generateClassArray(clinit, new Class[]{Remote.class, Method.class, Object[].class, Long.TYPE});
                clinit.visitMethodInsn(182, Type.getInternalName(Class.class), "getMethod", Type.getMethodDescriptor(Type.getType(Method.class), new Type[]{Type.getType(String.class), Type.getType(Class[].class)}));
                clinit.visitInsn(4);
                clinit.visitFieldInsn(179, this.classInternalName, "useNewInvoke", Type.BOOLEAN_TYPE.getDescriptor());
            }
            this.generateStaticMethodObjs(clinit);
            clinit.visitInsn(177);
            clinit.visitLabel(handler);
            if (this.need11Stubs) {
                clinit.visitInsn(3);
                clinit.visitFieldInsn(179, this.classInternalName, "useNewInvoke", Type.BOOLEAN_TYPE.getDescriptor());
                clinit.visitInsn(177);
            } else {
                clinit.visitTypeInsn(187, RMIC.typeArg(NoSuchMethodError.class));
                clinit.visitInsn(89);
                clinit.visitLdcInsn("stub class initialization failed");
                clinit.visitMethodInsn(183, Type.getInternalName(NoSuchMethodError.class), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[]{Type.getType(String.class)}));
                clinit.visitInsn(191);
            }
            clinit.visitTryCatchBlock(begin, handler, handler, Type.getInternalName(NoSuchMethodException.class));
        }
        clinit.visitMaxs(-1, -1);
        RMIC.generateClassForNamer(stub);
        if (this.need11Stubs) {
            MethodVisitor code = stub.visitMethod(1, "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]), null, null);
            code.visitVarInsn(25, 0);
            code.visitMethodInsn(183, superInternalName, "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]));
            code.visitInsn(177);
            code.visitMaxs(-1, -1);
        }
        MethodVisitor constructor = stub.visitMethod(1, "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[]{Type.getType(RemoteRef.class)}), null, null);
        constructor.visitVarInsn(25, 0);
        constructor.visitVarInsn(25, 1);
        constructor.visitMethodInsn(183, superInternalName, "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[]{Type.getType(RemoteRef.class)}));
        constructor.visitInsn(177);
        constructor.visitMaxs(-1, -1);
        for (int i = 0; i < this.remotemethods.length; ++i) {
            int j;
            Method m = this.remotemethods[i].meth;
            Class[] sig = m.getParameterTypes();
            Class<Object> returntype = m.getReturnType();
            Class[] except = this.sortExceptions(this.remotemethods[i].exceptions.toArray(new Class[0]));
            MethodVisitor code = stub.visitMethod(1, m.getName(), Type.getMethodDescriptor(Type.getType(returntype), RMIC.typeArray(sig)), null, RMIC.internalNameArray(RMIC.typeArray(except)));
            Variables var = new Variables();
            var.declare("this");
            for (int j2 = 0; j2 < sig.length; ++j2) {
                var.declare(RMIC.param(m, j2), RMIC.size(sig[j2]));
            }
            Label methodTryBegin = new Label();
            code.visitLabel(methodTryBegin);
            if (this.need12Stubs) {
                Label oldInvoke = new Label();
                if (this.need11Stubs) {
                    code.visitFieldInsn(178, this.classInternalName, "useNewInvoke", Type.getDescriptor(Boolean.TYPE));
                    code.visitJumpInsn(153, oldInvoke);
                }
                code.visitVarInsn(25, var.get("this"));
                code.visitFieldInsn(180, Type.getInternalName(RemoteObject.class), "ref", Type.getDescriptor(RemoteRef.class));
                code.visitVarInsn(25, var.get("this"));
                String methName = "$method_" + m.getName() + "_" + i;
                code.visitFieldInsn(178, this.classInternalName, methName, Type.getDescriptor(Method.class));
                if (sig.length == 0) {
                    code.visitInsn(1);
                } else {
                    code.visitLdcInsn(new Integer(sig.length));
                    code.visitTypeInsn(189, RMIC.typeArg(Object.class));
                    var.allocate("argArray");
                    code.visitVarInsn(58, var.get("argArray"));
                    for (int j3 = 0; j3 < sig.length; ++j3) {
                        int size = RMIC.size(sig[j3]);
                        int insn = RMIC.loadOpcode(sig[j3]);
                        Class box = sig[j3].isPrimitive() ? RMIC.box(sig[j3]) : null;
                        code.visitVarInsn(25, var.get("argArray"));
                        code.visitLdcInsn(new Integer(j3));
                        if (box != null) {
                            code.visitTypeInsn(187, RMIC.typeArg(box));
                            code.visitInsn(89);
                            code.visitVarInsn(insn, var.get(RMIC.param(m, j3)));
                            code.visitMethodInsn(183, Type.getInternalName(box), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[]{Type.getType(sig[j3])}));
                        } else {
                            code.visitVarInsn(insn, var.get(RMIC.param(m, j3)));
                        }
                        code.visitInsn(83);
                    }
                    code.visitVarInsn(25, var.deallocate("argArray"));
                }
                code.visitLdcInsn(new Long(this.remotemethods[i].hash));
                code.visitMethodInsn(185, Type.getInternalName(RemoteRef.class), "invoke", Type.getMethodDescriptor(Type.getType(Object.class), new Type[]{Type.getType(Remote.class), Type.getType(Method.class), Type.getType(Object[].class), Type.LONG_TYPE}));
                if (!returntype.equals(Void.TYPE)) {
                    int retcode = RMIC.returnOpcode(returntype);
                    Class<Object> boxCls = returntype.isPrimitive() ? RMIC.box(returntype) : null;
                    code.visitTypeInsn(192, RMIC.typeArg(boxCls == null ? returntype : boxCls));
                    if (returntype.isPrimitive()) {
                        code.visitMethodInsn(182, Type.getType(boxCls).getInternalName(), RMIC.unboxMethod(returntype), Type.getMethodDescriptor(Type.getType(returntype), new Type[0]));
                    }
                    code.visitInsn(retcode);
                } else {
                    code.visitInsn(177);
                }
                if (this.need11Stubs) {
                    code.visitLabel(oldInvoke);
                }
            }
            if (this.need11Stubs) {
                code.visitVarInsn(25, var.get("this"));
                code.visitFieldInsn(180, Type.getInternalName(RemoteObject.class), "ref", Type.getDescriptor(RemoteRef.class));
                code.visitVarInsn(25, var.get("this"));
                code.visitFieldInsn(178, this.classInternalName, "operations", Type.getDescriptor(Operation[].class));
                code.visitLdcInsn(new Integer(i));
                code.visitFieldInsn(178, this.classInternalName, "interfaceHash", Type.LONG_TYPE.getDescriptor());
                code.visitMethodInsn(185, Type.getInternalName(RemoteRef.class), "newCall", Type.getMethodDescriptor(Type.getType(RemoteCall.class), new Type[]{Type.getType(RemoteObject.class), Type.getType(Operation[].class), Type.INT_TYPE, Type.LONG_TYPE}));
                var.allocate("call");
                code.visitInsn(89);
                code.visitVarInsn(58, var.get("call"));
                Label beginArgumentTryBlock = new Label();
                code.visitLabel(beginArgumentTryBlock);
                code.visitMethodInsn(185, Type.getInternalName(RemoteCall.class), "getOutputStream", Type.getMethodDescriptor(Type.getType(ObjectOutput.class), new Type[0]));
                for (int j4 = 0; j4 < sig.length; ++j4) {
                    code.visitInsn(89);
                    code.visitVarInsn(RMIC.loadOpcode(sig[j4]), var.get(RMIC.param(m, j4)));
                    Class argCls = sig[j4].isPrimitive() ? sig[j4] : Object.class;
                    code.visitMethodInsn(185, Type.getInternalName(ObjectOutput.class), RMIC.writeMethod(sig[j4]), Type.getMethodDescriptor(Type.VOID_TYPE, new Type[]{Type.getType(argCls)}));
                }
                code.visitInsn(87);
                Label iohandler = new Label();
                Label endArgumentTryBlock = new Label();
                code.visitJumpInsn(167, endArgumentTryBlock);
                code.visitLabel(iohandler);
                code.visitVarInsn(58, var.allocate("exception"));
                code.visitTypeInsn(187, RMIC.typeArg(MarshalException.class));
                code.visitInsn(89);
                code.visitLdcInsn("error marshalling arguments");
                code.visitVarInsn(25, var.deallocate("exception"));
                code.visitMethodInsn(183, Type.getInternalName(MarshalException.class), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[]{Type.getType(String.class), Type.getType(Exception.class)}));
                code.visitInsn(191);
                code.visitLabel(endArgumentTryBlock);
                code.visitTryCatchBlock(beginArgumentTryBlock, iohandler, iohandler, Type.getInternalName(IOException.class));
                code.visitVarInsn(25, var.get("this"));
                code.visitFieldInsn(180, Type.getInternalName(RemoteObject.class), "ref", Type.getDescriptor(RemoteRef.class));
                code.visitVarInsn(25, var.get("call"));
                code.visitMethodInsn(185, Type.getInternalName(RemoteRef.class), "invoke", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[]{Type.getType(RemoteCall.class)}));
                boolean needcastcheck = false;
                Label beginReturnTryCatch = new Label();
                code.visitLabel(beginReturnTryCatch);
                int returncode = RMIC.returnOpcode(returntype);
                if (!returntype.equals(Void.TYPE)) {
                    code.visitVarInsn(25, var.get("call"));
                    code.visitMethodInsn(185, Type.getInternalName(RemoteCall.class), "getInputStream", Type.getMethodDescriptor(Type.getType(ObjectInput.class), new Type[0]));
                    Class<Object> readCls = returntype.isPrimitive() ? returntype : Object.class;
                    code.visitMethodInsn(185, Type.getInternalName(ObjectInput.class), RMIC.readMethod(returntype), Type.getMethodDescriptor(Type.getType(readCls), new Type[0]));
                    boolean castresult = false;
                    if (!returntype.isPrimitive()) {
                        if (!returntype.equals(Object.class)) {
                            castresult = true;
                        } else {
                            needcastcheck = true;
                        }
                    }
                    if (castresult) {
                        code.visitTypeInsn(192, RMIC.typeArg(returntype));
                    }
                }
                code.visitVarInsn(25, var.get("this"));
                code.visitFieldInsn(180, Type.getInternalName(RemoteObject.class), "ref", Type.getDescriptor(RemoteRef.class));
                code.visitVarInsn(25, var.deallocate("call"));
                code.visitMethodInsn(185, Type.getInternalName(RemoteRef.class), "done", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[]{Type.getType(RemoteCall.class)}));
                code.visitInsn(returncode);
                Label handler = new Label();
                code.visitLabel(handler);
                code.visitVarInsn(58, var.allocate("exception"));
                code.visitTypeInsn(187, RMIC.typeArg(UnmarshalException.class));
                code.visitInsn(89);
                code.visitLdcInsn("error unmarshalling return");
                code.visitVarInsn(25, var.deallocate("exception"));
                code.visitMethodInsn(183, Type.getInternalName(UnmarshalException.class), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[]{Type.getType(String.class), Type.getType(Exception.class)}));
                code.visitInsn(191);
                Label endReturnTryCatch = new Label();
                code.visitTryCatchBlock(beginReturnTryCatch, handler, handler, Type.getInternalName(IOException.class));
                if (needcastcheck) {
                    code.visitTryCatchBlock(beginReturnTryCatch, handler, handler, Type.getInternalName(ClassNotFoundException.class));
                }
            }
            Label rethrowHandler = new Label();
            code.visitLabel(rethrowHandler);
            code.visitInsn(191);
            boolean needgeneral = true;
            for (j = 0; j < except.length; ++j) {
                if (except[j] != Exception.class) continue;
                needgeneral = false;
            }
            for (j = 0; j < except.length; ++j) {
                code.visitTryCatchBlock(methodTryBegin, rethrowHandler, rethrowHandler, Type.getInternalName(except[j]));
            }
            if (needgeneral) {
                code.visitTryCatchBlock(methodTryBegin, rethrowHandler, rethrowHandler, Type.getInternalName(RuntimeException.class));
                Label generalHandler = new Label();
                code.visitLabel(generalHandler);
                String msg = "undeclared checked exception";
                code.visitVarInsn(58, var.allocate("exception"));
                code.visitTypeInsn(187, RMIC.typeArg(UnexpectedException.class));
                code.visitInsn(89);
                code.visitLdcInsn(msg);
                code.visitVarInsn(25, var.deallocate("exception"));
                code.visitMethodInsn(183, Type.getInternalName(UnexpectedException.class), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[]{Type.getType(String.class), Type.getType(Exception.class)}));
                code.visitInsn(191);
                code.visitTryCatchBlock(methodTryBegin, rethrowHandler, generalHandler, Type.getInternalName(Exception.class));
            }
            code.visitMaxs(-1, -1);
        }
        stub.visitEnd();
        byte[] classData = stub.toByteArray();
        classInfo.setBytecode(classData);
        return classInfo;
    }

    private void generateSkel() throws IOException {
        ClassInfo classInfo = this.generateSkelData();
        File file = new File(this.destination == null ? "" : this.destination + File.separator + classInfo.getName().replace('.', File.separatorChar) + ".class");
        if (file.exists()) {
            file.delete();
        }
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        FileOutputStream fos = new FileOutputStream(file);
        fos.write(classInfo.getBytecode());
        fos.flush();
        fos.close();
    }

    private ClassInfo generateSkelData() throws IOException {
        int i;
        ClassInfo classInfo = new ClassInfo();
        this.skelname = this.fullclassname + "_Skel";
        classInfo.setName(this.skelname);
        if (this.verbose) {
            System.out.println("[Generating class " + this.skelname + "]");
        }
        ClassWriter skel = new ClassWriter(1);
        this.classInternalName = this.skelname.replace('.', '/');
        skel.visit(196653, 17, this.classInternalName, null, Type.getInternalName(Object.class), new String[]{Type.getType(Skeleton.class).getInternalName()});
        skel.visitField(26, "interfaceHash", Type.LONG_TYPE.getDescriptor(), null, new Long(RMIC.getInterfaceHash(this.clazz)));
        skel.visitField(26, "operations", Type.getDescriptor(Operation[].class), null, null);
        MethodVisitor clinit = skel.visitMethod(8, "<clinit>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]), null, null);
        this.fillOperationArray(clinit);
        clinit.visitInsn(177);
        clinit.visitMaxs(-1, -1);
        MethodVisitor init = skel.visitMethod(1, "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]), null, null);
        init.visitVarInsn(25, 0);
        init.visitMethodInsn(183, Type.getInternalName(Object.class), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]));
        init.visitInsn(177);
        init.visitMaxs(-1, -1);
        MethodVisitor getOp = skel.visitMethod(1, "getOperations", Type.getMethodDescriptor(Type.getType(Operation[].class), new Type[0]), null, null);
        getOp.visitFieldInsn(178, this.classInternalName, "operations", Type.getDescriptor(Operation[].class));
        getOp.visitMethodInsn(182, Type.getInternalName(Object.class), "clone", Type.getMethodDescriptor(Type.getType(Object.class), new Type[0]));
        getOp.visitTypeInsn(192, RMIC.typeArg(Operation[].class));
        getOp.visitInsn(176);
        getOp.visitMaxs(-1, -1);
        MethodVisitor dispatch = skel.visitMethod(1, "dispatch", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[]{Type.getType(Remote.class), Type.getType(RemoteCall.class), Type.INT_TYPE, Type.LONG_TYPE}), null, new String[]{Type.getInternalName(Exception.class)});
        Variables var = new Variables();
        var.declare("this");
        var.declare("remoteobj");
        var.declare("remotecall");
        var.declare("opnum");
        var.declareWide("hash");
        dispatch.visitVarInsn(21, var.get("opnum"));
        Label nonNegativeOpnum = new Label();
        Label opnumSet = new Label();
        dispatch.visitJumpInsn(156, nonNegativeOpnum);
        for (int i2 = 0; i2 < this.remotemethods.length; ++i2) {
            dispatch.visitVarInsn(22, var.get("hash"));
            dispatch.visitLdcInsn(new Long(this.remotemethods[i2].hash));
            Label notit = new Label();
            dispatch.visitInsn(148);
            dispatch.visitJumpInsn(154, notit);
            dispatch.visitLdcInsn(new Integer(i2));
            dispatch.visitVarInsn(54, var.get("opnum"));
            dispatch.visitJumpInsn(167, opnumSet);
            dispatch.visitLabel(notit);
        }
        Label mismatch = new Label();
        dispatch.visitJumpInsn(167, mismatch);
        dispatch.visitLabel(nonNegativeOpnum);
        dispatch.visitVarInsn(22, var.get("hash"));
        dispatch.visitFieldInsn(178, this.classInternalName, "interfaceHash", Type.LONG_TYPE.getDescriptor());
        dispatch.visitInsn(148);
        dispatch.visitJumpInsn(153, opnumSet);
        dispatch.visitLabel(mismatch);
        dispatch.visitTypeInsn(187, RMIC.typeArg(SkeletonMismatchException.class));
        dispatch.visitInsn(89);
        dispatch.visitLdcInsn("interface hash mismatch");
        dispatch.visitMethodInsn(183, Type.getInternalName(SkeletonMismatchException.class), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[]{Type.getType(String.class)}));
        dispatch.visitInsn(191);
        dispatch.visitLabel(opnumSet);
        dispatch.visitVarInsn(25, var.get("remoteobj"));
        dispatch.visitTypeInsn(192, RMIC.typeArg(this.clazz));
        dispatch.visitVarInsn(58, var.get("remoteobj"));
        Label deflt = new Label();
        Label[] methLabels = new Label[this.remotemethods.length];
        for (i = 0; i < methLabels.length; ++i) {
            methLabels[i] = new Label();
        }
        dispatch.visitVarInsn(21, var.get("opnum"));
        dispatch.visitTableSwitchInsn(0, this.remotemethods.length - 1, deflt, methLabels);
        for (i = 0; i < this.remotemethods.length; ++i) {
            dispatch.visitLabel(methLabels[i]);
            Method m = this.remotemethods[i].meth;
            this.generateMethodSkel(dispatch, m, var);
        }
        dispatch.visitLabel(deflt);
        dispatch.visitTypeInsn(187, RMIC.typeArg(UnmarshalException.class));
        dispatch.visitInsn(89);
        dispatch.visitLdcInsn("invalid method number");
        dispatch.visitMethodInsn(183, Type.getInternalName(UnmarshalException.class), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[]{Type.getType(String.class)}));
        dispatch.visitInsn(191);
        dispatch.visitMaxs(-1, -1);
        skel.visitEnd();
        byte[] classData = skel.toByteArray();
        classInfo.setBytecode(classData);
        return classInfo;
    }

    private void generateMethodSkel(MethodVisitor cv, Method m, Variables var) {
        Class<?>[] sig = m.getParameterTypes();
        Label readArgs = new Label();
        cv.visitLabel(readArgs);
        boolean needcastcheck = false;
        cv.visitVarInsn(25, var.get("remotecall"));
        cv.visitMethodInsn(185, Type.getInternalName(RemoteCall.class), "getInputStream", Type.getMethodDescriptor(Type.getType(ObjectInput.class), new Type[0]));
        cv.visitVarInsn(58, var.allocate("objectinput"));
        for (int i = 0; i < sig.length; ++i) {
            cv.visitVarInsn(25, var.get("objectinput"));
            Class<Object> readCls = sig[i].isPrimitive() ? sig[i] : Object.class;
            cv.visitMethodInsn(185, Type.getInternalName(ObjectInput.class), RMIC.readMethod(sig[i]), Type.getMethodDescriptor(Type.getType(readCls), new Type[0]));
            if (!sig[i].isPrimitive() && !sig[i].equals(Object.class)) {
                needcastcheck = true;
                cv.visitTypeInsn(192, RMIC.typeArg(sig[i]));
            }
            cv.visitVarInsn(RMIC.storeOpcode(sig[i]), var.allocate(RMIC.param(m, i), RMIC.size(sig[i])));
        }
        var.deallocate("objectinput");
        Label doCall = new Label();
        Label closeInput = new Label();
        cv.visitJumpInsn(168, closeInput);
        cv.visitJumpInsn(167, doCall);
        Label handler = new Label();
        cv.visitLabel(handler);
        cv.visitVarInsn(58, var.allocate("exception"));
        cv.visitTypeInsn(187, RMIC.typeArg(UnmarshalException.class));
        cv.visitInsn(89);
        cv.visitLdcInsn("error unmarshalling arguments");
        cv.visitVarInsn(25, var.deallocate("exception"));
        cv.visitMethodInsn(183, Type.getInternalName(UnmarshalException.class), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[]{Type.getType(String.class), Type.getType(Exception.class)}));
        cv.visitVarInsn(58, var.allocate("toThrow"));
        cv.visitJumpInsn(168, closeInput);
        cv.visitVarInsn(25, var.get("toThrow"));
        cv.visitInsn(191);
        cv.visitTryCatchBlock(readArgs, handler, handler, Type.getInternalName(IOException.class));
        if (needcastcheck) {
            cv.visitTryCatchBlock(readArgs, handler, handler, Type.getInternalName(ClassCastException.class));
        }
        cv.visitLabel(closeInput);
        cv.visitVarInsn(58, var.allocate("retAddress"));
        cv.visitVarInsn(25, var.get("remotecall"));
        cv.visitMethodInsn(185, Type.getInternalName(RemoteCall.class), "releaseInputStream", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]));
        cv.visitVarInsn(169, var.deallocate("retAddress"));
        var.deallocate("toThrow");
        cv.visitLabel(doCall);
        cv.visitVarInsn(25, var.get("remoteobj"));
        for (int i = 0; i < sig.length; ++i) {
            cv.visitVarInsn(RMIC.loadOpcode(sig[i]), var.deallocate(RMIC.param(m, i)));
        }
        cv.visitMethodInsn(182, Type.getInternalName(this.clazz), m.getName(), Type.getMethodDescriptor(m));
        Class<?> returntype = m.getReturnType();
        if (!returntype.equals(Void.TYPE)) {
            cv.visitVarInsn(RMIC.storeOpcode(returntype), var.allocate("result", RMIC.size(returntype)));
        }
        Label writeResult = new Label();
        cv.visitLabel(writeResult);
        cv.visitVarInsn(25, var.get("remotecall"));
        cv.visitInsn(4);
        cv.visitMethodInsn(185, Type.getInternalName(RemoteCall.class), "getResultStream", Type.getMethodDescriptor(Type.getType(ObjectOutput.class), new Type[]{Type.BOOLEAN_TYPE}));
        if (!returntype.equals(Void.TYPE)) {
            cv.visitVarInsn(RMIC.loadOpcode(returntype), var.deallocate("result"));
            Class<Object> writeCls = returntype.isPrimitive() ? returntype : Object.class;
            cv.visitMethodInsn(185, Type.getInternalName(ObjectOutput.class), RMIC.writeMethod(returntype), Type.getMethodDescriptor(Type.VOID_TYPE, new Type[]{Type.getType(writeCls)}));
        }
        cv.visitInsn(177);
        Label marshalHandler = new Label();
        cv.visitLabel(marshalHandler);
        cv.visitVarInsn(58, var.allocate("exception"));
        cv.visitTypeInsn(187, RMIC.typeArg(MarshalException.class));
        cv.visitInsn(89);
        cv.visitLdcInsn("error marshalling return");
        cv.visitVarInsn(25, var.deallocate("exception"));
        cv.visitMethodInsn(183, Type.getInternalName(MarshalException.class), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[]{Type.getType(String.class), Type.getType(Exception.class)}));
        cv.visitInsn(191);
        cv.visitTryCatchBlock(writeResult, marshalHandler, marshalHandler, Type.getInternalName(IOException.class));
    }

    private static String typeArg(Class cls) {
        if (cls.isArray()) {
            return Type.getDescriptor(cls);
        }
        return Type.getInternalName(cls);
    }

    private static String readMethod(Class cls) {
        if (cls.equals(Void.TYPE)) {
            throw new IllegalArgumentException("can not read void");
        }
        String method = cls.equals(Boolean.TYPE) ? "readBoolean" : (cls.equals(Byte.TYPE) ? "readByte" : (cls.equals(Character.TYPE) ? "readChar" : (cls.equals(Short.TYPE) ? "readShort" : (cls.equals(Integer.TYPE) ? "readInt" : (cls.equals(Long.TYPE) ? "readLong" : (cls.equals(Float.TYPE) ? "readFloat" : (cls.equals(Double.TYPE) ? "readDouble" : "readObject")))))));
        return method;
    }

    private static String writeMethod(Class cls) {
        if (cls.equals(Void.TYPE)) {
            throw new IllegalArgumentException("can not read void");
        }
        String method = cls.equals(Boolean.TYPE) ? "writeBoolean" : (cls.equals(Byte.TYPE) ? "writeByte" : (cls.equals(Character.TYPE) ? "writeChar" : (cls.equals(Short.TYPE) ? "writeShort" : (cls.equals(Integer.TYPE) ? "writeInt" : (cls.equals(Long.TYPE) ? "writeLong" : (cls.equals(Float.TYPE) ? "writeFloat" : (cls.equals(Double.TYPE) ? "writeDouble" : "writeObject")))))));
        return method;
    }

    private static int returnOpcode(Class cls) {
        int returncode = cls.equals(Boolean.TYPE) ? 172 : (cls.equals(Byte.TYPE) ? 172 : (cls.equals(Character.TYPE) ? 172 : (cls.equals(Short.TYPE) ? 172 : (cls.equals(Integer.TYPE) ? 172 : (cls.equals(Long.TYPE) ? 173 : (cls.equals(Float.TYPE) ? 174 : (cls.equals(Double.TYPE) ? 175 : (cls.equals(Void.TYPE) ? 177 : 176))))))));
        return returncode;
    }

    private static int loadOpcode(Class cls) {
        if (cls.equals(Void.TYPE)) {
            throw new IllegalArgumentException("can not load void");
        }
        int loadcode = cls.equals(Boolean.TYPE) ? 21 : (cls.equals(Byte.TYPE) ? 21 : (cls.equals(Character.TYPE) ? 21 : (cls.equals(Short.TYPE) ? 21 : (cls.equals(Integer.TYPE) ? 21 : (cls.equals(Long.TYPE) ? 22 : (cls.equals(Float.TYPE) ? 23 : (cls.equals(Double.TYPE) ? 24 : 25)))))));
        return loadcode;
    }

    private static int storeOpcode(Class cls) {
        if (cls.equals(Void.TYPE)) {
            throw new IllegalArgumentException("can not load void");
        }
        int storecode = cls.equals(Boolean.TYPE) ? 54 : (cls.equals(Byte.TYPE) ? 54 : (cls.equals(Character.TYPE) ? 54 : (cls.equals(Short.TYPE) ? 54 : (cls.equals(Integer.TYPE) ? 54 : (cls.equals(Long.TYPE) ? 55 : (cls.equals(Float.TYPE) ? 56 : (cls.equals(Double.TYPE) ? 57 : 58)))))));
        return storecode;
    }

    private static String unboxMethod(Class primitive) {
        String method;
        if (!primitive.isPrimitive()) {
            throw new IllegalArgumentException("can not unbox nonprimitive");
        }
        if (primitive.equals(Boolean.TYPE)) {
            method = "booleanValue";
        } else if (primitive.equals(Byte.TYPE)) {
            method = "byteValue";
        } else if (primitive.equals(Character.TYPE)) {
            method = "charValue";
        } else if (primitive.equals(Short.TYPE)) {
            method = "shortValue";
        } else if (primitive.equals(Integer.TYPE)) {
            method = "intValue";
        } else if (primitive.equals(Long.TYPE)) {
            method = "longValue";
        } else if (primitive.equals(Float.TYPE)) {
            method = "floatValue";
        } else if (primitive.equals(Double.TYPE)) {
            method = "doubleValue";
        } else {
            throw new IllegalStateException("unknown primitive class " + primitive);
        }
        return method;
    }

    public static Class box(Class cls) {
        Class box;
        if (!cls.isPrimitive()) {
            throw new IllegalArgumentException("can only box primitive");
        }
        if (cls.equals(Boolean.TYPE)) {
            box = Boolean.class;
        } else if (cls.equals(Byte.TYPE)) {
            box = Byte.class;
        } else if (cls.equals(Character.TYPE)) {
            box = Character.class;
        } else if (cls.equals(Short.TYPE)) {
            box = Short.class;
        } else if (cls.equals(Integer.TYPE)) {
            box = Integer.class;
        } else if (cls.equals(Long.TYPE)) {
            box = Long.class;
        } else if (cls.equals(Float.TYPE)) {
            box = Float.class;
        } else if (cls.equals(Double.TYPE)) {
            box = Double.class;
        } else {
            throw new IllegalStateException("unknown primitive type " + cls);
        }
        return box;
    }

    private static int size(Class cls) {
        if (cls.equals(Long.TYPE) || cls.equals(Double.TYPE)) {
            return 2;
        }
        return 1;
    }

    private Class[] sortExceptions(Class[] except) {
        for (int i = 0; i < except.length; ++i) {
            for (int j = i + 1; j < except.length; ++j) {
                if (!except[i].isAssignableFrom(except[j])) continue;
                Class tmp = except[i];
                except[i] = except[j];
                except[j] = tmp;
            }
        }
        return except;
    }

    private void parseOptions() {
        while (this.next < this.args.length && this.args[this.next].charAt(0) == '-') {
            String arg = this.args[this.next];
            ++this.next;
            if (arg.length() > 3 && arg.charAt(0) == '-' && arg.charAt(1) == '-') {
                arg = arg.substring(1);
            }
            if (arg.equals("-keep")) {
                this.keep = true;
                continue;
            }
            if (arg.equals("-keepgenerated")) {
                this.keep = true;
                continue;
            }
            if (arg.equals("-v1.1")) {
                this.need11Stubs = true;
                this.need12Stubs = false;
                continue;
            }
            if (arg.equals("-vcompat")) {
                this.need11Stubs = true;
                this.need12Stubs = true;
                continue;
            }
            if (arg.equals("-v1.2")) {
                this.need11Stubs = false;
                this.need12Stubs = true;
                continue;
            }
            if (arg.equals("-g") || arg.equals("-depend") || arg.equals("-nowarn")) continue;
            if (arg.equals("-verbose")) {
                this.verbose = true;
                continue;
            }
            if (arg.equals("-nocompile")) {
                this.compile = false;
                continue;
            }
            if (arg.equals("-classpath")) {
                this.classpath = this.args[this.next];
                ++this.next;
                StringTokenizer st = new StringTokenizer(this.classpath, File.pathSeparator);
                URL[] u = new URL[st.countTokens()];
                for (int i = 0; i < u.length; ++i) {
                    String path = st.nextToken();
                    File f = new File(path);
                    try {
                        u[i] = f.toURL();
                        continue;
                    }
                    catch (MalformedURLException mue) {
                        RMIC.error("malformed classpath component " + path);
                    }
                }
                ClassLoader parent = RMIC.class.getClassLoader();
                this.loader = new URLClassLoader(u, parent);
                continue;
            }
            if (arg.equals("-help")) {
                RMIC.usage();
                continue;
            }
            if (arg.equals("-version")) {
                System.out.println("rmic (" + System.getProperty("java.vm.name") + ") " + System.getProperty("java.vm.version"));
                System.out.println();
                System.out.println("Copyright 2002 Free Software Foundation, Inc.");
                System.out.println("This is free software; see the source for copying conditions.  There is NO");
                System.out.println("warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.");
                System.exit(0);
                continue;
            }
            if (arg.equals("-d")) {
                this.destination = this.args[this.next];
                ++this.next;
                continue;
            }
            if (arg.charAt(1) == 'J') continue;
            RMIC.error("unrecognized option `" + arg + "'");
        }
    }

    private void findRemoteMethods() {
        int j;
        int i;
        ArrayList<Method> rmeths = new ArrayList<Method>();
        for (Class cur = this.clazz; cur != null; cur = cur.getSuperclass()) {
            Class<?>[] interfaces = cur.getInterfaces();
            for (i = 0; i < interfaces.length; ++i) {
                Class<?> remoteInterface;
                if (!Remote.class.isAssignableFrom(interfaces[i]) || this.mRemoteInterfaces.contains(remoteInterface = interfaces[i])) continue;
                if (this.verbose) {
                    System.out.println("[implements " + remoteInterface.getName() + "]");
                }
                Method[] meths = remoteInterface.getMethods();
                for (j = 0; j < meths.length; ++j) {
                    Method m = meths[j];
                    Class<?>[] exs = m.getExceptionTypes();
                    boolean throwsRemote = false;
                    for (int k = 0; k < exs.length; ++k) {
                        if (!exs[k].isAssignableFrom(RemoteException.class)) continue;
                        throwsRemote = true;
                    }
                    if (!throwsRemote) {
                        this.logError("Method " + m + " does not throw a RemoteException");
                        continue;
                    }
                    rmeths.add(m);
                }
                this.mRemoteInterfaces.add(remoteInterface);
            }
        }
        boolean[] skip = new boolean[rmeths.size()];
        for (int i2 = 0; i2 < skip.length; ++i2) {
            skip[i2] = false;
        }
        ArrayList<MethodRef> methrefs = new ArrayList<MethodRef>();
        for (i = 0; i < rmeths.size(); ++i) {
            if (skip[i]) continue;
            Method current = (Method)rmeths.get(i);
            MethodRef ref = new MethodRef(current);
            for (j = i + 1; j < rmeths.size(); ++j) {
                Method other = (Method)rmeths.get(j);
                if (!ref.isMatch(other)) continue;
                ref.intersectExceptions(other);
                skip[j] = true;
            }
            methrefs.add(ref);
        }
        this.remotemethods = methrefs.toArray(new MethodRef[methrefs.size()]);
        Arrays.sort(this.remotemethods);
    }

    private void logError(String theError) {
        ++this.errorCount;
        System.err.println("error:" + theError);
    }

    private static void error(String message) {
        System.err.println("rmic: " + message);
        System.err.println("Try `rmic --help' for more information.");
        System.exit(1);
    }

    private static void usage() {
        System.out.println("Usage: rmic [OPTION]... CLASS...\n\n    -keep *            Don't delete any intermediate files\n    -keepgenerated *    Same as -keep\n    -v1.1            Java 1.1 style stubs only\n    -vcompat        Java 1.1 & Java 1.2 stubs\n    -v1.2            Java 1.2 style stubs only\n    -g *            Generated debugging information\n    -depend *        Recompile out-of-date files\n    -nowarn    *        Suppress warning messages\n    -nocompile *        Don't compile the generated files\n    -verbose         Output what's going on\n    -classpath <path>     Use given path as classpath\n    -d <directory>         Specify where to place generated classes\n    -J<flag> *        Pass flag to Java\n    -help            Print this help, then exit\n    -version        Print version number, then exit\n\n  * Option currently ignored\nLong options can be used with `--option' form as well.");
        System.exit(0);
    }

    private static String getPrettyName(Class cls) {
        StringBuffer str = new StringBuffer();
        int count = 0;
        while (true) {
            if (!cls.isArray()) {
                str.append(cls.getName());
                while (count > 0) {
                    str.append("[]");
                    --count;
                }
                return str.toString();
            }
            cls = cls.getComponentType();
            ++count;
        }
    }

    public static long getInterfaceHash(Class cls) {
        return cls.hashCode();
    }

    public static long getMethodHash(Method meth) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            ByteArrayOutputStream digest_out = new ByteArrayOutputStream();
            DataOutputStream data_out = new DataOutputStream(digest_out);
            StringBuffer sbuf = new StringBuffer();
            sbuf.append(meth.getName());
            sbuf.append(Type.getMethodDescriptor(meth));
            data_out.writeUTF(sbuf.toString());
            data_out.flush();
            data_out.close();
            md.update(digest_out.toByteArray());
            byte[] sha = md.digest();
            long result = 0L;
            int len = sha.length < 8 ? sha.length : 8;
            for (int i = 0; i < len; ++i) {
                result += (long)(sha[i] & 0xFF) << 8 * i;
            }
            return result;
        }
        catch (Exception _) {
            return -1L;
        }
    }

    public static List<ClassInfo> generateStubForClass(String className, ClassLoader classLoader) throws RMICException {
        ClassInfo classInfo;
        ArrayList<ClassInfo> classInfos = new ArrayList<ClassInfo>();
        RMIC rmic = new RMIC(null);
        rmic.loader = classLoader;
        rmic.mRemoteInterfaces = new ArrayList();
        try {
            rmic.analyzeClass(className);
        }
        catch (Exception e) {
            throw new RMICException("Unable to analyze the class '" + className + "'", e);
        }
        try {
            classInfo = rmic.generateStubData();
            classInfos.add(classInfo);
        }
        catch (IOException e) {
            throw new RMICException("Unable to generate stub for the class '" + className + "'", e);
        }
        if (rmic.need11Stubs) {
            try {
                classInfo = rmic.generateSkelData();
                classInfos.add(classInfo);
            }
            catch (IOException e) {
                throw new RMICException("Unable to generate skel for the class '" + className + "'", e);
            }
        }
        return classInfos;
    }

    private static class MethodRef
    implements Comparable {
        Method meth;
        long hash;
        List exceptions;
        private String sig;

        MethodRef(Method m) {
            this.meth = m;
            this.sig = Type.getMethodDescriptor(this.meth);
            this.hash = RMIC.getMethodHash(m);
            this.exceptions = MethodRef.removeSubclasses(m.getExceptionTypes());
        }

        public int compareTo(Object obj) {
            MethodRef that = (MethodRef)obj;
            int name = this.meth.getName().compareTo(that.meth.getName());
            if (name == 0) {
                return this.sig.compareTo(that.sig);
            }
            return name;
        }

        public boolean isMatch(Method m) {
            Class<?>[] params2;
            if (!this.meth.getName().equals(m.getName())) {
                return false;
            }
            Class<?>[] params1 = this.meth.getParameterTypes();
            if (params1.length != (params2 = m.getParameterTypes()).length) {
                return false;
            }
            for (int i = 0; i < params1.length; ++i) {
                if (params1[i].equals(params2[i])) continue;
                return false;
            }
            return true;
        }

        private static List removeSubclasses(Class[] classes) {
            ArrayList<Class> list = new ArrayList<Class>();
            for (int i = 0; i < classes.length; ++i) {
                Class candidate = classes[i];
                boolean add = true;
                for (int j = 0; j < classes.length; ++j) {
                    if (classes[j].equals(candidate) || !classes[j].isAssignableFrom(candidate)) continue;
                    add = false;
                }
                if (!add) continue;
                list.add(candidate);
            }
            return list;
        }

        public void intersectExceptions(Method m) {
            List incoming = MethodRef.removeSubclasses(m.getExceptionTypes());
            ArrayList<Class> updated = new ArrayList<Class>();
            for (int i = 0; i < this.exceptions.size(); ++i) {
                Class outer = (Class)this.exceptions.get(i);
                boolean addOuter = false;
                for (int j = 0; j < incoming.size(); ++j) {
                    Class inner = (Class)incoming.get(j);
                    if (inner.equals(outer) || inner.isAssignableFrom(outer)) {
                        addOuter = true;
                        continue;
                    }
                    if (!outer.isAssignableFrom(inner)) continue;
                    updated.add(inner);
                }
                if (!addOuter) continue;
                updated.add(outer);
            }
            this.exceptions = updated;
        }
    }
}

