/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.dbm.internal;

import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.dbm.DataBaseService;
import org.ow2.jonas.dbm.internal.DBMConstants;
import org.ow2.jonas.dbm.internal.JOnASDataBaseManagerServiceMBean;
import org.ow2.jonas.dbm.internal.cm.ConnectionManager;
import org.ow2.jonas.dbm.internal.mbean.JDBCDataSource;
import org.ow2.jonas.dbm.internal.mbean.JDBCDriver;
import org.ow2.jonas.dbm.internal.mbean.JDBCResource;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.execution.ExecutionResult;
import org.ow2.jonas.lib.execution.IExecution;
import org.ow2.jonas.lib.execution.RunnableHelper;
import org.ow2.jonas.lib.management.javaee.J2eeObjectName;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.lib.util.JModule;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.registry.RegistryService;
import org.ow2.jonas.service.ServiceException;
import org.ow2.jonas.tm.TransactionService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JOnASDataBaseManagerService
extends AbsServiceImpl
implements DataBaseService,
JOnASDataBaseManagerServiceMBean,
DBMConstants {
    private static Logger logger = Log.getLogger("org.ow2.jonas.dbm");
    private List<ConnectionManager> cmList = new Vector<ConnectionManager>();
    private Map<String, String> boundDatasources = new Hashtable<String, String>();
    private List<String> dataSourceNames = new Vector<String>();
    private JmxService jmxService = null;
    private TransactionService txService = null;
    private Context ictx = null;
    private RegistryService registryService;
    public static final String JDBC_RESOURCE_NAME = "JDBCResource";
    private JDBCResource jdbcResourceMBean = null;

    public void setDatasources(String datasources) {
        this.dataSourceNames = JOnASDataBaseManagerService.convertToList(datasources);
    }

    @Override
    public void doStart() throws ServiceException {
        logger.log(BasicLevel.DEBUG, (Object)"Starting DataBase service");
        IExecution<InitialContext> ictxGetter = new IExecution<InitialContext>(){

            @Override
            public InitialContext execute() throws Exception {
                return JOnASDataBaseManagerService.this.getRegistryService().getRegistryContext();
            }
        };
        ExecutionResult<InitialContext> ictxResult = RunnableHelper.execute(this.getClass().getClassLoader(), ictxGetter);
        if (ictxResult.hasException()) {
            logger.log(BasicLevel.ERROR, (Object)"Cannot create initial context when DataBase service initializing");
            throw new ServiceException("Cannot create initial context when DataBase service initializing", ictxResult.getException());
        }
        this.ictx = ictxResult.getResult();
        if (this.jmxService != null) {
            this.jmxService.loadDescriptors(this.getClass().getPackage().getName(), this.getClass().getClassLoader());
        }
        this.registerDbmServiceMBean(this, this.getDomainName());
        this.jdbcResourceMBean = this.registerJdbcResourceMBean(this.getDomainName(), this.getJonasServerName(), JDBC_RESOURCE_NAME);
        String dsName = null;
        for (int i = 0; i < this.dataSourceNames.size(); ++i) {
            dsName = this.dataSourceNames.get(i);
            try {
                JProp prop = JProp.getInstance(dsName);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("Creating Datasource " + dsName));
                }
                this.createDataSource(dsName, prop.getConfigFileEnv());
                continue;
            }
            catch (Exception e) {
                JProp.removeInstance(dsName);
                logger.log(BasicLevel.ERROR, (Object)("JOnAS: Cannot create datasource: '" + dsName + "'"), (Throwable)e);
                logger.log(BasicLevel.ERROR, (Object)("Please check if " + dsName + ".properties is available"));
            }
        }
        logger.log(BasicLevel.INFO, (Object)"DBM Service started");
    }

    @Override
    public void doStop() throws ServiceException {
        try {
            this.unbindDataSources();
        }
        catch (NamingException e) {
            logger.log(BasicLevel.ERROR, (Object)"Cannot unbind datasources");
            throw new ServiceException("Cannot unbind datasources ", e);
        }
        if (this.jmxService != null) {
            this.unregisterDbmServiceMBean(this.getDomainName());
            this.unregisterJdbcResourceMBean(this.getDomainName(), this.getJonasServerName(), JDBC_RESOURCE_NAME);
        }
        logger.log(BasicLevel.INFO, (Object)"DBM Service stopped");
    }

    @Override
    public void createDataSource(String datasourceName, Properties dsd) throws Exception {
        String dsName = dsd.getProperty("datasource.name");
        if (dsName == null) {
            logger.log(BasicLevel.ERROR, (Object)"");
            throw new ServiceException("Cannot create datasource as JNDI name not provided");
        }
        dsName = dsName.trim();
        String className = dsd.getProperty("datasource.classname", "no class name").trim();
        String url = dsd.getProperty("datasource.url", "no url").trim();
        String description = dsd.getProperty("datasource.description", "no desc").trim();
        String user = dsd.getProperty("datasource.username", "").trim();
        String password = dsd.getProperty("datasource.password", "").trim();
        String connCheckLevel = dsd.getProperty("jdbc.connchecklevel", "1").trim();
        String connMaxAge = dsd.getProperty("jdbc.connmaxage", "1440").trim();
        String maxOpenTime = dsd.getProperty("jdbc.maxopentime", "1440").trim();
        String minconpool = dsd.getProperty("jdbc.minconpool", "0").trim();
        String maxconpool = dsd.getProperty("jdbc.maxconpool", "-1").trim();
        String maxwaittime = dsd.getProperty("jdbc.maxwaittime", "10").trim();
        String maxwaiters = dsd.getProperty("jdbc.maxwaiters", "1000").trim();
        String samplingperiod = dsd.getProperty("jdbc.samplingperiod", "30").trim();
        String adjustperiod = dsd.getProperty("jdbc.adjustperiod", "30").trim();
        String defaultStatement = dsd.getProperty("jdbc.connteststmt", "SELECT 1").trim();
        String pstmtmax = dsd.getProperty("jdbc.pstmtmax", "12").trim();
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("create JOnAS ConnectionManager corresponding to data source " + datasourceName + " with JNDI name " + dsName));
        }
        ConnectionManager ds = new ConnectionManager(this.txService);
        ds.setDatasourceName(datasourceName);
        ds.setDSName(dsName);
        ds.setUrl(url);
        ds.setClassName(className);
        ds.setUserName(user);
        ds.setPassword(password);
        ds.setTransactionIsolation(dsd.getProperty("datasource.isolationlevel", "").trim());
        ds.setMapperName(dsd.getProperty("datasource.mapper", "rdb").trim());
        ds.setDataSourceDescription(description);
        ds.poolConfigure(connCheckLevel, connMaxAge, maxOpenTime, defaultStatement, pstmtmax, minconpool, maxconpool, maxwaittime, maxwaiters, samplingperiod, adjustperiod);
        this.cmList.add(ds);
        this.ictx.rebind(dsName, (Object)ds);
        this.boundDatasources.put(dsName, datasourceName);
        logger.log(BasicLevel.INFO, (Object)("Mapping ConnectionManager " + url + " on " + dsName));
        String jdbcDataSourceName = datasourceName;
        String jdbcDriverName = "aJDBCDriver-" + jdbcDataSourceName;
        String jdbcDriverClassName = className;
        String jdbcDataSourceON = this.registerJdbcDataSourceAndDriverMBean(this.getDomainName(), this.getJonasServerName(), jdbcDataSourceName, jdbcDriverName, jdbcDriverClassName, ds);
        this.jdbcResourceMBean.addJdbcDataSource(jdbcDataSourceON);
    }

    @Override
    public void unbindDataSources() throws NamingException {
        logger.log(BasicLevel.DEBUG, (Object)"");
        try {
            if (this.cmList.size() > 0) {
                String dsn = null;
                for (ConnectionManager cm : this.cmList) {
                    cm.closeAllConnection();
                    dsn = cm.getDSName();
                    this.ictx.unbind(dsn);
                    this.boundDatasources.remove(dsn);
                }
            }
        }
        catch (NamingException e) {
            logger.log(BasicLevel.ERROR, (Object)"cannot unbind DataSources", (Throwable)e);
            throw e;
        }
        if (this.jmxService != null) {
            this.unregisterAllDataSourceAndDriverMBeans();
        }
    }

    public ConnectionManager getConnectionManager(String dsname) {
        if (this.cmList.size() > 0) {
            for (ConnectionManager cm : this.cmList) {
                if (!cm.getDSName().equals(dsname)) continue;
                return cm;
            }
        }
        return null;
    }

    public Collection<ConnectionManager> getDSList() {
        return this.cmList;
    }

    @Override
    public List getDataSourcePropertiesFiles() throws Exception {
        return JModule.getDatasourcePropsInDir();
    }

    @Override
    public Integer getCurrentNumberOfDataSource() {
        return new Integer(this.cmList.size());
    }

    @Override
    public Integer getTotalCurrentNumberOfJDBCConnectionOpen() {
        int result = 0;
        if (this.cmList.size() > 0) {
            for (ConnectionManager cm : this.cmList) {
                result += cm.getPool().getCurrentOpened();
            }
        }
        return new Integer(result);
    }

    @Override
    public boolean isLoadedDataSource(String dsName) {
        boolean result = false;
        if (this.cmList.size() > 0) {
            for (ConnectionManager cm : this.cmList) {
                if (!cm.getDatasourceName().equals(dsName)) continue;
                return true;
            }
        }
        return result;
    }

    @Override
    public void unloadDataSource(String name) {
        logger.log(BasicLevel.DEBUG, (Object)"");
        try {
            Iterator<ConnectionManager> i$;
            if (this.cmList.size() > 0 && (i$ = this.cmList.iterator()).hasNext()) {
                ConnectionManager cm = i$.next();
                String dsName = cm.getDatasourceName();
                String jndiName = cm.getDSName();
                if (dsName.equals(name)) {
                    cm.closeAllConnection();
                    this.ictx.unbind(jndiName);
                    this.cmList.remove(cm);
                    JProp.removeInstance(dsName);
                    String jdbcDataSourceOn = this.unregisterJdbcDataSourceAndDriverMBean(this.getDomainName(), this.getJonasServerName(), dsName);
                    this.jdbcResourceMBean.removeJdbcDataSource(jdbcDataSourceOn);
                }
                return;
            }
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)"Cannot unload DataSources", (Throwable)e);
        }
    }

    @Override
    public Properties getDataSourcePropertiesFile(String dsFile) throws Exception {
        try {
            return JProp.getInstance(dsFile).getConfigFileEnv();
        }
        catch (Exception e) {
            if (e instanceof FileNotFoundException) {
                logger.log(BasicLevel.ERROR, (Object)("Please check if '" + dsFile + ".properties' is available in JONAS_BASE/conf/ directory"));
            } else {
                logger.log(BasicLevel.ERROR, (Object)("Error occured when reading file " + dsFile));
            }
            throw e;
        }
    }

    @Override
    public void loadDataSource(String name, Properties prop, Boolean loadFromFile) throws ServiceException {
        boolean fromFile = loadFromFile;
        if (fromFile) {
            logger.log(BasicLevel.DEBUG, (Object)("Load data source named " + name + " from file"));
        } else {
            logger.log(BasicLevel.DEBUG, (Object)("Load data source named " + name + " from form"));
            if (this.isLoadedDataSource(name)) {
                logger.log(BasicLevel.DEBUG, (Object)("This data source, " + name + " is already loaded ; Unload it !"));
                this.unloadDataSource(name);
            }
            try {
                logger.log(BasicLevel.DEBUG, (Object)"Call getInstance on JProp in order to create the properties file");
                JProp.getInstance(name, prop);
            }
            catch (Exception e) {
                logger.log(BasicLevel.ERROR, (Object)("Cannot create datasource " + name + " as cannot create properties file"));
                throw new ServiceException("DatabaseService: Cannot create datasource '" + name + "'", e);
            }
        }
        try {
            logger.log(BasicLevel.DEBUG, (Object)"Call method to create a data source");
            this.createDataSource(name, prop);
            logger.log(BasicLevel.DEBUG, (Object)"New data source created");
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot create datasource '" + name + "'."));
            if (fromFile) {
                JProp.removeInstance(name);
            } else {
                JProp.deleteInstance(name);
            }
            throw new ServiceException("DatabaseService: Cannot create datasource: " + name + "'", e);
        }
    }

    @Override
    public String getDatasourceName(String jndiName) {
        return this.boundDatasources.get(jndiName);
    }

    private void registerDbmServiceMBean(Object service, String domainName) {
        ObjectName on = JonasObjectName.databaseService(domainName);
        this.jmxService.registerMBean(service, on);
    }

    private void unregisterDbmServiceMBean(String domainName) {
        ObjectName on = JonasObjectName.databaseService(domainName);
        this.jmxService.unregisterMBean(on);
    }

    private JDBCResource registerJdbcResourceMBean(String domainName, String serverName, String resourceName) {
        JDBCResource jdbcResourceMBean = null;
        try {
            String jdbcResourceON = J2eeObjectName.JDBCResourceName(domainName, serverName, resourceName);
            jdbcResourceMBean = new JDBCResource(jdbcResourceON);
            this.jmxService.registerModelMBean((Object)jdbcResourceMBean, jdbcResourceON);
        }
        catch (Exception e) {
            logger.log(BasicLevel.INFO, (Object)"DataBaseService: Cannot register JDBCResource MBean", (Throwable)e);
        }
        return jdbcResourceMBean;
    }

    private String registerJdbcDataSourceAndDriverMBean(String domainName, String serverName, String jdbcDataSourceName, String jdbcDriverName, String jdbcDriverClassName, ConnectionManager ds) {
        JDBCDataSource jdbcDataSourceMBean = null;
        String jdbcDataSourceON = null;
        try {
            jdbcDataSourceON = J2eeObjectName.getJDBCDataSourceName(domainName, serverName, jdbcDataSourceName);
            jdbcDataSourceMBean = new JDBCDataSource(jdbcDataSourceON, ds);
            this.jmxService.registerModelMBean((Object)jdbcDataSourceMBean, jdbcDataSourceON);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"JDBCDataSource MBean created");
            }
        }
        catch (Exception e) {
            logger.log(BasicLevel.INFO, (Object)"DataBaseService: Cannot register JDBCDataSource MBean", (Throwable)e);
        }
        JDBCDriver jdbcDriverMBean = null;
        String jdbcDriverON = null;
        try {
            jdbcDriverON = J2eeObjectName.getJDBCDriverName(domainName, serverName, jdbcDriverName);
            jdbcDriverMBean = new JDBCDriver(jdbcDriverON);
            jdbcDriverMBean.setDriverClassName(jdbcDriverClassName);
            this.jmxService.registerModelMBean((Object)jdbcDriverMBean, jdbcDriverON);
        }
        catch (Exception e) {
            logger.log(BasicLevel.INFO, (Object)"DataBaseService: Cannot register JDBCDriver MBean", (Throwable)e);
        }
        jdbcDataSourceMBean.setJdbcDriver(jdbcDriverON);
        return jdbcDataSourceON;
    }

    private String unregisterJdbcDataSourceAndDriverMBean(String domainName, String serverName, String jdbcDataSourceName) {
        String jdbcDataSourceON = J2eeObjectName.getJDBCDataSourceName(domainName, serverName, jdbcDataSourceName);
        ObjectName onJDBCDataSource = null;
        String jdbcDriverName = null;
        ObjectName onJDBCDriver = null;
        MBeanServer mbeanServer = this.jmxService.getJmxServer();
        try {
            onJDBCDataSource = ObjectName.getInstance(jdbcDataSourceON);
            jdbcDriverName = (String)mbeanServer.getAttribute(onJDBCDataSource, "jdbcDriver");
            onJDBCDriver = ObjectName.getInstance(jdbcDriverName);
        }
        catch (Exception e) {
            logger.log(BasicLevel.INFO, (Object)("DataBaseService: Cannot unregister MBean for datasource " + jdbcDataSourceName), (Throwable)e);
        }
        this.jmxService.unregisterModelMBean(onJDBCDataSource);
        this.jmxService.unregisterModelMBean(onJDBCDriver);
        return jdbcDataSourceON;
    }

    private void unregisterAllDataSourceAndDriverMBeans() {
        String[] ons = this.jdbcResourceMBean.getJdbcDataSources();
        ObjectName onJDBCDataSource = null;
        ObjectName onJDBCDriver = null;
        String dataSourceName = null;
        for (int i = 0; i < ons.length; ++i) {
            try {
                onJDBCDataSource = ObjectName.getInstance(ons[i]);
            }
            catch (MalformedObjectNameException e) {
                logger.log(BasicLevel.INFO, (Object)"DataBaseService: Cannot unegister JDBCDataSource MBean", (Throwable)e);
                continue;
            }
            dataSourceName = onJDBCDataSource.getKeyProperty("name");
            MBeanServer mbeanServer = this.jmxService.getJmxServer();
            String jdbcDriverName = null;
            try {
                jdbcDriverName = (String)mbeanServer.getAttribute(onJDBCDataSource, "jdbcDriver");
            }
            catch (Exception e) {
                logger.log(BasicLevel.INFO, (Object)("DataBaseService: Cannot unegister JDBCDriver MBean for datasource " + dataSourceName), (Throwable)e);
                continue;
            }
            try {
                onJDBCDriver = new ObjectName(jdbcDriverName);
            }
            catch (MalformedObjectNameException e) {
                logger.log(BasicLevel.INFO, (Object)("DataBaseService: Cannot unegister JDBCDriver MBean" + dataSourceName), (Throwable)e);
                continue;
            }
            this.jmxService.unregisterModelMBean(onJDBCDataSource);
            this.jmxService.unregisterModelMBean(onJDBCDriver);
            this.jdbcResourceMBean.removeJdbcDataSource(onJDBCDataSource.toString());
        }
    }

    private void unregisterJdbcResourceMBean(String domainName, String serverName, String resourceName) {
        try {
            ObjectName jdbcResourceOn = J2eeObjectName.JDBCResource(domainName, serverName, resourceName);
            this.jmxService.unregisterModelMBean(jdbcResourceOn);
        }
        catch (Exception e) {
            logger.log(BasicLevel.INFO, (Object)"DataBaseService: Cannot unegister JDBCResource MBean", (Throwable)e);
        }
    }

    public void setTransactionService(TransactionService txService) {
        this.txService = txService;
    }

    public void setJmxService(JmxService jmxService) {
        this.jmxService = jmxService;
    }

    public void setRegistryService(RegistryService registry) {
        this.registryService = registry;
    }

    private RegistryService getRegistryService() {
        return this.registryService;
    }
}

