/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.rar.lib;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.naming.Context;
import javax.naming.NamingException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.common.digester.JDigester;
import org.ow2.jonas.deployment.common.lib.AbsDeploymentDescManager;
import org.ow2.jonas.deployment.rar.ConnectorDTDs;
import org.ow2.jonas.deployment.rar.ConnectorSchemas;
import org.ow2.jonas.deployment.rar.JonasConnectorDTDs;
import org.ow2.jonas.deployment.rar.JonasConnectorSchemas;
import org.ow2.jonas.deployment.rar.RarDeploymentDesc;
import org.ow2.jonas.deployment.rar.RarDeploymentDescException;
import org.ow2.jonas.deployment.rar.rules.ConnectorRuleSet;
import org.ow2.jonas.deployment.rar.rules.JonasConnectorRuleSet;
import org.ow2.jonas.deployment.rar.xml.Connector;
import org.ow2.jonas.deployment.rar.xml.JonasConnector;
import org.ow2.jonas.lib.util.Log;

public class RarDeploymentDescManager
extends AbsDeploymentDescManager {
    public static final String RA_FILE_NAME = "META-INF/ra.xml";
    public static final String JONAS_RA_FILE_NAME = "META-INF/jonas-ra.xml";
    private static boolean parsingWithValidation = true;
    private static JDigester connectorDigester = null;
    private static JDigester jonasConnectorDigester = null;
    private static ConnectorRuleSet connectorRuleSet = new ConnectorRuleSet();
    private static JonasConnectorRuleSet jonasConnectorRuleSet = new JonasConnectorRuleSet();
    private static Logger logger = Log.getLogger("org.ow2.jonas.dbm");

    private RarDeploymentDescManager() {
    }

    public static RarDeploymentDesc getInstance(Context ctx) throws DeploymentDescException {
        String raDeployDesc;
        String xmlContent = "";
        String jonasXmlContent = "";
        boolean altDD = false;
        String rarFileName = null;
        ClassLoader classLoader = null;
        try {
            rarFileName = (String)ctx.lookup("rarFileName");
            classLoader = (ClassLoader)ctx.lookup("classloader");
        }
        catch (NamingException e) {
            String err = "Error while getting parameter from context param ";
            throw new RarDeploymentDescException(err, e);
        }
        try {
            raDeployDesc = (String)ctx.lookup("altDD");
            altDD = true;
        }
        catch (NamingException e) {
            raDeployDesc = "";
        }
        ZipFile rarFile = null;
        InputStream raInputStream = null;
        InputStream jonasRaInputStream = null;
        ZipEntry raZipEntry = null;
        ZipEntry jonasRaZipEntry = null;
        Connector connector = null;
        JonasConnector jonasConnector = null;
        File fRar = new File(rarFileName);
        if (!fRar.exists()) {
            throw new RarDeploymentDescException("The file '" + rarFileName + "' was not found.");
        }
        boolean setupRa = true;
        boolean setupJonasRa = true;
        try {
            if (!altDD) {
                if (fRar.isDirectory()) {
                    File rarXmlF = new File(rarFileName, RA_FILE_NAME);
                    if (!rarXmlF.exists()) {
                        connector = null;
                        setupRa = false;
                    } else {
                        raInputStream = new FileInputStream(rarXmlF);
                        xmlContent = RarDeploymentDescManager.xmlContent(raInputStream);
                        raInputStream = new FileInputStream(rarXmlF);
                    }
                } else {
                    rarFile = new JarFile(rarFileName);
                    raZipEntry = ((JarFile)rarFile).getEntry(RA_FILE_NAME);
                    if (raZipEntry == null) {
                        connector = null;
                        setupRa = false;
                    } else {
                        raInputStream = ((JarFile)rarFile).getInputStream(raZipEntry);
                        xmlContent = RarDeploymentDescManager.xmlContent(raInputStream);
                        raInputStream = ((JarFile)rarFile).getInputStream(raZipEntry);
                    }
                }
            } else {
                raInputStream = new FileInputStream(raDeployDesc);
                xmlContent = RarDeploymentDescManager.xmlContent(raInputStream);
                raInputStream = new FileInputStream(raDeployDesc);
            }
            if (fRar.isDirectory()) {
                File rarJXmlF = new File(rarFileName, JONAS_RA_FILE_NAME);
                if (rarJXmlF.exists()) {
                    jonasRaInputStream = new FileInputStream(rarJXmlF);
                    jonasXmlContent = RarDeploymentDescManager.xmlContent(jonasRaInputStream);
                    jonasRaInputStream = new FileInputStream(rarJXmlF);
                }
            } else {
                rarFile = new JarFile(rarFileName);
                jonasRaZipEntry = ((JarFile)rarFile).getEntry(JONAS_RA_FILE_NAME);
                if (jonasRaZipEntry == null) {
                    jonasConnector = null;
                    setupJonasRa = false;
                } else {
                    jonasRaInputStream = ((JarFile)rarFile).getInputStream(jonasRaZipEntry);
                    jonasXmlContent = RarDeploymentDescManager.xmlContent(jonasRaInputStream);
                    jonasRaInputStream = ((JarFile)rarFile).getInputStream(jonasRaZipEntry);
                }
            }
        }
        catch (Exception e) {
            if (rarFile != null) {
                try {
                    rarFile.close();
                }
                catch (IOException ioe) {
                    logger.log(BasicLevel.WARN, (Object)("Can't close '" + rarFileName + "'"));
                }
            }
            throw new RarDeploymentDescException("Cannot read the XML deployment descriptors of the rar file '" + rarFileName + "'.", e);
        }
        if (setupRa) {
            connector = RarDeploymentDescManager.loadConnector(new InputStreamReader(raInputStream), raDeployDesc);
            try {
                raInputStream.close();
            }
            catch (IOException e) {
                logger.log(BasicLevel.WARN, (Object)("Can't close META-INF/ra.xml of '" + rarFileName + "'"));
            }
        }
        if (setupJonasRa) {
            jonasConnector = RarDeploymentDescManager.loadJonasConnector(new InputStreamReader(jonasRaInputStream), JONAS_RA_FILE_NAME);
            try {
                jonasRaInputStream.close();
            }
            catch (IOException e) {
                logger.log(BasicLevel.WARN, (Object)("Can't close META-INF/jonas-ra.xml of '" + rarFileName + "'"));
            }
        }
        RarDeploymentDesc rdd = new RarDeploymentDesc(classLoader, connector, jonasConnector);
        rdd.setXmlContent(xmlContent);
        rdd.setJOnASXmlContent(jonasXmlContent);
        return rdd;
    }

    public static Connector loadConnector(Reader reader, String fileName) throws DeploymentDescException {
        Connector connector = new Connector();
        if (connectorDigester == null) {
            connectorDigester = new JDigester(connectorRuleSet, parsingWithValidation, true, new ConnectorDTDs(), new ConnectorSchemas());
        }
        try {
            connectorDigester.parse(reader, fileName, connector);
        }
        catch (DeploymentDescException e) {
            throw e;
        }
        finally {
            connectorDigester.push(null);
        }
        return connector;
    }

    public static JonasConnector loadJonasConnector(Reader reader, String fileName) throws DeploymentDescException {
        JonasConnector jonasConnector = new JonasConnector();
        if (jonasConnectorDigester == null) {
            jonasConnectorDigester = new JDigester(jonasConnectorRuleSet, parsingWithValidation, true, new JonasConnectorDTDs(), new JonasConnectorSchemas());
        }
        try {
            jonasConnectorDigester.parse(reader, fileName, jonasConnector);
        }
        catch (DeploymentDescException e) {
            throw e;
        }
        finally {
            jonasConnectorDigester.push(null);
        }
        return jonasConnector;
    }

    public static boolean getParsingWithValidation() {
        return parsingWithValidation;
    }

    public static void setParsingWithValidation(boolean validation) {
        parsingWithValidation = validation;
    }
}

