/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ejb.easybeans;

import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.security.auth.Subject;
import org.ow2.easybeans.security.api.EZBSecurityContext;
import org.ow2.easybeans.security.struct.JPrincipal;
import org.ow2.jonas.lib.security.context.SecurityContext;
import org.ow2.jonas.lib.security.context.SecurityCurrent;

public class JOnASSecurityContextWrapper
implements EZBSecurityContext {
    private SecurityContext jonasSecurityContext = null;

    public JOnASSecurityContextWrapper(SecurityContext jonasSecurityContext) {
        if (jonasSecurityContext == null) {
            this.jonasSecurityContext = new SecurityContext();
            SecurityCurrent.getCurrent().setSecurityContext(this.jonasSecurityContext);
        } else {
            this.jonasSecurityContext = jonasSecurityContext;
        }
    }

    public Principal getCallerPrincipal(boolean runAsBean) {
        return this.jonasSecurityContext.getCallerPrincipal(runAsBean);
    }

    public Principal[] getCallerRoles(boolean runAsBean) {
        String[] roles = this.jonasSecurityContext.getCallerPrincipalRoles(runAsBean);
        if (roles == null) {
            throw new IllegalStateException("No roles found on the JOnAS security context");
        }
        Principal[] principals = new Principal[roles.length];
        int i = 0;
        for (String role : roles) {
            principals[i++] = new JPrincipal(role);
        }
        return principals;
    }

    public Subject enterRunAs(Subject runAsSubject) {
        String principalName = null;
        for (Principal principal : runAsSubject.getPrincipals(Principal.class)) {
            if (principal instanceof Group) continue;
            principalName = principal.getName();
            break;
        }
        ArrayList<String> roleList = new ArrayList<String>();
        for (Principal principal : runAsSubject.getPrincipals(Principal.class)) {
            if (!(principal instanceof Group)) continue;
            Enumeration members = ((Group)principal).members();
            while (members.hasMoreElements()) {
                String role = ((Principal)members.nextElement()).getName();
                roleList.add(role);
            }
        }
        String[] roles = new String[roleList.size()];
        roles = roleList.toArray(roles);
        this.jonasSecurityContext.pushRunAs(roles[0], principalName, roles);
        return null;
    }

    public void endsRunAs(Subject oldSubject) {
        this.jonasSecurityContext.popRunAs();
    }
}

