/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.genclientstub.modifier;

import java.io.File;
import java.util.List;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.deployment.api.IEJBRefDesc;
import org.ow2.jonas.generators.genbase.GenBaseException;
import org.ow2.jonas.generators.genbase.archive.Archive;
import org.ow2.jonas.generators.genbase.archive.Ejb;
import org.ow2.jonas.generators.genbase.archive.EjbJar;
import org.ow2.jonas.generators.genclientstub.ClientStubGenException;
import org.ow2.jonas.generators.genclientstub.generator.Generator;
import org.ow2.jonas.generators.genclientstub.generator.GeneratorFactory;
import org.ow2.jonas.generators.genclientstub.modifier.AbsArchiveModifier;

public class EjbJarModifier
extends AbsArchiveModifier {
    private EjbJar ejbjar = null;

    public EjbJarModifier(EjbJar ejbjar) {
        super(ejbjar);
        this.ejbjar = ejbjar;
    }

    public Archive modify() throws GenBaseException, ClientStubGenException {
        EjbJarModifier.getLogger().log(BasicLevel.INFO, (Object)("Processing EjbJar " + this.ejbjar.getName()));
        GeneratorFactory gf = GeneratorFactory.getInstance();
        this.generateFoundStubs(gf.getConfiguration(), this.ejbjar);
        List ejbs = this.ejbjar.getEjbs();
        for (Ejb ejb : ejbs) {
            List ejbRefs = ejb.getEjbRefDescs();
            for (IEJBRefDesc ejbRef : ejbRefs) {
                Generator g = new Generator(gf.getConfiguration(), ejbRef, null, this.ejbjar);
                g.generate();
                g.compile();
                g.addFiles(this.ejbjar);
            }
        }
        return this.save(gf.getConfiguration(), "ejbjars" + File.separator + this.ejbjar.getRootFile().getName());
    }
}

