/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.resource.internal;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.spi.work.WorkManager;
import javax.transaction.xa.XAException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.deployment.rar.ConnectorDesc;
import org.ow2.jonas.deployment.rar.JonasConnectorDesc;
import org.ow2.jonas.deployment.rar.wrapper.RarManagerWrapper;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.bootstrap.LoaderManager;
import org.ow2.jonas.lib.execution.ExecutionResult;
import org.ow2.jonas.lib.execution.IExecution;
import org.ow2.jonas.lib.execution.RunnableHelper;
import org.ow2.jonas.lib.management.javaee.J2eeObjectName;
import org.ow2.jonas.lib.naming.ComponentContext;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.registry.RegistryService;
import org.ow2.jonas.resource.Rar;
import org.ow2.jonas.resource.ResourceService;
import org.ow2.jonas.resource.ResourceServiceException;
import org.ow2.jonas.resource.internal.JOnASResourceServiceMBean;
import org.ow2.jonas.resource.internal.RARDeployer;
import org.ow2.jonas.resource.internal.ResourceBootstrapContext;
import org.ow2.jonas.resource.internal.mbean.ArchiveConfigMBean;
import org.ow2.jonas.resource.internal.mbean.RarConfigMBean;
import org.ow2.jonas.service.ServiceException;
import org.ow2.jonas.tm.TransactionManager;
import org.ow2.jonas.tm.TransactionService;
import org.ow2.jonas.workmanager.WorkManagerService;
import org.ow2.util.ee.deploy.api.deployer.IDeployerManager;
import org.ow2.util.url.URLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JOnASResourceService
extends AbsServiceImpl
implements ResourceService,
JOnASResourceServiceMBean {
    private static Logger logger = Log.getLogger("org.ow2.jonas.jca.process");
    private static Logger manageLogger = Log.getLogger("org.ow2.jonas.jca.management");
    private RARDeployer rarDeployer = null;
    private ArrayList<Context> delayedRAs = new ArrayList();
    private TransactionService transactionService = null;
    private TransactionManager tm = null;
    private JmxService jmxService = null;
    private List<String> resourceNames = new ArrayList<String>();
    private static Hashtable<String, org.ow2.jonas.resource.internal.Rar> jndiName2RA = new Hashtable();
    private static Hashtable<String, org.ow2.jonas.resource.internal.Rar> fileName2RA = new Hashtable();
    private WorkManager workMgr = null;
    private ResourceBootstrapContext bootCtx = null;
    public static final String JONAS_BASE = JProp.getJonasBase();
    public static final String WORK_RARS_DIR = JProp.getWorkDir() + File.separator + "rars";
    private ClassLoader extClassLoader;
    private WorkManagerService workManagerService;
    private IDeployerManager deployerManager = null;
    private RegistryService registryService;
    private Context ictx = null;

    public JOnASResourceService() {
        this.rarDeployer = new RARDeployer();
    }

    public void setParsingwithvalidation(boolean validate) {
        RarManagerWrapper.setParsingWithValidation(validate);
    }

    @Override
    public void doStart() throws ServiceException {
        IExecution<InitialContext> ictxGetter = new IExecution<InitialContext>(){

            @Override
            public InitialContext execute() throws Exception {
                return JOnASResourceService.this.getRegistryService().getRegistryContext();
            }
        };
        ExecutionResult<InitialContext> ictxResult = RunnableHelper.execute(this.getClass().getClassLoader(), ictxGetter);
        if (ictxResult.hasException()) {
            logger.log(BasicLevel.ERROR, (Object)"Cannot create initial context when Resource service initializing");
            throw new ServiceException("Cannot create initial context when Resource service initializing", ictxResult.getException());
        }
        this.ictx = ictxResult.getResult();
        try {
            LoaderManager lm = LoaderManager.getInstance();
            this.extClassLoader = lm.getExternalLoader();
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot get the Applications ClassLoader from RAR Container Service: " + e));
            throw new ServiceException("Cannot get the Applications ClassLoader from RAR Container Service", e);
        }
        this.rarDeployer.setResourceService(this);
        this.deployerManager.register(this.rarDeployer);
        this.tm = this.transactionService.getTransactionManager();
        this.workMgr = this.workManagerService.getWorkManager();
        try {
            this.bootCtx = new ResourceBootstrapContext(this.workMgr, this.transactionService.getXATerminator());
        }
        catch (XAException e) {
            logger.log(BasicLevel.ERROR, (Object)"Unable to get an XATerminator from the TransactionService");
            throw new ServiceException("Unable to get an XATerminator from the TransactionService", e);
        }
        String rarFileName = null;
        ComponentContext ctx = null;
        for (int i = 0; i < this.resourceNames.size(); ++i) {
            rarFileName = this.resourceNames.get(i);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("rarFileName=" + rarFileName));
            }
            try {
                ctx = new ComponentContext(rarFileName);
                ctx.rebind("rarFileName", (Object)rarFileName);
                ctx.rebind("isInEar", (Object)false);
                ctx.rebind("classloader", (Object)this.extClassLoader);
                this.createResourceAdapter(ctx);
                continue;
            }
            catch (Exception e) {
                logger.log(BasicLevel.ERROR, (Object)("JOnAS: Cannot create resource: " + rarFileName + " exception: " + e));
                e.printStackTrace();
            }
        }
        this.jmxService.loadDescriptors(this.getClass().getPackage().getName(), this.getClass().getClassLoader());
        String domainName = this.getDomainName();
        this.jmxService.registerMBean((Object)this, JonasObjectName.resourceService(domainName));
        try {
            this.jmxService.registerModelMBean((Object)new ArchiveConfigMBean(), JonasObjectName.ArchiveConfig(domainName));
            this.jmxService.registerModelMBean((Object)new RarConfigMBean(), JonasObjectName.RarConfig(domainName));
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.log(BasicLevel.WARN, (Object)("ResourceService: Can't register MBeans for archive configuration" + e));
            return;
        }
        logger.log(BasicLevel.INFO, (Object)"Resource Service started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doStop() throws ServiceException {
        ServiceException se = null;
        Hashtable<String, org.ow2.jonas.resource.internal.Rar> hashtable = fileName2RA;
        synchronized (hashtable) {
            Enumeration<org.ow2.jonas.resource.internal.Rar> keys = fileName2RA.elements();
            while (keys.hasMoreElements()) {
                org.ow2.jonas.resource.internal.Rar ra = keys.nextElement();
                try {
                    ra.unRegister(this.getDomainName());
                }
                catch (Exception ex) {
                    logger.log(BasicLevel.ERROR, (Object)("ResourceService: Received the following:" + ex));
                    ex.printStackTrace();
                    if (se != null) continue;
                    se = new ServiceException(ex.getMessage());
                }
            }
        }
        fileName2RA.clear();
        if (this.deployerManager != null) {
            this.deployerManager.unregister(this.rarDeployer);
        }
        if (this.jmxService != null) {
            String domainName = this.getDomainName();
            this.jmxService.unregisterModelMBean(JonasObjectName.ArchiveConfig(domainName));
            this.jmxService.unregisterModelMBean(JonasObjectName.RarConfig(domainName));
            this.jmxService.unregisterMBean(JonasObjectName.resourceService(domainName));
        }
        if (se != null) {
            throw se;
        }
        logger.log(BasicLevel.INFO, (Object)"Resource Service stopped");
    }

    @Override
    public synchronized String createResourceAdapter(Context ctx) throws ResourceServiceException, NamingException, MalformedURLException {
        String ron = this.createRA(ctx);
        if (ron == null) {
            if (!this.delayedRAs.contains(ctx)) {
                this.delayedRAs.add(ctx);
            }
            return null;
        }
        int count = 1;
        while (count > 0 && this.delayedRAs.size() > 0) {
            ArrayList<Context> processedRAs = new ArrayList<Context>();
            count = 0;
            try {
                for (Context cc : this.delayedRAs) {
                    String on = this.createRA(cc);
                    if (on == null) continue;
                    ++count;
                    if (processedRAs.contains(cc)) continue;
                    processedRAs.add(cc);
                }
            }
            catch (Exception e) {
                logger.log(BasicLevel.WARN, (Object)("delayed creation of RA failed:" + e));
                e.printStackTrace();
            }
            for (Context cc : processedRAs) {
                int index = this.delayedRAs.indexOf(cc);
                if (index <= -1) continue;
                this.delayedRAs.remove(index);
            }
        }
        return ron;
    }

    private String createRA(Context ctx) throws ResourceServiceException, NamingException, MalformedURLException {
        File f;
        String rarFileName;
        try {
            rarFileName = (String)ctx.lookup("rarFileName");
            ctx.rebind("deployed", (Object)false);
        }
        catch (Exception ex) {
            String err = "Error while getting parameter from context param.";
            logger.log(BasicLevel.ERROR, (Object)(err + ex.getMessage()));
            throw new ResourceServiceException(err, ex);
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)rarFileName);
        }
        if (!rarFileName.endsWith(".rar")) {
            rarFileName = rarFileName + ".rar";
            ctx.rebind("rarFileName", (Object)rarFileName);
        }
        if (!(f = new File(rarFileName)).exists()) {
            logger.log(BasicLevel.ERROR, (Object)("createResourceAdapter: " + rarFileName + " not found"));
            throw new NamingException(rarFileName + " not found");
        }
        URL rarUrl = f.toURL();
        final org.ow2.jonas.resource.internal.Rar rar = new org.ow2.jonas.resource.internal.Rar(ctx, this.getDomainName(), this.getJonasServerName(), this.bootCtx, this.tm, this.jmxService);
        rar.setInitialContext(this.ictx);
        try {
            final JOnASResourceService resourceService = this;
            IExecution<Context> exec = new IExecution<Context>(){

                @Override
                public Context execute() throws Exception {
                    return rar.processRar(JOnASResourceService.this.getDomainName(), resourceService);
                }
            };
            ExecutionResult<Context> execResult = RunnableHelper.execute(this.getClass().getClassLoader(), exec);
            if (execResult.hasException()) {
                logger.log(BasicLevel.ERROR, (Object)("execResult failed:" + execResult.getException()));
                throw execResult.getException();
            }
            Context ctxRar = execResult.getResult();
        }
        catch (NullPointerException n) {
            logger.log(BasicLevel.ERROR, (Object)"NPE while processing RAR");
            n.printStackTrace();
            throw new ResourceServiceException("NPE while processing RAR", n);
        }
        catch (Exception ex) {
            String err = "Error processing Rar: " + ex.getMessage();
            try {
                rar.unRegister(this.getDomainName());
            }
            catch (Exception exc) {
                err = err + "  Unregister also failed with " + exc.getMessage();
            }
            if (ex.getMessage() != null && ex.getMessage().indexOf("no jonas-ra.xml") > 0) {
                throw new ResourceServiceException("", ex);
            }
            logger.log(BasicLevel.ERROR, (Object)err);
            throw new ResourceServiceException(err, ex);
        }
        boolean isDeployed = false;
        try {
            isDeployed = (Boolean)ctx.lookup("deployed");
        }
        catch (Exception ex) {
            String err = "Error while getting parameter(isDeployed) from context param.";
            logger.log(BasicLevel.ERROR, (Object)(err + ex.getMessage()));
            throw new ResourceServiceException(err, ex);
        }
        if (!isDeployed) {
            logger.log(BasicLevel.DEBUG, (Object)("Still not deployed:" + ctx));
            return null;
        }
        Vector jNames = rar.getJndinames();
        if (jNames != null) {
            for (int i = 0; i < jNames.size(); ++i) {
                jndiName2RA.put((String)jNames.get(i), rar);
            }
        }
        fileName2RA.put(rarUrl.getPath(), rar);
        String onRar = null;
        try {
            onRar = (String)ctx.lookup("onRar");
        }
        catch (Exception ex) {
            String err = "Error while getting parameter(onRar) from context param.";
            logger.log(BasicLevel.ERROR, (Object)(err + ex.getMessage()));
            throw new ResourceServiceException(err, ex);
        }
        return onRar;
    }

    @Override
    public void deployRars(Context ctx) throws ResourceServiceException {
        URL[] urls = null;
        URL earUrl = null;
        ClassLoader earClassLoader = null;
        URL[] altDDs = null;
        try {
            urls = (URL[])ctx.lookup("urls");
            earUrl = (URL)ctx.lookup("earUrl");
            earClassLoader = (ClassLoader)ctx.lookup("earClassLoader");
            altDDs = (URL[])ctx.lookup("altDDs");
        }
        catch (NamingException e) {
            String err = "Error while getting parameter from context param ";
            logger.log(BasicLevel.ERROR, (Object)(err + e.getMessage()));
            throw new ResourceServiceException(err, e);
        }
        for (int i = 0; i < urls.length; ++i) {
            String fileName = URLUtils.urlToFile(urls[i]).getPath();
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Deploy rar '" + fileName + "' for the ear service"));
            }
            ComponentContext contctx = null;
            try {
                contctx = new ComponentContext(fileName);
                contctx.rebind("rarFileName", (Object)fileName);
                contctx.rebind("isInEar", (Object)true);
                contctx.rebind("earUrl", (Object)earUrl);
                if (altDDs[i] != null) {
                    contctx.rebind("altDD", (Object)altDDs[i]);
                }
                contctx.rebind("classloader", (Object)earClassLoader);
                this.createResourceAdapter(contctx);
                continue;
            }
            catch (Exception e) {
                logger.log(BasicLevel.ERROR, (Object)("Error when deploying '" + fileName + "'"));
                logger.log(BasicLevel.ERROR, (Object)e.getMessage());
                logger.log(BasicLevel.ERROR, (Object)"Undeploy rar of the ear application");
                for (int j = 0; j < i; ++j) {
                    String rarFileName = urls[j].getFile();
                    try {
                        ComponentContext compctx = new ComponentContext(rarFileName);
                        compctx.rebind("rarFileName", (Object)rarFileName);
                        compctx.rebind("isInEar", (Object)new Boolean(true));
                        contctx.rebind("earUrl", (Object)earUrl);
                        this.unRegisterRar(compctx);
                        continue;
                    }
                    catch (Exception ex) {
                        logger.log(BasicLevel.ERROR, (Object)("Error when undeploying '" + rarFileName + "'"));
                        logger.log(BasicLevel.ERROR, (Object)ex.getMessage());
                        logger.log(BasicLevel.ERROR, (Object)"Cannot undeploy rar of the ear application");
                    }
                }
                throw new ResourceServiceException("Error during the deployment", e);
            }
        }
    }

    @Override
    public void unDeployRars(URL[] urls, URL earUrl) {
        for (int i = 0; i < urls.length; ++i) {
            String fileName = urls[i].getFile();
            if (fileName2RA.containsKey(fileName)) {
                try {
                    ComponentContext compctx = new ComponentContext(fileName);
                    compctx.rebind("rarFileName", (Object)fileName);
                    compctx.rebind("isInEar", (Object)true);
                    compctx.rebind("earUrl", (Object)earUrl);
                    this.unRegisterRar(compctx);
                }
                catch (Exception ex) {
                    logger.log(BasicLevel.ERROR, (Object)("Cannot undeploy resource: " + fileName + " " + ex));
                }
                continue;
            }
            logger.log(BasicLevel.ERROR, (Object)("Cannot remove the non-existant rar '" + fileName + "'"));
        }
    }

    public void unRegisterRar(Context ctx) throws Exception {
        String rarFileName;
        try {
            rarFileName = (String)ctx.lookup("rarFileName");
        }
        catch (NamingException e) {
            String err = "Error while getting parameter from context param.";
            logger.log(BasicLevel.ERROR, (Object)(err + e.getMessage()));
            throw new ResourceServiceException(err, e);
        }
        catch (Exception ex) {
            String err = "Error while getting parameter from context param.";
            logger.log(BasicLevel.ERROR, (Object)(err + ex.getMessage()));
            throw new ResourceServiceException(err, ex);
        }
        if (manageLogger.isLoggable(BasicLevel.DEBUG)) {
            manageLogger.log(BasicLevel.DEBUG, (Object)("TEST Unregister MBeans for RAR in file: " + rarFileName));
        }
        String rarPath = new File(rarFileName).toURL().getPath();
        org.ow2.jonas.resource.internal.Rar rar = fileName2RA.get(rarPath);
        Vector jNames = (Vector)rar.getJndinames().clone();
        rar.unRegister(this.getDomainName());
        for (int i = 0; i < jNames.size(); ++i) {
            jndiName2RA.remove(jNames.get(i));
        }
        fileName2RA.remove(rarPath);
        this.resourceNames.remove(this.normalizePath(rarFileName));
        logger.log(BasicLevel.INFO, (Object)("ResourceService: unRegisterRar: " + rarFileName));
    }

    public ObjectName[] getJDBCResourceAdapaters() throws Exception {
        ObjectName[] result = null;
        ObjectName raOns = J2eeObjectName.getResourceAdapters(this.getDomainName(), this.getJonasServerName());
        MBeanServer mbeanServer = this.jmxService.getJmxServer();
        Set<ObjectName> ons = mbeanServer.queryNames(raOns, null);
        if (ons.isEmpty()) {
            return null;
        }
        ArrayList<ObjectName> al = new ArrayList<ObjectName>();
        for (ObjectName aRaOn : ons) {
            Properties props = (Properties)mbeanServer.getAttribute(aRaOn, "properties");
            String dsClassValue = props.getProperty("dsClass");
            String urlValue = props.getProperty("URL");
            if (dsClassValue == null || dsClassValue.length() == 0 || urlValue == null || urlValue.length() == 0) continue;
            al.add(aRaOn);
        }
        int nbJDBCResourceAdapaters = al.size();
        if (nbJDBCResourceAdapaters == 0) {
            return null;
        }
        result = new ObjectName[nbJDBCResourceAdapaters];
        for (int i = 0; i < nbJDBCResourceAdapaters; ++i) {
            result[i] = (ObjectName)al.get(i);
        }
        return result;
    }

    public String getJDBCResourceAdapater(String jndiName) throws Exception {
        String result = null;
        ObjectName[] raOns = this.getJDBCResourceAdapaters();
        ObjectName raOn = null;
        String raJndiName = null;
        MBeanServer mbeanServer = this.jmxService.getJmxServer();
        if (raOns != null) {
            for (int i = 0; i < raOns.length; ++i) {
                raOn = raOns[i];
                raJndiName = (String)mbeanServer.getAttribute(raOn, "jndiName");
                if (!jndiName.equals(raJndiName)) continue;
                return raOn.toString();
            }
        }
        return result;
    }

    public Integer getCurrentNumberOfResource() {
        return this.getCurrentNumberOfRars();
    }

    @Override
    public Integer getCurrentNumberOfRars() {
        return fileName2RA.size();
    }

    @Override
    public List<String> getDeployedRars() {
        ArrayList<String> al = new ArrayList<String>();
        String rarFileName = null;
        Enumeration<String> keys = fileName2RA.keys();
        while (keys.hasMoreElements()) {
            rarFileName = keys.nextElement();
            try {
                al.add(new File(rarFileName).toURL().getPath());
            }
            catch (Exception e) {
                if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                logger.log(BasicLevel.DEBUG, (Object)("Unable to add rarfile " + rarFileName + " to arraylist"));
            }
        }
        return al;
    }

    @Override
    public String deployRar(String fileName) throws ResourceServiceException {
        ComponentContext ctx = null;
        String onRar = null;
        try {
            ctx = new ComponentContext(fileName);
            ctx.rebind("rarFileName", (Object)fileName);
            ctx.rebind("isInEar", (Object)false);
            ctx.rebind("classloader", (Object)this.extClassLoader);
            onRar = this.createResourceAdapter(ctx);
        }
        catch (Exception e) {
            String err = "Error when deploying the rar file: " + fileName;
            logger.log(BasicLevel.ERROR, (Object)(err + e.getMessage()));
            e.printStackTrace();
            throw new ResourceServiceException(err, e);
        }
        return onRar;
    }

    @Override
    public Boolean isRarDeployed(String fileName) {
        return this.isRarLoaded(fileName);
    }

    @Override
    public boolean isRarDeployedByUnpackName(String unpackName) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("entering for unpackName= " + unpackName));
        }
        return false;
    }

    @Override
    public void unDeployRar(String filename) throws Exception {
        String fileName = filename;
        boolean found = true;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Trying to undeploy: " + fileName + " with the following deployed:" + fileName2RA));
        }
        try {
            File f = new File(fileName);
            if (!fileName2RA.containsKey(f.toURL().getPath())) {
                found = false;
            }
            if (!found) {
                String err = "Cannot undeploy the rar '" + fileName + "', it is not deployed.";
                logger.log(BasicLevel.ERROR, (Object)err);
                throw new ResourceServiceException(err);
            }
        }
        catch (Exception ex) {
            String err = "Error trying to undeployRarMBean " + fileName;
            logger.log(BasicLevel.ERROR, (Object)(err + ex.getMessage()));
            throw new ResourceServiceException(err, ex);
        }
        ComponentContext compctx = null;
        try {
            compctx = new ComponentContext(fileName);
            compctx.rebind("rarFileName", (Object)fileName);
            compctx.rebind("isInEar", (Object)false);
            this.unRegisterRar(compctx);
        }
        catch (NamingException e) {
            String err = "Error when binding parameters";
            logger.log(BasicLevel.ERROR, (Object)(err + e.getMessage()));
            throw new ResourceServiceException(err, e);
        }
        catch (Exception ex) {
            String err = "Error when unRegistering rar " + fileName;
            logger.log(BasicLevel.ERROR, (Object)(err + ex.getMessage()));
            ex.printStackTrace();
            throw new ResourceServiceException(err, ex);
        }
    }

    @Override
    public boolean isRarLoaded(String fileName) {
        Object updateName = null;
        boolean isLoaded = false;
        try {
            if (fileName2RA.containsKey(fileName)) {
                isLoaded = true;
            }
        }
        catch (Exception e) {
            String err = "Cannot determine if the rar is deployed or not";
            logger.log(BasicLevel.ERROR, (Object)err);
            return false;
        }
        return isLoaded;
    }

    private String normalizePath(String path) {
        String ret = null;
        ret = File.separatorChar == '/' ? path.replace('\\', File.separatorChar) : path.replace('/', File.separatorChar);
        return ret;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setJmxService(JmxService jmxService) {
        this.jmxService = jmxService;
    }

    public void setWorkManagerService(WorkManagerService workManagerService) {
        this.workManagerService = workManagerService;
    }

    public void setDeployerManager(IDeployerManager deployerManager) {
        this.deployerManager = deployerManager;
    }

    public void setRegistryService(RegistryService registry) {
        this.registryService = registry;
    }

    private RegistryService getRegistryService() {
        return this.registryService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Rar getRar(String jndiName) {
        Hashtable<String, org.ow2.jonas.resource.internal.Rar> hashtable = jndiName2RA;
        synchronized (hashtable) {
            org.ow2.jonas.resource.internal.Rar ra = jndiName2RA.get(jndiName);
            return ra;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectorDesc getConnectorDesc(String jndiName) {
        Hashtable<String, org.ow2.jonas.resource.internal.Rar> hashtable = jndiName2RA;
        synchronized (hashtable) {
            org.ow2.jonas.resource.internal.Rar rar = jndiName2RA.get(jndiName);
            if (rar != null) {
                return rar.getConnectorDesc();
            }
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Can't find " + jndiName + " in " + jndiName2RA));
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JonasConnectorDesc getJonasConnectorDesc(String jndiName) {
        Hashtable<String, org.ow2.jonas.resource.internal.Rar> hashtable = jndiName2RA;
        synchronized (hashtable) {
            org.ow2.jonas.resource.internal.Rar rar = jndiName2RA.get(jndiName);
            if (rar != null) {
                return rar.getJonasConnectorDesc();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getResourceObject(String jndiName) {
        org.ow2.jonas.resource.internal.Rar ra = null;
        Hashtable<String, org.ow2.jonas.resource.internal.Rar> hashtable = jndiName2RA;
        synchronized (hashtable) {
            ra = jndiName2RA.get(jndiName);
        }
        if (ra != null) {
            return ra.getFactory(jndiName);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getXmlContent(String jndiName) {
        Hashtable<String, org.ow2.jonas.resource.internal.Rar> hashtable = jndiName2RA;
        synchronized (hashtable) {
            org.ow2.jonas.resource.internal.Rar rar = jndiName2RA.get(jndiName);
            if (rar != null) {
                return rar.getXmlContent();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getConfigObject(String jndiName) {
        org.ow2.jonas.resource.internal.Rar ra = null;
        Hashtable<String, org.ow2.jonas.resource.internal.Rar> hashtable = jndiName2RA;
        synchronized (hashtable) {
            ra = jndiName2RA.get(jndiName);
        }
        if (ra != null) {
            return ra.getConfigObj(jndiName);
        }
        return null;
    }
}

