/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.publish.internal.manager;

import java.util.ArrayList;
import java.util.List;
import javax.wsdl.Definition;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.service.ServiceException;
import org.ow2.jonas.ws.publish.PublicationInfo;
import org.ow2.jonas.ws.publish.WSDLPublisher;
import org.ow2.jonas.ws.publish.WSDLPublisherException;
import org.ow2.jonas.ws.publish.WSDLPublisherManager;
import org.ow2.jonas.ws.publish.internal.manager.WSDLPublisherFactory;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class DefaultWSDLPublisherManager
extends AbsServiceImpl
implements WSDLPublisherManager {
    private static Log logger = LogFactory.getLog(DefaultWSDLPublisherManager.class);
    private List<WSDLPublisher> publishers = new ArrayList<WSDLPublisher>();

    public void setPublishers(String param) {
        List<String> handlers = DefaultWSDLPublisherManager.convertToList(param);
        WSDLPublisherFactory factory = WSDLPublisherFactory.newInstance();
        for (String name : handlers) {
            WSDLPublisher publisher = null;
            try {
                publisher = factory.newPublisher(name);
            }
            catch (WSDLPublisherException e) {
                logger.info("Cannot add the new WSDLPublisher '{0}'", name, e);
            }
            logger.debug("Adding WSDLPublisher ''{0}''", name);
            this.addPublisher(publisher);
        }
    }

    public void addPublisher(WSDLPublisher publisher) {
        this.publishers.add(publisher);
    }

    public void removePublisher(WSDLPublisher publisher) {
        this.publishers.remove(publisher);
    }

    public void publish(Definition definition, PublicationInfo info) throws WSDLPublisherException {
        for (WSDLPublisher publisher : this.publishers) {
            publisher.publish(definition, info);
        }
    }

    protected void doStart() throws ServiceException {
    }

    protected void doStop() throws ServiceException {
    }
}

