/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2005-2006 Bull S.A.S
 * Contact: jonas-team@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * Initial developer(s):
 * --------------------------------------------------------------------------
 * $Id: ClientFOSFSB.java 15500 2008-10-09 19:47:38Z pelletib $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.examples.cluster.j2ee14.client;

import java.util.Properties;

import org.ow2.jonas.examples.cluster.j2ee14.beans.samplecluster2.MyStateful;
import org.ow2.jonas.examples.cluster.j2ee14.beans.samplecluster2.MyStatefulHome;


/**
 * Fat client :
 * - test Fail Over of the SFSB
 */
public class ClientFOSFSB {

    /**
     * Iteration number
     */
    private static final int ITERATION_NB = 50;

    /**
     * Main method
     * @param args arguments of the client
     */
    public static int main(final String[] args) {

        String jonasEJBServer = null;
        String ejbTotalCallsCount = null;
        String ejbEntityCreated = null;
        Properties prop = null;

        // get home
        MyStatefulHome home = ClientUtility.getMyStatefulHome();
        System.out.println("Home retrieved -> " + home);

        // get primary remote
        MyStateful bean = ClientUtility.getMyStatefulBean(home);
        System.out.println("Bean created -> " + bean);

        for (int i = 1; i < ITERATION_NB + 1; i++) {
            try {

                String l = "log entry " + i;
                // add in the bean state
                bean.logWithJOnASInstance(l);

                System.out.println("Add " + l);

                if (0 == i % 10) {
                    System.out.println("------------------------------------------");
                    System.out.println("Get the log entries from the bean state");
                    System.out.println("------------------------------------------");
                    StringBuffer sb = bean.getLogTextDump();
                    System.out.println(sb);

                    System.out.println("------------------------------------------");
                    System.out.println("Sleep 10s");
                    System.out.println("------------------------------------------");
                    try {
                        Thread.sleep(10000);
                    } catch (Exception e) {
                        e.printStackTrace();
                        return -1;
                    }
                }

            } catch (Exception e) {
                e.printStackTrace();
                return -1;
            }
        }
        try {
            bean.remove();
        } catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        System.out.println("Client OK. Exiting.");
        return 0;
    }
}

