/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.axis2.jaxws.description.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.ConnectException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.jws.HandlerChain;
import javax.jws.soap.SOAPBinding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.handler.PortInfo;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.ClientConfigurationFactory;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.catalog.JAXWSCatalogManager;
import org.apache.axis2.jaxws.catalog.impl.OASISCatalogManager;
import org.apache.axis2.jaxws.description.DescriptionFactory;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.EndpointInterfaceDescription;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.description.ServiceDescriptionJava;
import org.apache.axis2.jaxws.description.ServiceDescriptionWSDL;
import org.apache.axis2.jaxws.description.ServiceRuntimeDescription;
import org.apache.axis2.jaxws.description.builder.DescriptionBuilderComposite;
import org.apache.axis2.jaxws.description.builder.MethodDescriptionComposite;
import org.apache.axis2.jaxws.description.builder.ParameterDescriptionComposite;
import org.apache.axis2.jaxws.description.builder.WebServiceClientAnnot;
import org.apache.axis2.jaxws.description.xml.handler.HandlerChainsType;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.util.WSDL4JWrapper;
import org.apache.axis2.jaxws.util.WSDLWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.jonas.ws.axis2.jaxws.description.impl.DescriptionUtils;
import org.ow2.jonas.ws.axis2.jaxws.description.impl.EndpointDescriptionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceDescriptionImpl
implements ServiceDescription,
ServiceDescriptionWSDL,
ServiceDescriptionJava {
    private ClientConfigurationFactory clientConfigFactory;
    private ConfigurationContext configContext;
    private String wsdlURL;
    private QName serviceQName;
    private WSDLWrapper wsdlWrapper;
    private WSDLWrapper generatedWsdlWrapper;
    private HandlerChain handlerChainAnnotation;
    private HandlerChainsType handlerChainsType;
    private Map<QName, EndpointDescription> definedEndpointDescriptions = new HashMap<QName, EndpointDescription>();
    private Map<Object, Map<QName, EndpointDescriptionImpl>> dynamicEndpointDescriptions = new WeakHashMap<Object, Map<QName, EndpointDescriptionImpl>>();
    Map<PortInfo, List<Class>> handlerClassesMap = new WeakHashMap<PortInfo, List<Class>>();
    private static final Log log = LogFactory.getLog(ServiceDescriptionImpl.class);
    private HashMap<String, DescriptionBuilderComposite> dbcMap = null;
    private DescriptionBuilderComposite composite = null;
    private boolean isServerSide = false;
    private JAXWSCatalogManager catalogManager = null;
    Map<String, ServiceRuntimeDescription> runtimeDescMap = new ConcurrentHashMap<String, ServiceRuntimeDescription>();

    ServiceDescriptionImpl(URL wsdlURL, QName serviceQName, Class serviceClass) {
        this(wsdlURL, serviceQName, serviceClass, null, null);
    }

    ServiceDescriptionImpl(URL wsdlURL, QName serviceQName, Class serviceClass, DescriptionBuilderComposite sparseComposite, Object sparseCompositeKey) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ServiceDescriptionImpl(URL,QName,Class,DescriptionBuilderComposite,Object)");
        }
        this.catalogManager = sparseComposite != null ? sparseComposite.getCatalogManager() : new OASISCatalogManager();
        if (serviceQName == null) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"serviceDescErr0"));
        }
        if (serviceClass == null) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"serviceDescErr1", (String)"null"));
        }
        if (!Service.class.isAssignableFrom(serviceClass)) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"serviceDescErr1", (String)serviceClass.getName()));
        }
        this.composite = new DescriptionBuilderComposite();
        this.composite.setIsServiceProvider(false);
        this.composite.setCorrespondingClass(serviceClass);
        this.composite.setClassLoader(ServiceDescriptionImpl.getClassLoader(serviceClass));
        this.composite.setSparseComposite(sparseCompositeKey, sparseComposite);
        URL sparseCompositeWsdlURL = this.getSparseCompositeWsdlURL(sparseComposite);
        if (sparseCompositeWsdlURL != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Wsdl location overriden by sparse composite; overriden value: " + this.wsdlURL));
            }
            this.wsdlURL = sparseCompositeWsdlURL.toString();
        } else {
            String string = this.wsdlURL = wsdlURL == null ? null : wsdlURL.toString();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Wsdl Location value used: " + this.wsdlURL));
        }
        this.serviceQName = serviceQName;
        this.setupWsdlDefinition();
    }

    URL getSparseCompositeWsdlURL(DescriptionBuilderComposite sparseComposite) {
        WebServiceClientAnnot wsc;
        URL url = null;
        if (sparseComposite != null && (wsc = sparseComposite.getWebServiceClientAnnot()) != null && wsc.wsdlLocation() != null) {
            String wsdlLocation = wsc.wsdlLocation();
            URL wsdlUrl = this.getWSDLURL(wsdlLocation);
            if (wsdlUrl == null) {
                throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"serviceDescErr4", (String)wsdlLocation));
            }
            url = wsdlUrl;
        }
        return url;
    }

    private static URL createWsdlURL(String wsdlLocation) {
        URL theUrl;
        block2: {
            theUrl = null;
            try {
                theUrl = new URL(wsdlLocation);
            }
            catch (Exception ex) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)("Unable to obtain URL for WSDL file: " + wsdlLocation + " by using File reference"));
            }
        }
        return theUrl;
    }

    @Deprecated
    public ServiceDescriptionImpl(Class serviceImplClass, AxisService axisService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ServiceDescriptionImpl(Class,AxisService)");
        }
        this.composite = new DescriptionBuilderComposite();
        this.composite.setIsDeprecatedServiceProviderConstruction(true);
        this.composite.setIsServiceProvider(true);
        this.isServerSide = true;
        EndpointDescriptionImpl endpointDescription = new EndpointDescriptionImpl(serviceImplClass, null, axisService, this);
        this.addEndpointDescription(endpointDescription);
    }

    public ServiceDescriptionImpl(HashMap<String, DescriptionBuilderComposite> dbcMap, DescriptionBuilderComposite composite) {
        this(dbcMap, composite, null);
    }

    public ServiceDescriptionImpl(HashMap<String, DescriptionBuilderComposite> dbcMap, DescriptionBuilderComposite composite, ConfigurationContext configContext) {
        this.composite = composite;
        this.configContext = configContext;
        if (log.isDebugEnabled()) {
            log.debug((Object)"ServiceDescriptionImpl(HashMap<String,DescriptionBuilderComposite>,ConfigurationContext)");
        }
        String serviceImplName = this.composite.getClassName();
        this.dbcMap = dbcMap;
        this.isServerSide = true;
        this.setupWsdlDefinition();
        this.validateDBCLIntegrity();
        EndpointDescriptionImpl endpointDescription = new EndpointDescriptionImpl(this, serviceImplName, composite.getProperties());
        this.addEndpointDescription(endpointDescription);
    }

    EndpointDescription updateEndpointDescription(Class sei, QName portQName, DescriptionFactory.UpdateType updateType, DescriptionBuilderComposite composite, Object serviceDelegateKey) {
        QName preferredPortQN;
        EndpointDescriptionImpl endpointDescription = this.getEndpointDescriptionImpl(portQName);
        boolean isPortDeclared = this.isPortDeclared(portQName);
        if (endpointDescription == null && serviceDelegateKey != null) {
            endpointDescription = this.getDynamicEndpointDescriptionImpl(portQName, serviceDelegateKey);
        }
        if (DescriptionUtils.isEmpty(portQName) && !DescriptionUtils.isEmpty(preferredPortQN = this.getPreferredPort(serviceDelegateKey))) {
            portQName = preferredPortQN;
        }
        switch (updateType) {
            case ADD_PORT: {
                if (composite != null) {
                    throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"serviceDescErr5", (String)portQName.toString()));
                }
                if (DescriptionUtils.isEmpty(portQName)) {
                    throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"addPortErr2"));
                }
                if (this.getWSDLWrapper() != null && isPortDeclared) {
                    throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"addPortDup", (String)portQName.toString()));
                }
                if (endpointDescription != null) break;
                if (serviceDelegateKey == null) {
                    throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"serviceDescriptionImplAddPortErr"));
                }
                endpointDescription = new EndpointDescriptionImpl(sei, portQName, true, this);
                this.addDynamicEndpointDescriptionImpl(endpointDescription, serviceDelegateKey);
                break;
            }
            case GET_PORT: {
                if (endpointDescription == null && portQName == null && sei != null) {
                    endpointDescription = this.getEndpointDescriptionImpl(sei);
                }
                if (!isPortDeclared || endpointDescription != null && endpointDescription.isDynamicPort()) {
                    throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"updateEPDescrErr1", (String)(portQName != null ? portQName.toString() : "not specified")));
                }
                if (sei == null) {
                    throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"updateEPDescrErr2", (String)(portQName != null ? portQName.toString() : "not specified")));
                }
                if (endpointDescription == null) {
                    endpointDescription = new EndpointDescriptionImpl(sei, portQName, this, composite, serviceDelegateKey);
                    this.addEndpointDescription(endpointDescription);
                    this.resetServiceRuntimeDescription();
                    break;
                }
                if (this.getEndpointSEI(portQName) == null && !endpointDescription.isDynamicPort()) {
                    endpointDescription.updateWithSEI(sei, composite, serviceDelegateKey);
                    break;
                }
                if (this.getEndpointSEI(portQName) != sei) {
                    throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"updateEPDescrErr3", (String)portQName.toString(), (String)sei.getName(), (String)this.getEndpointSEI(portQName).getName()));
                }
                endpointDescription.getDescriptionBuilderComposite().setSparseComposite(serviceDelegateKey, composite);
                break;
            }
            case CREATE_DISPATCH: {
                if (composite != null) {
                    throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"serviceDescErr6"));
                }
                if (DescriptionUtils.isEmpty(portQName)) {
                    throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"createDispatchFail0"));
                }
                if (endpointDescription != null) break;
                if (sei != null) {
                    throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"createDispatchFail3", (String)portQName.toString()));
                }
                if (this.getWSDLWrapper() != null && isPortDeclared) {
                    endpointDescription = new EndpointDescriptionImpl(sei, portQName, this);
                    this.addEndpointDescription(endpointDescription);
                    break;
                }
                throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"createDispatchFail1", (String)portQName.toString()));
            }
        }
        return endpointDescription;
    }

    private Class getEndpointSEI(QName portQName) {
        EndpointInterfaceDescription endpointInterfaceDesc;
        Class endpointSEI = null;
        EndpointDescription endpointDesc = this.getEndpointDescription(portQName);
        if (endpointDesc != null && (endpointInterfaceDesc = endpointDesc.getEndpointInterfaceDescription()) != null) {
            endpointSEI = endpointInterfaceDesc.getSEIClass();
        }
        return endpointSEI;
    }

    private boolean isPortDeclared(QName portQName) {
        Definition wsdlDefn;
        javax.wsdl.Service wsdlService;
        Port wsdlPort;
        boolean portIsDeclared = false;
        portIsDeclared = !DescriptionUtils.isEmpty(portQName) ? (this.getWSDLWrapper() != null ? (wsdlPort = (wsdlService = (wsdlDefn = this.getWSDLWrapper().getDefinition()).getService(this.serviceQName)).getPort(portQName.getLocalPart())) != null : true) : true;
        return portIsDeclared;
    }

    public EndpointDescription[] getEndpointDescriptions() {
        return this.definedEndpointDescriptions.values().toArray(new EndpointDescriptionImpl[0]);
    }

    public Collection<EndpointDescriptionImpl> getDynamicEndpointDescriptions_AsCollection(Object serviceDelegateKey) {
        Collection<EndpointDescriptionImpl> dynamicEndpoints = null;
        if (serviceDelegateKey != null && this.dynamicEndpointDescriptions.get(serviceDelegateKey) != null) {
            dynamicEndpoints = this.dynamicEndpointDescriptions.get(serviceDelegateKey).values();
        }
        return dynamicEndpoints;
    }

    public Collection<EndpointDescription> getEndpointDescriptions_AsCollection() {
        return this.definedEndpointDescriptions.values();
    }

    public EndpointDescription getEndpointDescription(QName portQName) {
        return this.getEndpointDescription(portQName, null);
    }

    public EndpointDescription getEndpointDescription(QName portQName, Object serviceDelegateKey) {
        EndpointDescription returnDesc = null;
        if (!DescriptionUtils.isEmpty(portQName) && (returnDesc = this.definedEndpointDescriptions.get(portQName)) == null && serviceDelegateKey != null) {
            returnDesc = this.getDynamicEndpointDescriptionImpl(portQName, serviceDelegateKey);
        }
        return returnDesc;
    }

    EndpointDescriptionImpl getEndpointDescriptionImpl(QName portQName) {
        return (EndpointDescriptionImpl)this.getEndpointDescription(portQName, null);
    }

    EndpointDescriptionImpl getEndpointDescriptionImpl(QName portQName, Object serviceDelegateKey) {
        return (EndpointDescriptionImpl)this.getEndpointDescription(portQName);
    }

    EndpointDescriptionImpl getEndpointDescriptionImpl(Class seiClass) {
        for (EndpointDescription endpointDescription : this.definedEndpointDescriptions.values()) {
            Class endpointSEIClass;
            EndpointInterfaceDescription endpointInterfaceDesc = endpointDescription.getEndpointInterfaceDescription();
            if (endpointInterfaceDesc == null || (endpointSEIClass = endpointInterfaceDesc.getSEIClass()) == null || !endpointSEIClass.equals(seiClass)) continue;
            return (EndpointDescriptionImpl)endpointDescription;
        }
        return null;
    }

    public DescriptionBuilderComposite getDescriptionBuilderComposite() {
        return this.composite;
    }

    public EndpointDescription[] getEndpointDescription(Class seiClass) {
        EndpointDescription[] returnEndpointDesc = null;
        ArrayList<EndpointDescriptionImpl> matchingEndpoints = new ArrayList<EndpointDescriptionImpl>();
        for (EndpointDescription endpointDescription : this.definedEndpointDescriptions.values()) {
            Class endpointSEIClass;
            EndpointInterfaceDescription endpointInterfaceDesc = endpointDescription.getEndpointInterfaceDescription();
            if (endpointInterfaceDesc == null || (endpointSEIClass = endpointInterfaceDesc.getSEIClass()) == null || !endpointSEIClass.equals(seiClass)) continue;
            matchingEndpoints.add((EndpointDescriptionImpl)endpointDescription);
        }
        if (matchingEndpoints.size() > 0) {
            returnEndpointDesc = matchingEndpoints.toArray(new EndpointDescriptionImpl[0]);
        }
        return returnEndpointDesc;
    }

    private void addEndpointDescription(EndpointDescriptionImpl endpoint) {
        this.definedEndpointDescriptions.put(endpoint.getPortQName(), endpoint);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setupWsdlDefinition() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"setupWsdlDefinition()");
        }
        if (this.composite.isServiceProvider()) {
            if (this.composite.getWebServiceAnnot() != null && DescriptionUtils.isEmpty(this.composite.getWebServiceAnnot().endpointInterface()) || this.composite.getWebServiceProviderAnnot() != null) {
                if (this.composite.getWsdlDefinition() != null) {
                    URL url = this.composite.getWsdlURL();
                    this.wsdlURL = url == null ? null : url.toString();
                    try {
                        if (log.isDebugEnabled()) {
                            if (this.configContext != null) {
                                log.debug((Object)"new WSDL4JWrapper-ConfigContext not null1");
                            } else {
                                log.debug((Object)"new WSDL4JWrapper-ConfigContext null1");
                            }
                        }
                        this.wsdlWrapper = new WSDL4JWrapper(url, this.composite.getWsdlDefinition(), this.configContext, this.catalogManager);
                        return;
                    }
                    catch (WSDLException e) {
                        throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"wsdlException", (String)e.getMessage()), (Throwable)e);
                    }
                } else {
                    String wsdlLocation = null;
                    String string = wsdlLocation = this.composite.getWebServiceAnnot() != null ? this.composite.getWebServiceAnnot().wsdlLocation() : this.composite.getWebServiceProviderAnnot().wsdlLocation();
                    if (wsdlLocation == null || "".equals(wsdlLocation)) return;
                    this.setWSDLDefinitionOnDBC(wsdlLocation);
                }
                return;
            } else {
                if (this.composite.getWebServiceAnnot() == null) return;
                DescriptionBuilderComposite seic = this.getDBCMap().get(this.composite.getWebServiceAnnot().endpointInterface());
                try {
                    if (seic == null && log.isDebugEnabled()) {
                        log.debug((Object)("The SEI class " + this.composite.getWebServiceAnnot().endpointInterface() + " was not found."));
                    }
                    if (seic != null && seic.getWsdlDefinition() != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Get the wsdl definition from the SEI composite.");
                        }
                        URL url = seic.getWsdlURL();
                        this.wsdlURL = url.toString();
                        if (log.isDebugEnabled()) {
                            if (this.configContext != null) {
                                log.debug((Object)"new WSDL4JWrapper-ConfigContext not null2");
                            } else {
                                log.debug((Object)"new WSDL4JWrapper-ConfigContext null2");
                            }
                        }
                        this.wsdlWrapper = new WSDL4JWrapper(seic.getWsdlURL(), seic.getWsdlDefinition(), this.configContext, this.catalogManager);
                        return;
                    }
                    if (this.composite.getWsdlDefinition() != null) {
                        URL url;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Get the wsdl definition from the impl class composite.");
                        }
                        if (log.isDebugEnabled()) {
                            if (this.configContext != null) {
                                log.debug((Object)"new WSDL4JWrapper-ConfigContext not null3");
                            } else {
                                log.debug((Object)"new WSDL4JWrapper-ConfigContext null3");
                            }
                        }
                        this.wsdlURL = (url = this.composite.getWsdlURL()) == null ? null : url.toString();
                        this.wsdlWrapper = new WSDL4JWrapper(this.composite.getWsdlURL(), this.composite.getWsdlDefinition(), this.configContext, this.catalogManager);
                        return;
                    }
                    String wsdlLocation = null;
                    if (seic != null && seic.getWebServiceAnnot() != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Get the wsdl location from the SEI composite.");
                        }
                        wsdlLocation = seic.getWebServiceAnnot().wsdlLocation();
                    }
                    if (wsdlLocation == null || "".equals(wsdlLocation)) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Get the wsdl location from the impl class composite.");
                        }
                        wsdlLocation = this.composite.getWebServiceAnnot().wsdlLocation();
                    }
                    if (wsdlLocation == null || "".equals(wsdlLocation)) return;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("wsdl location =" + wsdlLocation));
                    }
                    this.wsdlURL = wsdlLocation;
                    this.setWSDLDefinitionOnDBC(wsdlLocation);
                    return;
                }
                catch (WSDLException e) {
                    throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"wsdlException", (String)e.getMessage()), (Throwable)e);
                }
            }
        }
        if (this.wsdlURL == null) return;
        try {
            if (log.isDebugEnabled()) {
                if (this.configContext != null) {
                    log.debug((Object)"new WSDL4JWrapper-ConfigContext not null4");
                } else {
                    log.debug((Object)"new WSDL4JWrapper-ConfigContext null4");
                }
            }
            this.wsdlWrapper = new WSDL4JWrapper(new URL(this.wsdlURL), this.configContext, this.catalogManager);
            return;
        }
        catch (FileNotFoundException e) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"wsdlNotFoundErr", (String)e.getMessage()), (Throwable)e);
        }
        catch (UnknownHostException e) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"unknownHost", (String)e.getMessage()), (Throwable)e);
        }
        catch (ConnectException e) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"connectionRefused", (String)e.getMessage()), (Throwable)e);
        }
        catch (IOException e) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"urlStream", (String)e.getMessage()), (Throwable)e);
        }
        catch (WSDLException e) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"wsdlException", (String)e.getMessage()), (Throwable)e);
        }
    }

    private void setWSDLDefinitionOnDBC(String wsdlLocation) {
        block8: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Attempting to load WSDL file from location specified in annotation: " + wsdlLocation));
            }
            if (this.composite.getClassLoader() == null && log.isDebugEnabled()) {
                log.debug((Object)("A classloader could not be found for class: " + this.composite.getClassName() + ". The WSDL file: " + wsdlLocation + " will not be " + "processed, and the ServiceDescription will be built from " + "annotations"));
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Attempting to read WSDL: " + wsdlLocation + " for web " + "service endpoint: " + this.composite.getClassName()));
                }
                if (log.isDebugEnabled()) {
                    if (this.configContext != null) {
                        log.debug((Object)"new WSDL4JWrapper-ConfigContext not null5");
                    } else {
                        log.debug((Object)"new WSDL4JWrapper-ConfigContext null5");
                    }
                }
                URL url = this.getWSDLURL(wsdlLocation);
                ConfigurationContext cc = this.composite.getConfigurationContext();
                this.wsdlWrapper = cc != null ? new WSDL4JWrapper(url, cc, this.catalogManager) : new WSDL4JWrapper(url, this.catalogManager, true, 2);
                this.composite.setWsdlDefinition(this.wsdlWrapper.getDefinition());
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block8;
                log.debug((Object)("The WSDL file: " + wsdlLocation + " for class: " + this.composite.getClassName() + "could not be processed. The ServiceDescription will be built from " + "annotations"));
            }
        }
    }

    private URL getWSDLURL(String wsdlLocation) {
        ClassLoader classLoader;
        ClassLoader loader = this.composite.getClassLoader();
        URL url = null;
        if (loader != null) {
            url = this.getResource(wsdlLocation, loader);
        }
        if (url == null && (classLoader = ServiceDescriptionImpl.getContextClassLoader(null)) != loader) {
            url = this.getResource(wsdlLocation, classLoader);
        }
        if (url == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("URL for wsdl file: " + wsdlLocation + " could not be " + "determined by classloader... looking for file reference"));
            }
            url = ServiceDescriptionImpl.createWsdlURL(wsdlLocation);
        }
        if (url == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("URL for wsdl file: " + wsdlLocation + " could not be " + "found as local file reference... prepending file: protocol"));
            }
            if (wsdlLocation.indexOf("/") == 0) {
                wsdlLocation = wsdlLocation.substring(1, wsdlLocation.length());
            }
            url = ServiceDescriptionImpl.createWsdlURL("file:/" + wsdlLocation);
        }
        if (url == null && log.isDebugEnabled()) {
            log.debug((Object)("Unable to obtain URL for WSDL file: " + wsdlLocation + " by using prepended file: protocol"));
        }
        return url;
    }

    private URL getResource(final String wsdlLocation, final ClassLoader loader) {
        return (URL)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return loader.getResource(wsdlLocation);
            }
        });
    }

    public WSDLWrapper getWSDLWrapper() {
        return this.wsdlWrapper;
    }

    public String getWSDLLocation() {
        return this.wsdlURL;
    }

    public WSDLWrapper getGeneratedWsdlWrapper() {
        return this.generatedWsdlWrapper;
    }

    void setAxisConfigContext(ConfigurationContext config) {
        this.configContext = config;
    }

    public ConfigurationContext getAxisConfigContext() {
        if (this.configContext == null) {
            this.configContext = this.getClientConfigurationFactory().getClientConfigurationContext();
        }
        return this.configContext;
    }

    ClientConfigurationFactory getClientConfigurationFactory() {
        if (this.clientConfigFactory == null) {
            this.clientConfigFactory = DescriptionFactory.createClientConfigurationFactory();
        }
        return this.clientConfigFactory;
    }

    public ServiceClient getServiceClient(QName portQName, Object serviceDelegateKey) {
        ServiceClient returnServiceClient = null;
        if (!DescriptionUtils.isEmpty(portQName)) {
            EndpointDescription endpointDesc = this.getEndpointDescription(portQName, serviceDelegateKey);
            if (endpointDesc != null) {
                returnServiceClient = endpointDesc.getServiceClient();
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Could not find portQName: " + portQName + " under ServiceDescription: " + this.toString()));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("PortQName agrument is invalid; it can not be null or an empty string: " + portQName));
        }
        return returnServiceClient;
    }

    public QName getServiceQName() {
        return this.serviceQName;
    }

    void setServiceQName(QName theName) {
        this.serviceQName = theName;
    }

    public JAXWSCatalogManager getCatalogManager() {
        return this.catalogManager;
    }

    public boolean isMTOMEnabled(Object key) {
        return this.getDescriptionBuilderComposite().isMTOMEnabled(key);
    }

    public QName getPreferredPort(Object key) {
        return this.getDescriptionBuilderComposite().getPreferredPort(key);
    }

    public boolean isServerSide() {
        return this.isServerSide;
    }

    HashMap<String, DescriptionBuilderComposite> getDBCMap() {
        return this.dbcMap;
    }

    void setGeneratedWsdlWrapper(WSDL4JWrapper wrapper) {
        this.generatedWsdlWrapper = wrapper;
    }

    void setWsdlWrapper(WSDL4JWrapper wrapper) {
        this.wsdlWrapper = wrapper;
    }

    private void validateDBCLIntegrity() {
        try {
            this.validateIntegrity();
        }
        catch (Exception ex) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"dbclIntegrityErr", (String)ex.toString(), (String)this.composite.toString()), (Throwable)ex);
        }
    }

    void validateIntegrity() {
        Iterator iter = this.composite.getInterfacesList().iterator();
        boolean providerInterfaceValid = false;
        while (iter.hasNext()) {
            String interfaceString = (String)iter.next();
            if (!interfaceString.equals("javax.xml.ws.Provider<javax.xml.transform.Source>") && !interfaceString.equals("javax.xml.ws.Provider<javax.xml.soap.SOAPMessage>") && !interfaceString.equals("javax.xml.ws.Provider<javax.activation.DataSource>") && !interfaceString.equals("javax.xml.ws.Provider<java.lang.String>")) continue;
            providerInterfaceValid = true;
            if (this.composite.getWebServiceProviderAnnot() != null) continue;
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"validateIntegrityErr1", (String)this.composite.getClassName()));
        }
        if (this.composite.getWebServiceAnnot() != null && this.composite.getWebServiceProviderAnnot() != null) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"validateIntegrityErr2", (String)this.composite.getClassName()));
        }
        if (this.composite.getWebServiceProviderAnnot() != null) {
            if (!providerInterfaceValid) {
                throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"validateIntegrityErr3", (String)this.composite.getClassName()));
            }
            if (!this.validateDefaultConstructor()) {
                throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"validateIntegrityErr4", (String)this.composite.getClassName()));
            }
            if (!this.validateInvokeMethod()) {
                throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"validateIntegrityErr5", (String)this.composite.getClassName()));
            }
            this.validateProviderInterfaces();
        } else if (this.composite.getWebServiceAnnot() != null) {
            if (this.composite.getServiceModeAnnot() != null) {
                throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"validateIntegrityErr6", (String)this.composite.getClassName()));
            }
            if (!this.composite.isInterface()) {
                if (!DescriptionUtils.isEmpty(this.composite.getWebServiceAnnot().wsdlLocation()) && this.composite.getWsdlDefinition() == null && this.composite.getWsdlURL() == null) {
                    throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"validateIntegrityErr7", (String)this.composite.getClassName(), (String)this.composite.getWebServiceAnnot().wsdlLocation()));
                }
                if (!DescriptionUtils.isEmpty(this.composite.getWebServiceAnnot().endpointInterface())) {
                    DescriptionBuilderComposite seic = this.dbcMap.get(this.composite.getWebServiceAnnot().endpointInterface());
                    if (seic == null) {
                        throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"validateIntegrityErr8", (String)this.composite.getClassName(), (String)this.composite.getWebServiceAnnot().endpointInterface()));
                    }
                    if (this.composite.getSoapBindingAnnot() != null || this.composite.getWebFaultAnnot() != null || this.composite.getWebServiceClientAnnot() != null) {
                        throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"validateIntegrityErr9", (String)this.composite.getClassName()));
                    }
                    if (!DescriptionUtils.isEmpty(this.composite.getWebServiceAnnot().name())) {
                        throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"validateIntegrityErr10", (String)this.composite.getClassName(), (String)this.composite.getWebServiceAnnot().name()));
                    }
                    this.validateSEI(seic);
                    this.validateImplementation(seic);
                    if (this.webMethodAnnotationsExist()) {
                        throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"validateIntegrityErr11", (String)this.composite.getClassName()));
                    }
                } else {
                    this.checkImplicitSEIAgainstWSDL();
                }
            } else {
                throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"validateIntegrityErr12", (String)this.composite.getClassName()));
            }
            if (this.composite.getSoapBindingAnnot() != null && this.composite.getSoapBindingAnnot().use() == SOAPBinding.Use.ENCODED) {
                throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"validateIntegrityErr13", (String)this.composite.getClassName()));
            }
            this.checkMethodsAgainstWSDL();
        }
    }

    private boolean validateInvokeMethod() {
        boolean validInvokeMethod = false;
        List invokeMethodList = this.composite.getMethodDescriptionComposite("invoke");
        if (invokeMethodList != null && !invokeMethodList.isEmpty()) {
            validInvokeMethod = true;
        }
        return validInvokeMethod;
    }

    private void validateProviderInterfaces() {
        if (this.composite.getServiceModeAnnot() == null || this.composite.getServiceModeAnnot().value() == Service.Mode.PAYLOAD) {
            for (String interfaceString : this.composite.getInterfacesList()) {
                if (!interfaceString.equals("javax.xml.ws.Provider<javax.xml.soap.SOAPMessage>") && !interfaceString.equals("javax.xml.ws.Provider<javax.activation.DataSource>")) continue;
                throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"validatePIsErr1", (String)this.composite.getClassName()));
            }
        } else {
            String bindingType = null;
            if (this.composite.getBindingTypeAnnot() != null) {
                bindingType = this.composite.getBindingTypeAnnot().value();
            }
            for (String interfaceString : this.composite.getInterfacesList()) {
                if (interfaceString.equals("javax.xml.ws.Provider<javax.xml.soap.SOAPMessage>")) {
                    if (DescriptionUtils.isEmpty(bindingType) || bindingType.equals("http://schemas.xmlsoap.org/wsdl/soap/http") || bindingType.equals("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true") || bindingType.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/") || bindingType.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true") || bindingType.equals("http://www.example.org/2006/06/soap/bindings/JMS/") || bindingType.equals("http://http://www.example.org/2006/06/soap/bindings/JMS/?mtom=true") || bindingType.equals("http://www.example.org/2006/06/soap/bindings/JMS/") || bindingType.equals("http://http://www.example.org/2006/06/soap/bindings/JMS/?mtom=true")) continue;
                    throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"validatePIsErr2", (String)this.composite.getClassName()));
                }
                if (!interfaceString.equals("javax.xml.ws.Provider<javax.activation.DataSource>") || !DescriptionUtils.isEmpty(bindingType) && bindingType.equals("http://www.w3.org/2004/08/wsdl/http")) continue;
                throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"validatePIsErr3", (String)this.composite.getClassName()));
            }
        }
    }

    private boolean validateDefaultConstructor() {
        boolean validDefaultCtor = false;
        List constructorList = this.composite.getMethodDescriptionComposite("<init>");
        if (constructorList != null && !constructorList.isEmpty()) {
            for (MethodDescriptionComposite checkCtor : constructorList) {
                List paramList = checkCtor.getParameterDescriptionCompositeList();
                if (paramList != null && !paramList.isEmpty()) continue;
                validDefaultCtor = true;
                break;
            }
        }
        return validDefaultCtor;
    }

    private void validateImplementation(DescriptionBuilderComposite seic) {
        List implMethods = this.composite.getMethodDescriptionsList();
        this.addSuperClassMethods(implMethods, this.composite);
        List seiMethods = seic.getMethodDescriptionsList();
        this.addSuperClassMethods(seiMethods, seic);
        for (MethodDescriptionComposite seiMDC : seiMethods) {
            Iterator implMDCIterator = implMethods.iterator();
            boolean methodImplFound = false;
            while (implMDCIterator.hasNext()) {
                MethodDescriptionComposite implMDC = (MethodDescriptionComposite)implMDCIterator.next();
                if (!seiMDC.getMethodName().equals(implMDC.getMethodName())) continue;
                try {
                    this.validateMethodParameters(seiMDC, implMDC, seic.getClassName());
                    methodImplFound = true;
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (!methodImplFound) continue;
                this.validateMethodExceptions(seiMDC, implMDC, seic.getClassName());
                this.validateMethodReturnValue(seiMDC, implMDC, seic.getClassName());
                break;
            }
            if (methodImplFound) continue;
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"validateImplErr", (String)this.composite.getClassName(), (String)seiMDC.getMethodName(), (String)seic.getClassName()));
        }
    }

    private void validateMethodParameters(MethodDescriptionComposite seiMDC, MethodDescriptionComposite implMDC, String className) {
        List seiPDCList = seiMDC.getParameterDescriptionCompositeList();
        List implPDCList = implMDC.getParameterDescriptionCompositeList();
        if (seiPDCList != null && !seiPDCList.isEmpty() || implPDCList != null && !implPDCList.isEmpty()) {
            if ((seiPDCList == null || seiPDCList.isEmpty()) && implPDCList != null && !implPDCList.isEmpty()) {
                throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"validateMethodParamErr1", (String)implPDCList.toString(), (String)this.composite.getClassName(), (String)seiMDC.getMethodName(), (String)className));
            }
            if (seiPDCList != null && !seiPDCList.isEmpty() && (implPDCList == null || implPDCList.isEmpty())) {
                throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"validateMethodParamErr2", (String)seiPDCList.toString(), (String)this.composite.getClassName(), (String)seiMDC.getMethodName(), (String)className));
            }
            if (seiPDCList.size() != implPDCList.size()) {
                throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"validateMethodParamErr3", (String)new Integer(seiPDCList.size()).toString(), (String)new Integer(implPDCList.size()).toString(), (String)this.composite.getClassName(), (String)seiMDC.getMethodName(), (String)className));
            }
            boolean parametersMatch = true;
            String failingMessage = null;
            for (int paramNumber = 0; paramNumber < seiPDCList.size(); ++paramNumber) {
                String implParamType;
                String seiParamType = ((ParameterDescriptionComposite)seiPDCList.get(paramNumber)).getParameterType();
                if (seiParamType.equals(implParamType = ((ParameterDescriptionComposite)implPDCList.get(paramNumber)).getParameterType())) continue;
                parametersMatch = false;
                String[] inserts = new String[]{String.valueOf(paramNumber), seiParamType, implParamType, this.composite.getClassName(), seiMDC.getMethodName(), className};
                failingMessage = Messages.getMessage((String)"serviceDescriptionImplValidationErr", (String[])inserts);
                break;
            }
            if (!parametersMatch) {
                throw ExceptionFactory.makeWebServiceException(failingMessage);
            }
        }
    }

    private void validateMethodReturnValue(MethodDescriptionComposite seiMDC, MethodDescriptionComposite implMDC, String className) {
        String seiReturnValue = seiMDC.getReturnType();
        String implReturnValue = implMDC.getReturnType();
        if (seiReturnValue != null || implReturnValue != null) {
            if (seiReturnValue == null && implReturnValue != null) {
                throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"validateMethodRVErr1", (String)implReturnValue, (String)this.composite.getClassName(), (String)seiMDC.getMethodName(), (String)className));
            }
            if (seiReturnValue != null && implReturnValue == null) {
                throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"validateMethodRVErr2", (String)seiReturnValue, (String)this.composite.getClassName(), (String)seiMDC.getMethodName(), (String)className));
            }
            if (!seiReturnValue.equals(implReturnValue)) {
                throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"validateMethodRVErr3", (String)seiReturnValue, (String)implReturnValue, (String)this.composite.getClassName(), (String)seiMDC.getMethodName(), (String)className));
            }
        }
    }

    private void validateMethodExceptions(MethodDescriptionComposite seiMDC, MethodDescriptionComposite implMDC, String className) {
        String[] seiExceptions = seiMDC.getExceptions();
        String[] implExceptions = implMDC.getExceptions();
        if (seiExceptions == null) {
            if (implExceptions == null) {
                return;
            }
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"validateMethodExceptionErr1", (String)this.composite.getClassName(), (String)seiMDC.getMethodName(), (String)className));
        }
        if (implExceptions == null) {
            return;
        }
        if (seiExceptions.length < implExceptions.length) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"validateMethodExceptionErr2", (String)new Integer(implExceptions.length).toString(), (String)new Integer(seiExceptions.length).toString(), (String)this.composite.getClassName(), (String)seiMDC.getMethodName(), (String)className));
        }
        if (implExceptions.length > 0) {
            for (String implException : implExceptions) {
                boolean foundIt = false;
                if (seiExceptions.length > 0) {
                    for (String seiException : seiExceptions) {
                        if (!seiException.equals(implException)) continue;
                        foundIt = true;
                        break;
                    }
                }
                if (foundIt) continue;
                throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"validateMethodExceptionErr3", (String)implException, (String)this.composite.getClassName(), (String)seiMDC.getMethodName(), (String)className));
            }
        }
    }

    private void addSuperClassMethods(List<MethodDescriptionComposite> methodList, DescriptionBuilderComposite dbc) {
        DescriptionBuilderComposite superDBC = this.dbcMap.get(dbc.getSuperClassName());
        if (superDBC != null) {
            for (MethodDescriptionComposite mdc : superDBC.getMethodDescriptionsList()) {
                methodList.add(mdc);
            }
            this.addSuperClassMethods(methodList, superDBC);
        }
    }

    private void checkMethodsAgainstWSDL() {
        if (this.webMethodAnnotationsExist()) {
            if (DescriptionUtils.falseExclusionsExist(this.composite)) {
                this.verifyFalseExclusionsWithWSDL();
            } else {
                this.verifyPublicMethodsWithWSDL();
            }
        } else {
            this.verifyPublicMethodsWithWSDL();
        }
    }

    private void checkImplicitSEIAgainstWSDL() {
        if (this.webMethodAnnotationsExist()) {
            if (DescriptionUtils.falseExclusionsExist(this.composite)) {
                this.verifyFalseExclusionsWithWSDL();
            } else {
                this.verifyPublicMethodsWithWSDL();
            }
        } else {
            this.verifyPublicMethodsWithWSDL();
        }
    }

    private void checkSEIAgainstWSDL() {
    }

    private void validateSEI(DescriptionBuilderComposite seic) {
        if (seic.getWebServiceAnnot() == null) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"validateSEIErr1", (String)this.composite.getClassName(), (String)seic.getClassName()));
        }
        if (!seic.getWebServiceAnnot().endpointInterface().equals("")) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"validateSEIErr2", (String)this.composite.getClassName(), (String)seic.getClassName(), (String)seic.getWebServiceAnnot().endpointInterface()));
        }
        if (seic.getSoapBindingAnnot() != null && seic.getSoapBindingAnnot().use() == SOAPBinding.Use.ENCODED) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"validateSEIErr3", (String)seic.getClassName()));
        }
        this.checkSEIAgainstWSDL();
        this.validateMethods(seic.getMethodDescriptionsList());
    }

    private boolean webMethodAnnotationsExist() {
        MethodDescriptionComposite mdc2 = null;
        for (MethodDescriptionComposite mdc2 : this.composite.getMethodDescriptionsList()) {
            if (mdc2.getWebMethodAnnot() == null) continue;
            return true;
        }
        return false;
    }

    private void verifyFalseExclusionsWithWSDL() {
    }

    private void verifyPublicMethodsWithWSDL() {
    }

    private void validateMethods(List<MethodDescriptionComposite> mdcList) {
        if (mdcList != null && !mdcList.isEmpty()) {
            for (MethodDescriptionComposite mdc : mdcList) {
                String returnType = mdc.getReturnType();
                if (returnType != null && (returnType.equals("java.util.concurrent.Future") || returnType.equals("javax.xml.ws.Response"))) {
                    throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"serverSideAsync", (String)mdc.getDeclaringClass(), (String)mdc.getMethodName()));
                }
                if (mdc.getSoapBindingAnnot() == null) continue;
                if (mdc.getSoapBindingAnnot().use() == SOAPBinding.Use.ENCODED) {
                    throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"soapBindingUseEncoded", (String)mdc.getDeclaringClass(), (String)mdc.getMethodName()));
                }
                if (mdc.getSoapBindingAnnot().style() != SOAPBinding.Style.RPC) continue;
                throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"soapBindingStyle", (String)mdc.getDeclaringClass(), (String)mdc.getMethodName()));
            }
        }
    }

    private void validateWSDLOperations() {
    }

    public boolean isWSDLSpecified() {
        boolean wsdlSpecified = false;
        if (this.getWSDLWrapper() != null) {
            wsdlSpecified = this.getWSDLWrapper().getDefinition() != null;
        }
        return wsdlSpecified;
    }

    public HandlerChainsType getHandlerChain() {
        return this.getHandlerChain(null);
    }

    public HandlerChainsType getHandlerChain(Object sparseCompositeKey) {
        DescriptionBuilderComposite sparseComposite;
        if (sparseCompositeKey != null && (sparseComposite = this.composite.getSparseComposite(sparseCompositeKey)) != null && sparseComposite.getHandlerChainsType() != null) {
            return sparseComposite.getHandlerChainsType();
        }
        if (this.handlerChainsType == null) {
            this.getAnnoHandlerChainAnnotation();
            if (this.handlerChainAnnotation != null) {
                ClassLoader classLoader;
                String className;
                InputStream is;
                String handlerFileName = this.handlerChainAnnotation.file();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("EndpointDescriptionImpl.getHandlerChain: fileName: " + handlerFileName + " className: " + this.composite.getClassName()));
                }
                if ((is = DescriptionUtils.openHandlerConfigStream(handlerFileName, className = this.composite.getClassName(), classLoader = this.composite.getClassLoader())) == null) {
                    log.warn((Object)("Unable to load handlers from file: " + handlerFileName));
                } else {
                    this.handlerChainsType = DescriptionUtils.loadHandlerChains(is, ServiceDescriptionImpl.getClassLoader(this.getClass()));
                }
            }
        }
        return this.handlerChainsType;
    }

    public HandlerChain getAnnoHandlerChainAnnotation() {
        Class serviceClass;
        if (this.handlerChainAnnotation == null && (serviceClass = this.composite.getCorrespondingClass()) != null) {
            this.handlerChainAnnotation = (HandlerChain)ServiceDescriptionImpl.getAnnotation(serviceClass, HandlerChain.class);
        }
        return this.handlerChainAnnotation;
    }

    public Definition getWSDLDefinition() {
        Definition defn = null;
        if (this.getWSDLWrapper() != null) {
            defn = this.getWSDLWrapper().getDefinition();
        }
        return defn;
    }

    public Definition getWSDLGeneratedDefinition() {
        Definition defn = null;
        if (this.getGeneratedWsdlWrapper() != null) {
            defn = this.getGeneratedWsdlWrapper().getDefinition();
        }
        return defn;
    }

    public javax.wsdl.Service getWSDLService() {
        javax.wsdl.Service returnWSDLService = null;
        Definition defn = this.getWSDLDefinition();
        if (defn != null) {
            returnWSDLService = defn.getService(this.getServiceQName());
        }
        return returnWSDLService;
    }

    public Map getWSDLPorts() {
        javax.wsdl.Service wsdlService = this.getWSDLService();
        if (wsdlService != null) {
            return wsdlService.getPorts();
        }
        return null;
    }

    public List<QName> getPorts(Object serviceDelegateKey) {
        Collection<EndpointDescriptionImpl> dynamicEndpointDescs;
        ArrayList<QName> portList = new ArrayList<QName>();
        Map wsdlPortsMap = this.getWSDLPorts();
        if (wsdlPortsMap != null) {
            Iterator wsdlPortsIterator = wsdlPortsMap.values().iterator();
            String serviceTNS = this.getServiceQName().getNamespaceURI();
            Port wsdlPort = null;
            while (wsdlPortsIterator.hasNext()) {
                wsdlPort = (Port)wsdlPortsIterator.next();
                String wsdlPortLocalPart = wsdlPort.getName();
                portList.add(new QName(serviceTNS, wsdlPortLocalPart));
            }
        }
        Collection<EndpointDescription> endpointDescs = this.getEndpointDescriptions_AsCollection();
        for (EndpointDescription endpointDesc : endpointDescs) {
            QName endpointPortQName = endpointDesc.getPortQName();
            if (portList.contains(endpointPortQName)) continue;
            portList.add(endpointPortQName);
        }
        if (serviceDelegateKey != null && (dynamicEndpointDescs = this.getDynamicEndpointDescriptions_AsCollection(serviceDelegateKey)) != null) {
            for (EndpointDescriptionImpl dynamicEndpointDesc : dynamicEndpointDescs) {
                QName endpointPortQName = dynamicEndpointDesc.getPortQName();
                if (portList.contains(endpointPortQName)) continue;
                portList.add(endpointPortQName);
            }
        }
        return portList;
    }

    public List<Port> getWSDLPortsUsingPortType(QName portTypeQN) {
        Map wsdlPortMap;
        ArrayList<Port> portList = new ArrayList<Port>();
        if (!DescriptionUtils.isEmpty(portTypeQN) && (wsdlPortMap = this.getWSDLPorts()) != null && !wsdlPortMap.isEmpty()) {
            for (Object mapElement : wsdlPortMap.values()) {
                Port wsdlPort = (Port)mapElement;
                PortType wsdlPortType = wsdlPort.getBinding().getPortType();
                QName wsdlPortTypeQN = wsdlPortType.getQName();
                if (!portTypeQN.equals(wsdlPortTypeQN)) continue;
                portList.add(wsdlPort);
            }
        }
        return portList;
    }

    public List<Port> getWSDLPortsUsingSOAPAddress(List<Port> wsdlPorts) {
        ArrayList<Port> portsUsingAddress = new ArrayList<Port>();
        if (wsdlPorts != null && !wsdlPorts.isEmpty()) {
            for (Port checkPort : wsdlPorts) {
                List extensibilityElementList = checkPort.getExtensibilityElements();
                for (Object checkElement : extensibilityElementList) {
                    if (!EndpointDescriptionImpl.isSOAPAddressElement((ExtensibilityElement)checkElement)) continue;
                    portsUsingAddress.add(checkPort);
                }
            }
        }
        return portsUsingAddress;
    }

    public ServiceRuntimeDescription getServiceRuntimeDesc(String name) {
        return this.runtimeDescMap.get(name);
    }

    public void setServiceRuntimeDesc(ServiceRuntimeDescription srd) {
        this.runtimeDescMap.put(srd.getKey(), srd);
    }

    private void resetServiceRuntimeDescription() {
        this.runtimeDescMap.clear();
    }

    protected String getServiceClassName() {
        return this.composite.getClassName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EndpointDescriptionImpl getDynamicEndpointDescriptionImpl(QName portQName, Object key) {
        Map<QName, EndpointDescriptionImpl> innerMap = null;
        Map<Object, Map<QName, EndpointDescriptionImpl>> map = this.dynamicEndpointDescriptions;
        synchronized (map) {
            innerMap = this.dynamicEndpointDescriptions.get(key);
            if (innerMap != null) {
                return innerMap.get(portQName);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDynamicEndpointDescriptionImpl(EndpointDescriptionImpl endpointDescriptionImpl, Object key) {
        Map<QName, EndpointDescriptionImpl> innerMap = null;
        Map<Object, Map<QName, EndpointDescriptionImpl>> map = this.dynamicEndpointDescriptions;
        synchronized (map) {
            innerMap = this.dynamicEndpointDescriptions.get(key);
            if (innerMap == null) {
                innerMap = new HashMap<QName, EndpointDescriptionImpl>();
                this.dynamicEndpointDescriptions.put(key, innerMap);
            }
            innerMap.put(endpointDescriptionImpl.getPortQName(), endpointDescriptionImpl);
        }
    }

    public String toString() {
        String newline = "\n";
        String sameline = "; ";
        boolean dumpWSDLContents = false;
        StringBuffer string = new StringBuffer();
        try {
            string.append(super.toString());
            string.append("\n");
            string.append("ServiceQName: " + this.getServiceQName());
            string.append("\n");
            string.append("isWSDLSpecified: " + this.isWSDLSpecified());
            string.append("; ");
            string.append("WSDL Location: " + this.getWSDLLocation());
            string.append("\n");
            if (dumpWSDLContents) {
                string.append("WSDL Definition: " + this.getWSDLDefinition());
                string.append("\n");
                string.append("Generated WSDL Definition: " + this.getWSDLGeneratedDefinition());
            } else {
                string.append("WSDL Definition available: " + (this.getWSDLDefinition() != null));
                string.append("; ");
                string.append("Generated WSDL Definition available: " + (this.getWSDLGeneratedDefinition() != null));
            }
            string.append("\n");
            List<QName> ports = this.getPorts(null);
            string.append("Number of defined ports: " + ports.size());
            string.append("\n");
            string.append("Port QNames: ");
            for (QName port : ports) {
                string.append(port + "; ");
            }
            string.append("\n");
            Collection<EndpointDescription> endpointDescs = this.getEndpointDescriptions_AsCollection();
            if (endpointDescs == null) {
                string.append("EndpointDescription array is null");
            } else {
                string.append("Number of EndpointDescrptions: " + endpointDescs.size());
                string.append("\n");
                for (EndpointDescription endpointDesc : endpointDescs) {
                    string.append(endpointDesc.toString());
                    string.append("\n");
                }
            }
            string.append("RuntimeDescriptions:" + this.runtimeDescMap.size());
            string.append("\n");
            for (ServiceRuntimeDescription runtimeDesc : this.runtimeDescMap.values()) {
                string.append(runtimeDesc.toString());
                string.append("\n");
            }
        }
        catch (Throwable t) {
            string.append("\n");
            string.append("Complete debug information not currently available for ServiceDescription");
            return string.toString();
        }
        return string.toString();
    }

    private static Annotation getAnnotation(final Class cls, final Class annotation) {
        return (Annotation)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return cls.getAnnotation(annotation);
            }
        });
    }

    private static ClassLoader getContextClassLoader(final ClassLoader classLoader) {
        ClassLoader cl;
        try {
            cl = (ClassLoader)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return classLoader != null ? classLoader : Thread.currentThread().getContextClassLoader();
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception thrown from AccessController: " + e.getMessage()), (Throwable)e);
            }
            throw ExceptionFactory.makeWebServiceException((Throwable)e.getException());
        }
        return cl;
    }

    private static ClassLoader getClassLoader(final Class cls) {
        ClassLoader cl = null;
        try {
            cl = (ClassLoader)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return cls.getClassLoader();
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception thrown from AccessController: " + e));
            }
            throw ExceptionFactory.makeWebServiceException((Throwable)e.getException());
        }
        return cl;
    }

    public List<Class> getHandlerChainClasses(PortInfo portinfo) {
        return this.handlerClassesMap.get(portinfo);
    }

    public void setHandlerChainClasses(PortInfo portinfo, List<Class> handlerClasses) {
        this.handlerClassesMap.put(portinfo, handlerClasses);
    }
}

