/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.metadata.ws.impl.xml.parsing;

import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.namespace.QName;
import org.ow2.util.ee.metadata.common.impl.xml.parsing.CommonDeploymentDescLoader;
import org.ow2.util.ee.metadata.common.impl.xml.parsing.ParsingException;
import org.ow2.util.ee.metadata.ws.impl.xml.parsing.WebservicesEntityResolver;
import org.ow2.util.ee.metadata.ws.impl.xml.struct.PortComponent;
import org.ow2.util.ee.metadata.ws.impl.xml.struct.ServiceImplBean;
import org.ow2.util.ee.metadata.ws.impl.xml.struct.WebserviceDescription;
import org.ow2.util.ee.metadata.ws.impl.xml.struct.Webservices;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.xml.DocumentParser;
import org.ow2.util.xml.DocumentParserException;
import org.ow2.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;

public class WebservicesDeploymentDescLoader
extends CommonDeploymentDescLoader {
    private static Log logger = LogFactory.getLog(WebservicesDeploymentDescLoader.class);
    private static Map<String, String> bindingAliases = new Hashtable<String, String>();
    private Webservices webservices = new Webservices();

    private WebservicesDeploymentDescLoader(URL url) {
        super(url);
    }

    public static Webservices loadDeploymentDescriptor(URL url) throws ParsingException {
        logger.debug((Object)"Analyzing url {0}", new Object[]{url});
        WebservicesDeploymentDescLoader wsLoader = new WebservicesDeploymentDescLoader(url);
        wsLoader.parse();
        return wsLoader.getWebservices();
    }

    public void parse() throws ParsingException {
        Document document = null;
        try {
            document = DocumentParser.getDocument((URL)this.getURL(), (boolean)WebservicesDeploymentDescLoader.isValidating(), (EntityResolver)((Object)new WebservicesEntityResolver()));
        }
        catch (DocumentParserException e) {
            throw new ParsingException("Cannot parse the url", (Throwable)e);
        }
        Element webservicesRootElement = document.getDocumentElement();
        this.defineXMLNS(webservicesRootElement);
        String version = webservicesRootElement.getAttribute("version");
        this.webservices.setVersion(version);
        NodeList wsDescriptionsList = webservicesRootElement.getElementsByTagNameNS(this.getXMLNS(), "webservice-description");
        for (int i = 0; i < wsDescriptionsList.getLength(); ++i) {
            Element wsDescriptionElement = (Element)wsDescriptionsList.item(i);
            WebserviceDescription wd = new WebserviceDescription();
            this.webservices.addWebserviceDescription(wd);
            this.analyzeWebserviceDescription(wsDescriptionElement, wd);
        }
    }

    private void analyzeWebserviceDescription(Element wsDescriptionElement, WebserviceDescription webserviceDescription) {
        String name = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)wsDescriptionElement, (String)"webservice-description-name");
        webserviceDescription.setName(name);
        String wsdlFile = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)wsDescriptionElement, (String)"wsdl-file");
        webserviceDescription.setWsdlFile(wsdlFile);
        NodeList portComponentList = wsDescriptionElement.getElementsByTagNameNS(this.getXMLNS(), "port-component");
        for (int i = 0; i < portComponentList.getLength(); ++i) {
            Element portComponentElement = (Element)portComponentList.item(i);
            PortComponent pc = new PortComponent(webserviceDescription);
            webserviceDescription.addPortComponent(pc);
            this.analyzePortComponent(portComponentElement, pc);
        }
    }

    private void analyzePortComponent(Element portComponentElement, PortComponent portComponent) {
        String protocolBinding;
        String enableMtom;
        NodeList wsdlPortNodes;
        String name = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)portComponentElement, (String)"port-component-name");
        portComponent.setName(name);
        NodeList wsdlServiceNodes = portComponentElement.getElementsByTagNameNS(this.getXMLNS(), "wsdl-service");
        if (wsdlServiceNodes.getLength() == 1) {
            Element wsdlServiceNode = (Element)wsdlServiceNodes.item(0);
            QName wsdlService = XMLUtils.getValueAsQName((Element)wsdlServiceNode);
            portComponent.setWsdlService(wsdlService);
        }
        if ((wsdlPortNodes = portComponentElement.getElementsByTagNameNS(this.getXMLNS(), "wsdl-port")).getLength() == 1) {
            Element wsdlPortNode = (Element)wsdlPortNodes.item(0);
            QName wsdlPort = XMLUtils.getValueAsQName((Element)wsdlPortNode);
            portComponent.setWsdlPort(wsdlPort);
        }
        if ("true".equals(enableMtom = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)portComponentElement, (String)"enable-mtom"))) {
            portComponent.setMTOMEnabled(true);
        }
        if ((protocolBinding = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)portComponentElement, (String)"protocol-binding")) != null) {
            String aliased = bindingAliases.get(protocolBinding);
            if (aliased == null) {
                aliased = protocolBinding;
            }
            portComponent.setProtocolBinding(aliased);
        }
        String sei = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)portComponentElement, (String)"service-endpoint-interface");
        portComponent.setServiceEndpointInterface(sei);
        NodeList sibNodes = portComponentElement.getElementsByTagNameNS(this.getXMLNS(), "service-impl-bean");
        if (sibNodes.getLength() == 1) {
            Element sibNode = (Element)sibNodes.item(0);
            ServiceImplBean sib = new ServiceImplBean();
            portComponent.setServiceImplBean(sib);
            this.analyzeServiceImplBean(sibNode, sib);
        }
    }

    private void analyzeServiceImplBean(Element sibElement, ServiceImplBean sib) {
        String servletLink = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)sibElement, (String)"servlet-link");
        sib.setServletLink(servletLink);
        String ejbLink = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)sibElement, (String)"ejb-link");
        sib.setEjbLink(ejbLink);
    }

    public Webservices getWebservices() {
        return this.webservices;
    }

    static {
        bindingAliases.put("##SOAP11_HTTP", "http://schemas.xmlsoap.org/wsdl/soap/http");
        bindingAliases.put("##SOAP11_HTTP_MTOM", "http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true");
        bindingAliases.put("##SOAP12_HTTP", "http://www.w3.org/2003/05/soap/bindings/HTTP/");
        bindingAliases.put("##SOAP12_HTTP_MTOM", "http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true");
        bindingAliases.put("##XML_HTTP", "http://www.w3.org/2004/08/wsdl/http");
    }
}

