/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.jsse;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.security.cert.X509Certificate;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.SSLSupport;

class JSSESupport
implements SSLSupport {
    private static Log log = LogFactory.getLog(JSSESupport.class);
    protected SSLSocket ssl;
    protected SSLSession session;
    Listener listener = new Listener();

    JSSESupport(SSLSocket sock) {
        this.ssl = sock;
        this.session = sock.getSession();
        sock.addHandshakeCompletedListener(this.listener);
    }

    JSSESupport(SSLSession session) {
        this.session = session;
    }

    public String getCipherSuite() throws IOException {
        if (this.session == null) {
            return null;
        }
        return this.session.getCipherSuite();
    }

    public Object[] getPeerCertificateChain() throws IOException {
        return this.getPeerCertificateChain(false);
    }

    protected java.security.cert.X509Certificate[] getX509Certificates(SSLSession session) throws IOException {
        Certificate[] certs = null;
        try {
            certs = session.getPeerCertificates();
        }
        catch (Throwable t) {
            log.debug("Error getting client certs", t);
            return null;
        }
        if (certs == null) {
            return null;
        }
        java.security.cert.X509Certificate[] x509Certs = new java.security.cert.X509Certificate[certs.length];
        for (int i = 0; i < certs.length; ++i) {
            if (certs[i] instanceof java.security.cert.X509Certificate) {
                x509Certs[i] = (java.security.cert.X509Certificate)certs[i];
            } else {
                try {
                    byte[] buffer = certs[i].getEncoded();
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    ByteArrayInputStream stream = new ByteArrayInputStream(buffer);
                    x509Certs[i] = (java.security.cert.X509Certificate)cf.generateCertificate(stream);
                }
                catch (Exception ex) {
                    log.info("Error translating cert " + certs[i], ex);
                    return null;
                }
            }
            if (!log.isTraceEnabled()) continue;
            log.trace("Cert #" + i + " = " + x509Certs[i]);
        }
        if (x509Certs.length < 1) {
            return null;
        }
        return x509Certs;
    }

    public Object[] getPeerCertificateChain(boolean force) throws IOException {
        if (this.session == null) {
            return null;
        }
        X509Certificate[] jsseCerts = null;
        try {
            jsseCerts = this.session.getPeerCertificateChain();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (jsseCerts == null) {
            jsseCerts = new X509Certificate[]{};
        }
        if (jsseCerts.length <= 0 && force) {
            this.session.invalidate();
            this.handShake();
            this.session = this.ssl.getSession();
        }
        return this.getX509Certificates(this.session);
    }

    protected void handShake() throws IOException {
        if (this.ssl.getWantClientAuth()) {
            log.debug("No client cert sent for want");
        } else {
            this.ssl.setNeedClientAuth(true);
        }
        InputStream in = this.ssl.getInputStream();
        int oldTimeout = this.ssl.getSoTimeout();
        this.ssl.setSoTimeout(1000);
        byte[] b = new byte[]{};
        this.listener.reset();
        this.ssl.startHandshake();
        int maxTries = 60;
        for (int i = 0; i < maxTries; ++i) {
            if (log.isTraceEnabled()) {
                log.trace("Reading for try #" + i);
            }
            try {
                int x = in.read(b);
            }
            catch (SSLException sslex) {
                log.info("SSL Error getting client Certs", sslex);
                throw sslex;
            }
            catch (IOException e) {
                // empty catch block
            }
            if (this.listener.completed) break;
        }
        this.ssl.setSoTimeout(oldTimeout);
        if (!this.listener.completed) {
            throw new SocketException("SSL Cert handshake timeout");
        }
    }

    public Integer getKeySize() throws IOException {
        SSLSupport.CipherData[] c_aux = ciphers;
        if (this.session == null) {
            return null;
        }
        Integer keySize = (Integer)this.session.getValue("javax.servlet.request.key_size");
        if (keySize == null) {
            int size = 0;
            String cipherSuite = this.session.getCipherSuite();
            for (int i = 0; i < c_aux.length; ++i) {
                if (cipherSuite.indexOf(c_aux[i].phrase) < 0) continue;
                size = c_aux[i].keySize;
                break;
            }
            keySize = new Integer(size);
            this.session.putValue("javax.servlet.request.key_size", keySize);
        }
        return keySize;
    }

    public String getSessionId() throws IOException {
        if (this.session == null) {
            return null;
        }
        byte[] ssl_session = this.session.getId();
        if (ssl_session == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer("");
        for (int x = 0; x < ssl_session.length; ++x) {
            String digit = Integer.toHexString(ssl_session[x]);
            if (digit.length() < 2) {
                buf.append('0');
            }
            if (digit.length() > 2) {
                digit = digit.substring(digit.length() - 2);
            }
            buf.append(digit);
        }
        return buf.toString();
    }

    private static class Listener
    implements HandshakeCompletedListener {
        volatile boolean completed = false;

        private Listener() {
        }

        public void handshakeCompleted(HandshakeCompletedEvent event) {
            this.completed = true;
        }

        void reset() {
            this.completed = false;
        }
    }
}

