/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.clusterd.lib;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.deployment.clusterd.ClusterDaemonConfiguration;
import org.ow2.jonas.deployment.clusterd.ClusterDaemonConfigurationException;
import org.ow2.jonas.deployment.clusterd.ClusterDaemonSchemas;
import org.ow2.jonas.deployment.clusterd.rules.ClusterDaemonRuleSet;
import org.ow2.jonas.deployment.clusterd.xml.ClusterDaemon;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.common.digester.JDigester;
import org.ow2.jonas.deployment.common.lib.AbsDeploymentDescManager;
import org.ow2.jonas.lib.util.Log;

public class ClusterDaemonConfigurationManager
extends AbsDeploymentDescManager {
    public static final String CLUSTERD_FILE_NAME = "clusterd.xml";
    private static JDigester clusterDaemonDigester = null;
    private static ClusterDaemonRuleSet clusterDaemonRuleSet = new ClusterDaemonRuleSet();
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.cluster.daemon");
    private static boolean parsingWithValidation = true;

    private ClusterDaemonConfigurationManager() {
    }

    public static ClusterDaemonConfiguration getClusterDaemonConfiguration(String clusterDaemonFileName, ClassLoader classLoaderForCls) throws ClusterDaemonConfigurationException {
        InputStream is = null;
        String fileName = null;
        fileName = clusterDaemonFileName == null ? System.getProperty("jonas.base") + File.separator + "conf" + File.separator + CLUSTERD_FILE_NAME : clusterDaemonFileName;
        File clusterDaemonFile = new File(fileName);
        if (!clusterDaemonFile.exists()) {
            is = classLoaderForCls.getResourceAsStream(CLUSTERD_FILE_NAME);
            if (is == null) {
                throw new ClusterDaemonConfigurationException("Cannot read the " + fileName + " and " + CLUSTERD_FILE_NAME + " is not accessible in the classpath");
            }
        } else {
            try {
                is = new FileInputStream(clusterDaemonFile);
            }
            catch (Exception e) {
                throw new ClusterDaemonConfigurationException("Cannot read the clusterd.xml", e);
            }
        }
        ClusterDaemon clusterDaemon = ClusterDaemonConfigurationManager.loadClusterDaemon(new InputStreamReader(is), CLUSTERD_FILE_NAME);
        try {
            is.close();
        }
        catch (IOException e) {
            logger.log(BasicLevel.WARN, (Object)"Cannot close InputStream for clusterd.xml");
        }
        ClusterDaemonConfiguration clusterDaemonConfiguration = new ClusterDaemonConfiguration(clusterDaemon);
        return clusterDaemonConfiguration;
    }

    public static String getClusterDaemonFileName(String clusterDaemonFileName) {
        String fileName = null;
        fileName = clusterDaemonFileName == null ? System.getProperty("jonas.base") + File.separator + "conf" + File.separator + CLUSTERD_FILE_NAME : clusterDaemonFileName;
        return fileName;
    }

    public static ClusterDaemon loadClusterDaemon(Reader reader, String fileName) throws ClusterDaemonConfigurationException {
        ClusterDaemon clusterDaemon = new ClusterDaemon();
        if (clusterDaemonDigester == null) {
            try {
                clusterDaemonDigester = new JDigester(clusterDaemonRuleSet, ClusterDaemonConfigurationManager.getParsingWithValidation(), true, null, new ClusterDaemonSchemas());
            }
            catch (DeploymentDescException e) {
                throw new ClusterDaemonConfigurationException(e);
            }
        }
        try {
            clusterDaemonDigester.parse(reader, fileName, clusterDaemon);
        }
        catch (DeploymentDescException e) {
            throw new ClusterDaemonConfigurationException(e);
        }
        finally {
            clusterDaemonDigester.push(null);
        }
        return clusterDaemon;
    }

    public static boolean getParsingWithValidation() {
        return parsingWithValidation;
    }

    public static void setParsingWithValidation(boolean validation) {
        parsingWithValidation = validation;
    }
}

