/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.deployer;

import aQute.bnd.service.RepositoryPlugin;
import aQute.lib.osgi.Jar;
import aQute.lib.osgi.Plugin;
import aQute.lib.osgi.Processor;
import aQute.libg.reporter.Reporter;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectRepo
implements Plugin,
RepositoryPlugin {
    File[] EMPTY_FILES = new File[0];
    File workspace;
    String classes = "bin";
    Reporter reporter;

    @Override
    public void setProperties(Map<String, String> map) {
        String workspace = map.get("workspace");
        if (workspace == null) {
            throw new IllegalArgumentException("workspace muse be set on a ProjectRepo plugin");
        }
        this.workspace = Processor.getFile(new File(""), workspace);
        if (!this.workspace.isDirectory()) {
            throw new IllegalArgumentException("Workspace is not a valid directory " + workspace);
        }
    }

    @Override
    public File[] get(String bsn, String versionRange) {
        if (versionRange == null || !versionRange.equals("project")) {
            return null;
        }
        File project = Processor.getFile(this.workspace, bsn);
        if (!project.isDirectory()) {
            return null;
        }
        File classes = Processor.getFile(project, this.classes);
        if (!classes.isDirectory()) {
            throw new IllegalArgumentException("Found project " + bsn + " but can not find classes directory, looking for " + classes);
        }
        return new File[]{classes};
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public File put(Jar jar) throws Exception {
        throw new IllegalArgumentException("A Project Repo can not write");
    }

    @Override
    public void setReporter(Reporter reporter) {
        this.reporter = reporter;
    }

    @Override
    public List<String> list(String regex) {
        return Arrays.asList(this.workspace.list());
    }
}

