/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.management.extensions.base;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.TabularData;
import org.ow2.jonas.lib.management.domain.DomainMonitor;
import org.ow2.jonas.lib.management.extensions.base.ManagementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JonasManagementRepr {
    private static DomainMonitor dm = DomainMonitor.getInstance();
    private static Hashtable<String, MBeanServerConnection> serverConnections = new Hashtable();

    private static MBeanServerConnection getServerConnection(String serverName) throws ManagementException {
        MBeanServerConnection conn = serverConnections.get(serverName);
        if (conn == null) {
            conn = dm.getConnection(serverName);
            if (conn == null) {
                throw new ManagementException("Can't manage server " + serverName + " as couldn't get connection");
            }
            serverConnections.put(serverName, conn);
        }
        return conn;
    }

    public static boolean isRegistered(ObjectName on, String serverName) throws ManagementException {
        MBeanServerConnection repr = JonasManagementRepr.getServerConnection(serverName);
        try {
            return repr.isRegistered(on);
        }
        catch (IOException e) {
            serverConnections.remove(serverName);
            throw new ManagementException("Error calling isRegistered", e);
        }
    }

    public static Object getAttribute(ObjectName on, String attribute, String serverName) throws ManagementException {
        MBeanServerConnection repr = JonasManagementRepr.getServerConnection(serverName);
        try {
            return repr.getAttribute(on, attribute);
        }
        catch (IOException ioe) {
            serverConnections.remove(serverName);
            throw new ManagementException("Error getting attribute: " + attribute, ioe);
        }
        catch (Exception e) {
            throw new ManagementException("Error getting attribute: " + attribute, e);
        }
    }

    public static AttributeList getAttributes(ObjectName on, String[] attributes, String serverName) throws ManagementException {
        MBeanServerConnection repr = JonasManagementRepr.getServerConnection(serverName);
        try {
            return repr.getAttributes(on, attributes);
        }
        catch (IOException ioe) {
            serverConnections.remove(serverName);
            throw new ManagementException("Error getting attributes, first attribute is " + attributes[0], ioe);
        }
        catch (Exception e) {
            throw new ManagementException("Error getting attributes, first attribute is " + attributes[0], e);
        }
    }

    public static void setAttribute(ObjectName on, String attribute, Object value, String serverName) throws ManagementException {
        MBeanServerConnection repr = JonasManagementRepr.getServerConnection(serverName);
        try {
            repr.setAttribute(on, new Attribute(attribute, value));
        }
        catch (IOException ioe) {
            serverConnections.remove(serverName);
            throw new ManagementException("Error setting attribute: " + attribute, ioe);
        }
        catch (Exception e) {
            throw new ManagementException("Error setting attribute: " + attribute, e);
        }
    }

    public static void setAttributes(ObjectName on, AttributeList attributes, String serverName) throws ManagementException {
        MBeanServerConnection repr = JonasManagementRepr.getServerConnection(serverName);
        try {
            repr.setAttributes(on, attributes);
        }
        catch (IOException ioe) {
            serverConnections.remove(serverName);
            throw new ManagementException("Error setting attributes, first attribute is " + attributes.get(0), ioe);
        }
        catch (Exception e) {
            throw new ManagementException("Error setting attributes, first attribute is " + attributes.get(0), e);
        }
    }

    public static Object invoke(ObjectName on, String operation, Object[] param, String[] signature, String serverName) throws ManagementException {
        MBeanServerConnection repr = JonasManagementRepr.getServerConnection(serverName);
        try {
            return repr.invoke(on, operation, param, signature);
        }
        catch (IOException ioe) {
            serverConnections.remove(serverName);
            throw new ManagementException("Error while invoking opeartion: ", ioe);
        }
        catch (Exception e) {
            String message = e.getMessage();
            message = message + " - " + e.getCause().getMessage();
            Exception exc = null;
            if (e instanceof MBeanException || e instanceof ReflectionException || e instanceof RuntimeMBeanException || e instanceof RuntimeOperationsException || e instanceof RuntimeErrorException) {
                Exception targetExc = null;
                if (e instanceof MBeanException) {
                    targetExc = ((MBeanException)e).getTargetException();
                } else if (e instanceof ReflectionException) {
                    targetExc = ((ReflectionException)e).getTargetException();
                } else if (e instanceof RuntimeMBeanException) {
                    targetExc = ((RuntimeMBeanException)e).getTargetException();
                } else if (e instanceof RuntimeOperationsException) {
                    targetExc = ((RuntimeOperationsException)e).getTargetException();
                } else if (e instanceof RuntimeErrorException) {
                    Error atargetExc = ((RuntimeErrorException)e).getTargetError();
                    targetExc = new Exception(atargetExc.getMessage());
                }
                exc = targetExc;
            } else {
                exc = e;
            }
            throw new ManagementException(message, exc);
        }
    }

    public static Set queryNames(ObjectName on, String serverName) throws ManagementException {
        MBeanServerConnection repr = JonasManagementRepr.getServerConnection(serverName);
        try {
            return repr.queryNames(on, null);
        }
        catch (IOException e) {
            serverConnections.remove(serverName);
            throw new ManagementException("Error while getting MBeans names: ", e);
        }
    }

    public static MBeanInfo getMBeanInfo(ObjectName on, String serverName) throws ManagementException {
        MBeanServerConnection repr = JonasManagementRepr.getServerConnection(serverName);
        try {
            return repr.getMBeanInfo(on);
        }
        catch (IOException ioe) {
            serverConnections.remove(serverName);
            throw new ManagementException("Error while getting MBean info: ", ioe);
        }
        catch (Exception e) {
            throw new ManagementException("Error while getting MBean info: ", e);
        }
    }

    public static void unregisterMBean(ObjectName on, String serverName) throws ManagementException {
        MBeanServerConnection repr = JonasManagementRepr.getServerConnection(serverName);
        try {
            repr.unregisterMBean(on);
        }
        catch (IOException ioe) {
            serverConnections.remove(serverName);
            throw new ManagementException("Error while unregistering MBean: ", ioe);
        }
        catch (Exception e) {
            throw new ManagementException("Error while unregistering MBean: ", e);
        }
    }

    public static List<List<String>> getServerThreadsInformation(String serverName, String domainName) throws Exception {
        MBeanServerConnection conn = serverConnections.get(serverName);
        if (conn == null) {
            throw new ManagementException("Can't manage server " + serverName + " as couldn't get connection");
        }
        ObjectName on = null;
        String operation = "getThreadStackDumpList";
        String server = domainName + ":j2eeType=J2EEServer,name=" + serverName;
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        try {
            on = new ObjectName(server);
            TabularData tabData = (TabularData)conn.invoke(on, operation, null, null);
            CompositeDataSupport cmpData = null;
            for (Object ob : tabData.values()) {
                cmpData = (CompositeDataSupport)ob;
                ArrayList<String> subResult = new ArrayList<String>();
                subResult.add(cmpData.get("id").toString());
                subResult.add(cmpData.get("name").toString());
                subResult.add(cmpData.get("priority").toString());
                subResult.add(cmpData.get("is alive").toString());
                subResult.add(cmpData.get("is interrupted").toString());
                subResult.add(cmpData.get("state").toString());
                subResult.add(cmpData.get("is daemon").toString());
                subResult.add(cmpData.get("stackTrace").toString());
                result.add(subResult);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("Could not invoke method \"" + operation + "\" on server \"" + server + "\"");
        }
        return result;
    }
}

