/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.management.extensions.manager;

import java.io.Serializable;
import java.util.List;
import org.ow2.jonas.lib.management.extensions.base.JonasManagementRepr;
import org.ow2.jonas.lib.management.extensions.cluster.ClusterManagement;
import org.ow2.jonas.lib.management.extensions.clusterdaemon.ClusterdaemonManagement;
import org.ow2.jonas.lib.management.extensions.domain.DomainManagement;
import org.ow2.jonas.lib.management.extensions.server.ServerManagement;
import org.ow2.jonas.management.extensions.cluster.api.ICluster;
import org.ow2.jonas.management.extensions.clusterdaemon.api.IClusterdaemon;
import org.ow2.jonas.management.extensions.domain.api.IDomain;
import org.ow2.jonas.management.extensions.server.api.IServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ManagementEntryPoint
implements IDomain,
IServer,
IClusterdaemon,
ICluster,
Serializable {
    private static final long serialVersionUID = 1L;
    private static ManagementEntryPoint unique = null;
    private static IDomain domainManagement = null;
    private static IServer serverManagement = null;
    private static IClusterdaemon clusterdaemonManagement = null;
    private static ICluster clusterManagement = null;

    public static synchronized ManagementEntryPoint getInstance() {
        if (unique == null) {
            unique = new ManagementEntryPoint();
        }
        return unique;
    }

    private ManagementEntryPoint() {
        domainManagement = new DomainManagement();
        serverManagement = new ServerManagement();
        clusterdaemonManagement = new ClusterdaemonManagement();
        clusterManagement = new ClusterManagement();
    }

    public String getDomainName() {
        return domainManagement.getDomainName();
    }

    public String getServerName() {
        return domainManagement.getServerName();
    }

    public String getServerHost() {
        return domainManagement.getServerHost();
    }

    public String getServerPort() {
        return domainManagement.getServerPort();
    }

    public boolean isMaster(String serverName) {
        return domainManagement.isMaster(serverName);
    }

    public boolean isMaster() {
        return domainManagement.isMaster();
    }

    public String[] getServerNames() {
        return domainManagement.getServerNames();
    }

    public String[] getClustersNames() {
        return domainManagement.getClustersNames();
    }

    public String[] getClusterDaemonNames() {
        return domainManagement.getClusterDaemonNames();
    }

    public String[] getClusters() {
        return domainManagement.getClusters();
    }

    public String[] getclusterDaemons() {
        return domainManagement.getclusterDaemons();
    }

    public void addServer(String serverName, String serverURL, String userName, String password, String clusterdaemon) {
        domainManagement.addServer(serverName, serverURL, userName, password, clusterdaemon);
    }

    public void removeServers(String[] serversToRemove) {
        domainManagement.removeServers(serversToRemove);
    }

    public void addCluster(String clusterName) {
        domainManagement.addCluster(clusterName);
    }

    public String getServerState(String serverName) {
        return domainManagement.getServerState(serverName);
    }

    public void startServer(String serverName) {
        domainManagement.startServer(serverName);
    }

    public void stopServer(String serverName) {
        domainManagement.stopServer(serverName);
    }

    public void haltServer(String serverName) {
        domainManagement.haltServer(serverName);
    }

    public String getServerClusterdaemon(String serverName) {
        return domainManagement.getServerClusterdaemon(serverName);
    }

    public String getClusterState(String clusterName) {
        return domainManagement.getClusterState(clusterName);
    }

    public String getClusterType(String clusterName) {
        return domainManagement.getClusterType(clusterName);
    }

    public String[] getServerNames(String clusterName) {
        return domainManagement.getServerNames(clusterName);
    }

    public long getCurrentUsedMemory(String server) {
        return serverManagement.getCurrentUsedMemory(server);
    }

    public String getServerVersion(String server) {
        return serverManagement.getServerVersion(server);
    }

    public int getAllThreadsCount(String server) {
        return serverManagement.getAllThreadsCount(server);
    }

    public Long getCurrentTotalMemory(String server) {
        return serverManagement.getCurrentTotalMemory(server);
    }

    public String getConnectionUrl(String server) {
        return serverManagement.getConnectionUrl(server);
    }

    public String getJavaVendor(String server) {
        return serverManagement.getJavaVendor(server);
    }

    public String getJavaVersion(String server) {
        return serverManagement.getJavaVersion(server);
    }

    public String getProtocols(String server) {
        return serverManagement.getProtocols(server);
    }

    public int getTotalBegunTransactions(String server) {
        return serverManagement.getTotalBegunTransactions(server);
    }

    public int getTotalCommittedTransactions(String server) {
        return serverManagement.getTotalCommittedTransactions(server);
    }

    public int getTotalExpiredTransactions(String server) {
        return serverManagement.getTotalExpiredTransactions(server);
    }

    public int getTotalRolledbackTransactions(String server) {
        return serverManagement.getTotalRolledbackTransactions(server);
    }

    public int getTotalCurrentTransactions(String server) {
        return serverManagement.getTotalCurrentTransactions(server);
    }

    public long getBytesReceivedByConnectorTomcat(String server) {
        return serverManagement.getBytesReceivedByConnectorTomcat(server);
    }

    public long getBytesSentByConnectorTomcat(String server) {
        return serverManagement.getBytesSentByConnectorTomcat(server);
    }

    public int getCurrentThreadBusyByConnectorTomcat(String server) {
        return serverManagement.getCurrentThreadBusyByConnectorTomcat(server);
    }

    public int getCurrentThreadCountByConnectorTomcat(String server) {
        return serverManagement.getCurrentThreadCountByConnectorTomcat(server);
    }

    public int getErrorCountByConnectorTomcat(String server) {
        return serverManagement.getErrorCountByConnectorTomcat(server);
    }

    public int getMaxThreadsByConnectorTomcat(String server) {
        return serverManagement.getMaxThreadsByConnectorTomcat(server);
    }

    public long getProcessingTimeByConnectorTomcat(String server) {
        return serverManagement.getProcessingTimeByConnectorTomcat(server);
    }

    public int getRequestCountByConnectorTomcat(String server) {
        return serverManagement.getRequestCountByConnectorTomcat(server);
    }

    public int getCurrentNumberOfEJB(String server) {
        return serverManagement.getCurrentNumberOfEJB(server);
    }

    public int getCurrentNumberOfEntityBean(String server) {
        return serverManagement.getCurrentNumberOfEntityBean(server);
    }

    public int getCurrentNumberOfMDB(String server) {
        return serverManagement.getCurrentNumberOfMDB(server);
    }

    public int getCurrentNumberOfSBF(String server) {
        return serverManagement.getCurrentNumberOfSBF(server);
    }

    public int getCurrentNumberOfSBL(String server) {
        return serverManagement.getCurrentNumberOfSBL(server);
    }

    public String[] getControlledServersNames(String clusterdaemonName) {
        return clusterdaemonManagement.getControlledServersNames(clusterdaemonName);
    }

    public boolean isRunning(String clusterdaemonName) {
        return clusterdaemonManagement.isRunning(clusterdaemonName);
    }

    public String getClusterdaemonState(String clusterdaemonName) {
        return clusterdaemonManagement.getClusterdaemonState(clusterdaemonName);
    }

    public void startAllServers(String clusterName) {
        clusterManagement.startAllServers(clusterName);
    }

    public void stopAllServers(String clusterName) {
        clusterManagement.stopAllServers(clusterName);
    }

    public String getMcastAddr(String clusterName) {
        return clusterManagement.getMcastAddr(clusterName);
    }

    public int getMcastPort(String clusterName) {
        return clusterManagement.getMcastPort(clusterName);
    }

    public int getDelayToRefresh(String clusterName) {
        return clusterManagement.getDelayToRefresh(clusterName);
    }

    public String[] getServersNotInCluster(String clusterName) {
        return domainManagement.getServersNotInCluster(clusterName);
    }

    public List<List<String>> getServerThreadsInformation(String serverName, String domainName) throws Exception {
        return JonasManagementRepr.getServerThreadsInformation(serverName, domainName);
    }
}

