/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrUtils {
    public static List<String> splitSmart(String s, char separator) {
        ArrayList<String> lst = new ArrayList<String>(4);
        int pos = 0;
        int start = 0;
        int end = s.length();
        char inString = '\u0000';
        char ch = '\u0000';
        while (pos < end) {
            char prevChar = ch;
            if ((ch = s.charAt(pos++)) == '\\') {
                ++pos;
                continue;
            }
            if (inString != '\u0000' && ch == inString) {
                inString = '\u0000';
                continue;
            }
            if (ch == '\'' || ch == '\"') {
                if (Character.isLetterOrDigit(prevChar)) continue;
                inString = ch;
                continue;
            }
            if (ch != separator || inString != '\u0000') continue;
            lst.add(s.substring(start, pos - 1));
            start = pos;
        }
        if (start < end) {
            lst.add(s.substring(start, end));
        }
        return lst;
    }

    public static List<String> splitSmart(String s, String separator, boolean decode) {
        ArrayList<String> lst = new ArrayList<String>(2);
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        int end = s.length();
        while (pos < end) {
            int ch;
            if (s.startsWith(separator, pos)) {
                if (sb.length() > 0) {
                    lst.add(sb.toString());
                    sb = new StringBuilder();
                }
                pos += separator.length();
                continue;
            }
            if ((ch = s.charAt(pos++)) == 92) {
                if (!decode) {
                    sb.append((char)ch);
                }
                if (pos >= end) break;
                ch = s.charAt(pos++);
                if (decode) {
                    switch (ch) {
                        case 110: {
                            ch = 10;
                            break;
                        }
                        case 116: {
                            ch = 9;
                            break;
                        }
                        case 114: {
                            ch = 13;
                            break;
                        }
                        case 98: {
                            ch = 8;
                            break;
                        }
                        case 102: {
                            ch = 12;
                        }
                    }
                }
            }
            sb.append((char)ch);
        }
        if (sb.length() > 0) {
            lst.add(sb.toString());
        }
        return lst;
    }

    public static List<String> splitWS(String s, boolean decode) {
        ArrayList<String> lst = new ArrayList<String>(2);
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        int end = s.length();
        while (pos < end) {
            int ch;
            if (Character.isWhitespace((char)(ch = s.charAt(pos++)))) {
                if (sb.length() <= 0) continue;
                lst.add(sb.toString());
                sb = new StringBuilder();
                continue;
            }
            if (ch == 92) {
                if (!decode) {
                    sb.append((char)ch);
                }
                if (pos >= end) break;
                ch = s.charAt(pos++);
                if (decode) {
                    switch (ch) {
                        case 110: {
                            ch = 10;
                            break;
                        }
                        case 116: {
                            ch = 9;
                            break;
                        }
                        case 114: {
                            ch = 13;
                            break;
                        }
                        case 98: {
                            ch = 8;
                            break;
                        }
                        case 102: {
                            ch = 12;
                        }
                    }
                }
            }
            sb.append((char)ch);
        }
        if (sb.length() > 0) {
            lst.add(sb.toString());
        }
        return lst;
    }

    public static List<String> toLower(List<String> strings) {
        ArrayList<String> ret = new ArrayList<String>(strings.size());
        for (String str : strings) {
            ret.add(str.toLowerCase());
        }
        return ret;
    }

    public static boolean parseBoolean(String s) {
        char ch = s.length() > 0 ? s.charAt(0) : (char)'\u0000';
        return ch == '1' || ch == 't' || ch == 'T';
    }

    public static void partialURLEncodeVal(Appendable dest, String val) throws IOException {
        block7: for (int i = 0; i < val.length(); ++i) {
            char ch = val.charAt(i);
            if (ch < ' ') {
                dest.append('%');
                dest.append(Integer.toString(ch));
                continue;
            }
            switch (ch) {
                case ' ': {
                    dest.append('+');
                    continue block7;
                }
                case '&': {
                    dest.append("%26");
                    continue block7;
                }
                case '%': {
                    dest.append("%25");
                    continue block7;
                }
                case '=': {
                    dest.append("%3D");
                    continue block7;
                }
                case '+': {
                    dest.append("%2B");
                    continue block7;
                }
                default: {
                    dest.append(ch);
                }
            }
        }
    }
}

