/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.BufferedMessageInputStream;
import fr.dyade.aaa.agent.BufferedMessageOutputStream;
import fr.dyade.aaa.agent.Channel;
import fr.dyade.aaa.agent.ExpiredNot;
import fr.dyade.aaa.agent.Message;
import fr.dyade.aaa.agent.NetSessionWrapper;
import fr.dyade.aaa.agent.PoolNetworkMBean;
import fr.dyade.aaa.agent.ServerDesc;
import fr.dyade.aaa.agent.StreamNetwork;
import fr.dyade.aaa.agent.UnknownServerException;
import fr.dyade.aaa.util.Daemon;
import fr.dyade.aaa.util.management.MXWrapper;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.OptionalDataException;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.net.ConnectException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class PoolNetwork
extends StreamNetwork
implements PoolNetworkMBean {
    WakeOnConnection wakeOnConnection = null;
    NetSession[] sessions = null;
    Dispatcher dispatcher = null;
    PoolSender poolSender = null;
    WatchDog watchDog = null;
    Vector activeSessions;
    boolean compressedFlows = false;
    int nbMaxCnx;
    long IdleTimeout = 60000L;
    int defaultMaxMessageInFlow = -1;
    int nbMaxFreeSender;

    public boolean getCompressedFlows() {
        return this.compressedFlows;
    }

    public int getNbMaxActiveSession() {
        return this.nbMaxCnx;
    }

    public int getNbActiveSession() {
        return this.activeSessions.size();
    }

    public long getIdleTimeout() {
        return this.IdleTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        if (idleTimeout > 1000L) {
            this.IdleTimeout = idleTimeout;
        }
    }

    public int getNbMaxFreeSender() {
        return this.nbMaxFreeSender;
    }

    public void init(String name, int port, short[] servers) throws Exception {
        super.init(name, port, servers);
        this.sessions = new NetSession[servers.length];
        for (int i = 0; i < this.sessions.length; ++i) {
            if (servers[i] == AgentServer.getServerId()) continue;
            this.sessions[i] = new NetSession(this.getName(), servers[i]);
        }
        this.wakeOnConnection = new WakeOnConnection(this.getName(), this.logmon);
        this.dispatcher = new Dispatcher(this.getName(), this.logmon);
        this.watchDog = new WatchDog(this.getName(), this.logmon);
        this.poolSender = new PoolSender(this.getName(), this.nbMaxFreeSender);
    }

    public void setProperties() throws Exception {
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.domain + ", PoolNetwork.setProperties()"));
        }
        super.setProperties();
        try {
            this.nbMaxCnx = AgentServer.getInteger(this.domain + ".nbMaxCnx");
        }
        catch (Exception exc) {
            try {
                this.nbMaxCnx = AgentServer.getInteger("PoolNetwork.nbMaxCnx");
            }
            catch (Exception exc2) {
                this.nbMaxCnx = -1;
            }
        }
        this.nbMaxFreeSender = AgentServer.getInteger("PoolNetwork.nbMaxFreeSender", 2);
        this.nbMaxFreeSender = AgentServer.getInteger(this.domain + ".nbMaxFreeSender", this.nbMaxFreeSender);
        if (this.nbMaxFreeSender < 1) {
            this.nbMaxFreeSender = 2;
        }
        this.IdleTimeout = Long.getLong("PoolNetwork.IdleTimeout", this.IdleTimeout);
        this.IdleTimeout = Long.getLong(this.domain + ".IdleTimeout", this.IdleTimeout);
        if (this.IdleTimeout < 1000L) {
            this.IdleTimeout = 5000L;
        }
        this.defaultMaxMessageInFlow = AgentServer.getInteger("PoolNetwork.maxMessageInFlow", this.defaultMaxMessageInFlow);
        this.defaultMaxMessageInFlow = AgentServer.getInteger(this.domain + ".maxMessageInFlow", this.defaultMaxMessageInFlow);
        String value = System.getProperty(this.domain + ".compressedFlows");
        if (value == null) {
            value = System.getProperty("PoolNetwork.compressedFlows");
        }
        this.compressedFlows = Boolean.valueOf(value);
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            StringBuffer strbuf = new StringBuffer();
            strbuf.append(" setProperties(");
            strbuf.append("nbMaxCnx=").append(this.nbMaxCnx);
            strbuf.append(", nbMaxFreeSender=").append(this.nbMaxFreeSender);
            strbuf.append(", IdleTimeout=").append(this.IdleTimeout);
            strbuf.append(", defaultMaxMessageInFlow=").append(this.defaultMaxMessageInFlow);
            strbuf.append(", compressedFlows=").append(this.compressedFlows);
            strbuf.append(')');
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + strbuf.toString()));
        }
    }

    synchronized void addServer(short id) throws Exception {
        int i;
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            StringBuffer strbuf = new StringBuffer();
            for (i = 0; i < this.servers.length; ++i) {
                strbuf.append("\n\t").append("server#" + this.servers[i] + " -> " + this.sessions[i]);
            }
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + " before addServer:" + strbuf.toString()));
        }
        try {
            super.addServer(id);
            if (this.sessions.length == this.servers.length) {
                return;
            }
            NetSession[] newSessions = new NetSession[this.servers.length];
            for (i = 0; i < this.sessions.length; ++i) {
                if (this.sessions[i] == null || this.sessions[i].sid == AgentServer.getServerId()) continue;
                newSessions[this.index((short)((NetSession)this.sessions[i]).sid)] = this.sessions[i];
                this.sessions[i] = null;
            }
            this.sessions = newSessions;
            int idx = this.index(id);
            this.sessions[idx] = new NetSession(this.getName(), id);
            this.sessions[idx].init();
            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                StringBuffer strbuf = new StringBuffer();
                for (int i2 = 0; i2 < this.servers.length; ++i2) {
                    strbuf.append("\t").append(this.sessions[i2]).append("\n");
                }
                this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + " after addServer:" + strbuf.toString()));
            }
        }
        catch (Exception exc) {
            this.logmon.log(BasicLevel.FATAL, (Object)(this.getName() + " addServer failed"), (Throwable)exc);
        }
        this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + " addServer ok"));
    }

    synchronized void delServer(short id) throws Exception {
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            StringBuffer strbuf = new StringBuffer();
            for (int i = 0; i < this.servers.length; ++i) {
                strbuf.append("\t").append(this.sessions[i]).append("\n");
            }
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + strbuf.toString()));
        }
        try {
            super.delServer(id);
            NetSession[] newSessions = new NetSession[this.servers.length];
            int j = 0;
            for (int i = 0; i < this.servers.length; ++i) {
                if (this.sessions[i] == null) {
                    ++j;
                    continue;
                }
                if (this.sessions[i].sid == id) continue;
                newSessions[j++] = this.sessions[i];
                this.sessions[i] = null;
            }
            this.sessions = newSessions;
            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                StringBuffer strbuf = new StringBuffer();
                for (int i = 0; i < this.servers.length; ++i) {
                    strbuf.append("\t").append(this.sessions[i]).append("\n");
                }
                this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + strbuf.toString()));
            }
        }
        catch (Exception exc) {
            this.logmon.log(BasicLevel.FATAL, (Object)(this.getName() + " delServer failed"), (Throwable)exc);
        }
        this.logmon.log(BasicLevel.FATAL, (Object)(this.getName() + " delServer ok"), (Throwable)new Exception());
    }

    private String getMBeanName(short sid) {
        return "server=" + AgentServer.getName() + ",cons=" + this.name + ",session=netSession#" + sid;
    }

    public void start() throws Exception {
        this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", starting"));
        try {
            if (this.isRunning()) {
                throw new IOException("Consumer already running.");
            }
            for (int i = 0; i < this.sessions.length; ++i) {
                if (this.sessions[i] == null) continue;
                this.sessions[i].init();
                try {
                    MXWrapper.registerMBean(new NetSessionWrapper(this, this.servers[i]), "AgentServer", this.getMBeanName(this.servers[i]));
                    continue;
                }
                catch (Exception exc) {
                    this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + " jmx failed"), (Throwable)exc);
                }
            }
            this.activeSessions = this.nbMaxCnx != -1 ? new Vector(this.nbMaxCnx) : new Vector(this.servers.length - 1);
            this.wakeOnConnection.start();
            this.dispatcher.start();
            this.watchDog.start();
        }
        catch (Exception exc) {
            this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", can't start"), (Throwable)exc);
            throw exc;
        }
        this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", started"));
    }

    public void wakeup() {
        if (this.watchDog != null) {
            this.watchDog.wakeup();
        }
    }

    public void stop() {
        if (this.wakeOnConnection != null) {
            this.wakeOnConnection.stop();
        }
        if (this.dispatcher != null) {
            this.dispatcher.stop();
        }
        if (this.watchDog != null) {
            this.watchDog.stop();
        }
        if (this.poolSender != null) {
            this.poolSender.stop();
        }
        for (int i = 0; i < this.sessions.length; ++i) {
            if (this.sessions[i] == null) continue;
            try {
                MXWrapper.unregisterMBean("AgentServer", this.getMBeanName(this.sessions[i].sid));
            }
            catch (Exception exc) {
                this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + " jmx failed"), (Throwable)exc);
            }
            if (!this.sessions[i].isRunning()) continue;
            this.sessions[i].stop();
        }
        this.activeSessions.clear();
        this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", stopped"));
    }

    public boolean isRunning() {
        return this.wakeOnConnection != null && this.wakeOnConnection.isRunning() && this.dispatcher != null && this.dispatcher.isRunning() && this.watchDog != null && this.watchDog.isRunning();
    }

    final NetSession getSession(short sid) {
        return this.sessions[this.index(sid)];
    }

    final boolean isSessionRunning(short sid) {
        return this.sessions[this.index(sid)].isRunning();
    }

    final int getMaxMessageInFlow(short sid) {
        return this.sessions[this.index(sid)].getMaxMessageInFlow();
    }

    void setMaxMessageInFlow(short sid, int maxMessageInFlow) {
        this.sessions[this.index(sid)].setMaxMessageInFlow(maxMessageInFlow);
    }

    final int getSessionNbWaitingMessages(short sid) {
        return this.sessions[this.index(sid)].getNbWaitingMessages();
    }

    final int getNbMessageSent(short sid) {
        return this.sessions[this.index(sid)].getNbMessageSent();
    }

    final int getNbMessageReceived(short sid) {
        return this.sessions[this.index(sid)].getNbMessageReceived();
    }

    final int getNbAckSent(short sid) {
        return this.sessions[this.index(sid)].getNbAckSent();
    }

    final long getLastReceived(short sid) {
        return this.sessions[this.index(sid)].getLastReceived();
    }

    final int getNbBufferingMessageToSent(short sid) {
        return this.sessions[this.index(sid)].getNbBufferingMessageToSent();
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append(super.toString()).append("\n\t");
        if (this.wakeOnConnection != null) {
            strbuf.append(this.wakeOnConnection.toString()).append("\n\t");
        }
        if (this.dispatcher != null) {
            strbuf.append(this.dispatcher.toString()).append("\n\t");
        }
        if (this.watchDog != null) {
            strbuf.append(this.watchDog.toString()).append("\n\t");
        }
        for (int i = 0; i < this.sessions.length; ++i) {
            if (this.sessions[i] == null) continue;
            strbuf.append(this.sessions[i].toString()).append("\n\t");
        }
        return strbuf.toString();
    }

    final void writeBoot(OutputStream out) throws IOException {
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", writeBoot: " + this.getBootTS()));
        }
        byte[] iobuf = new byte[]{(byte)(AgentServer.getServerId() >>> 8), (byte)(AgentServer.getServerId() >>> 0), (byte)(this.getBootTS() >>> 24), (byte)(this.getBootTS() >>> 16), (byte)(this.getBootTS() >>> 8), (byte)(this.getBootTS() >>> 0)};
        out.write(iobuf);
        out.flush();
    }

    final void readFully(InputStream is, byte[] iobuf) throws IOException {
        int count;
        int n = 0;
        do {
            if ((count = is.read(iobuf, n, iobuf.length - n)) >= 0) continue;
            throw new EOFException();
        } while ((n += count) < iobuf.length);
    }

    final Boot readBoot(InputStream in) throws IOException {
        Boot boot = new Boot();
        byte[] iobuf = new byte[6];
        this.readFully(in, iobuf);
        boot.sid = (short)(((iobuf[0] & 0xFF) << 8) + (iobuf[1] & 0xFF));
        boot.boot = ((iobuf[2] & 0xFF) << 24) + ((iobuf[3] & 0xFF) << 16) + ((iobuf[4] & 0xFF) << 8) + ((iobuf[5] & 0xFF) << 0);
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", readBoot from #" + boot.sid + " -> " + boot.boot));
        }
        return boot;
    }

    final void writeAck(OutputStream out) throws IOException {
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", writeAck: " + this.getBootTS()));
        }
        byte[] iobuf = new byte[]{(byte)(this.getBootTS() >>> 24), (byte)(this.getBootTS() >>> 16), (byte)(this.getBootTS() >>> 8), (byte)(this.getBootTS() >>> 0)};
        out.write(iobuf);
        out.flush();
    }

    final int readAck(InputStream in) throws IOException {
        byte[] iobuf = new byte[4];
        this.readFully(in, iobuf);
        int boot = ((iobuf[0] & 0xFF) << 24) + ((iobuf[1] & 0xFF) << 16) + ((iobuf[2] & 0xFF) << 8) + ((iobuf[3] & 0xFF) << 0);
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", readAck:" + boot));
        }
        return boot;
    }

    final class Boot {
        transient short sid;
        transient int boot;

        Boot() {
        }
    }

    final class NetSession
    implements Runnable {
        private short sid;
        private volatile boolean running = false;
        private boolean canStop = false;
        private Thread thread = null;
        private String name = null;
        private boolean local = false;
        private ServerDesc server;
        private Socket sock = null;
        Sender sender = null;
        int maxMessageInFlow = -1;
        NetworkInputStream nis = null;
        NetworkOutputStream nos = null;
        private MessageVector sendList;
        private long last = 0L;
        int nbMessageSent = 0;
        int nbMessageReceived = 0;
        int nbAckSent = 0;
        long lastReceived = 0L;

        int getMaxMessageInFlow() {
            return this.maxMessageInFlow;
        }

        void setMaxMessageInFlow(int maxMessageInFlow) {
            this.maxMessageInFlow = maxMessageInFlow;
        }

        public String toString() {
            return this.toString(new StringBuffer()).toString();
        }

        public StringBuffer toString(StringBuffer strbuf) {
            strbuf.append("[sid=").append(this.sid);
            strbuf.append(",running=").append(this.running);
            strbuf.append(",name=").append(this.name).append("]");
            return strbuf;
        }

        NetSession(String name, short sid) {
            this.sid = sid;
            this.name = name + ".netSession#" + sid;
            if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", created"));
            }
            this.running = false;
            this.canStop = false;
            this.thread = null;
            this.maxMessageInFlow = AgentServer.getInteger("PoolNetwork.maxMessageInFlow_" + sid, PoolNetwork.this.defaultMaxMessageInFlow);
            this.maxMessageInFlow = AgentServer.getInteger(PoolNetwork.this.domain + ".maxMessageInFlow_" + sid, this.maxMessageInFlow);
            this.sendList = new MessageVector();
        }

        void init() throws UnknownServerException {
            this.server = AgentServer.getServerDesc(this.sid);
        }

        public final String getName() {
            return this.name;
        }

        public short getRemoteSID() {
            return this.sid;
        }

        public boolean isRunning() {
            return this.running;
        }

        int getNbWaitingMessages() {
            return this.sendList.size();
        }

        int getNbMessageSent() {
            return this.nbMessageSent;
        }

        int getNbMessageReceived() {
            return this.nbMessageReceived;
        }

        int getNbAckSent() {
            return this.nbAckSent;
        }

        long getLastReceived() {
            return this.lastReceived;
        }

        int getNbBufferingMessageToSent() {
            if (this.sender == null || this.sender.msgToSend == null) {
                return 0;
            }
            return this.sender.msgToSend.size();
        }

        void start(long currentTimeMillis) {
            if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", starting"));
            }
            if (this.server.retry < PoolNetwork.this.WDNbRetryLevel1 && this.server.last + PoolNetwork.this.WDRetryPeriod1 < currentTimeMillis || this.server.retry < PoolNetwork.this.WDNbRetryLevel2 && this.server.last + PoolNetwork.this.WDRetryPeriod2 < currentTimeMillis || this.server.last + PoolNetwork.this.WDRetryPeriod3 < currentTimeMillis) {
                if (this.localStart()) {
                    this.startEnd();
                } else {
                    this.server.last = currentTimeMillis;
                    ++this.server.retry;
                }
                PoolNetwork.this.poolSender.restart(this.sid);
            }
        }

        void start(Socket sock, int boot) {
            if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", remotely started"));
            }
            if (this.remoteStart(sock, boot)) {
                this.startEnd();
            }
            PoolNetwork.this.poolSender.restart(this.sid);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean localStart() {
            NetSession netSession = this;
            synchronized (netSession) {
                if (this.sock != null || this.local) {
                    if (PoolNetwork.this.logmon.isLoggable(BasicLevel.WARN)) {
                        PoolNetwork.this.logmon.log(BasicLevel.WARN, (Object)(this.getName() + ", connection refused"));
                    }
                    return false;
                }
                PoolNetwork.this.poolSender.reset(this.sid);
                this.local = true;
            }
            Socket sock = null;
            try {
                NetworkInputStream nis;
                sock = PoolNetwork.this.createSocket(this.server);
                PoolNetwork.this.setSocketOption(sock);
                PoolNetwork.this.writeBoot(sock.getOutputStream());
                int boot = PoolNetwork.this.readAck(sock.getInputStream());
                AgentServer.getTransaction().begin();
                PoolNetwork.this.testBootTS(this.sid, boot);
                AgentServer.getTransaction().commit(true);
                NetworkOutputStream nos = new NetworkOutputStream(sock.getOutputStream());
                this.nis = nis = new NetworkInputStream(sock.getInputStream());
                this.nos = nos;
                if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                    PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", connection done"));
                }
            }
            catch (Exception exc) {
                if (PoolNetwork.this.logmon.isLoggable(BasicLevel.WARN)) {
                    PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", connection aborted"), (Throwable)exc);
                }
                try {
                    sock.getOutputStream().close();
                }
                catch (Exception exc2) {
                    // empty catch block
                }
                try {
                    sock.getInputStream().close();
                }
                catch (Exception exc2) {
                    // empty catch block
                }
                try {
                    sock.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.local = false;
                return false;
            }
            this.sock = sock;
            this.local = false;
            return true;
        }

        synchronized boolean remoteStart(Socket sock, int boot) {
            try {
                NetworkInputStream nis;
                if (this.sock != null || this.local && this.server.sid > AgentServer.getServerId()) {
                    throw new ConnectException("Already connected");
                }
                if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                    PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", send AckStatus"));
                }
                PoolNetwork.this.writeAck(sock.getOutputStream());
                PoolNetwork.this.poolSender.reset(this.sid);
                AgentServer.getTransaction().begin();
                PoolNetwork.this.testBootTS(this.sid, boot);
                AgentServer.getTransaction().commit(true);
                NetworkOutputStream nos = new NetworkOutputStream(sock.getOutputStream());
                this.nis = nis = new NetworkInputStream(sock.getInputStream());
                this.nos = nos;
                this.sock = sock;
                return true;
            }
            catch (Exception exc) {
                if (PoolNetwork.this.logmon.isLoggable(BasicLevel.WARN)) {
                    PoolNetwork.this.logmon.log(BasicLevel.WARN, (Object)(this.getName() + ", connection refused"), (Throwable)exc);
                }
                try {
                    sock.getOutputStream().close();
                }
                catch (Exception exc2) {
                    // empty catch block
                }
                try {
                    sock.getInputStream().close();
                }
                catch (Exception exc2) {
                    // empty catch block
                }
                try {
                    sock.close();
                }
                catch (Exception exc2) {
                    // empty catch block
                }
                return false;
            }
        }

        private void startEnd() {
            this.server.active = true;
            this.server.retry = 0;
            for (int i = PoolNetwork.this.activeSessions.size() - 1; i >= 0; --i) {
                NetSession session = (NetSession)PoolNetwork.this.activeSessions.get(i);
                if (session.running) continue;
                PoolNetwork.this.activeSessions.remove(i);
            }
            if (PoolNetwork.this.nbMaxCnx == -1 || PoolNetwork.this.activeSessions.size() < PoolNetwork.this.nbMaxCnx) {
                PoolNetwork.this.activeSessions.add(this);
            } else {
                long min = Long.MAX_VALUE;
                int idx = -1;
                for (int i = 0; i < PoolNetwork.this.activeSessions.size(); ++i) {
                    NetSession session = (NetSession)PoolNetwork.this.activeSessions.get(i);
                    if (session.last >= min) continue;
                    idx = i;
                    min = session.last;
                }
                if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                    PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", Kill session " + PoolNetwork.this.activeSessions.get(idx) + ",  and insert new one."));
                }
                ((NetSession)PoolNetwork.this.activeSessions.get(idx)).stop();
                PoolNetwork.this.activeSessions.set(idx, this);
            }
            this.last = System.currentTimeMillis();
            this.thread = new Thread((Runnable)this, this.getName());
            this.thread.setDaemon(false);
            this.running = true;
            this.canStop = true;
            this.thread.start();
            if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", connection started"));
            }
        }

        void stop() {
            this.running = false;
            if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", stops."));
            }
            if (Thread.currentThread() == this.thread) {
                return;
            }
            while (this.thread != null && this.thread.isAlive()) {
                if (this.canStop) {
                    if (this.thread.isAlive()) {
                        this.thread.interrupt();
                    }
                    this.shutdown();
                }
                try {
                    this.thread.join(1000L);
                }
                catch (InterruptedException exc) {
                    continue;
                }
                this.thread = null;
            }
        }

        public void shutdown() {
            this.close();
        }

        synchronized void close() {
            if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", closed."));
            }
            try {
                this.sock.getInputStream().close();
            }
            catch (Exception exc) {
                // empty catch block
            }
            try {
                this.sock.getOutputStream().close();
            }
            catch (Exception exc) {
                // empty catch block
            }
            try {
                this.sock.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.nis = null;
            this.nos = null;
        }

        private final void doAck(int ack) throws Exception {
            Message msg = null;
            if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", ack received #" + ack));
            }
            try {
                msg = this.sendList.removeMessage(ack);
                AgentServer.getTransaction().begin();
                msg.delete();
                msg.free();
                AgentServer.getTransaction().commit(true);
            }
            catch (NoSuchElementException exc) {
                PoolNetwork.this.logmon.log(BasicLevel.WARN, (Object)(this.getName() + ", can't ack, unknown msg#" + ack));
            }
            catch (Exception e) {
                if (PoolNetwork.this.logmon.isLoggable(BasicLevel.WARN)) {
                    PoolNetwork.this.logmon.log(BasicLevel.WARN, (Object)(this.getName() + ", exception during doAck : msg#" + ack));
                }
                throw e;
            }
        }

        private final void removeExpired(Message msg) {
            block9: {
                int stamp = msg.getStamp();
                try {
                    this.sendList.removeMessage(stamp);
                }
                catch (NoSuchElementException exc) {
                    PoolNetwork.this.logmon.log(BasicLevel.WARN, (Object)(this.getName() + ", can't removes unknown expired msg#" + stamp));
                }
                try {
                    AgentServer.getTransaction().begin();
                    ExpiredNot expiredNot = null;
                    if (msg.not.deadNotificationAgentId != null) {
                        if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                            PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ": forward expired notification " + msg.from + ", " + msg.not + " to " + msg.not.deadNotificationAgentId));
                        }
                        expiredNot = new ExpiredNot(msg.not, msg.from, msg.to);
                    } else if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                        PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ": removes expired notification " + msg.from + ", " + msg.not));
                    }
                    if (expiredNot != null) {
                        Channel.post(Message.alloc(AgentId.localId, msg.not.deadNotificationAgentId, expiredNot));
                        Channel.validate();
                    }
                    msg.delete();
                    msg.free();
                    AgentServer.getTransaction().commit(true);
                }
                catch (Exception exc) {
                    if (!PoolNetwork.this.logmon.isLoggable(BasicLevel.WARN)) break block9;
                    PoolNetwork.this.logmon.log(BasicLevel.WARN, (Object)(this.getName() + ", exception in removeExpired msg#" + stamp), (Throwable)exc);
                }
            }
        }

        final void send() {
            if (this.sock != null) {
                Message msg = null;
                long currentTimeMillis = System.currentTimeMillis();
                if (this.maxMessageInFlow > 0) {
                    msg = (Message)this.sender.msgToSend.firstElement();
                    while (this.sock != null && msg.not != null && this.sendList.size() > this.maxMessageInFlow) {
                        try {
                            if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                                PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", transmit waits -> sendList.size=" + this.sendList.size()));
                            }
                            Thread.sleep(100L);
                            if (this.sock == null) {
                                return;
                            }
                        }
                        catch (InterruptedException exc) {
                            // empty catch block
                        }
                        msg = (Message)this.sender.msgToSend.firstElement();
                    }
                }
                if (this.sock == null) {
                    return;
                }
                msg = (Message)this.sender.msgToSend.remove(0);
                if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                    if (msg.not != null) {
                        PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", send msg#" + msg.getStamp()));
                    } else {
                        PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", send ack#" + msg.getStamp()));
                    }
                }
                if (msg.not != null) {
                    ++this.nbMessageSent;
                    this.sendList.addElement(msg);
                    if (msg.not.expiration > 0L && msg.not.expiration < currentTimeMillis) {
                        this.removeExpired(msg);
                        return;
                    }
                } else {
                    ++this.nbAckSent;
                }
                if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                    if (msg.not != null) {
                        PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", transmit(msg#" + msg.stamp + ", " + currentTimeMillis + ')'));
                    } else {
                        PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", transmit(ack#" + msg.stamp + ", " + currentTimeMillis + ')'));
                    }
                }
                this.last = currentTimeMillis;
                try {
                    this.nos.writeMessage(msg, currentTimeMillis);
                }
                catch (IOException exc) {
                    PoolNetwork.this.logmon.log(BasicLevel.WARN, (Object)(this.getName() + ", exception in sending message " + msg), (Throwable)exc);
                    this.close();
                }
                catch (NullPointerException exc) {
                    PoolNetwork.this.logmon.log(BasicLevel.WARN, (Object)(this.getName() + ", exception in sending message " + msg));
                }
            } else {
                Message msg = (Message)this.sender.msgToSend.remove(0);
                long currentTimeMillis = System.currentTimeMillis();
                if (msg.not != null) {
                    if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                        PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", move msg#" + msg.getStamp() + " to sendList"));
                    }
                    this.sendList.addElement(msg);
                    if (msg.not.expiration > 0L && msg.not.expiration < currentTimeMillis) {
                        this.removeExpired(msg);
                        return;
                    }
                }
            }
        }

        private final void ack(int stamp) throws Exception {
            if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", set ack msg#" + stamp));
            }
            Message ack = Message.alloc(AgentId.localId, AgentId.localId(this.server.sid), null);
            ack.source = AgentServer.getServerId();
            ack.dest = AgentServer.getServerDesc((short)this.server.sid).gateway;
            ack.stamp = stamp;
            PoolNetwork.this.qout.push(ack);
            PoolNetwork.this.qout.validate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (this.running) {
                    Message msg;
                    this.canStop = true;
                    if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                        PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", waiting message"));
                    }
                    try {
                        msg = this.nis.readMessage();
                    }
                    catch (ClassNotFoundException exc) {
                        PoolNetwork.this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", error during waiting message"), (Throwable)exc);
                        continue;
                    }
                    catch (InvalidClassException exc) {
                        PoolNetwork.this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", error during waiting message"), (Throwable)exc);
                        continue;
                    }
                    catch (StreamCorruptedException exc) {
                        PoolNetwork.this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", error during waiting message"), (Throwable)exc);
                        break;
                    }
                    catch (OptionalDataException exc) {
                        PoolNetwork.this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", error during waiting message"), (Throwable)exc);
                        break;
                    }
                    catch (NullPointerException exc) {
                        break;
                    }
                    this.canStop = false;
                    if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                        PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", receives: " + msg));
                    }
                    this.last = this.lastReceived = System.currentTimeMillis();
                    int stamp = msg.getStamp();
                    if (msg.not != null) {
                        ++this.nbMessageReceived;
                        PoolNetwork.this.deliver(msg);
                        this.ack(stamp);
                    } else {
                        this.doAck(stamp);
                    }
                    Thread.yield();
                }
            }
            catch (EOFException exc) {
                if (this.running) {
                    PoolNetwork.this.logmon.log(BasicLevel.WARN, (Object)(this.getName() + ", connection closed"), (Throwable)exc);
                }
            }
            catch (SocketException exc) {
                if (this.running) {
                    PoolNetwork.this.logmon.log(BasicLevel.WARN, (Object)(this.getName() + ", connection closed"), (Throwable)exc);
                }
            }
            catch (Exception exc) {
                PoolNetwork.this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", exited"), (Throwable)exc);
            }
            finally {
                PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", ends"));
                this.running = false;
                this.close();
                this.sock = null;
            }
        }

        final class NetworkOutputStream
        extends BufferedMessageOutputStream {
            OutputStream os = null;

            NetworkOutputStream(OutputStream os) throws IOException {
                this.out = os;
                this.compressedFlows = PoolNetwork.this.getCompressedFlows();
            }

            protected void writeHeader() throws IOException {
            }
        }

        final class NetworkInputStream
        extends BufferedMessageInputStream {
            NetworkInputStream(InputStream is) throws IOException {
                this.in = is;
                this.compressedFlows = PoolNetwork.this.getCompressedFlows();
            }

            protected void readHeader() throws IOException {
            }
        }
    }

    final class PoolSender {
        String name;
        int nbFree = 0;
        Sender[] free = null;
        Vector senders = null;
        int count = 0;

        PoolSender(String name, int nbMaxFreeSender) {
            this.name = name;
            this.free = new Sender[nbMaxFreeSender];
            this.senders = new Vector();
        }

        private Sender getSender(short sid) {
            if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(PoolNetwork.this.getName() + ", getSender(" + sid + ')'));
            }
            NetSession session = PoolNetwork.this.getSession(sid);
            if (session.sender == null) {
                if (this.nbFree == 0) {
                    if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                        PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(PoolNetwork.this.getName() + ", creates a Sender (" + sid + ')'));
                    }
                    Sender sender = new Sender(this.name + '_' + this.count++, PoolNetwork.this.logmon, this);
                    this.senders.add(sender);
                    sender.session = session;
                    session.sender = sender;
                    sender.start();
                } else {
                    if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                        PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(PoolNetwork.this.getName() + ", alloc a Sender (" + sid + ')'));
                    }
                    --this.nbFree;
                    Sender sender = this.free[this.nbFree];
                    this.free[this.nbFree] = null;
                    sender.session = session;
                    session.sender = sender;
                }
            }
            if (!session.sender.isRunning()) {
                PoolNetwork.this.logmon.log(BasicLevel.WARN, (Object)(PoolNetwork.this.getName() + ", start anew sender (" + sid + ')'));
                session.sender.start();
            }
            if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(PoolNetwork.this.getName() + ", getSender returns " + session.sender.getName()));
            }
            return session.sender;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void reset(short sid) {
            PoolNetwork.this.logmon.log(BasicLevel.INFO, (Object)(PoolNetwork.this.getName() + ", reset(" + sid + ')'));
            Sender sender = this.getSender(sid);
            sender.restart = true;
            if (!sender.isCurrentThread()) {
                Sender sender2 = sender;
                synchronized (sender2) {
                    while (!sender.waiting) {
                        try {
                            if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                                PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(PoolNetwork.this.getName() + ", waits sender."));
                            }
                            sender.wait(10L);
                        }
                        catch (InterruptedException e) {}
                    }
                }
            }
            if (sender.session.sendList.size() > 0) {
                Object[] waiting = sender.session.sendList.toArray();
                sender.session.sendList.clear();
                PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(PoolNetwork.this.getName() + ", reset - " + waiting.length + " waiting messages"));
                sender.msgToSend.insertMessage(waiting);
            }
            PoolNetwork.this.logmon.log(BasicLevel.WARN, (Object)(PoolNetwork.this.getName() + ", reset end (" + sid + ')'));
        }

        synchronized void restart(short sid) {
            PoolNetwork.this.logmon.log(BasicLevel.INFO, (Object)(PoolNetwork.this.getName() + ", restart(" + sid + ')'));
            Sender sender = this.getSender(sid);
            PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(PoolNetwork.this.getName() + ", restart sender=" + sender + ", msgToSend=" + sender.msgToSend));
            sender.restart = false;
            if (!sender.msgToSend.isEmpty()) {
                sender.send(null);
            }
        }

        synchronized void send(Message msg) {
            if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(PoolNetwork.this.getName() + ", send(" + msg + ')'));
            }
            Sender sender = this.getSender(msg.getDest());
            sender.send(msg);
        }

        synchronized void release(Sender sender) {
            if (sender.msgToSend.isEmpty() && !sender.restart) {
                if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                    PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(PoolNetwork.this.getName() + ", release sender (" + sender.session.sid + ')'));
                }
                sender.session.sender = null;
                if (this.nbFree == this.free.length) {
                    if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                        PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(PoolNetwork.this.getName() + ", free sender (" + sender.session.sid + ')'));
                    }
                    sender.session = null;
                    sender.stop();
                    this.senders.remove(sender);
                    return;
                }
                sender.session = null;
                this.free[this.nbFree++] = sender;
            }
        }

        public void stop() {
            if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(PoolNetwork.this.getName() + "poolSender.stop()"));
            }
            for (int i = 0; i < PoolNetwork.this.sessions.length; ++i) {
                if (PoolNetwork.this.sessions[i] == null || PoolNetwork.this.sessions[i].sender == null) continue;
                Sender sender = PoolNetwork.this.sessions[i].sender;
                PoolNetwork.this.sessions[i].sender = null;
                sender.session = null;
                sender.stop();
                if (!PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) continue;
                PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(PoolNetwork.this.getName() + "senders[" + i + "].stop() done."));
            }
            while (this.nbFree > 0) {
                --this.nbFree;
                this.free[this.nbFree].stop();
                this.free[this.nbFree] = null;
            }
        }
    }

    final class Sender
    extends Daemon {
        MessageList msgToSend;
        PoolSender poolSender;
        NetSession session;
        public boolean restart;
        public boolean waiting;

        Sender(String name, Logger logmon, PoolSender poolSender) {
            super(name + ".sender");
            this.session = null;
            this.restart = false;
            this.waiting = false;
            this.logmon = logmon;
            this.poolSender = poolSender;
            this.msgToSend = new MessageList();
        }

        protected void close() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void shutdown() {
            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", shutdown."));
            }
            Sender sender = this;
            synchronized (sender) {
                if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                    this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", shutdown - 1."));
                }
                this.notify();
                try {
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        synchronized void send(Message msg) {
            if (msg != null) {
                if (msg.not == null) {
                    this.msgToSend.insertAck(msg);
                } else {
                    this.msgToSend.addElement(msg);
                }
            }
            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", send [" + this.session.sid + "] notify run, msgToSend=" + this.msgToSend));
            }
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (this.running) {
                    this.canStop = true;
                    Sender sender = this;
                    synchronized (sender) {
                        try {
                            if (this.msgToSend.isEmpty() || this.restart) {
                                if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                                    this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", waits message."));
                                }
                                this.waiting = true;
                                this.wait();
                                if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                                    this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", trace1."));
                                }
                                if (this.restart) {
                                    continue;
                                }
                                if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                                    this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", trace2."));
                                }
                            }
                        }
                        catch (InterruptedException e) {
                            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                                this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", trace3."));
                            }
                            continue;
                        }
                        finally {
                            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                                this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", trace4."));
                            }
                            this.waiting = false;
                        }
                    }
                    this.canStop = false;
                    if (!this.running) {
                        break;
                    }
                    if (this.session == null) {
                        this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", Sender[null] notified, msgToSend=" + this.msgToSend));
                        continue;
                    }
                    if (this.session.sock == null && ((NetSession)this.session).server.retry == 0) {
                        this.waiting = true;
                        this.session.start(System.currentTimeMillis());
                    }
                    if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                        this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", send(" + this.msgToSend + ')'));
                    }
                    if (!this.msgToSend.isEmpty()) {
                        this.session.send();
                    }
                    this.waiting = true;
                    if (this.restart) continue;
                    this.poolSender.release(this);
                }
            }
            catch (Exception exc) {
                this.logmon.log(BasicLevel.ERROR, (Object)this.getName(), (Throwable)exc);
            }
            finally {
                if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                    this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", ends"));
                }
                this.finish();
            }
        }
    }

    class MessageList
    extends Vector {
        MessageList() {
        }

        public synchronized void insertMessage(Object[] waiting) {
            ++this.modCount;
            Message msg = null;
            for (int i = 0; i < waiting.length; ++i) {
                int idx;
                msg = (Message)waiting[i];
                PoolNetwork.this.logmon.log(BasicLevel.WARN, (Object)(PoolNetwork.this.getName() + ", insert msg (" + msg + ')'));
                for (idx = 0; idx < this.elementCount; ++idx) {
                    Message current = (Message)this.elementData[idx];
                    if (current.not != null && current.stamp > msg.stamp) break;
                }
                this.insertElementAt(msg, idx);
            }
        }

        public synchronized void insertAck(Message ack) {
            int idx;
            ++this.modCount;
            PoolNetwork.this.logmon.log(BasicLevel.WARN, (Object)(PoolNetwork.this.getName() + ", insert ack (" + ack + ')'));
            for (idx = 0; idx < this.elementCount; ++idx) {
                Message current = (Message)this.elementData[idx];
                if (current.not == null && current.stamp == ack.stamp) {
                    return;
                }
                if (current.not != null || current.stamp > ack.stamp) break;
            }
            this.insertElementAt(ack, idx);
        }
    }

    final class WatchDog
    extends Daemon {
        private Object lock;

        WatchDog(String name, Logger logmon) {
            super(name + ".watchdog");
            this.lock = new Object();
            this.logmon = logmon;
        }

        protected void close() {
        }

        protected void shutdown() {
            this.wakeup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void wakeup() {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                Object object = this.lock;
                synchronized (object) {
                    block9: while (this.running) {
                        block16: {
                            try {
                                this.lock.wait(PoolNetwork.this.WDActivationPeriod);
                                if (!this.logmon.isLoggable(BasicLevel.DEBUG)) break block16;
                                this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", activated"));
                            }
                            catch (InterruptedException exc) {
                                continue;
                            }
                        }
                        if (!this.running) {
                            return;
                        }
                        long currentTimeMillis = System.currentTimeMillis();
                        try {
                            int sid = 0;
                            while (true) {
                                if (sid >= PoolNetwork.this.sessions.length) continue block9;
                                if (PoolNetwork.this.sessions[sid] != null) {
                                    if (PoolNetwork.this.sessions[sid].sendList.size() > 0 && !PoolNetwork.this.sessions[sid].running) {
                                        PoolNetwork.this.sessions[sid].start(currentTimeMillis);
                                    } else if (PoolNetwork.this.IdleTimeout > 0L && PoolNetwork.this.sessions[sid].running && currentTimeMillis > PoolNetwork.this.sessions[sid].last + PoolNetwork.this.IdleTimeout) {
                                        PoolNetwork.this.sessions[sid].stop();
                                    }
                                }
                                ++sid;
                            }
                        }
                        catch (Exception exc) {
                            this.logmon.log(BasicLevel.ERROR, (Object)this.getName(), (Throwable)exc);
                        }
                    }
                    return;
                }
            }
            finally {
                this.logmon.log(BasicLevel.WARN, (Object)(this.getName() + ", ended"));
                this.finish();
            }
        }
    }

    final class Dispatcher
    extends Daemon {
        Dispatcher(String name, Logger logmon) {
            super(name + ".dispatcher");
            this.logmon = logmon;
        }

        protected void close() {
        }

        protected void shutdown() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Message msg = null;
            try {
                while (this.running) {
                    this.canStop = true;
                    if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                        this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", waiting message"));
                    }
                    do {
                        if ((msg = PoolNetwork.this.qout.removeExpired(System.currentTimeMillis())) == null) continue;
                        this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", Handles expired message: " + msg));
                        if (msg.not.deadNotificationAgentId != null) {
                            ExpiredNot expiredNot = new ExpiredNot(msg.not, msg.from, msg.to);
                            try {
                                AgentServer.getTransaction().begin();
                                Channel.post(Message.alloc(AgentId.localId, msg.not.deadNotificationAgentId, expiredNot));
                                Channel.validate();
                                AgentServer.getTransaction().commit(true);
                            }
                            catch (Exception e) {
                                this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", cannot post ExpireNotification"), (Throwable)e);
                                continue;
                            }
                        }
                        try {
                            msg.delete();
                        }
                        catch (IOException exc) {
                            this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", cannot delete message"), (Throwable)exc);
                        }
                        msg.free();
                    } while (msg != null);
                    try {
                        msg = PoolNetwork.this.qout.get();
                    }
                    catch (InterruptedException exc) {
                        if (!this.logmon.isLoggable(BasicLevel.DEBUG)) continue;
                        this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", interrupted"));
                        continue;
                    }
                    this.canStop = false;
                    if (!this.running) {
                        break;
                    }
                    PoolNetwork.this.poolSender.send(msg);
                    PoolNetwork.this.qout.pop();
                    Thread.yield();
                }
            }
            finally {
                this.finish();
            }
        }
    }

    final class WakeOnConnection
    extends Daemon {
        ServerSocket listen;

        WakeOnConnection(String name, Logger logmon) throws IOException {
            super(name + ".wakeOnConnection");
            this.listen = null;
            this.listen = PoolNetwork.this.createServerSocket();
            this.logmon = logmon;
        }

        protected void close() {
            try {
                this.listen.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.listen = null;
        }

        protected void shutdown() {
            this.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Socket sock = null;
            try {
                if (this.listen == null) {
                    this.listen = PoolNetwork.this.createServerSocket();
                }
                while (this.running) {
                    try {
                        this.canStop = true;
                        try {
                            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                                this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", waiting connection"));
                            }
                            sock = this.listen.accept();
                        }
                        catch (IOException exc) {
                            if (!this.running) continue;
                            this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", error during waiting connection"), (Throwable)exc);
                            continue;
                        }
                        this.canStop = false;
                        PoolNetwork.this.setSocketOption(sock);
                        Boot boot = PoolNetwork.this.readBoot(sock.getInputStream());
                        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", connection setup from #" + boot.sid));
                        }
                        PoolNetwork.this.getSession(boot.sid).start(sock, boot.boot);
                    }
                    catch (Exception exc) {
                        this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", bad connection setup"), (Throwable)exc);
                    }
                }
            }
            catch (IOException exc) {
                this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", bad socket initialisation"), (Throwable)exc);
            }
            finally {
                this.finish();
            }
        }
    }

    final class MessageVector
    extends Vector {
        private static final long serialVersionUID = 1L;

        MessageVector() {
        }

        public synchronized Message removeMessage(int stamp) {
            Message msg = null;
            ++this.modCount;
            for (int index = 0; index < this.elementCount; ++index) {
                try {
                    msg = (Message)this.elementData[index];
                }
                catch (ClassCastException exc) {
                    continue;
                }
                if (msg.getStamp() != stamp) continue;
                int j = this.elementCount - index - 1;
                if (j > 0) {
                    System.arraycopy(this.elementData, index + 1, this.elementData, index, j);
                }
                --this.elementCount;
                this.elementData[this.elementCount] = null;
                return msg;
            }
            throw new NoSuchElementException();
        }
    }
}

