/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.interceptors;

import com.sun.xml.bind.v2.runtime.JAXBContextImpl;
import com.sun.xml.bind.v2.util.DataSourceSource;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.mail.util.ByteArrayDataSource;
import javax.xml.bind.JAXBContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.cxf.attachment.AttachmentImpl;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.binding.soap.model.SoapBodyInfo;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.AttachmentOutInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxws.interceptors.HolderOutInterceptor;
import org.apache.cxf.jaxws.interceptors.WrapperClassOutInterceptor;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.staxutils.StaxUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwAOutInterceptor
extends AbstractSoapInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(SwAOutInterceptor.class);
    private static final boolean HAS_SWA_REF_METHOD;
    AttachmentOutInterceptor attachOut = new AttachmentOutInterceptor();

    public SwAOutInterceptor() {
        super("pre-logical");
        this.addAfter(HolderOutInterceptor.class.getName());
        this.addBefore(WrapperClassOutInterceptor.class.getName());
    }

    @Override
    public void handleMessage(SoapMessage message) throws Fault {
        boolean client;
        BindingMessageInfo bmi;
        Exchange ex = message.getExchange();
        BindingOperationInfo bop = ex.get(BindingOperationInfo.class);
        if (bop == null) {
            return;
        }
        if (bop.isUnwrapped()) {
            bop = bop.getWrappedOperation();
        }
        BindingMessageInfo bindingMessageInfo = bmi = (client = this.isRequestor(message)) ? bop.getInput() : bop.getOutput();
        if (bmi == null) {
            return;
        }
        SoapBodyInfo sbi = bmi.getExtensor(SoapBodyInfo.class);
        if (sbi == null || sbi.getAttachments() == null || sbi.getAttachments().size() == 0) {
            Service s = ex.get(Service.class);
            DataBinding db = s.getDataBinding();
            if (db instanceof JAXBDataBinding && this.hasSwaRef((JAXBDataBinding)db)) {
                this.setupAttachmentOutput(message);
            }
            return;
        }
        Collection<Attachment> atts = this.setupAttachmentOutput(message);
        List outObjects = CastUtils.cast(message.getContent(List.class));
        for (MessagePartInfo mpi : sbi.getAttachments()) {
            String partName = mpi.getConcreteName().getLocalPart();
            String ct = (String)mpi.getProperty("Content-Type");
            String id = partName + "=" + UUID.randomUUID() + "@apache.org";
            int idx = mpi.getIndex();
            Object o = outObjects.get(idx);
            if (o == null) continue;
            outObjects.set(idx, null);
            DataHandler dh = null;
            if (o instanceof Source) {
                dh = new DataHandler(this.createDataSource((Source)o, ct));
            } else if (o instanceof Image) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream(2048);
                Iterator<ImageWriter> writers = ImageIO.getImageWritersByMIMEType(ct);
                if (writers.hasNext()) {
                    ImageWriter writer = writers.next();
                    try {
                        BufferedImage bimg = this.convertToBufferedImage((Image)o);
                        ImageOutputStream out = ImageIO.createImageOutputStream(bos);
                        writer.setOutput(out);
                        writer.write(bimg);
                        writer.dispose();
                        out.flush();
                        out.close();
                        bos.close();
                    }
                    catch (IOException e) {
                        throw new Fault(e);
                    }
                } else {
                    throw new Fault(new Message("ATTACHMENT_NOT_SUPPORTED", LOG, ct));
                }
                dh = new DataHandler(new ByteArrayDataSource(bos.toByteArray(), ct));
            } else if (o instanceof DataHandler) {
                dh = (DataHandler)o;
                ct = dh.getContentType();
                try {
                    if ("text/xml".equals(ct) && dh.getContent() instanceof Source) {
                        dh = new DataHandler(this.createDataSource((Source)dh.getContent(), ct));
                    }
                }
                catch (IOException e) {}
            } else if (o instanceof byte[]) {
                if (ct == null) {
                    ct = "application/octet-stream";
                }
                dh = new DataHandler(new ByteArrayDataSource((byte[])o, ct));
            } else {
                throw new Fault(new Message("ATTACHMENT_NOT_SUPPORTED", LOG, o.getClass()));
            }
            AttachmentImpl att = new AttachmentImpl(id);
            att.setDataHandler(dh);
            att.setHeader("Content-Type", ct);
            atts.add(att);
        }
    }

    private boolean hasSwaRef(JAXBDataBinding db) {
        JAXBContext context = db.getContext();
        if (HAS_SWA_REF_METHOD && context instanceof JAXBContextImpl) {
            return ((JAXBContextImpl)context).hasSwaRef();
        }
        return false;
    }

    private DataSource createDataSource(Source o, String ct) {
        DataSource ds = null;
        if (o instanceof DataSourceSource) {
            ds = (DataSource)((Object)o);
        } else if (o instanceof StreamSource) {
            StreamSource src = (StreamSource)o;
            try {
                if (src.getInputStream() != null) {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream(2048);
                    IOUtils.copy(src.getInputStream(), bos, 1024);
                    ds = new ByteArrayDataSource(bos.toByteArray(), ct);
                }
                ds = new ByteArrayDataSource(IOUtils.toString(src.getReader()), ct);
            }
            catch (IOException e) {
                throw new Fault(e);
            }
        } else {
            XMLStreamReader reader = StaxUtils.createXMLStreamReader(o);
            StringWriter stringWriter = new StringWriter();
            XMLStreamWriter writer = StaxUtils.createXMLStreamWriter(stringWriter);
            try {
                StaxUtils.copy(reader, writer);
                writer.flush();
                ds = new ByteArrayDataSource(stringWriter.toString(), ct);
            }
            catch (XMLStreamException e1) {
                throw new Fault(e1);
            }
            catch (IOException e) {
                throw new Fault(e);
            }
        }
        return ds;
    }

    private BufferedImage convertToBufferedImage(Image image) throws IOException {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        MediaTracker tracker = new MediaTracker(new Component(){});
        tracker.addImage(image, 0);
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException e) {
            throw new Fault(e);
        }
        BufferedImage bufImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g = bufImage.createGraphics();
        g.drawImage(image, 0, 0, null);
        return bufImage;
    }

    private Collection<Attachment> setupAttachmentOutput(SoapMessage message) {
        message.getInterceptorChain().add(this.attachOut);
        message.put("write.attachments", (Object)Boolean.TRUE);
        Collection<Attachment> atts = message.getAttachments();
        if (atts == null) {
            atts = new ArrayList<Attachment>();
            message.setAttachments(atts);
        }
        return atts;
    }

    static {
        Class<JAXBContextImpl> cls = JAXBContextImpl.class;
        Method m = null;
        try {
            m = cls.getMethod("hasSwaRef", new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        HAS_SWA_REF_METHOD = m != null;
    }
}

