/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.spring;

import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.BusWiringBeanFactoryPostProcessor;
import org.apache.cxf.configuration.spring.StringBeanDefinitionParser;
import org.apache.cxf.frontend.spring.ServerFactoryBeanDefinitionParser;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.jaxws.spring.EndpointDefinitionParser;
import org.apache.cxf.jaxws.spring.JaxWsProxyFactoryBeanDefinitionParser;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class NamespaceHandler
extends NamespaceHandlerSupport {
    public void init() {
        this.registerBeanDefinitionParser("client", new JaxWsProxyFactoryBeanDefinitionParser());
        this.registerBeanDefinitionParser("endpoint", new EndpointDefinitionParser());
        this.registerBeanDefinitionParser("schemaLocation", new StringBeanDefinitionParser());
        ServerFactoryBeanDefinitionParser parser2 = new ServerFactoryBeanDefinitionParser();
        parser2.setBeanClass(SpringServerFactoryBean.class);
        this.registerBeanDefinitionParser("server", parser2);
    }

    public static class SpringServerFactoryBean
    extends JaxWsServerFactoryBean
    implements ApplicationContextAware {
        public SpringServerFactoryBean() {
        }

        public SpringServerFactoryBean(JaxWsServiceFactoryBean fact) {
            super(fact);
        }

        public void setApplicationContext(ApplicationContext ctx) throws BeansException {
            if (this.getBus() == null) {
                Bus bus = BusFactory.getThreadDefaultBus();
                BusWiringBeanFactoryPostProcessor.updateBusReferencesInContext(bus, ctx);
                this.setBus(bus);
            }
        }
    }
}

