/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.processors.idl;

import java.util.Iterator;
import org.apache.cxf.binding.corba.wsdl.CorbaTypeImpl;
import org.apache.cxf.binding.corba.wsdl.ParamType;
import org.apache.cxf.tools.corba.common.ReferenceConstants;
import org.apache.cxf.tools.corba.processors.idl.ModuleToNSMapper;
import org.apache.cxf.tools.corba.processors.idl.SchemaDeferredAction;
import org.apache.cxf.tools.corba.processors.idl.Scope;
import org.apache.cxf.tools.corba.processors.idl.WSDLSchemaManager;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaImport;
import org.apache.ws.commons.schema.XmlSchemaType;

public class ParamDeferredAction
implements SchemaDeferredAction {
    protected ParamType param;
    protected XmlSchemaElement element;
    protected XmlSchema schema;
    protected XmlSchemaCollection schemas;
    protected Scope typeScope;
    protected WSDLSchemaManager manager;
    protected ModuleToNSMapper mapper;

    public ParamDeferredAction(ParamType defParam, XmlSchemaElement elem) {
        this.param = defParam;
        this.element = elem;
    }

    public ParamDeferredAction(ParamType defParam) {
        this.param = defParam;
    }

    public ParamDeferredAction(XmlSchemaElement elem) {
        this.element = elem;
    }

    public ParamDeferredAction(XmlSchemaElement elem, Scope ts, XmlSchema xmlSchema, XmlSchemaCollection xmlSchemas, WSDLSchemaManager man, ModuleToNSMapper map) {
        this.element = elem;
        this.schema = xmlSchema;
        this.schemas = xmlSchemas;
        this.typeScope = ts;
        this.manager = man;
        this.mapper = map;
    }

    public void execute(XmlSchemaType stype, CorbaTypeImpl ctype) {
        if (this.param != null) {
            this.param.setIdltype(ctype.getQName());
        }
        if (this.element != null) {
            this.element.setSchemaTypeName(stype.getQName());
            if (stype.getQName().equals(ReferenceConstants.WSADDRESSING_TYPE)) {
                this.element.setNillable(true);
            }
            if (this.manager == null) {
                return;
            }
            XmlSchema importedSchema = null;
            if (stype.getQName().getNamespaceURI().equals("http://www.w3.org/2005/08/addressing")) {
                boolean alreadyImported = false;
                Iterator i = this.schema.getIncludes().getIterator();
                while (i.hasNext()) {
                    XmlSchemaImport schemaImport;
                    Object o = i.next();
                    if (!(o instanceof XmlSchemaImport) || !(schemaImport = (XmlSchemaImport)o).getNamespace().equals("http://www.w3.org/2005/08/addressing")) continue;
                    alreadyImported = true;
                    break;
                }
                if (!alreadyImported) {
                    XmlSchemaImport wsaImport = new XmlSchemaImport();
                    wsaImport.setNamespace("http://www.w3.org/2005/08/addressing");
                    wsaImport.setSchemaLocation("http://www.w3.org/2005/08/addressing/ws-addr.xsd");
                    this.schema.getItems().add(wsaImport);
                    this.schema.getIncludes().add(wsaImport);
                }
            } else if (!stype.getQName().getNamespaceURI().equals(this.schema.getTargetNamespace())) {
                importedSchema = this.manager.getXmlSchema(this.mapper.map(this.typeScope));
                this.manager.addXmlSchemaImport(this.schema, importedSchema, this.typeScope.toString("_"));
            }
        }
    }
}

