/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.processors.idl;

import antlr.collections.AST;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public final class Scope
implements Comparable {
    private static final String SEPARATOR = ".";
    private List<String> scope;
    private Scope parent;

    public Scope() {
        this.scope = new ArrayList<String>();
        this.parent = this;
    }

    public Scope(String scopes, String separator) {
        StringTokenizer tokens = new StringTokenizer(scopes, separator);
        Scope rootScope = new Scope();
        Scope prevScope = rootScope.parent;
        this.scope = rootScope.scope;
        this.parent = this;
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            this.parent = prevScope;
            prevScope = new Scope(prevScope, token);
            this.scope.add(token);
        }
    }

    public Scope(Scope containingScope) {
        this.scope = new ArrayList<String>(containingScope.scope);
        this.parent = containingScope.getParent();
    }

    public Scope(Scope containingScope, String str) {
        this.scope = new ArrayList<String>(containingScope.scope);
        this.scope.add(str);
        this.parent = containingScope;
    }

    public Scope(Scope containingScope, Scope prefixScope, String str) {
        this.scope = new ArrayList<String>(containingScope.scope);
        this.scope.addAll(prefixScope.scope);
        this.scope.add(str);
        this.parent = containingScope;
    }

    public Scope(Scope containingScope, AST node) {
        this.scope = new ArrayList<String>(containingScope.scope);
        if (node != null) {
            this.scope.add(((Object)node).toString());
        }
        this.parent = containingScope;
    }

    public String tail() {
        int size = this.scope.size();
        if (size > 0) {
            return this.scope.get(size - 1);
        }
        return "";
    }

    public Scope getParent() {
        return this.parent;
    }

    public String toString(String separator) {
        StringBuffer result = new StringBuffer();
        Iterator<String> it = this.scope.iterator();
        while (it.hasNext()) {
            result.append(it.next());
            if (!it.hasNext()) continue;
            result.append(separator);
        }
        return result.toString();
    }

    public String toString() {
        return this.toString(SEPARATOR);
    }

    public String toIDLRepositoryID() {
        StringBuffer result = new StringBuffer();
        result.append("IDL:");
        result.append(this.toString("/"));
        result.append(":1.0");
        return result.toString();
    }

    public boolean equals(Object otherScope) {
        if (otherScope instanceof Scope) {
            return this.toString().equals(((Scope)otherScope).toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public int compareTo(Object otherScope) {
        if (otherScope == null) {
            throw new RuntimeException("Cannot compare a null object");
        }
        if (otherScope instanceof Scope) {
            return this.toString().compareTo(otherScope.toString());
        }
        throw new ClassCastException("Scope class expected but found " + otherScope.getClass().getName());
    }
}

