/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy.builder.primitive;

import java.util.Collection;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.policy.PolicyAssertion;
import org.apache.cxf.ws.policy.PolicyConstants;
import org.apache.neethi.All;
import org.apache.neethi.ExactlyOne;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class PrimitiveAssertion
implements PolicyAssertion {
    protected QName name;
    protected boolean optional;

    public PrimitiveAssertion() {
        this(null);
    }

    public PrimitiveAssertion(QName n) {
        this(n, false);
    }

    public PrimitiveAssertion(QName n, boolean o) {
        this.name = n;
        this.optional = o;
    }

    public PrimitiveAssertion(Element element, PolicyConstants constants) {
        this.name = new QName(element.getNamespaceURI(), element.getLocalName());
        Attr attribute = element.getAttributeNodeNS(constants.getNamespace(), constants.getOptionalAttrName());
        if (attribute != null) {
            this.optional = Boolean.valueOf(attribute.getValue());
        }
    }

    public String toString() {
        return this.name.toString();
    }

    public boolean equal(PolicyComponent policyComponent) {
        if (policyComponent.getType() != 5) {
            return false;
        }
        return this.getName().equals(((PolicyAssertion)policyComponent).getName());
    }

    public short getType() {
        return 5;
    }

    public QName getName() {
        return this.name;
    }

    public void setName(QName n) {
        this.name = n;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean o) {
        this.optional = o;
    }

    public PolicyComponent normalize() {
        if (this.isOptional()) {
            Policy policy = new Policy();
            ExactlyOne exactlyOne = new ExactlyOne();
            All all = new All();
            all.addPolicyComponent(this.cloneMandatory());
            exactlyOne.addPolicyComponent(all);
            exactlyOne.addPolicyComponent(new All());
            policy.addPolicyComponent(exactlyOne);
            return policy;
        }
        return this.cloneMandatory();
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
    }

    protected PolicyAssertion cloneMandatory() {
        return new PrimitiveAssertion(this.name, false);
    }

    public Policy getPolicy() {
        return null;
    }

    public boolean isAsserted(AssertionInfoMap aim) {
        Collection<AssertionInfo> ail = aim.getAssertionInfo(this.name);
        for (AssertionInfo ai : ail) {
            if (!ai.isAsserted() || !ai.getAssertion().equal(this)) continue;
            return true;
        }
        return false;
    }
}

