/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.AbstractSecurityAssertion;
import org.apache.cxf.ws.security.policy.model.Header;
import org.apache.neethi.PolicyComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequiredParts
extends AbstractSecurityAssertion {
    private List<Header> headers = new ArrayList<Header>();

    public RequiredParts(SPConstants version2) {
        super(version2);
    }

    public List<Header> getHeaders() {
        return this.headers;
    }

    public void addHeader(Header header) {
        this.headers.add(header);
    }

    @Override
    public QName getName() {
        return SP12Constants.REQUIRED_PARTS;
    }

    @Override
    public PolicyComponent normalize() {
        return this;
    }

    @Override
    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String localName = this.getName().getLocalPart();
        String namespaceURI = this.getName().getNamespaceURI();
        String prefix = writer.getPrefix(namespaceURI);
        if (prefix == null) {
            prefix = this.getName().getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        }
        writer.writeStartElement(prefix, localName, namespaceURI);
        writer.writeNamespace(prefix, namespaceURI);
        for (Header header : this.headers) {
            writer.writeStartElement(prefix, "Header", namespaceURI);
            if (header.getName() != null) {
                writer.writeAttribute("Name", header.getName());
            }
            writer.writeAttribute("Namespace", header.getNamespace());
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }
}

