/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.perseus.cache.replacement.lib;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.perseus.cache.api.CacheCapacityEvent;
import org.objectweb.perseus.cache.api.CacheCapacityEventListener;
import org.objectweb.perseus.cache.api.CacheEntryFilter;
import org.objectweb.perseus.cache.api.CacheException;
import org.objectweb.perseus.cache.api.FixableCacheEntry;
import org.objectweb.perseus.cache.api.UnbindManager;
import org.objectweb.perseus.cache.replacement.api.ReplaceableCacheEntry;
import org.objectweb.perseus.cache.replacement.api.ReplacementManager;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public abstract class AbstractReplacementManager
implements ReplacementManager,
BindingController,
CacheCapacityEventListener {
    public static final String UNBIND_MANAGER_BINDING = "unbind-manager";
    protected UnbindManager ub;
    protected SortedSet entries = new TreeSet();
    protected HashMap oid2wentry = new HashMap();
    protected ReferenceQueue queue = new ReferenceQueue();
    protected Logger logger = null;

    public String[] listFc() {
        return new String[]{UNBIND_MANAGER_BINDING};
    }

    public Object lookupFc(String s) {
        if (UNBIND_MANAGER_BINDING.equals(s)) {
            return this.ub;
        }
        return null;
    }

    public void bindFc(String s, Object o) {
        if (UNBIND_MANAGER_BINDING.equals(s)) {
            this.ub = (UnbindManager)o;
        } else if ("logger".equals(s)) {
            this.logger = (Logger)o;
        }
    }

    public void unbindFc(String s) {
        if (UNBIND_MANAGER_BINDING.equals(s)) {
            this.ub = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheResized(CacheCapacityEvent event) {
        int size = event.getSize();
        if (size > 0) {
            SortedSet sortedSet = this.entries;
            synchronized (sortedSet) {
                if (this.oid2wentry.size() == 0) {
                    this.oid2wentry = new HashMap(size);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addForReplacement(FixableCacheEntry entry) throws CacheException {
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("add the entry " + entry.getCeIdentifier()));
        }
        ReplaceableCacheEntry dentry = this.check(entry);
        SortedSet sortedSet = this.entries;
        synchronized (sortedSet) {
            this.clean();
            WeakReplaceableCacheEntry we = (WeakReplaceableCacheEntry)this.oid2wentry.get(entry.getCeIdentifier());
            this.add(dentry);
            if (we != null) {
                this.entries.remove(we);
                we.updateEntry((ReplaceableCacheEntry)entry);
            } else {
                we = new WeakReplaceableCacheEntry(dentry, this.queue);
                this.oid2wentry.put(entry.getCeIdentifier(), we);
            }
            this.entries.add(we);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adjustForReplacement(FixableCacheEntry entry) throws CacheException {
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("touch the entry " + entry.getCeIdentifier()));
        }
        ReplaceableCacheEntry dentry = this.check(entry);
        SortedSet sortedSet = this.entries;
        synchronized (sortedSet) {
            this.clean();
            WeakReplaceableCacheEntry we = (WeakReplaceableCacheEntry)this.oid2wentry.get(entry.getCeIdentifier());
            this.touch(dentry);
            if (we != null) {
                this.entries.remove(we);
                we.updateEntry((ReplaceableCacheEntry)entry);
            } else {
                we = new WeakReplaceableCacheEntry(dentry, this.queue);
                this.oid2wentry.put(entry.getCeIdentifier(), we);
            }
            this.entries.add(we);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int forceFree(int capacity) throws CacheException {
        boolean debug = this.logger.isLoggable(BasicLevel.DEBUG);
        if (debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("forceFree: requested: " + capacity));
        }
        ArrayList<Object> oids = new ArrayList<Object>(capacity);
        int count = 0;
        SortedSet sortedSet = this.entries;
        synchronized (sortedSet) {
            Iterator i = this.entries.iterator();
            while (count < capacity && i.hasNext()) {
                WeakReplaceableCacheEntry wentry = (WeakReplaceableCacheEntry)i.next();
                ReplaceableCacheEntry entry = (ReplaceableCacheEntry)wentry.get();
                if (entry == null || entry.getCeFixCount() != 0) continue;
                oids.add(entry.getCeIdentifier());
                ++count;
            }
        }
        if (debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("forceFree: try to unbound, oids=" + oids));
        }
        Collection _oids = this.ub.unbindAll(oids, false);
        if (debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("forceFree: entries unbound, oid=" + _oids));
        }
        return _oids.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeForReplacement(Object oid) {
        SortedSet sortedSet = this.entries;
        synchronized (sortedSet) {
            Object we = this.oid2wentry.remove(oid);
            if (we != null) {
                this.entries.remove(we);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection unbind(CacheEntryFilter filter, boolean force) throws CacheException {
        ArrayList<Object> oids;
        SortedSet sortedSet = this.entries;
        synchronized (sortedSet) {
            if (this.entries.isEmpty()) {
                return Collections.EMPTY_SET;
            }
            oids = new ArrayList<Object>();
            Iterator it = this.entries.iterator();
            while (it.hasNext()) {
                ReplaceableCacheEntry ce;
                WeakReplaceableCacheEntry wentry = (WeakReplaceableCacheEntry)it.next();
                if (wentry == null || (ce = (ReplaceableCacheEntry)wentry.get()) == null || !filter.accept(ce)) continue;
                oids.add(wentry.getCeIdentifier());
            }
        }
        boolean debug = this.logger.isLoggable(BasicLevel.DEBUG);
        if (debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("unbindAll(oids, " + force + ") try to unbound, oids=" + oids));
        }
        Collection res = this.ub.unbindAll(oids, force);
        if (debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("entries unbound, oid=" + res));
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection unbindAll(Collection _oids, boolean force) throws CacheException {
        ArrayList oids;
        boolean debug = this.logger.isLoggable(BasicLevel.DEBUG);
        SortedSet sortedSet = this.entries;
        synchronized (sortedSet) {
            if (this.entries.isEmpty()) {
                return Collections.EMPTY_SET;
            }
            oids = new ArrayList();
            Iterator it = _oids.iterator();
            while (it.hasNext()) {
                Object oid = it.next();
                WeakReplaceableCacheEntry wentry = (WeakReplaceableCacheEntry)this.oid2wentry.get(oid);
                if (wentry == null) continue;
                oids.add(oid);
            }
        }
        if (debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("unbindAll(oids, " + force + ") try to unbound, oids=" + oids));
        }
        _oids = this.ub.unbindAll(oids, force);
        if (debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("entries unbound, oid=" + _oids));
        }
        return _oids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindAll(boolean force) throws CacheException {
        boolean debug = this.logger.isLoggable(BasicLevel.DEBUG);
        SortedSet sortedSet = this.entries;
        synchronized (sortedSet) {
            if (this.entries.isEmpty()) {
                return;
            }
            this.entries.clear();
            this.oid2wentry.clear();
        }
        if (debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("unbindAll(" + force + ") try to unbound"));
        }
        this.ub.unbindAll(force);
        if (debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)"all entries unbound");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection unbindUnfixed(boolean force) throws CacheException {
        ArrayList<Object> oids;
        boolean debug = this.logger.isLoggable(BasicLevel.DEBUG);
        SortedSet sortedSet = this.entries;
        synchronized (sortedSet) {
            if (this.entries.isEmpty()) {
                return Collections.EMPTY_SET;
            }
            oids = new ArrayList<Object>();
            Iterator it = this.entries.iterator();
            while (it.hasNext()) {
                WeakReplaceableCacheEntry wentry = (WeakReplaceableCacheEntry)it.next();
                ReplaceableCacheEntry ce = (ReplaceableCacheEntry)wentry.get();
                if (ce != null && ce.getCeFixCount() != 0) continue;
                oids.add(wentry.getCeIdentifier());
            }
        }
        if (debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("unbindAll(" + force + ") try to unbound, oids=" + oids));
        }
        Collection _oids = this.ub.unbindAll(oids, force);
        if (debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("entries unbound, oid=" + _oids));
        }
        return _oids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unbind(Object oid, boolean force) throws CacheException {
        WeakReplaceableCacheEntry we;
        boolean debug = this.logger.isLoggable(BasicLevel.DEBUG);
        if (oid == null) {
            return false;
        }
        if (debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("unbind, oid=" + oid));
        }
        try {
            we = (WeakReplaceableCacheEntry)this.oid2wentry.get(oid);
        }
        catch (Throwable e) {
            SortedSet sortedSet = this.entries;
            synchronized (sortedSet) {
                we = (WeakReplaceableCacheEntry)this.oid2wentry.get(oid);
            }
        }
        if (we != null) {
            return this.ub.unbind(oid, force);
        }
        this.logger.log(BasicLevel.WARN, (Object)"The entry has not been found from the cache");
        return false;
    }

    private ReplaceableCacheEntry check(FixableCacheEntry entry) {
        try {
            return (ReplaceableCacheEntry)entry;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("This replacement manager works only with ReplaceableCacheEntry entries");
        }
    }

    protected abstract void add(ReplaceableCacheEntry var1);

    protected abstract void touch(ReplaceableCacheEntry var1);

    private void clean() {
        WeakReplaceableCacheEntry wentry;
        boolean debug = this.logger.isLoggable(BasicLevel.DEBUG);
        while ((wentry = (WeakReplaceableCacheEntry)this.queue.poll()) != null) {
            if (debug) {
                this.logger.log(BasicLevel.DEBUG, (Object)("auto cleanup, oid=" + wentry.getCeIdentifier()));
            }
            this.entries.remove(wentry);
            this.oid2wentry.remove(wentry.getCeIdentifier());
        }
    }

    private static class WeakReplaceableCacheEntry
    extends WeakReference
    implements Comparable {
        private long date;
        private Object oid;

        public WeakReplaceableCacheEntry(ReplaceableCacheEntry ce, ReferenceQueue queue) {
            super(ce, queue);
            this.oid = ce.getCeIdentifier();
            this.date = ce.getCeAge();
        }

        public Object getCeIdentifier() {
            return this.oid;
        }

        public int compareTo(Object o) {
            long odate = ((WeakReplaceableCacheEntry)o).date;
            if (this.date == odate) {
                return 0;
            }
            return this.date < odate ? -1 : 1;
        }

        public boolean equals(Object o) {
            return this.date == ((WeakReplaceableCacheEntry)o).date;
        }

        public void updateEntry(ReplaceableCacheEntry ce) {
            this.oid = ce.getCeIdentifier();
            this.date = ce.getCeAge();
        }
    }
}

