/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.monolog.wrapper.javaLog;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogManager;
import org.objectweb.util.monolog.Monolog;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.wrapper.common.AbstractFactory;
import org.objectweb.util.monolog.wrapper.javaLog.JDKLevelImpl;
import org.objectweb.util.monolog.wrapper.javaLog.LevelImpl;
import org.objectweb.util.monolog.wrapper.javaLog.Logger;

public class LoggerFactory
extends AbstractFactory {
    protected static LogManager manager = null;
    protected static Logger rootLogger = null;
    private ArrayList loggers = new ArrayList();
    public static final String JAVALOG_CONFIGURATION = "javaLogConfiguration";
    public static final String DEFAULT = "default";
    public static final String PROPERTY = "property";
    public static final String CLASS = "class";
    public static final String JAVALOG_CONFIGURATION_FILE = "javaLogConfigurationFile";
    public static final String JAVALOG_CONFIGURATION_CLASS = "javaLogConfigurationClass";
    static /* synthetic */ Class class$org$objectweb$util$monolog$wrapper$javaLog$LoggerFactory;

    public String getWrapperName() {
        return "javaLog";
    }

    protected String[][] getDefaultHandlerType2className() {
        if (handlerTypes != null) {
            return new String[][]{{handlerTypes[0], "org.objectweb.util.monolog.wrapper.javaLog.GenericHandler"}, {handlerTypes[1], "org.objectweb.util.monolog.wrapper.javaLog.GenericHandler"}, {handlerTypes[2], "org.objectweb.util.monolog.wrapper.javaLog.GenericHandler"}, {handlerTypes[3], "org.objectweb.util.monolog.wrapper.javaLog.GenericHandler"}, {handlerTypes[4], "org.objectweb.util.monolog.wrapper.javaLog.JMXGenericHandler"}, {handlerTypes[5], "org.objectweb.util.monolog.wrapper.javaLog.GenericHandler"}, {handlerTypes[6], "org.objectweb.util.monolog.wrapper.javaLog.GenericHandler"}};
        }
        return new String[0][];
    }

    protected synchronized Logger getMonoLogger(String name, String resName) {
        if (name == null) {
            throw new IllegalArgumentException("The specified Logger name is null");
        }
        if (name.equals("root") || name.length() == 0) {
            return rootLogger;
        }
        name = LoggerFactory.monoLoggerName(name);
        java.util.logging.Logger o = null;
        if (manager != null) {
            o = manager.getLogger(name);
        }
        if (o == null) {
            Logger result = new Logger(name, resName);
            if (manager != null) {
                manager.addLogger(result);
            }
            Monolog.debug("Instanciate the logger " + name);
            this.loggers.add(result);
            return result;
        }
        if (o instanceof Logger) {
            Monolog.debug("return existing logger " + name);
            return (Logger)o;
        }
        return new Logger(o);
    }

    public void configure(Properties prop) throws Exception {
        if (prop == null) {
            return;
        }
        String confMode = prop.getProperty(JAVALOG_CONFIGURATION, null);
        if (confMode == null) {
            return;
        }
        String param = null;
        if (confMode.equals(PROPERTY)) {
            param = prop.getProperty(JAVALOG_CONFIGURATION_FILE, null);
            if (param != null) {
                System.setProperty("java.util.logging.config.file", param);
            }
            manager.readConfiguration();
        } else if (confMode.equals(CLASS)) {
            param = prop.getProperty(JAVALOG_CONFIGURATION_CLASS, null);
            if (param != null) {
                System.setProperty("java.util.logging.config.class", param);
            }
            manager.readConfiguration();
        }
    }

    public org.objectweb.util.monolog.api.Logger getLogger(String key) {
        return this.getMonoLogger(key, this.resourceBundleName);
    }

    public org.objectweb.util.monolog.api.Logger getLogger(String key, String rbn) {
        return this.getMonoLogger(key, rbn);
    }

    public org.objectweb.util.monolog.api.Logger[] getLoggers() {
        ArrayList<java.util.logging.Logger> res = new ArrayList<java.util.logging.Logger>();
        Enumeration<String> e = manager.getLoggerNames();
        while (e.hasMoreElements()) {
            java.util.logging.Logger o = manager.getLogger(e.nextElement());
            if (!(o instanceof Logger)) continue;
            res.add(o);
        }
        return res.toArray(new Logger[0]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        LoggerFactory.debug("Initializing " + (class$org$objectweb$util$monolog$wrapper$javaLog$LoggerFactory == null ? (class$org$objectweb$util$monolog$wrapper$javaLog$LoggerFactory = LoggerFactory.class$("org.objectweb.util.monolog.wrapper.javaLog.LoggerFactory")) : class$org$objectweb$util$monolog$wrapper$javaLog$LoggerFactory).getName());
        LoggerFactory.debug("set default level values");
        BasicLevel.INHERIT = -1;
        LoggerFactory.debug("\t-INHERIT= " + BasicLevel.INHERIT);
        BasicLevel.DEBUG = Level.FINEST.intValue();
        LoggerFactory.debug("\t-DEBUG= " + BasicLevel.DEBUG);
        BasicLevel.INFO = Level.INFO.intValue();
        LoggerFactory.debug("\t-INFO= " + BasicLevel.INFO);
        BasicLevel.WARN = Level.WARNING.intValue();
        LoggerFactory.debug("\t-WARN= " + BasicLevel.WARN);
        BasicLevel.ERROR = Level.SEVERE.intValue();
        LoggerFactory.debug("\t-ERROR= " + BasicLevel.ERROR);
        BasicLevel.FATAL = JDKLevelImpl.FATAL.intValue();
        LoggerFactory.debug("\t-FATAL= " + BasicLevel.FATAL);
        BasicLevel.LEVEL_INHERIT = new LevelImpl("INHERIT", BasicLevel.INHERIT);
        BasicLevel.LEVEL_DEBUG = new LevelImpl("DEBUG", BasicLevel.DEBUG);
        BasicLevel.LEVEL_INFO = new LevelImpl("INFO", BasicLevel.INFO);
        BasicLevel.LEVEL_WARN = new LevelImpl("WARN", BasicLevel.WARN);
        BasicLevel.LEVEL_ERROR = new LevelImpl("ERROR", BasicLevel.ERROR);
        BasicLevel.LEVEL_FATAL = new LevelImpl("FATAL", BasicLevel.FATAL);
        manager = LogManager.getLogManager();
        if (classLoaderIsoltion) {
            LoggerFactory.debug("class loader isolation activated");
            int i = 0;
            while (rootLogger == null) {
                rootLoggerName = "root" + i;
                LogManager logManager = manager;
                synchronized (logManager) {
                    if (manager.getLogger(rootLoggerName) == null) {
                        rootLogger = new Logger(rootLoggerName, null);
                        manager.addLogger(rootLogger);
                    } else {
                        ++i;
                    }
                }
            }
            rootLogger.setUseParentHandlers(false);
            Monolog.debug("Instanciate the root logger " + rootLoggerName);
            rootLoggerPrefix = rootLoggerName + '.';
        } else {
            rootLogger = new Logger(manager.getLogger(""));
        }
    }
}

