/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.util.configuration;

import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.carol.util.configuration.CMIConfigurationHelper;
import org.ow2.carol.util.configuration.ConfigurationException;
import org.ow2.carol.util.configuration.ServerConfiguration;
import org.ow2.carol.util.configuration.ServerConfigurationImplMBean;
import org.ow2.carol.util.configuration.TraceCarol;

public class ServerConfigurationImpl
implements ServerConfiguration,
ServerConfigurationImplMBean {
    private static Log logger = LogFactory.getLog(ServerConfigurationImpl.class);
    private final Properties properties;
    private final boolean startNS;
    private final boolean startJNDI;
    private final boolean startRMI;
    private volatile boolean startCMI;
    private final String domainName;
    private final String serverName;
    private String objectName;
    private final String agentId;
    private final boolean server;
    private volatile boolean multiEnvironment;
    private static boolean initCMIDone = false;

    protected ServerConfigurationImpl(Properties properties, String domainName, String serverName, String agentId) throws ConfigurationException {
        String key;
        this.properties = properties;
        this.domainName = domainName;
        this.serverName = serverName;
        this.agentId = agentId;
        if (properties == null) {
            throw new ConfigurationException("Cannot build a server configuration without properties");
        }
        this.startNS = this.getBooleanValue("carol.start.ns");
        this.startRMI = this.getBooleanValue("carol.start.rmi");
        this.startJNDI = this.getBooleanValue("carol.start.jndi");
        this.server = System.getProperty("carol.server.mode", "false").equalsIgnoreCase("true");
        logger.debug(System.getProperties());
        Properties jvmProperties = new Properties();
        if (this.startRMI) {
            jvmProperties.setProperty("javax.rmi.CORBA.PortableRemoteObjectClass", "org.ow2.carol.rmi.multi.MultiPRODelegate");
        }
        if (this.startJNDI) {
            jvmProperties.setProperty("java.naming.factory.initial", "org.ow2.carol.jndi.spi.MultiOrbInitialContextFactory");
        }
        String protocols = properties.getProperty("carol.protocols");
        boolean isMultiProtocols = false;
        if (protocols != null) {
            isMultiProtocols = protocols.split(",").length > 1;
        }
        this.multiEnvironment = this.getBooleanValue("carol.multi.env");
        String jndiPrefix = "carol.jndi";
        String multiJvmPrefix = "multi.carol.jvm";
        String singleJvmPrefix = "carol.jvm";
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String newKey;
            key = (String)e.nextElement();
            if (key.startsWith(jndiPrefix)) {
                jvmProperties.setProperty(key.substring(jndiPrefix.length() + 1), properties.getProperty(key));
            }
            if (key.startsWith(multiJvmPrefix) && isMultiProtocols) {
                newKey = key.substring(multiJvmPrefix.length() + 1);
                jvmProperties.setProperty(newKey, "");
            }
            if (!key.startsWith(singleJvmPrefix)) continue;
            newKey = key.substring(singleJvmPrefix.length() + 1);
            jvmProperties.setProperty(newKey, properties.getProperty(key));
        }
        e = jvmProperties.propertyNames();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            String value = jvmProperties.getProperty(key);
            System.setProperty(key, value);
            if (!TraceCarol.isDebugCarol()) continue;
            TraceCarol.debugCarol("Set the JVM property '" + key + "' with the value '" + value + "'.");
        }
    }

    protected boolean getBooleanValue(String key) throws ConfigurationException {
        String s = this.properties.getProperty(key);
        if (s == null) {
            throw new ConfigurationException("Property '" + key + "' was not found in the properties object of the protocol, properties are :'" + this.properties + "'");
        }
        return Boolean.parseBoolean(s.trim());
    }

    public boolean isStartingJNDI() {
        return this.startJNDI;
    }

    public boolean isStartingNS() {
        return this.startNS;
    }

    public boolean isStartingRMI() {
        return this.startRMI;
    }

    public synchronized boolean isStartCMI() {
        return this.startCMI;
    }

    public synchronized void enableCMI(URL cmiConfigUrl) throws ConfigurationException {
        if (!initCMIDone && CMIConfigurationHelper.enableCMI((ServerConfiguration)this, this.domainName, this.serverName, this.agentId, cmiConfigUrl)) {
            initCMIDone = true;
        }
        if (initCMIDone) {
            this.startCMI = true;
        }
    }

    public synchronized void enableCMI(Properties cmiEnv) throws ConfigurationException {
        if (!initCMIDone && CMIConfigurationHelper.enableCMI(this, this.domainName, this.serverName, this.agentId, cmiEnv)) {
            initCMIDone = true;
        }
        if (initCMIDone) {
            this.startCMI = true;
        }
    }

    public synchronized void disableCMI() {
        this.startCMI = false;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public boolean isServer() {
        return this.server;
    }

    public boolean isMultiEnvironment() {
        return this.multiEnvironment;
    }

    public void setMultiEnvironment(boolean multiEnvironment) {
        this.multiEnvironment = multiEnvironment;
    }
}

