/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.cmi;

import java.util.List;
import java.util.Properties;
import org.ow2.carol.util.configuration.ConfigurationRepository;
import org.ow2.cmi.config.CMIProperty;
import org.ow2.cmi.controller.common.ClusterViewManager;
import org.ow2.cmi.controller.factory.ClusterViewManagerFactory;
import org.ow2.cmi.controller.server.ServerClusterViewManager;
import org.ow2.easybeans.component.api.EZBComponent;
import org.ow2.easybeans.component.api.EZBComponentException;
import org.ow2.easybeans.component.cmi.CmiConfigurationExtension;
import org.ow2.easybeans.component.event.EventComponent;
import org.ow2.easybeans.server.ServerConfig;
import org.ow2.util.component.api.Component;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class CmiComponent
implements EZBComponent {
    private Log logger = LogFactory.getLog(CmiComponent.class);
    private ServerConfig config;
    private EventComponent eventComponent;
    private boolean lifecycleManaged = true;
    private ServerClusterViewManager clusterViewManager;
    private Properties cmiProperties = new Properties();

    public void init() throws EZBComponentException {
        this.cmiProperties.setProperty(CMIProperty.REPLICATION_MANAGER_CLASS.getPropertyName(), "org.ow2.cmi.controller.server.impl.jgroups.JGroupsClusterViewManager");
        this.cmiProperties.setProperty(CMIProperty.CONF_FILENAME.getPropertyName(), "cmi-jgroups-config.xml");
    }

    public void start() throws EZBComponentException {
        if (this.lifecycleManaged) {
            try {
                ConfigurationRepository.getServerConfiguration().enableCMI(this.cmiProperties);
            }
            catch (Exception e) {
                this.logger.error("Cannot configure Carol to use CMI", e);
                throw new EZBComponentException("Cannot configure Carol to use CMI", e);
            }
            ClusterViewManagerFactory clusterViewManagerFactory = ClusterViewManagerFactory.getFactory();
            try {
                this.clusterViewManager = (ServerClusterViewManager)clusterViewManagerFactory.create();
            }
            catch (Exception e) {
                this.logger.error("Cannot retrieve the CMI Server", e);
                throw new EZBComponentException("Cannot retrieve the CMI Server", e);
            }
            if (this.clusterViewManager != null && this.clusterViewManager.getState().equals((Object)ClusterViewManager.State.STOPPED)) {
                List<Component> components;
                if (this.eventComponent != null && (components = clusterViewManagerFactory.getConfig().getComponents().getComponents()) != null) {
                    for (Component cmiEventComponent : components) {
                        if (!org.ow2.cmi.component.event.EventComponent.class.isAssignableFrom(cmiEventComponent.getClass())) continue;
                        ((org.ow2.cmi.component.event.EventComponent)cmiEventComponent).setEventService(this.eventComponent.getEventService());
                    }
                }
                try {
                    this.clusterViewManager.start();
                }
                catch (Exception e) {
                    this.logger.error("Cannot start the CMI Server", e);
                    throw new EZBComponentException("Cannot start the CMI Server", e);
                }
            }
        }
        this.config.addExtensionFactory(new CmiConfigurationExtension());
        this.logger.debug("The CMI configuration extension has been added.", new Object[0]);
    }

    public void stop() throws EZBComponentException {
        if (this.lifecycleManaged) {
            try {
                ConfigurationRepository.getServerConfiguration().disableCMI();
            }
            catch (Exception e) {
                this.logger.error("Cannot disable CMI in Carol", e);
            }
            if (this.clusterViewManager != null) {
                try {
                    this.clusterViewManager.stop();
                }
                catch (Exception e) {
                    this.logger.error("Cannot stop the server-side manager", e);
                    throw new EZBComponentException("Cannot stop the server-side manager", e);
                }
            }
        }
    }

    public ServerConfig getServerConfig() {
        return this.config;
    }

    public void setServerConfig(ServerConfig config) {
        this.config = config;
    }

    public EventComponent getEventComponent() {
        return this.eventComponent;
    }

    public void setEventComponent(EventComponent eventComponent) {
        this.eventComponent = eventComponent;
    }

    public boolean isLifecycleManaged() {
        return this.lifecycleManaged;
    }

    public void setLifecycleManaged(boolean lifecycleManaged) {
        this.lifecycleManaged = lifecycleManaged;
    }
}

