/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.statistic;

import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.EZBJ2EEManagedObject;
import org.ow2.easybeans.api.EZBServer;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.api.statistic.EZBStatisticFactory;
import org.ow2.easybeans.api.statistic.EZBStatisticProvider;
import org.ow2.easybeans.component.api.EZBComponentException;
import org.ow2.easybeans.component.itf.EZBEventComponent;
import org.ow2.easybeans.component.itf.EZBJmxComponent;
import org.ow2.easybeans.component.itf.EZBStatisticComponent;
import org.ow2.easybeans.component.statistic.ManagedStatistic;
import org.ow2.easybeans.component.statistic.ManagedStatisticFactory;
import org.ow2.easybeans.component.statistic.ManagedStatisticProvider;
import org.ow2.easybeans.jmx.MBeansException;
import org.ow2.easybeans.jmx.MBeansHelper;
import org.ow2.easybeans.naming.J2EEManagedObjectNamingHelper;
import org.ow2.easybeans.statistic.CallCountStatisticFactory;
import org.ow2.easybeans.statistic.MeanCallTimeStatisticFactory;
import org.ow2.easybeans.statistic.TotalCallTimeStatisticFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticComponent
implements EZBStatisticComponent {
    private EZBEventComponent eventComponent;
    private EZBJmxComponent jmxComponent;
    private Map<String, ManagedStatistic> managedStatistics = new HashMap<String, ManagedStatistic>();
    private Map<String, ManagedStatisticProvider> managedStatisticProviders = new HashMap<String, ManagedStatisticProvider>();
    private Map<String, ManagedStatisticFactory> managedStatisticFactories = new HashMap<String, ManagedStatisticFactory>();

    @Override
    public synchronized void init() throws EZBComponentException {
    }

    @Override
    public synchronized void start() throws EZBComponentException {
        this.registerStatisticFactory(new CallCountStatisticFactory(this.eventComponent, this.jmxComponent));
        this.registerStatisticFactory(new MeanCallTimeStatisticFactory(this.eventComponent, this.jmxComponent));
        this.registerStatisticFactory(new TotalCallTimeStatisticFactory(this.eventComponent, this.jmxComponent));
        try {
            MBeansHelper.getInstance().registerMBean(this);
        }
        catch (MBeansException mBeansException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void stop() throws EZBComponentException {
        LinkedList<ManagedStatisticFactory> managedStatisticFactories = new LinkedList<ManagedStatisticFactory>();
        managedStatisticFactories.addAll(this.managedStatisticFactories.values());
        for (ManagedStatisticFactory managedStatisticFactory : managedStatisticFactories) {
            managedStatisticFactory.destroy();
        }
        LinkedList<ManagedStatisticProvider> managedStatisticProviders = new LinkedList<ManagedStatisticProvider>();
        managedStatisticProviders.addAll(this.managedStatisticProviders.values());
        for (ManagedStatisticProvider managedStatisticProvider : managedStatisticProviders) {
            managedStatisticProvider.destroy();
        }
        this.managedStatisticProviders.clear();
        this.managedStatisticFactories.clear();
        this.managedStatistics.clear();
    }

    public synchronized void setEventComponent(EZBEventComponent eventComponent) {
        this.eventComponent = eventComponent;
    }

    public synchronized void setJmxComponent(EZBJmxComponent jmxComponent) {
        this.jmxComponent = jmxComponent;
    }

    @Override
    public synchronized void registerStatisticFactory(EZBStatisticFactory statisticFactory) {
        this.unregisterStatisticFactory(statisticFactory);
        ManagedStatisticFactory managedStatisticFactory = new ManagedStatisticFactory(statisticFactory, this.managedStatisticProviders, this.managedStatisticFactories);
        this.managedStatisticFactories.put(statisticFactory.getStatisticFactoryId(), managedStatisticFactory);
        for (ManagedStatistic managedStatistic : managedStatisticFactory.getManagedStatistics()) {
            this.managedStatistics.put(managedStatistic.getStatistic().getStatisticId(), managedStatistic);
        }
    }

    @Override
    public synchronized void unregisterStatisticFactory(EZBStatisticFactory statisticFactory) {
        ManagedStatisticFactory managedStatisticFactory = this.managedStatisticFactories.remove(statisticFactory.getStatisticFactoryId());
        if (managedStatisticFactory != null) {
            for (ManagedStatistic managedStatistic : managedStatisticFactory.getManagedStatistics()) {
                this.managedStatistics.remove(managedStatistic.getStatistic().getStatisticId());
            }
            managedStatisticFactory.destroy();
        }
    }

    @Override
    public synchronized void registerJ2EEManagedObject(EZBJ2EEManagedObject object) {
        if (EZBServer.class.isAssignableFrom(object.getClass())) {
            this.registerEZBServer((EZBServer)object);
        } else if (EZBContainer.class.isAssignableFrom(object.getClass())) {
            this.registerEZBContainer((EZBContainer)object);
        } else if (Factory.class.isAssignableFrom(object.getClass())) {
            this.registerEZBFactory((Factory)object);
        }
    }

    @Override
    public synchronized void unregisterJ2EEManagedObject(EZBJ2EEManagedObject object) {
        if (EZBServer.class.isAssignableFrom(object.getClass())) {
            this.unregisterEZBServer((EZBServer)object);
        } else if (EZBContainer.class.isAssignableFrom(object.getClass())) {
            this.unregisterEZBContainer((EZBContainer)object);
        } else if (Factory.class.isAssignableFrom(object.getClass())) {
            this.unregisterEZBFactory((Factory)object);
        }
    }

    @Override
    public synchronized void importStatisticFactory(URL url) throws EZBComponentException {
        throw new EZBComponentException("Function not yet implemented");
    }

    @Override
    public synchronized List<String> getStatisticFactoryIds() throws EZBComponentException {
        return new LinkedList<String>(this.managedStatisticFactories.keySet());
    }

    @Override
    public synchronized EZBStatisticComponent.STATISTIC_FACTORY_MODE getStatisticFactoryMode(String statisticFactoryId) throws EZBComponentException {
        ManagedStatisticFactory managedStatisticFactory = this.managedStatisticFactories.get(statisticFactoryId);
        if (managedStatisticFactory == null) {
            throw new EZBComponentException("Cannot find statisticFactoryId " + statisticFactoryId);
        }
        return managedStatisticFactory.getManagedStatisticFactoryMode();
    }

    @Override
    public synchronized void setStatisticFactoryMode(String statisticFactoryId, EZBStatisticComponent.STATISTIC_FACTORY_MODE statisticFactoryMode) throws EZBComponentException {
        ManagedStatisticFactory managedStatisticFactory = this.managedStatisticFactories.get(statisticFactoryId);
        if (managedStatisticFactory == null) {
            throw new EZBComponentException("Cannot find statisticFactoryId " + statisticFactoryId);
        }
        managedStatisticFactory.setManagedStatisticFactoryMode(statisticFactoryMode);
    }

    @Override
    public synchronized boolean getStatisticFactoryState(String statisticFactoryId) throws EZBComponentException {
        ManagedStatisticFactory managedStatisticFactory = this.managedStatisticFactories.get(statisticFactoryId);
        if (managedStatisticFactory == null) {
            throw new EZBComponentException("Cannot find statisticFactoryId " + statisticFactoryId);
        }
        return managedStatisticFactory.getManagedStatisticFactoryState();
    }

    @Override
    public synchronized void setStatisticFactoryState(String statisticFactoryId, boolean statisticFactoryState) throws EZBComponentException {
        ManagedStatisticFactory managedStatisticFactory = this.managedStatisticFactories.get(statisticFactoryId);
        if (managedStatisticFactory == null) {
            throw new EZBComponentException("Cannot find statisticFactoryId " + statisticFactoryId);
        }
        managedStatisticFactory.setManagedStatisticFactoryState(statisticFactoryState);
    }

    @Override
    public synchronized List<String> getStatisticProviderIds() throws EZBComponentException {
        return new LinkedList<String>(this.managedStatisticProviders.keySet());
    }

    @Override
    public synchronized EZBStatisticComponent.STATISTIC_PROVIDER_MODE getStatisticProviderMode(String statisticProviderId) throws EZBComponentException {
        ManagedStatisticProvider managedStatisticProvider = this.managedStatisticProviders.get(statisticProviderId);
        if (managedStatisticProvider == null) {
            throw new EZBComponentException("Cannot find statisticProviderId " + statisticProviderId);
        }
        return managedStatisticProvider.getManagedStatisticProviderMode();
    }

    @Override
    public synchronized void setStatisticProviderMode(String statisticProviderId, EZBStatisticComponent.STATISTIC_PROVIDER_MODE statisticProviderMode) throws EZBComponentException {
        ManagedStatisticProvider managedStatisticProvider = this.managedStatisticProviders.get(statisticProviderId);
        if (managedStatisticProvider == null) {
            throw new EZBComponentException("Cannot find statisticProviderId " + statisticProviderId);
        }
        managedStatisticProvider.setManagedStatisticProviderMode(statisticProviderMode);
    }

    @Override
    public synchronized boolean getStatisticProviderState(String statisticProviderId) throws EZBComponentException {
        ManagedStatisticProvider managedStatisticProvider = this.managedStatisticProviders.get(statisticProviderId);
        if (managedStatisticProvider == null) {
            throw new EZBComponentException("Cannot find statisticProviderId " + statisticProviderId);
        }
        return managedStatisticProvider.getManagedStatisticProviderState();
    }

    @Override
    public synchronized void setStatisticProviderState(String statisticProviderId, boolean statisticProviderState) throws EZBComponentException {
        ManagedStatisticProvider managedStatisticProvider = this.managedStatisticProviders.get(statisticProviderId);
        if (managedStatisticProvider == null) {
            throw new EZBComponentException("Cannot find statisticProviderId " + statisticProviderId);
        }
        managedStatisticProvider.setManagedStatisticProviderState(statisticProviderState);
    }

    @Override
    public synchronized List<String> getStatisticIds() throws EZBComponentException {
        return new LinkedList<String>(this.managedStatistics.keySet());
    }

    @Override
    public synchronized EZBStatisticComponent.STATISTIC_MODE getStatisticMode(String statisticId) throws EZBComponentException {
        ManagedStatistic managedStatistic = this.managedStatistics.get(statisticId);
        if (managedStatistic == null) {
            throw new EZBComponentException("Cannot find statistic " + statisticId);
        }
        return managedStatistic.getManagedStatisticMode();
    }

    @Override
    public synchronized void setStatisticMode(String statisticId, EZBStatisticComponent.STATISTIC_MODE statisticMode) throws EZBComponentException {
        ManagedStatistic managedStatistic = this.managedStatistics.get(statisticId);
        if (managedStatistic == null) {
            throw new EZBComponentException("Cannot find statistic " + statisticId);
        }
        managedStatistic.setManagedStatisticMode(statisticMode);
    }

    @Override
    public synchronized boolean getStatisticState(String statisticId) throws EZBComponentException {
        ManagedStatistic managedStatistic = this.managedStatistics.get(statisticId);
        if (managedStatistic == null) {
            throw new EZBComponentException("Cannot find statistic " + statisticId);
        }
        return managedStatistic.getManagedStatisticState();
    }

    @Override
    public synchronized void setStatisticState(String statisticId, boolean statisticStateValue) throws EZBComponentException {
        ManagedStatistic managedStatistic = this.managedStatistics.get(statisticId);
        if (managedStatistic == null) {
            throw new EZBComponentException("Cannot find statistic " + statisticId);
        }
        managedStatistic.setManagedStatisticState(statisticStateValue);
    }

    @Override
    public synchronized void resetStatistic(String statisticId) throws EZBComponentException {
        ManagedStatistic managedStatistic = this.managedStatistics.get(statisticId);
        if (managedStatistic == null) {
            throw new EZBComponentException("Cannot find statistic " + statisticId);
        }
        managedStatistic.getStatistic().reset();
    }

    @Override
    public synchronized String getStatisticName(String statisticId) throws EZBComponentException {
        ManagedStatistic managedStatistic = this.managedStatistics.get(statisticId);
        if (managedStatistic == null) {
            throw new EZBComponentException("Cannot find statistic " + statisticId);
        }
        return managedStatistic.getStatistic().getName();
    }

    @Override
    public synchronized String getStatisticDescription(String statisticId) throws EZBComponentException {
        ManagedStatistic managedStatistic = this.managedStatistics.get(statisticId);
        if (managedStatistic == null) {
            throw new EZBComponentException("Cannot find statistic " + statisticId);
        }
        return managedStatistic.getStatistic().getDescription();
    }

    @Override
    public synchronized String getStatisticValue(String statisticId) throws EZBComponentException {
        ManagedStatistic managedStatistic = this.managedStatistics.get(statisticId);
        if (managedStatistic == null) {
            throw new EZBComponentException("Cannot find statistic " + statisticId);
        }
        return managedStatistic.getStatistic().getValue();
    }

    @Override
    public synchronized long getStatisticStartTime(String statisticId) throws EZBComponentException {
        ManagedStatistic managedStatistic = this.managedStatistics.get(statisticId);
        if (managedStatistic == null) {
            throw new EZBComponentException("Cannot find statistic " + statisticId);
        }
        return managedStatistic.getStatistic().getStartTime();
    }

    @Override
    public synchronized long getStatisticLastSampleTime(String statisticId) throws EZBComponentException {
        ManagedStatistic managedStatistic = this.managedStatistics.get(statisticId);
        if (managedStatistic == null) {
            throw new EZBComponentException("Cannot find statistic " + statisticId);
        }
        return managedStatistic.getStatistic().getLastSampleTime();
    }

    private void registerEZBServer(final EZBServer server) {
        this.unregisterEZBServer(server);
        ManagedStatisticProvider managedStatisticProvider = new ManagedStatisticProvider(new EZBStatisticProvider(){

            public String getStatisticProviderId() {
                return server.getJ2EEManagedObjectId();
            }
        }, this.managedStatisticProviders, this.managedStatisticFactories);
        this.managedStatisticProviders.put(server.getJ2EEManagedObjectId(), managedStatisticProvider);
        for (ManagedStatistic managedStatistic : managedStatisticProvider.getManagedStatistics()) {
            this.managedStatistics.put(managedStatistic.getStatistic().getStatisticId(), managedStatistic);
        }
    }

    private void unregisterEZBServer(EZBServer server) {
        ManagedStatisticProvider managedStatisticProvider = this.managedStatisticProviders.remove(server.getJ2EEManagedObjectId());
        if (managedStatisticProvider != null) {
            for (ManagedStatistic managedStatistic : managedStatisticProvider.getManagedStatistics()) {
                this.managedStatistics.remove(managedStatistic.getStatistic().getStatisticId());
            }
            managedStatisticProvider.destroy();
        }
    }

    private void registerEZBContainer(final EZBContainer container) {
        this.unregisterEZBContainer(container);
        ManagedStatisticProvider managedStatisticProvider = new ManagedStatisticProvider(new EZBStatisticProvider(){

            public String getStatisticProviderId() {
                return container.getJ2EEManagedObjectId();
            }
        }, this.managedStatisticProviders, this.managedStatisticFactories);
        this.managedStatisticProviders.put(container.getJ2EEManagedObjectId(), managedStatisticProvider);
        for (ManagedStatistic managedStatistic : managedStatisticProvider.getManagedStatistics()) {
            this.managedStatistics.put(managedStatistic.getStatistic().getStatisticId(), managedStatistic);
        }
    }

    private void unregisterEZBContainer(EZBContainer container) {
        ManagedStatisticProvider managedStatisticProvider = this.managedStatisticProviders.remove(container.getJ2EEManagedObjectId());
        if (managedStatisticProvider != null) {
            for (ManagedStatistic managedStatistic : managedStatisticProvider.getManagedStatistics()) {
                this.managedStatistics.remove(managedStatistic.getStatistic().getStatisticId());
            }
            managedStatisticProvider.destroy();
        }
    }

    private void registerEZBFactory(final Factory<?, ?> factory) {
        this.unregisterEZBFactory(factory);
        ManagedStatisticProvider managedStatisticProvider = new ManagedStatisticProvider(new EZBStatisticProvider(){

            public String getStatisticProviderId() {
                return factory.getJ2EEManagedObjectId();
            }
        }, this.managedStatisticProviders, this.managedStatisticFactories);
        this.managedStatisticProviders.put(factory.getJ2EEManagedObjectId(), managedStatisticProvider);
        for (ManagedStatistic managedStatistic : managedStatisticProvider.getManagedStatistics()) {
            this.managedStatistics.put(managedStatistic.getStatistic().getStatisticId(), managedStatistic);
        }
        List<String> methods = J2EEManagedObjectNamingHelper.getBeanMethodsManagedObjectIds(factory);
        for (final String method : methods) {
            managedStatisticProvider = new ManagedStatisticProvider(new EZBStatisticProvider(){

                public String getStatisticProviderId() {
                    return method;
                }
            }, this.managedStatisticProviders, this.managedStatisticFactories);
            this.managedStatisticProviders.put(method, managedStatisticProvider);
            for (ManagedStatistic managedStatistic : managedStatisticProvider.getManagedStatistics()) {
                this.managedStatistics.put(managedStatistic.getStatistic().getStatisticId(), managedStatistic);
            }
        }
    }

    private void unregisterEZBFactory(Factory<?, ?> factory) {
        ManagedStatisticProvider managedStatisticProvider = this.managedStatisticProviders.remove(factory.getJ2EEManagedObjectId());
        if (managedStatisticProvider != null) {
            for (ManagedStatistic managedStatistic : managedStatisticProvider.getManagedStatistics()) {
                this.managedStatistics.remove(managedStatistic.getStatistic().getStatisticId());
            }
            managedStatisticProvider.destroy();
            List<String> methods = J2EEManagedObjectNamingHelper.getBeanMethodsManagedObjectIds(factory);
            for (String method : methods) {
                managedStatisticProvider = this.managedStatisticProviders.remove(method);
                if (managedStatisticProvider == null) continue;
                for (ManagedStatistic managedStatistic : managedStatisticProvider.getManagedStatistics()) {
                    this.managedStatistics.remove(managedStatistic.getStatistic().getStatisticId());
                }
                managedStatisticProvider.destroy();
            }
        }
    }
}

