/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.metadata.ejbjar.helper;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarClassMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarFieldMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarMethodMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EjbJarArchiveMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.xml.AbsSpecificBean;
import org.ow2.easybeans.deployment.metadata.ejbjar.xml.EJB;
import org.ow2.easybeans.deployment.metadata.ejbjar.xml.EasyBeansDD;
import org.ow2.easybeans.deployment.metadata.ejbjar.xml.MessageDrivenBean;
import org.ow2.easybeans.deployment.metadata.ejbjar.xml.ServiceRef;
import org.ow2.easybeans.deployment.metadata.ejbjar.xml.Session;
import org.ow2.util.ee.metadata.common.api.struct.IJaxwsWebServiceRef;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.api.IPoolConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MetadataSpecificMerge {
    private static Log logger = LogFactory.getLog(MetadataSpecificMerge.class);
    private EjbJarArchiveMetadata ejbMetadata;

    private MetadataSpecificMerge(EjbJarArchiveMetadata ejbMetadata) {
        this.ejbMetadata = ejbMetadata;
    }

    public static void merge(EjbJarArchiveMetadata ejbMetadata) {
        new MetadataSpecificMerge(ejbMetadata).resolve();
    }

    private void resolve() {
        EasyBeansDD easybeansDD = this.ejbMetadata.getEasyBeansDD();
        if (easybeansDD != null) {
            logger.debug("There is a specific Deployment Descriptor object, performing the merge of the metadata.", new Object[0]);
            EJB ejb = easybeansDD.getEJB();
            if (ejb != null) {
                List<MessageDrivenBean> mdbList;
                List<Session> sessionList = ejb.getSessions();
                if (sessionList != null) {
                    for (Session session : sessionList) {
                        String ejbName = session.getEjbName();
                        EasyBeansEjbJarClassMetadata classAnnotationMetadata = this.ejbMetadata.getEjbJarClassMetadataForEjbName(ejbName);
                        this.applySessionBean(session, classAnnotationMetadata);
                    }
                }
                if ((mdbList = ejb.getMessageDrivenBeans()) != null) {
                    for (MessageDrivenBean mdb : mdbList) {
                        String ejbName = mdb.getEjbName();
                        EasyBeansEjbJarClassMetadata classAnnotationMetadata = this.ejbMetadata.getEjbJarClassMetadataForEjbName(ejbName);
                        this.applyMessageDrivenBean(mdb, classAnnotationMetadata);
                    }
                }
            }
        }
    }

    private void applySessionBean(Session sessionbean, EasyBeansEjbJarClassMetadata classAnnotationMetadata) {
        this.applyCommonBean(sessionbean, classAnnotationMetadata);
        classAnnotationMetadata.setWebServiceEndpointAddress(sessionbean.getEndpointAddress());
    }

    private void applyMessageDrivenBean(MessageDrivenBean mdb, EasyBeansEjbJarClassMetadata classAnnotationMetadata) {
        this.applyCommonBean(mdb, classAnnotationMetadata);
    }

    private void applyCommonBean(AbsSpecificBean bean, EasyBeansEjbJarClassMetadata classAnnotationMetadata) {
        List<ServiceRef> references;
        IPoolConfiguration poolConfiguration = bean.getPoolConfiguration();
        Object clusterConfiguration = bean.getCluster();
        if (poolConfiguration != null) {
            classAnnotationMetadata.setPoolConfiguration(poolConfiguration);
        }
        if (clusterConfiguration != null) {
            classAnnotationMetadata.setCluster(clusterConfiguration);
        }
        if ((references = bean.getServiceRefs()) != null && !references.isEmpty()) {
            this.applyServiceRefs(classAnnotationMetadata, references);
        }
    }

    private void applyServiceRefs(EasyBeansEjbJarClassMetadata classAnnotationMetadata, List<ServiceRef> references) {
        Map<String, IJaxwsWebServiceRef> namedReferences = this.createMappedAnnotationsReferences(classAnnotationMetadata);
        for (ServiceRef reference : references) {
            String name = reference.getName();
            IJaxwsWebServiceRef ref = namedReferences.get(name);
            if (ref != null) {
                ref.setWsdlLocation(reference.getWsdlLocation());
                continue;
            }
            logger.info("@WebServiceRef({0}) was not found in the class '{1}', unused overriding information.", name, classAnnotationMetadata.getClassName());
        }
    }

    private Map<String, IJaxwsWebServiceRef> createMappedAnnotationsReferences(EasyBeansEjbJarClassMetadata classAnnotationMetadata) {
        Collection methods;
        Collection fields;
        List<IJaxwsWebServiceRef> refs;
        HashMap<String, IJaxwsWebServiceRef> references = new HashMap<String, IJaxwsWebServiceRef>();
        IJaxwsWebServiceRef ref = classAnnotationMetadata.getJaxwsWebServiceRef();
        if (ref != null) {
            references.put(ref.getName(), ref);
        }
        if ((refs = classAnnotationMetadata.getJaxwsWebServiceRefs()) != null && !refs.isEmpty()) {
            for (IJaxwsWebServiceRef classLevelReference : refs) {
                references.put(classLevelReference.getName(), classLevelReference);
            }
        }
        if ((fields = classAnnotationMetadata.getStandardFieldMetadataCollection()) != null && !fields.isEmpty()) {
            for (EasyBeansEjbJarFieldMetadata field : fields) {
                IJaxwsWebServiceRef fieldReference = field.getJaxwsWebServiceRef();
                if (fieldReference == null) continue;
                String refName = fieldReference.getName();
                if (refName == null) {
                    refName = field.getFieldName();
                }
                references.put(refName, fieldReference);
            }
        }
        if ((methods = classAnnotationMetadata.getMethodMetadataCollection()) != null && !methods.isEmpty()) {
            for (EasyBeansEjbJarMethodMetadata methodMetadata : methods) {
                IJaxwsWebServiceRef methodReference = methodMetadata.getJaxwsWebServiceRef();
                if (methodReference == null) continue;
                String refName = methodReference.getName();
                if (refName == null) {
                    String methodName = methodMetadata.getJMethod().getName();
                    methodName = methodName.substring("set".length());
                    String first = methodName.substring(0, 1).toUpperCase();
                    refName = first.concat(methodName.substring(1));
                }
                references.put(refName, methodReference);
            }
        }
        return references;
    }
}

