/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.osgi.ejbjar;

import java.net.URL;
import java.util.Dictionary;
import java.util.Properties;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.EZBContainerException;
import org.ow2.easybeans.api.EZBServer;
import org.ow2.easybeans.container.JContainer3;
import org.ow2.easybeans.container.JContainerConfig;
import org.ow2.easybeans.osgi.ejbjar.BackedClassLoader;
import org.ow2.easybeans.osgi.ejbjar.EmbeddedServiceListener;
import org.ow2.easybeans.osgi.util.BCMapper;
import org.ow2.easybeans.osgi.util.LDAPFilter;
import org.ow2.easybeans.server.Embedded;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.impl.ArchiveManager;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class Activator
implements BundleActivator {
    private static final String ROOT = "/";
    private Log logger = LogFactory.getLog(Activator.class);
    private EZBContainer container = null;
    private BundleContext bc = null;
    private ServiceListener listener;
    private ServiceRegistration serviceReg = null;

    public void start(BundleContext bc) throws Exception {
        this.bc = bc;
        this.listener = new EmbeddedServiceListener(this);
        String filter = LDAPFilter.createLDAPFilter(Embedded.class.getName());
        bc.addServiceListener(this.listener, filter);
        ServiceReference sr = bc.getServiceReference(Embedded.class.getName());
        if (sr != null) {
            this.startContainer(sr);
        }
    }

    public void stop(BundleContext bc) throws Exception {
        bc.removeServiceListener(this.listener);
        this.stopContainer();
    }

    public void startContainer(ServiceReference sr) {
        if (this.container == null) {
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            try {
                ArchiveManager am = ArchiveManager.getInstance();
                IArchive archive = am.getArchive(this.bc);
                BCMapper.getInstance().put(this.bc.getBundle().getEntry(ROOT), this.bc);
                BackedClassLoader backedClassLoader = new BackedClassLoader(new URL[]{archive.getURL()}, this.getClass().getClassLoader(), this.bc);
                Thread.currentThread().setContextClassLoader(backedClassLoader);
                this.logger.info("Creating Container from the Bundle Archive ''{0}''", archive.getURL());
                JContainerConfig jConfig = new JContainerConfig(archive);
                jConfig.setEZBServer((EZBServer)this.bc.getService(sr));
                this.container = new JContainer3(jConfig);
                this.container.addExtension(BundleContext.class, this.bc);
                this.container.setClassLoader(backedClassLoader);
                this.container.start();
                Properties props = new Properties();
                props.setProperty("name", this.bc.getBundle().getSymbolicName());
                props.setProperty("last.modified", String.valueOf(this.bc.getBundle().getLastModified()));
                props.setProperty("url", String.valueOf(this.bc.getBundle().getBundleId()));
                this.serviceReg = this.bc.registerService(EZBContainer.class.getName(), (Object)this.container, (Dictionary)props);
            }
            catch (EZBContainerException e) {
                if (this.container != null) {
                    this.container.stop();
                }
                BCMapper.getInstance().remove(this.bc.getBundle().getEntry(ROOT));
                throw new RuntimeException(e);
            }
            catch (ArchiveException e) {
                if (this.container != null) {
                    this.container.stop();
                }
                BCMapper.getInstance().remove(this.bc.getBundle().getEntry(ROOT));
                throw new RuntimeException(e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopContainer() {
        if (this.container != null) {
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                this.container.stop();
                this.container.removeExtension(BundleContext.class);
                if (this.serviceReg != null) {
                    this.serviceReg.unregister();
                }
                BCMapper.getInstance().remove(this.bc.getBundle().getEntry(ROOT));
                this.container = null;
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
    }
}

