/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.persistence;

import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.persistence.TransactionRequiredException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.ow2.easybeans.transaction.JTransactionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerManagedEntityManager
implements EntityManager {
    private EntityManager wrappedEntityManager = null;

    public ContainerManagedEntityManager(EntityManager entityManager) {
        this.wrappedEntityManager = entityManager;
    }

    @Override
    public void persist(Object entity) throws IllegalArgumentException, TransactionRequiredException {
        this.checkTransaction();
        this.wrappedEntityManager.persist(entity);
    }

    @Override
    public <T> T merge(T entity) throws IllegalArgumentException, TransactionRequiredException {
        this.checkTransaction();
        return this.wrappedEntityManager.merge(entity);
    }

    @Override
    public void remove(Object entity) throws IllegalArgumentException, TransactionRequiredException {
        this.checkTransaction();
        this.wrappedEntityManager.remove(entity);
    }

    @Override
    public <T> T find(Class<T> entityClass, Object primaryKey) throws IllegalArgumentException {
        return this.wrappedEntityManager.find(entityClass, primaryKey);
    }

    @Override
    public <T> T getReference(Class<T> entityClass, Object primaryKey) throws IllegalArgumentException, EntityNotFoundException {
        return this.wrappedEntityManager.getReference(entityClass, primaryKey);
    }

    @Override
    public void flush() throws TransactionRequiredException, PersistenceException {
        this.wrappedEntityManager.flush();
    }

    @Override
    public void setFlushMode(FlushModeType flushMode) {
        this.wrappedEntityManager.setFlushMode(flushMode);
    }

    @Override
    public FlushModeType getFlushMode() {
        return this.wrappedEntityManager.getFlushMode();
    }

    @Override
    public void lock(Object entity, LockModeType lockMode) throws PersistenceException, IllegalArgumentException, TransactionRequiredException {
        this.wrappedEntityManager.lock(entity, lockMode);
    }

    @Override
    public void refresh(Object entity) throws IllegalArgumentException, TransactionRequiredException, EntityNotFoundException {
        this.checkTransaction();
        this.wrappedEntityManager.refresh(entity);
    }

    @Override
    public void clear() {
        this.wrappedEntityManager.clear();
    }

    @Override
    public boolean contains(Object entity) throws IllegalArgumentException {
        return this.wrappedEntityManager.contains(entity);
    }

    @Override
    public Query createQuery(String ejbqlString) throws IllegalArgumentException {
        return this.wrappedEntityManager.createQuery(ejbqlString);
    }

    @Override
    public Query createNamedQuery(String name) throws IllegalArgumentException {
        return this.wrappedEntityManager.createNamedQuery(name);
    }

    @Override
    public Query createNativeQuery(String sqlString) {
        return this.wrappedEntityManager.createNativeQuery(sqlString);
    }

    @Override
    public Query createNativeQuery(String sqlString, Class resultClass) {
        return this.wrappedEntityManager.createNativeQuery(sqlString, resultClass);
    }

    @Override
    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        return this.wrappedEntityManager.createNativeQuery(sqlString, resultSetMapping);
    }

    @Override
    public void joinTransaction() throws IllegalStateException, TransactionRequiredException {
        this.wrappedEntityManager.joinTransaction();
    }

    @Override
    public Object getDelegate() throws IllegalStateException {
        return this.wrappedEntityManager.getDelegate();
    }

    @Override
    public void close() throws IllegalStateException {
        throw new IllegalStateException("This entity manager is a container managed entity manager. This operation is denied.");
    }

    @Override
    public boolean isOpen() {
        return this.wrappedEntityManager.isOpen();
    }

    @Override
    public EntityTransaction getTransaction() throws IllegalStateException {
        return this.wrappedEntityManager.getTransaction();
    }

    protected void checkTransaction() throws TransactionRequiredException {
        Transaction currentTx = null;
        try {
            currentTx = JTransactionManager.getTransactionManager().getTransaction();
        }
        catch (SystemException e) {
            throw new IllegalStateException("Cannot get current transaction", e);
        }
        if (currentTx == null) {
            throw new TransactionRequiredException("The operation needs to be executed within a transaction");
        }
    }
}

