/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.server;

import java.io.File;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.EZBContainerConfig;
import org.ow2.easybeans.api.EZBServer;
import org.ow2.easybeans.api.EmbeddedManager;
import org.ow2.easybeans.component.ComponentManager;
import org.ow2.easybeans.component.Components;
import org.ow2.easybeans.component.api.EZBComponent;
import org.ow2.easybeans.component.api.EZBComponentException;
import org.ow2.easybeans.component.itf.EZBEventComponent;
import org.ow2.easybeans.component.itf.EZBStatisticComponent;
import org.ow2.easybeans.component.itf.RegistryComponent;
import org.ow2.easybeans.container.JContainer3;
import org.ow2.easybeans.container.JContainerConfig;
import org.ow2.easybeans.deployer.IRemoteDeployer;
import org.ow2.easybeans.deployer.RemoteDeployer;
import org.ow2.easybeans.deployment.helper.listener.EnvEntriesExtensionListener;
import org.ow2.easybeans.deployment.helper.listener.JavaCompExtensionListener;
import org.ow2.easybeans.event.lifecycle.EventLifeCycleStarted;
import org.ow2.easybeans.event.lifecycle.EventLifeCycleStarting;
import org.ow2.easybeans.event.lifecycle.EventLifeCycleStopped;
import org.ow2.easybeans.event.lifecycle.EventLifeCycleStopping;
import org.ow2.easybeans.jmx.CommonsModelerException;
import org.ow2.easybeans.jmx.CommonsModelerHelper;
import org.ow2.easybeans.jmx.JMXRemoteException;
import org.ow2.easybeans.jmx.JMXRemoteHelper;
import org.ow2.easybeans.jmx.MBeanServerException;
import org.ow2.easybeans.jmx.MBeanServerHelper;
import org.ow2.easybeans.jmx.MBeansException;
import org.ow2.easybeans.jmx.MBeansHelper;
import org.ow2.easybeans.naming.J2EEManagedObjectNamingHelper;
import org.ow2.easybeans.resolver.ServerJNDIResolver;
import org.ow2.easybeans.resolver.api.EZBServerJNDIResolver;
import org.ow2.easybeans.rpc.api.RMIServerRPC;
import org.ow2.easybeans.rpc.rmi.server.RMIServerRPCImpl;
import org.ow2.easybeans.security.jacc.PolicyProvider;
import org.ow2.easybeans.server.ContainersMonitor;
import org.ow2.easybeans.server.DirectoryDeployerMonitor;
import org.ow2.easybeans.server.EasyBeansConfigurationExtension;
import org.ow2.easybeans.server.EmbeddedConfigurator;
import org.ow2.easybeans.server.EmbeddedException;
import org.ow2.easybeans.server.ServerConfig;
import org.ow2.easybeans.server.Version;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.event.api.IEventDispatcher;
import org.ow2.util.event.api.IEventListener;
import org.ow2.util.event.impl.EventDispatcher;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Embedded
implements EZBServer {
    private static final int SLEEP_VALUE = 10000;
    public static final String CORE_XML_FILE = "org/ow2/easybeans/server/easybeans-core.xml";
    public static final String DEFAULT_DEPLOY_DIRECTORY = "easybeans-deploy";
    public static final String DEPRECATED_DEFAULT_DEPLOY_DIRECTORY = "ejb3s";
    private static Log logger = LogFactory.getLog(Embedded.class);
    private static int counter = 0;
    private Integer id = counter++;
    private ServerConfig serverConfig = null;
    private Map<String, EZBContainer> containers = new ConcurrentHashMap<String, EZBContainer>();
    private RemoteDeployer deployer = null;
    private Components components = null;
    private ComponentManager componentManager = null;
    private boolean started = false;
    private boolean stopped = false;
    private ContainersMonitor monitor = null;
    private RMIServerRPC invoker = null;
    private EZBServerJNDIResolver jndiResolver = null;
    private IEventDispatcher dispatcher = null;
    private String j2eeManagedObjectId = null;
    private List<IEventListener> defaultNamingExtensions;
    public static final String NAMING_EXTENSION_POINT = "/easybeans/container/factory/context";

    public Embedded() {
        this.serverConfig = new ServerConfig();
        this.defaultNamingExtensions = new ArrayList<IEventListener>();
        this.defaultNamingExtensions.add(new JavaCompExtensionListener());
        this.defaultNamingExtensions.add(new EnvEntriesExtensionListener());
        this.jndiResolver = new ServerJNDIResolver();
        EmbeddedManager.addEmbedded(this);
        this.components = new Components();
        this.componentManager = new ComponentManager(this.components);
        this.j2eeManagedObjectId = J2EEManagedObjectNamingHelper.getJ2EEManagedObjectId(this);
    }

    public void start() throws EmbeddedException {
        EZBStatisticComponent statisticComponent;
        long tStart = System.currentTimeMillis();
        if (this.serverConfig.addEmbeddedComponents()) {
            this.serverConfig.getConfigurationURLs().addFirst(Thread.currentThread().getContextClassLoader().getResource(CORE_XML_FILE));
        }
        try {
            logger.info("Configuring EasyBeans with the configuration URLs ''{0}''", this.serverConfig.getConfigurationURLs());
            EmbeddedConfigurator.init(this, this.serverConfig.getConfigurationURLs(), this.serverConfig.getConfigurationMap());
        }
        catch (EmbeddedException e) {
            throw new EmbeddedException("Cannot configure the embedded server", e);
        }
        if (this.serverConfig.initJACC()) {
            PolicyProvider.init();
        }
        this.configure();
        if (this.serverConfig.isUsingNaming()) {
            System.setProperty("java.naming.factory.url.pkgs", "org.ow2.easybeans.naming.pkg");
        }
        try {
            this.deployer = new RemoteDeployer(this);
        }
        catch (DeployerException e) {
            throw new EmbeddedException("Cannot build a remote deployer.", e);
        }
        MBeansHelper.getInstance().activate(this.serverConfig.isUsingMBeans());
        if (this.serverConfig.isUsingMBeans()) {
            try {
                CommonsModelerHelper.initRegistry();
            }
            catch (CommonsModelerException e) {
                throw new EmbeddedException("Cannot init MBean server", e);
            }
            try {
                MBeanServerHelper.startMBeanServer();
            }
            catch (MBeanServerException e) {
                throw new EmbeddedException("Cannot start MBean server", e);
            }
        }
        if (this.serverConfig.isAutoConfigureComponents()) {
            try {
                this.componentManager.initComponents();
            }
            catch (EZBComponentException e) {
                throw new EmbeddedException("Cannot init components", e);
            }
            try {
                this.componentManager.startComponents();
            }
            catch (EZBComponentException e) {
                throw new EmbeddedException("Cannot start components", e);
            }
        }
        this.dispatcher = new EventDispatcher();
        this.dispatcher.start();
        EZBEventComponent eventComponent = this.getComponent(EZBEventComponent.class);
        if (eventComponent != null) {
            eventComponent.registerJ2EEManagedObject(this, this.dispatcher);
        }
        if ((statisticComponent = this.getComponent(EZBStatisticComponent.class)) != null) {
            statisticComponent.registerJ2EEManagedObject(this);
        }
        if (eventComponent != null) {
            for (IEventListener extension : this.defaultNamingExtensions) {
                eventComponent.getEventService().registerListener(extension, NAMING_EXTENSION_POINT);
            }
        }
        this.dispatcher.dispatch(new EventLifeCycleStarting(this.j2eeManagedObjectId));
        if (this.serverConfig.isUsingMBeans()) {
            if (this.serverConfig.isStartJMXConnector()) {
                try {
                    JMXRemoteHelper.startConnector((RegistryComponent)this.getComponent("org.ow2.easybeans.component.carol.CarolComponent"));
                }
                catch (JMXRemoteException e) {
                    throw new EmbeddedException("Cannot start JMX Remote connector", e);
                }
            }
            if (this.serverConfig.isRegisterDeployerMBean()) {
                try {
                    MBeansHelper.getInstance().registerMBean(this.deployer);
                }
                catch (MBeansException e) {
                    throw new EmbeddedException("Cannot init MBeans", e);
                }
            }
            if (this.serverConfig.isRegisterJ2EEServerMBean()) {
                try {
                    MBeansHelper.getInstance().registerMBean(this);
                }
                catch (MBeansException e) {
                    throw new EmbeddedException("Cannot init MBeans", e);
                }
            }
        }
        try {
            this.invoker = new RMIServerRPCImpl(this);
        }
        catch (RemoteException e) {
            throw new EmbeddedException("Cannot build RPC invoker", e);
        }
        try {
            new InitialContext().rebind("RMI_SERVER_RPC", (Object)this.invoker);
        }
        catch (NamingException e) {
            throw new EmbeddedException("Cannot bind the RPC invoker", e);
        }
        if (this.serverConfig.isDirectoryScanningEnabled()) {
            this.monitor = this.serverConfig.isUsingOldDeployer() ? new ContainersMonitor(this) : new DirectoryDeployerMonitor(this);
            this.monitor.init();
        }
        logger.info("Embedded.start.startup", Version.getVersion(), System.currentTimeMillis() - tStart);
        logger.debug("Embedded.start.created", this.containers.size());
        if (this.serverConfig.isDirectoryScanningEnabled()) {
            this.monitor.start();
        }
        this.dispatcher.dispatch(new EventLifeCycleStarted(this.j2eeManagedObjectId));
        this.started = true;
        if (this.serverConfig.shouldWait()) {
            logger.info("Embedded.start.waiting", new Object[0]);
            while (this.started) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    logger.error("Cannot sleep in the thread", e);
                }
            }
        }
    }

    @Override
    public synchronized void stop() throws EmbeddedException {
        EZBEventComponent eventComponent;
        if (!this.started) {
            throw new EmbeddedException("Cannot stop the server as it is not started.");
        }
        this.dispatcher.dispatch(new EventLifeCycleStopping(this.j2eeManagedObjectId));
        ArrayList<EZBContainer> containersList = new ArrayList<EZBContainer>(this.containers.values());
        ListIterator li = containersList.listIterator();
        while (li.hasNext()) {
            EZBContainer container = (EZBContainer)li.next();
            container.stop();
            this.removeContainer(container);
        }
        if (this.serverConfig.isDirectoryScanningEnabled()) {
            this.monitor.stopOrder();
        }
        if (this.serverConfig.isUsingMBeans()) {
            if (this.serverConfig.isStartJMXConnector()) {
                try {
                    JMXRemoteHelper.stopConnector();
                }
                catch (JMXRemoteException e) {
                    logger.debug("Cannot stop JMX Remote connector", e);
                }
            }
            if (this.serverConfig.isRegisterDeployerMBean()) {
                try {
                    MBeansHelper.getInstance().unregisterMBean(this.deployer);
                }
                catch (MBeansException e) {
                    logger.error("Cannot unregister Deployer MBean", e);
                }
            }
            if (this.serverConfig.isRegisterJ2EEServerMBean()) {
                try {
                    MBeansHelper.getInstance().unregisterMBean(this);
                }
                catch (MBeansException e) {
                    logger.error("Cannot unregister Embedded MBean", e);
                }
            }
        }
        try {
            new InitialContext().unbind("RMI_SERVER_RPC");
        }
        catch (NamingException e) {
            logger.error("Cannot unbind the RPC invoker", e);
        }
        try {
            PortableRemoteObject.unexportObject((Remote)this.invoker);
        }
        catch (NoSuchObjectException e) {
            logger.error("Cannot unexport RPC invoker", e);
        }
        this.dispatcher.dispatch(new EventLifeCycleStopped(this.j2eeManagedObjectId));
        EZBStatisticComponent statisticComponent = this.getComponent(EZBStatisticComponent.class);
        if (statisticComponent != null) {
            statisticComponent.unregisterJ2EEManagedObject(this);
        }
        if ((eventComponent = this.getComponent(EZBEventComponent.class)) != null) {
            eventComponent.unregisterJ2EEManagedObject(this);
            for (IEventListener extension : this.defaultNamingExtensions) {
                eventComponent.getEventService().unregisterListener(extension);
            }
        }
        this.dispatcher.stop();
        this.dispatcher = null;
        if (this.serverConfig.isStopComponentsDuringShutdown()) {
            this.componentManager.stopComponents();
        }
        if (this.serverConfig.initJACC()) {
            try {
                PolicyProvider.stop();
            }
            catch (Exception e) {
                logger.error("Unable to stop the JACC provider", e);
            }
        }
        logger.info("Embedded.stop.stopped", Version.getVersion());
        this.started = false;
        this.stopped = true;
    }

    public void setServerConfig(ServerConfig serverConfig) {
        if (this.started) {
            throw new IllegalStateException("Cannot set the server configuration when server has been started.");
        }
        this.serverConfig = serverConfig;
    }

    @Override
    public EZBContainer getContainer(String id) {
        return this.containers.get(id);
    }

    @Override
    public EZBContainer findContainer(IArchive archive) {
        if (archive == null) {
            return null;
        }
        for (EZBContainer container : this.containers.values()) {
            if (!archive.equals(container.getArchive())) continue;
            return container;
        }
        return null;
    }

    private void configure() {
        File deprecatedDir;
        List<File> deployDirectories = this.serverConfig.getDeployDirectories();
        for (File deployDirectory : deployDirectories) {
            if (deployDirectory.exists()) continue;
            if (deployDirectory.mkdir()) {
                logger.warn("Directory '" + deployDirectory.getAbsolutePath() + "' created.", new Object[0]);
                continue;
            }
            throw new IllegalStateException("Cannot make directory '" + deployDirectory.getAbsolutePath() + "'.");
        }
        if (deployDirectories.size() == 1 && (deprecatedDir = new File(deployDirectories.get(0).getParentFile(), DEPRECATED_DEFAULT_DEPLOY_DIRECTORY)).exists()) {
            logger.warn("DEPRECATED directory ''{0}'' found. New deploy directory with the name ''{1}'' has to be used instead.", deprecatedDir, DEFAULT_DEPLOY_DIRECTORY);
            this.serverConfig.getDeployDirectories().add(deprecatedDir);
        }
        if (this.serverConfig.getDeployDirectories().size() > 0) {
            logger.info("Using directories ''{0}'' as deploy directories", deployDirectories);
        }
    }

    @Override
    public EZBContainer createContainer(IArchive archive) {
        JContainerConfig jConfig = new JContainerConfig(archive);
        jConfig.setEZBServer(this);
        JContainer3 container = new JContainer3(jConfig);
        this.addContainer(container);
        return container;
    }

    @Override
    public void addContainer(EZBContainer container) {
        this.callJContainerConfigExtensions(container.getConfiguration());
        String id = container.getId();
        this.containers.put(id, container);
    }

    @Override
    public void removeContainer(EZBContainer container) {
        this.containers.remove(container.getId());
        logger.info("Container ''{0}'' removed", container.getArchive().getName());
    }

    private void callJContainerConfigExtensions(EZBContainerConfig jcc) {
        for (EasyBeansConfigurationExtension extension : this.serverConfig.getExtensionFactories()) {
            try {
                extension.configure(jcc);
            }
            catch (Throwable t) {
                logger.info("Failed to configure JContainerConfig with {0}", extension.getClass().getName());
            }
        }
    }

    public ServerConfig getServerConfig() {
        return this.serverConfig;
    }

    @Override
    public Map<String, EZBContainer> getContainers() {
        return this.containers;
    }

    @Override
    public Integer getID() {
        return this.id;
    }

    @Override
    public String getDescription() {
        return this.serverConfig.getDescription();
    }

    public IRemoteDeployer getDeployer() {
        return this.deployer;
    }

    public Components getComponents() {
        return this.components;
    }

    public void setComponents(Components components) {
        this.components = components;
    }

    public EZBComponent getComponent(String componentName) {
        if (this.componentManager != null) {
            return this.componentManager.getComponentRegistry().getComponent(componentName);
        }
        return null;
    }

    @Override
    public <T extends EZBComponent> T getComponent(Class<T> itf) {
        try {
            return (T)((EZBComponent)this.componentManager.getComponentRegistry().getComponents(itf).get(0));
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    @Override
    public ComponentManager getComponentManager() {
        return this.componentManager;
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public EZBServerJNDIResolver getJNDIResolver() {
        return this.jndiResolver;
    }

    @Override
    public String getJ2EEManagedObjectId() {
        return this.j2eeManagedObjectId;
    }

    public IEventDispatcher getEventDispatcher() {
        return this.dispatcher;
    }
}

