/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.cmi.internal.event;

import java.util.Set;
import javax.ejb.EJBObject;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.cmi.controller.server.ServerClusterViewManager;
import org.ow2.cmi.info.CMIInfoExtractor;
import org.ow2.cmi.info.CMIInfoExtractorException;
import org.ow2.cmi.info.CMIInfoRepository;
import org.ow2.cmi.info.ClusteredObjectInfo;
import org.ow2.cmi.reference.CMIReference;
import org.ow2.cmi.reference.ServerId;
import org.ow2.jonas.cmi.internal.CmiServiceImpl;
import org.ow2.jonas.lib.util.Log;
import org.ow2.util.ee.event.listeners.AbsBeanEventListener;
import org.ow2.util.ee.event.types.BeanRegisterEvent;
import org.ow2.util.ee.event.types.BeanUnregisterEvent;
import org.ow2.util.event.api.IEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanEventListener
extends AbsBeanEventListener {
    private static final String EVENT_PROVIDER_FILTER = "/beans/lifecycle/events";
    private static final long serialVersionUID = 1L;
    private static Logger cmilogger = Log.getLogger("org.ow2.jonas.cmi");

    public BeanEventListener() {
        super(EVENT_PROVIDER_FILTER);
    }

    @Override
    public void handle(IEvent event) {
        try {
            if (BeanUnregisterEvent.class.isAssignableFrom(event.getClass())) {
                this.removeClusteredObject(((BeanUnregisterEvent)event).getJndiName(), (ServerClusterViewManager)CmiServiceImpl.getClusterViewManager());
            } else if (BeanRegisterEvent.class.isAssignableFrom(event.getClass())) {
                BeanRegisterEvent beanRegisterEvent = (BeanRegisterEvent)event;
                this.addClusteredObject(beanRegisterEvent.getJndiName(), beanRegisterEvent.getClusterConfig(), beanRegisterEvent.getHomeClass(), beanRegisterEvent.getRemoteClass(), beanRegisterEvent.getClassLoader(), beanRegisterEvent.isStateful(), beanRegisterEvent.isClusterReplicated());
            } else {
                cmilogger.log(BasicLevel.DEBUG, (Object)"Unrecognized event type");
            }
        }
        catch (Exception e) {
            cmilogger.log(BasicLevel.ERROR, (Object)("Unable to handle event" + e));
        }
    }

    public synchronized void removeClusteredObject(String jndiName, ServerClusterViewManager clusterViewManager) throws Exception {
        cmilogger.log(BasicLevel.DEBUG, (Object)("Removing clustered object named :" + jndiName));
        if (CMIInfoRepository.containClusteredObjectInfo(jndiName)) {
            ServerId serverRef = null;
            Set<String> protocols = clusterViewManager.getProtocols();
            for (String proto : protocols) {
                serverRef = clusterViewManager.getRefOnLocalRegistry(proto);
                CMIReference cmiReference = new CMIReference(serverRef, jndiName);
                try {
                    clusterViewManager.removeCMIReference(cmiReference);
                }
                catch (Exception e) {
                    cmilogger.log(BasicLevel.DEBUG, (Object)(jndiName + "Not bound in the with protocol " + proto));
                }
            }
            CMIInfoRepository.removeClusteredObjectInfo(jndiName);
        }
    }

    public synchronized void addClusteredObject(String jndiName, Object clusterConfig, Class<?> homeClass, Class<? extends EJBObject> remoteClass, ClassLoader classLoader, boolean stateful, boolean clusterReplicated) throws Exception {
        if (clusterConfig != null) {
            try {
                ClusteredObjectInfo clusteredObjectInfo = CMIInfoExtractor.extractClusteringInfoFromClusteredObject(clusterConfig, homeClass, remoteClass, stateful, clusterReplicated, null);
                CMIInfoRepository.addClusteredObjectInfo(jndiName, clusteredObjectInfo);
                cmilogger.log(BasicLevel.INFO, (Object)("The object with name " + jndiName + " is clustered."));
            }
            catch (CMIInfoExtractorException e) {
                cmilogger.log(BasicLevel.ERROR, (Object)("Error when extracting infos about clustering for the object with name " + jndiName), (Throwable)e);
                throw new Exception("Error when extracting infos about clustering for the object with name " + jndiName, e);
            }
        } else {
            cmilogger.log(BasicLevel.DEBUG, (Object)("Cluster configuration not set for the object : " + clusterConfig));
        }
    }
}

