/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.ejb;

import java.util.HashMap;
import java.util.Iterator;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.ejb.EjbRelationDesc;
import org.ow2.jonas.deployment.ejb.EntityCmp2Desc;
import org.ow2.jonas.deployment.ejb.FieldJdbcDesc;
import org.ow2.jonas.deployment.ejb.xml.EjbRelationshipRole;
import org.ow2.jonas.deployment.ejb.xml.ForeignKeyJdbcMapping;
import org.ow2.jonas.deployment.ejb.xml.JonasEjbRelationshipRole;

public class EjbRelationshipRoleDesc {
    private Logger logger = null;
    public static final byte INDEX = 1;
    public static final byte SOURCE = 2;
    public static final byte TARGET = 4;
    public static final byte OOU = 0;
    public static final byte OOB = 1;
    public static final byte OMU = 2;
    public static final byte OMB = 3;
    public static final byte MOU = 4;
    public static final byte MOB = 5;
    public static final byte MMU = 6;
    public static final byte MMB = 7;
    private String rsrName;
    private String ejbSourceName;
    private EjbRelationDesc ejbRelationDesc;
    private EntityCmp2Desc sourceEntityCmp2Desc;
    private boolean isSourceMultiple;
    private EntityCmp2Desc targetEntityCmp2Desc;
    private boolean isTargetMultiple;
    private boolean isSlave;
    protected String cmrFieldName = null;
    protected Class cmrFieldType = null;
    protected boolean isJOnASCMR = false;
    private byte relationType = (byte)-1;
    private boolean mustCascade;
    private JonasEjbRelationshipRole jSourceRsRole = null;
    private HashMap foreignKeyMap = new HashMap();
    private boolean hasJdbcMapping = false;

    public EjbRelationshipRoleDesc(EjbRelationDesc rd, String name, EjbRelationshipRole role, JonasEjbRelationshipRole jrole, EjbRelationshipRole opposite, boolean isSlave, Logger logger) throws DeploymentDescException {
        this.logger = logger;
        this.ejbRelationDesc = rd;
        this.isSlave = isSlave;
        this.rsrName = name;
        this.mustCascade = opposite.isCascadeDelete();
        this.ejbSourceName = role.getRelationshipRoleSource().getEjbName();
        if (opposite.getMultiplicity().equalsIgnoreCase("Many")) {
            this.isTargetMultiple = true;
            if (role.isCascadeDelete()) {
                throw new DeploymentDescException("Cascade delete not allowed for relationshipRole for relationship '" + rd.getName() + "(because opposite role has a multiplicity of Many)");
            }
        } else if (opposite.getMultiplicity().equalsIgnoreCase("One")) {
            this.isTargetMultiple = false;
        } else {
            throw new DeploymentDescException("Invalid multiplicity value for relationshipRole for relationship '" + rd.getName() + "'(must be One or Many)");
        }
        if (role.getMultiplicity().equalsIgnoreCase("Many")) {
            this.isSourceMultiple = true;
        } else if (role.getMultiplicity().equalsIgnoreCase("One")) {
            this.isSourceMultiple = false;
        } else {
            throw new DeploymentDescException("Invalid multiplicity value for relationshipRole for relationship '" + rd.getName() + "'(must be One or Many)");
        }
        if (role.getCmrField() != null) {
            this.setCmrFieldName(role.getCmrField().getCmrFieldName());
            if (this.isTargetMultiple) {
                String type = role.getCmrField().getCmrFieldType();
                if (type == null) {
                    throw new DeploymentDescException("You must specify a cmr-field-type in case where the relation is 'Many' in the cmr-field '" + this.cmrFieldName + "' of bean " + this.ejbSourceName);
                }
                this.setCmrFieldType(type);
            }
        }
        this.jSourceRsRole = jrole;
    }

    protected void fillMappingInfo() throws DeploymentDescException {
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("" + (this.jSourceRsRole != null) + " for " + this.rsrName));
        }
        if (this.jSourceRsRole != null) {
            for (ForeignKeyJdbcMapping fkMapping : this.jSourceRsRole.getForeignKeyJdbcMappingList()) {
                String fkc = fkMapping.getForeignKeyJdbcName();
                String kc = null;
                if (fkMapping.getKeyJdbcName() != null) {
                    kc = fkMapping.getKeyJdbcName();
                }
                if (kc == null) {
                    if (this.targetEntityCmp2Desc.hasSimplePkField()) {
                        kc = ((FieldJdbcDesc)this.targetEntityCmp2Desc.getSimplePkField()).getJdbcFieldName();
                    } else {
                        throw new DeploymentDescException("key-jdbc-name must be provided for foreign-key-jdbc-mapping " + fkc + " of relation-ship role " + this.rsrName + "of relation " + this.ejbRelationDesc.getName());
                    }
                }
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("explicit fk mapping = " + fkc + " for " + kc));
                }
                this.foreignKeyMap.put(kc, fkc);
            }
            this.hasJdbcMapping = true;
        }
    }

    protected void fillMappingInfoWithDefault() {
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("" + this.hasJdbcMapping));
        }
        if (!this.hasJdbcMapping) {
            if (this.targetEntityCmp2Desc.hasSimplePkField()) {
                String fn = this.targetEntityCmp2Desc.getSimplePkFieldName();
                FieldJdbcDesc fd = (FieldJdbcDesc)this.targetEntityCmp2Desc.getCmpFieldDesc(fn);
                String kc = fd.getJdbcFieldName();
                String fkc = this.targetEntityCmp2Desc.getAbstractSchemaName() + "_" + kc;
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("default fk mapping = " + fkc + " for " + kc));
                }
                this.foreignKeyMap.put(kc, fkc);
            } else {
                Iterator i = this.targetEntityCmp2Desc.getCmpFieldDescIterator();
                while (i.hasNext()) {
                    FieldJdbcDesc fd = (FieldJdbcDesc)i.next();
                    String kc = fd.getJdbcFieldName();
                    String fkc = this.targetEntityCmp2Desc.getAbstractSchemaName() + "_" + kc;
                    if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                        this.logger.log(BasicLevel.DEBUG, (Object)("default fk mapping = " + fkc + " for " + kc));
                    }
                    this.foreignKeyMap.put(kc, fkc);
                }
            }
            this.hasJdbcMapping = true;
        }
    }

    public String getName() {
        return this.rsrName;
    }

    protected void setCmrFieldName(String name) throws DeploymentDescException {
        this.cmrFieldName = name;
    }

    protected void setCmrFieldType(String type) throws DeploymentDescException {
        try {
            this.cmrFieldType = Class.forName(type);
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentDescException("class name not found for cmr-field " + this.cmrFieldName + " of bean " + this.ejbSourceName, e);
        }
        if (!this.cmrFieldType.getName().equals("java.util.Collection") && !this.cmrFieldType.getName().equals("java.util.Set")) {
            throw new DeploymentDescException("value of cmr-field-type " + this.cmrFieldName + " of bean " + this.ejbSourceName + " should be java.util.Set or java.util.Collection if set");
        }
    }

    protected void setIsJOnASCmrField() {
        this.isJOnASCMR = true;
    }

    protected void setSourceBean(EntityCmp2Desc led) {
        this.sourceEntityCmp2Desc = led;
    }

    protected void setTargetBean(EntityCmp2Desc led) {
        this.targetEntityCmp2Desc = led;
        if (this.cmrFieldType == null) {
            this.cmrFieldType = led.getLocalClass();
        }
    }

    public EjbRelationDesc getRelation() {
        return this.ejbRelationDesc;
    }

    public EjbRelationshipRoleDesc getOppositeRelationshipRole() {
        EjbRelationshipRoleDesc res = this.ejbRelationDesc.getRelationshipRole1();
        if (res == this) {
            return this.ejbRelationDesc.getRelationshipRole2();
        }
        return res;
    }

    public String getSourceBeanName() {
        return this.ejbSourceName;
    }

    public EntityCmp2Desc getSourceBean() {
        return this.sourceEntityCmp2Desc;
    }

    public EntityCmp2Desc getTargetBean() {
        return this.targetEntityCmp2Desc;
    }

    public boolean isSourceMultiple() {
        return this.isSourceMultiple;
    }

    public boolean isTargetMultiple() {
        return this.isTargetMultiple;
    }

    public boolean mustCascade() {
        return this.mustCascade;
    }

    public boolean isJOnASCmrField() {
        return this.isJOnASCMR;
    }

    public boolean hasCmrField() {
        return this.cmrFieldName != null;
    }

    public String getCmrFieldName() {
        return this.cmrFieldName;
    }

    public Class getCmrFieldType() {
        return this.cmrFieldType;
    }

    public byte getRelationType() {
        if (this.relationType == -1) {
            this.relationType = 0;
            EjbRelationshipRoleDesc rsr2 = this.getOppositeRelationshipRole();
            if (rsr2.hasCmrField() && this.hasCmrField()) {
                this.relationType = (byte)(this.relationType + 1);
            }
            if (this.isTargetMultiple()) {
                this.relationType = (byte)(this.relationType + 2);
            }
            if (rsr2.isTargetMultiple()) {
                this.relationType = (byte)(this.relationType + 4);
            }
        }
        return this.relationType;
    }

    public boolean hasJdbcMapping() {
        return this.hasJdbcMapping;
    }

    public boolean isSlave() {
        return this.isSlave;
    }

    public String getForeignKeyJdbcName(String jdbcFieldName) {
        return (String)this.foreignKeyMap.get(jdbcFieldName);
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("\ngetName() = " + this.getName());
        ret.append("\ngetRelation().getName() = " + this.getRelation().getName());
        ret.append("\ngetOppositeRelationshipRole().getName() = " + this.getOppositeRelationshipRole().getName());
        ret.append("\ngetSourceBeanName() = " + this.getSourceBeanName());
        ret.append("\ngetTargetBean().getName() = " + this.getTargetBean().getEjbName());
        ret.append("\nisSourceMultiple() = " + this.isSourceMultiple());
        ret.append("\nisTargetMultiple() = " + this.isTargetMultiple());
        ret.append("\nmustCascade() = " + this.mustCascade());
        ret.append("\nisJOnASCmrField() = " + this.isJOnASCmrField());
        ret.append("\ngetCmrFieldName() = " + this.getCmrFieldName());
        ret.append("\ngetCmrFieldType() = " + this.getCmrFieldType());
        ret.append("\ngetRelationType() = " + this.getRelationType());
        if (this.hasJdbcMapping()) {
            for (String key : this.foreignKeyMap.keySet()) {
                String fkey = (String)this.foreignKeyMap.get(key);
                ret.append("\ngetForeignKeyJdbcName(" + key + ")=" + fkey);
            }
        }
        return ret.toString();
    }
}

