/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ee.jdbc;

import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.ee.jdbc.ManagedConnectionImpl;

public class XAResourceImpl
implements XAResource {
    private Xid currentXid = null;
    boolean started = false;
    boolean ended = true;
    protected ManagedConnectionImpl mc = null;
    private XAResource xares = null;

    public XAResourceImpl(ManagedConnectionImpl mc, XAResource xares) {
        this.mc = mc;
        this.xares = xares;
        if (mc.trace.isLoggable(BasicLevel.DEBUG)) {
            mc.trace.log(BasicLevel.DEBUG, (Object)("" + mc + "," + xares));
        }
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        block12: {
            if (this.mc.trace.isLoggable(BasicLevel.DEBUG)) {
                this.mc.trace.log(BasicLevel.DEBUG, (Object)("" + xid + "," + onePhase));
            }
            try {
                if (this.xares != null) {
                    this.xares.commit(xid, onePhase);
                    if (xid.equals(this.currentXid)) {
                        this.started = false;
                    }
                } else {
                    if (this.currentXid == null || !this.currentXid.equals(xid) || !this.started) {
                        this.mc.trace.log(BasicLevel.ERROR, (Object)("passed xid(" + xid + "),current Xid(" + this.currentXid + "),started(" + this.started + ")"));
                        throw new XAException("Commit: Must call correct XAResource for its started XID");
                    }
                    this.mc.connection.commit();
                    this.started = false;
                }
            }
            catch (XAException xe) {
                this.mc.trace.log(BasicLevel.ERROR, (Object)xe.getMessage());
                throw xe;
            }
            catch (SQLException e) {
                this.mc.trace.log(BasicLevel.ERROR, (Object)e.getMessage());
                try {
                    this.mc.signalEvent(5, null, e);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                throw new XAException("Error on commit");
            }
            try {
                this.mc.setAutoCommit(true);
            }
            catch (Exception exc) {
                if (this.xares != null || !this.mc.trace.isLoggable(BasicLevel.DEBUG)) break block12;
                this.mc.trace.log(BasicLevel.DEBUG, (Object)"Unable to set autoCommit to true:", (Throwable)exc);
            }
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        if (this.mc.trace.isLoggable(BasicLevel.DEBUG)) {
            this.mc.trace.log(BasicLevel.DEBUG, (Object)("" + xid + "," + flags));
        }
        if (this.currentXid == null || !this.currentXid.equals(xid)) {
            throw new XAException(105);
        }
        if (!this.started && this.ended) {
            throw new XAException(105);
        }
        this.ended = true;
        if (this.xares != null) {
            this.xares.end(xid, flags);
        }
    }

    public void forget(Xid xid) throws XAException {
        if (this.mc.trace.isLoggable(BasicLevel.DEBUG)) {
            this.mc.trace.log(BasicLevel.DEBUG, (Object)("" + xid));
        }
        if (this.xares != null) {
            this.xares.forget(xid);
        }
    }

    public int getTransactionTimeout() throws XAException {
        if (this.xares != null) {
            return this.xares.getTransactionTimeout();
        }
        return 0;
    }

    public boolean isSameRM(XAResource xaRes) throws XAException {
        boolean ret = false;
        if (xaRes.equals(this)) {
            ret = true;
        } else if (!(xaRes instanceof XAResourceImpl)) {
            ret = false;
        } else {
            XAResourceImpl xaResImpl = (XAResourceImpl)xaRes;
            if (this.mc == xaResImpl.mc) {
                ret = true;
            }
        }
        if (this.mc.trace.isLoggable(BasicLevel.DEBUG)) {
            this.mc.trace.log(BasicLevel.DEBUG, (Object)("" + xaRes + "," + this + " is " + ret));
        }
        return ret;
    }

    public int prepare(Xid xid) throws XAException {
        if (this.mc.trace.isLoggable(BasicLevel.DEBUG)) {
            this.mc.trace.log(BasicLevel.DEBUG, (Object)("" + xid));
        }
        if (this.xares != null) {
            int ret = this.xares.prepare(xid);
            if (ret == 3) {
                this.started = false;
                try {
                    this.mc.setAutoCommit(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return ret;
        }
        return 0;
    }

    public Xid[] recover(int flag) throws XAException {
        if (this.mc.trace.isLoggable(BasicLevel.DEBUG)) {
            this.mc.trace.log(BasicLevel.DEBUG, (Object)("" + flag));
        }
        if (this.xares != null) {
            return this.xares.recover(flag);
        }
        return null;
    }

    public void rollback(Xid xid) throws XAException {
        block12: {
            if (this.mc.trace.isLoggable(BasicLevel.DEBUG)) {
                this.mc.trace.log(BasicLevel.DEBUG, (Object)("" + xid));
            }
            try {
                if (this.xares != null) {
                    this.xares.rollback(xid);
                    if (xid.equals(this.currentXid)) {
                        this.started = false;
                    }
                } else {
                    if (this.currentXid == null || !this.currentXid.equals(xid) || !this.started) {
                        this.mc.trace.log(BasicLevel.ERROR, (Object)("passed xid(" + xid + "),current Xid(" + this.currentXid + "),started(" + this.started + ")"));
                        throw new XAException("Rollback: Must call correct XAResource for its started XID");
                    }
                    this.mc.connection.rollback();
                    this.started = false;
                }
            }
            catch (XAException xe) {
                this.mc.trace.log(BasicLevel.ERROR, (Object)xe.getMessage());
                throw xe;
            }
            catch (SQLException e) {
                try {
                    this.mc.trace.log(BasicLevel.ERROR, (Object)e.getMessage());
                    this.mc.signalEvent(5, null, e);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new XAException("Error on rollback");
            }
            try {
                this.mc.setAutoCommit(true);
            }
            catch (Exception exc) {
                if (this.xares != null || !this.mc.trace.isLoggable(BasicLevel.DEBUG)) break block12;
                this.mc.trace.log(BasicLevel.DEBUG, (Object)"Unable to set autoCommit to true:", (Throwable)exc);
            }
        }
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        if (this.xares != null) {
            return this.xares.setTransactionTimeout(seconds);
        }
        return false;
    }

    public void start(Xid xid, int flags) throws XAException {
        if (this.mc.trace.isLoggable(BasicLevel.DEBUG)) {
            this.mc.trace.log(BasicLevel.DEBUG, (Object)("" + xid + "," + flags));
        }
        try {
            this.mc.setAutoCommit(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.mc.trace.log(BasicLevel.ERROR, (Object)("Unable to set autoCommit to false:" + ex.getMessage()));
            throw new XAException("Error : Unable to set autoCommit to false in start");
        }
        if (this.xares != null) {
            this.xares.start(xid, flags);
        } else if (this.started && (this.currentXid == null || !this.currentXid.equals(xid))) {
            this.mc.trace.log(BasicLevel.ERROR, (Object)"Must call correct XAResource for its started XID");
            throw new XAException("XAResourceImpl.start : Must call correct XAResource for its started XID");
        }
        this.currentXid = xid;
        this.started = true;
        this.ended = false;
    }
}

