/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.wsgen.generator.axis;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import org.apache.velocity.VelocityContext;
import org.ow2.jonas.deployment.common.HandlerDesc;
import org.ow2.jonas.deployment.ws.MappingFile;
import org.ow2.jonas.deployment.ws.PortComponentDesc;
import org.ow2.jonas.deployment.ws.SSBPortComponentDesc;
import org.ow2.jonas.deployment.ws.ServiceDesc;
import org.ow2.jonas.deployment.ws.ServiceRefDesc;
import org.ow2.jonas.generators.wsgen.generator.axis.VcArrayMapping;
import org.ow2.jonas.generators.wsgen.generator.axis.VcBeanMapping;
import org.ow2.jonas.generators.wsgen.generator.axis.VcPortComponent;
import org.ow2.jonas.generators.wsgen.generator.axis.VcTypeMapping;

public class VContextFactory {
    public static final String PROVIDER = "provider";
    public static final String EJB_PROVIDER = "JOnASEJB";
    public static final String RPC_PROVIDER = "RPC";
    public static final String MAPPINGS = "mappings";
    public static final String PORT_COMPONENTS = "portComponents";
    private static final String WEB_WSDL = "WEB-INF/wsdl/";
    private static final String META_WSDL = "META-INF/wsdl/";

    private VContextFactory() {
    }

    public static VelocityContext getContext(ServiceDesc sd) {
        String wsdl;
        VelocityContext vc = new VelocityContext();
        if (sd.getPortComponents().get(0) instanceof SSBPortComponentDesc) {
            vc.put(PROVIDER, EJB_PROVIDER);
            wsdl = sd.getWSDL().getName().substring(META_WSDL.length());
        } else {
            vc.put(PROVIDER, RPC_PROVIDER);
            wsdl = sd.getWSDL().getName().substring(WEB_WSDL.length());
        }
        List ports = sd.getPortComponents();
        Vector<VcPortComponent> portComponents = new Vector<VcPortComponent>();
        for (PortComponentDesc pcd : ports) {
            portComponents.add(new VcPortComponent(pcd, wsdl));
        }
        vc.put(PORT_COMPONENTS, portComponents);
        Vector<VcTypeMapping> mappings = new Vector<VcTypeMapping>();
        MappingFile mf = sd.getMapping();
        Iterator m = mf.getXmlTypeMappings();
        while (m.hasNext()) {
            QName xml = (QName)m.next();
            String classname = mf.getClassname(xml);
            if (classname.endsWith("[]")) {
                mappings.add(new VcArrayMapping(xml, classname));
                continue;
            }
            mappings.add(new VcBeanMapping(xml, classname));
        }
        vc.put(MAPPINGS, mappings);
        return vc;
    }

    public static VelocityContext getContext(ServiceRefDesc sr) {
        VelocityContext vc = new VelocityContext();
        Hashtable pcds = new Hashtable();
        List hrs = sr.getHandlerRefs();
        Vector<HandlerDesc> commonh = new Vector<HandlerDesc>();
        for (HandlerDesc hr : hrs) {
            List pcns = hr.getPortNames();
            if (pcns.size() != 0) {
                for (String pcn : pcns) {
                    if (!pcds.containsKey(pcn)) {
                        pcds.put(pcn, new Vector());
                    }
                    ((Vector)pcds.get(pcn)).add(hr);
                }
                continue;
            }
            commonh.add(hr);
        }
        Vector<VcPortComponent> portComponents = new Vector<VcPortComponent>();
        if (pcds.isEmpty()) {
            Definition def = sr.getWSDLFile().getDefinition();
            Service s = def.getService(sr.getServiceQName());
            Map ports = s.getPorts();
            for (Port p : ports.values()) {
                portComponents.add(new VcPortComponent(p.getName(), commonh));
            }
        } else {
            Enumeration enPc = pcds.keys();
            while (enPc.hasMoreElements()) {
                String pcn = (String)enPc.nextElement();
                Vector pchrs = (Vector)pcds.get(pcn);
                pchrs.addAll(commonh);
                portComponents.add(new VcPortComponent(pcn, pchrs));
            }
        }
        vc.put(PORT_COMPONENTS, portComponents);
        Vector<VcTypeMapping> mappings = new Vector<VcTypeMapping>();
        MappingFile mf = sr.getMappingFile();
        if (mf != null) {
            Iterator m = mf.getXmlTypeMappings();
            while (m.hasNext()) {
                QName xml = (QName)m.next();
                String classname = mf.getClassname(xml);
                if (classname.endsWith("[]")) {
                    mappings.add(new VcArrayMapping(xml, classname));
                    continue;
                }
                mappings.add(new VcBeanMapping(xml, classname));
            }
        }
        vc.put(MAPPINGS, mappings);
        return vc;
    }
}

