/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.management.extensions.manager;

import java.io.Serializable;
import java.util.List;
import org.ow2.jonas.lib.management.extensions.base.JonasManagementRepr;
import org.ow2.jonas.lib.management.extensions.cluster.ClusterManagement;
import org.ow2.jonas.lib.management.extensions.clusterdaemon.ClusterdaemonManagement;
import org.ow2.jonas.lib.management.extensions.domain.DomainManagement;
import org.ow2.jonas.lib.management.extensions.server.ServerManagement;
import org.ow2.jonas.management.extensions.cluster.api.ICluster;
import org.ow2.jonas.management.extensions.clusterdaemon.api.IClusterdaemon;
import org.ow2.jonas.management.extensions.domain.api.IDomain;
import org.ow2.jonas.management.extensions.server.api.IServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ManagementEntryPoint
implements IDomain,
IServer,
IClusterdaemon,
ICluster,
Serializable {
    private static final long serialVersionUID = 1L;
    private static ManagementEntryPoint unique = null;
    private static IDomain domainManagement = null;
    private static IServer serverManagement = null;
    private static IClusterdaemon clusterdaemonManagement = null;
    private static ICluster clusterManagement = null;

    public static synchronized ManagementEntryPoint getInstance() {
        if (unique == null) {
            unique = new ManagementEntryPoint();
        }
        return unique;
    }

    private ManagementEntryPoint() {
        domainManagement = new DomainManagement();
        serverManagement = new ServerManagement();
        clusterdaemonManagement = new ClusterdaemonManagement();
        clusterManagement = new ClusterManagement();
    }

    @Override
    public String getDomainName() {
        return domainManagement.getDomainName();
    }

    @Override
    public String getServerName() {
        return domainManagement.getServerName();
    }

    @Override
    public String getServerHost() {
        return domainManagement.getServerHost();
    }

    @Override
    public String getServerPort() {
        return domainManagement.getServerPort();
    }

    @Override
    public boolean isMaster(String serverName) {
        return domainManagement.isMaster(serverName);
    }

    @Override
    public boolean isMaster() {
        return domainManagement.isMaster();
    }

    @Override
    public String[] getServerNames() {
        return domainManagement.getServerNames();
    }

    @Override
    public String[] getClustersNames() {
        return domainManagement.getClustersNames();
    }

    @Override
    public String[] getClusterDaemonNames() {
        return domainManagement.getClusterDaemonNames();
    }

    @Override
    public String[] getClusters() {
        return domainManagement.getClusters();
    }

    @Override
    public String[] getclusterDaemons() {
        return domainManagement.getclusterDaemons();
    }

    @Override
    public void addServer(String serverName, String serverURL, String userName, String password, String clusterdaemon) {
        domainManagement.addServer(serverName, serverURL, userName, password, clusterdaemon);
    }

    @Override
    public void removeServers(String[] serversToRemove) {
        domainManagement.removeServers(serversToRemove);
    }

    @Override
    public void addCluster(String clusterName) {
        domainManagement.addCluster(clusterName);
    }

    @Override
    public String getServerState(String serverName) {
        return domainManagement.getServerState(serverName);
    }

    @Override
    public void startServer(String serverName) {
        domainManagement.startServer(serverName);
    }

    @Override
    public void stopServer(String serverName) {
        domainManagement.stopServer(serverName);
    }

    @Override
    public void haltServer(String serverName) {
        domainManagement.haltServer(serverName);
    }

    @Override
    public String getServerClusterdaemon(String serverName) {
        return domainManagement.getServerClusterdaemon(serverName);
    }

    @Override
    public String getClusterState(String clusterName) {
        return domainManagement.getClusterState(clusterName);
    }

    @Override
    public String getClusterType(String clusterName) {
        return domainManagement.getClusterType(clusterName);
    }

    @Override
    public String[] getServerNames(String clusterName) {
        return domainManagement.getServerNames(clusterName);
    }

    @Override
    public long getCurrentUsedMemory(String server) {
        return serverManagement.getCurrentUsedMemory(server);
    }

    @Override
    public String getServerVersion(String server) {
        return serverManagement.getServerVersion(server);
    }

    @Override
    public int getAllThreadsCount(String server) {
        return serverManagement.getAllThreadsCount(server);
    }

    @Override
    public Long getCurrentTotalMemory(String server) {
        return serverManagement.getCurrentTotalMemory(server);
    }

    @Override
    public String getConnectionUrl(String server) {
        return serverManagement.getConnectionUrl(server);
    }

    @Override
    public String getJavaVendor(String server) {
        return serverManagement.getJavaVendor(server);
    }

    @Override
    public String getJavaVersion(String server) {
        return serverManagement.getJavaVersion(server);
    }

    @Override
    public String getProtocols(String server) {
        return serverManagement.getProtocols(server);
    }

    @Override
    public int getTotalBegunTransactions(String server) {
        return serverManagement.getTotalBegunTransactions(server);
    }

    @Override
    public int getTotalCommittedTransactions(String server) {
        return serverManagement.getTotalCommittedTransactions(server);
    }

    @Override
    public int getTotalExpiredTransactions(String server) {
        return serverManagement.getTotalExpiredTransactions(server);
    }

    @Override
    public int getTotalRolledbackTransactions(String server) {
        return serverManagement.getTotalRolledbackTransactions(server);
    }

    @Override
    public int getTotalCurrentTransactions(String server) {
        return serverManagement.getTotalCurrentTransactions(server);
    }

    @Override
    public long getBytesReceivedByConnectorTomcat(String server) {
        return serverManagement.getBytesReceivedByConnectorTomcat(server);
    }

    @Override
    public long getBytesSentByConnectorTomcat(String server) {
        return serverManagement.getBytesSentByConnectorTomcat(server);
    }

    @Override
    public int getCurrentThreadBusyByConnectorTomcat(String server) {
        return serverManagement.getCurrentThreadBusyByConnectorTomcat(server);
    }

    @Override
    public int getCurrentThreadCountByConnectorTomcat(String server) {
        return serverManagement.getCurrentThreadCountByConnectorTomcat(server);
    }

    @Override
    public int getErrorCountByConnectorTomcat(String server) {
        return serverManagement.getErrorCountByConnectorTomcat(server);
    }

    @Override
    public int getMaxThreadsByConnectorTomcat(String server) {
        return serverManagement.getMaxThreadsByConnectorTomcat(server);
    }

    @Override
    public long getProcessingTimeByConnectorTomcat(String server) {
        return serverManagement.getProcessingTimeByConnectorTomcat(server);
    }

    @Override
    public int getRequestCountByConnectorTomcat(String server) {
        return serverManagement.getRequestCountByConnectorTomcat(server);
    }

    @Override
    public int getCurrentNumberOfEJB(String server) {
        return serverManagement.getCurrentNumberOfEJB(server);
    }

    @Override
    public int getCurrentNumberOfEntityBean(String server) {
        return serverManagement.getCurrentNumberOfEntityBean(server);
    }

    @Override
    public int getCurrentNumberOfMDB(String server) {
        return serverManagement.getCurrentNumberOfMDB(server);
    }

    @Override
    public int getCurrentNumberOfSBF(String server) {
        return serverManagement.getCurrentNumberOfSBF(server);
    }

    @Override
    public int getCurrentNumberOfSBL(String server) {
        return serverManagement.getCurrentNumberOfSBL(server);
    }

    @Override
    public String[] getControlledServersNames(String clusterdaemonName) {
        return clusterdaemonManagement.getControlledServersNames(clusterdaemonName);
    }

    @Override
    public boolean isRunning(String clusterdaemonName) {
        return clusterdaemonManagement.isRunning(clusterdaemonName);
    }

    @Override
    public String getClusterdaemonState(String clusterdaemonName) {
        return clusterdaemonManagement.getClusterdaemonState(clusterdaemonName);
    }

    @Override
    public void startAllServers(String clusterName) {
        clusterManagement.startAllServers(clusterName);
    }

    @Override
    public void stopAllServers(String clusterName) {
        clusterManagement.stopAllServers(clusterName);
    }

    @Override
    public String getMcastAddr(String clusterName) {
        return clusterManagement.getMcastAddr(clusterName);
    }

    @Override
    public int getMcastPort(String clusterName) {
        return clusterManagement.getMcastPort(clusterName);
    }

    @Override
    public int getDelayToRefresh(String clusterName) {
        return clusterManagement.getDelayToRefresh(clusterName);
    }

    @Override
    public String[] getServersNotInCluster(String clusterName) {
        return domainManagement.getServersNotInCluster(clusterName);
    }

    public List<List<String>> getServerThreadsInformation(String serverName, String domainName) throws Exception {
        return JonasManagementRepr.getServerThreadsInformation(serverName, domainName);
    }
}

